/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPublicKeySpec;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class ESDHPublicKey
extends PublicKeyInfo
implements Serializable,
DHPublicKey {
    private ESDHParameterSpec c;
    private BigInteger a;
    private transient ASN1 b;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.encode());
    }

    public static void validatePublicKey(ESDHPublicKey eSDHPublicKey) throws InvalidKeyException {
        BigInteger bigInteger = eSDHPublicKey.getY();
        ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)eSDHPublicKey.getParams();
        BigInteger bigInteger2 = eSDHParameterSpec.getP();
        BigInteger bigInteger3 = eSDHParameterSpec.getQ();
        BigInteger bigInteger4 = bigInteger2.subtract(BigInteger.valueOf(1L));
        if (bigInteger.compareTo(BigInteger.valueOf(2L)) != 1 || bigInteger.compareTo(bigInteger4) != -1) {
            throw new InvalidKeyException("The key is not valid (y is not in the interval [2,p-1])");
        }
        if (bigInteger.modPow(bigInteger3, bigInteger2).compareTo(BigInteger.valueOf(1L)) != 0) {
            throw new InvalidKeyException("The key is not valid (y^q mod p == 1)");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESDH public key");
        stringBuffer.append(this.c == null ? ":\n" : " (" + this.c.getP().bitLength() + " bits):\n");
        stringBuffer.append("y: " + this.a.toString(16) + "\n");
        if (this.c != null) {
            stringBuffer.append("key parameters:\n" + this.c.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        try {
            this.decode(new ASN1(objectInputStream).toByteArray());
            return;
        }
        catch (Exception exception) {
            throw new IOException("Unable to restore Certificate: " + exception.toString());
        }
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode();
    }

    public BigInteger getY() {
        return this.a;
    }

    public DHParameterSpec getParams() {
        return this.c;
    }

    public byte[] getFingerprint() {
        return this.b.fingerprint();
    }

    public String getAlgorithm() {
        return "ESDH";
    }

    protected byte[] encode() {
        return this.b.toByteArray();
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a = (BigInteger)this.b.toASN1Object().getValue();
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            if (aSN1Object != null) {
                BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
                BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
                BigInteger bigInteger3 = (BigInteger)aSN1Object.getComponentAt(2).getValue();
                BigInteger bigInteger4 = null;
                byte[] byArray2 = null;
                int n2 = 0;
                int n3 = 0;
                while (n3 < aSN1Object.countComponents() - 3) {
                    if (aSN1Object.getComponentAt(n3 + 3) instanceof INTEGER) {
                        bigInteger4 = (BigInteger)aSN1Object.getComponentAt(n3 + 3).getValue();
                    }
                    if (aSN1Object.getComponentAt(n3 + 3) instanceof SEQUENCE) {
                        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object.getComponentAt(n3 + 3);
                        byArray2 = (byte[])sEQUENCE.getComponentAt(0).getValue();
                        n2 = ((BigInteger)sEQUENCE.getComponentAt(1).getValue()).intValue();
                    }
                    ++n3;
                }
                this.c = new ESDHParameterSpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray2, n2);
                return;
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No ESDH Public Key: " + exception.toString());
        }
    }

    private void a() {
        try {
            this.b = new ASN1(new INTEGER(this.a));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.c.getP()));
            sEQUENCE.addComponent(new INTEGER(this.c.getG()));
            sEQUENCE.addComponent(new INTEGER(this.c.getQ()));
            if (this.c.getJ() != null) {
                sEQUENCE.addComponent(new INTEGER(this.c.getJ()));
            }
            if (this.c.getSeed() != null) {
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(new BIT_STRING(this.c.getSeed()));
                sEQUENCE2.addComponent(new INTEGER(this.c.getPGenCounter()));
                sEQUENCE.addComponent(sEQUENCE2);
            }
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.esdh.clone();
            this.public_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public ESDHPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ESDHPublicKey(BigInteger bigInteger, ESDHParameterSpec eSDHParameterSpec) {
        this.a = bigInteger;
        this.c = eSDHParameterSpec;
        this.a();
    }

    public ESDHPublicKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public ESDHPublicKey(ESDHPublicKeySpec eSDHPublicKeySpec) {
        this.a = eSDHPublicKeySpec.getY();
        this.c = new ESDHParameterSpec(eSDHPublicKeySpec.getP(), eSDHPublicKeySpec.getG(), eSDHPublicKeySpec.getQ(), eSDHPublicKeySpec.getJ(), eSDHPublicKeySpec.getSeed(), eSDHPublicKeySpec.getPGenCounter());
        this.a();
    }

    public ESDHPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }
}

