/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.cipher.DESKeyGenerator;
import iaik.security.cipher.SecretKey;
import iaik.security.dh.ESDHKEKParameterSpec;
import iaik.security.dh.ESDHKEKParameters;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKey;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.md.SHA;
import iaik.utils.CriticalObject;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class ESDHKeyAgreement
extends KeyAgreementSpi {
    private byte[] f;
    private BigInteger g;
    private BigInteger e;
    private ESDHPrivateKey c;
    private SecureRandom d;
    private byte[] b;
    private ESDHKEKParameterSpec a;

    private byte[] a(byte[] byArray) {
        try {
            int n2 = byArray.length;
            this.a.resetCounter();
            ESDHKEKParameters eSDHKEKParameters = new ESDHKEKParameters(this.a);
            int n3 = this.a.getSuppPubInfoAsInt() / 8;
            int n4 = (n3 + 19) / 20;
            byte[] byArray2 = new byte[n4 * 20];
            byte[] byArray3 = eSDHKEKParameters.engineGetEncoded();
            byte[] byArray4 = new byte[n2 + byArray3.length];
            SHA sHA = new SHA();
            int n5 = 0;
            while (n5 < n4) {
                if (n5 > 0) {
                    eSDHKEKParameters.incrementCounter();
                    byArray3 = eSDHKEKParameters.engineGetEncoded();
                }
                System.arraycopy(byArray, 0, byArray4, 0, n2);
                System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
                System.arraycopy(sHA.digest(byArray4), 0, byArray2, n5 * 20, 20);
                ++n5;
            }
            CriticalObject.destroy(byArray4);
            byte[] byArray5 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray5, 0, n3);
            CriticalObject.destroy(byArray2);
            return byArray5;
        }
        catch (IOException iOException) {
            throw new InternalErrorException("Error encoding OtherInfo. " + iOException.getMessage(), iOException);
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.d = secureRandom;
        if (!(key instanceof ESDHPrivateKey)) {
            throw new InvalidKeyException("Only ESDH private keys are allowed.");
        }
        this.c = (ESDHPrivateKey)key;
        this.e = this.c.getParams().getP();
        this.g = this.c.getParams().getG();
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof ESDHKEKParameterSpec) {
                this.a = (ESDHKEKParameterSpec)algorithmParameterSpec;
                return;
            }
            throw new InvalidKeyException("Params must be ESDHKEKParameterSpec!");
        }
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, null, secureRandom);
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws ShortBufferException, IllegalStateException {
        if (byArray.length - n2 < this.f.length) {
            throw new ShortBufferException("Output buffer is to small for holding the secret.");
        }
        System.arraycopy(this.f, 0, byArray, n2, this.f.length);
        return this.f.length;
    }

    protected javax.crypto.SecretKey engineGenerateSecret(String string) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        if (this.b == null) {
            throw new InvalidKeyException("Cannot create secret key. Please init this KeyAgreement with ESDHKEKParameterSpec!");
        }
        try {
            javax.crypto.SecretKey secretKey;
            if (string.equals("DES")) {
                if (this.b.length < 8) {
                    throw new InvalidKeyException("Generated secret to short for a DES key!");
                }
                byte[] byArray = (byte[])this.b.clone();
                DESKeyGenerator.adjustParity(byArray, 0);
                secretKey = new SecretKey(byArray, 0, 8, "DES");
            } else if (string.equals("3DES") || string.equals("DESede")) {
                if (this.b.length < 24) {
                    throw new InvalidKeyException("Generated secret to short for a Triple DES key!");
                }
                byte[] byArray = (byte[])this.b.clone();
                DESKeyGenerator.adjustParity(byArray, 0);
                DESKeyGenerator.adjustParity(byArray, 8);
                DESKeyGenerator.adjustParity(byArray, 16);
                secretKey = new SecretKey(byArray, 0, 24, "DESede");
            } else {
                SecretKeySpec secretKeySpec = new SecretKeySpec(this.b, string);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
                secretKey = secretKeyFactory.generateSecret(secretKeySpec);
            }
            return secretKey;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Invalid key: " + invalidKeySpecException.toString());
        }
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.f;
    }

    protected Key engineDoPhase(Key key, boolean bl) throws IllegalStateException, InvalidKeyException {
        ESDHPublicKey eSDHPublicKey = null;
        if (key instanceof ESDHPublicKey) {
            ESDHPublicKey eSDHPublicKey2 = (ESDHPublicKey)key;
            ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)eSDHPublicKey2.getParams();
            if (eSDHParameterSpec != null && !this.e.equals(eSDHParameterSpec.getP()) && !this.g.equals(eSDHParameterSpec.getG())) {
                throw new InvalidKeyException("ESDH parameters are not equal.");
            }
            BigInteger bigInteger = eSDHPublicKey2.getY().modPow(this.c.getX(), this.e);
            if (bl) {
                this.f = bigInteger.toByteArray();
                if (this.f[0] == 0) {
                    byte[] byArray = new byte[this.f.length - 1];
                    System.arraycopy(this.f, 1, byArray, 0, this.f.length - 1);
                    this.f = byArray;
                }
            } else {
                eSDHPublicKey = new ESDHPublicKey(bigInteger, (ESDHParameterSpec)this.c.getParams());
            }
        } else {
            throw new InvalidKeyException("ESDH public key needed.");
        }
        if (bl && this.a != null) {
            this.b = this.a(this.f);
        }
        return eSDHPublicKey;
    }
}

