/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.IvParameters;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class RC5Parameters
extends IvParameters {
    private int a;
    private int c;
    private int b;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.b + "\n");
        stringBuffer.append("rounds: " + this.c + "\n");
        stringBuffer.append("wordsize: " + this.b + "\n");
        stringBuffer.append("iv: " + Util.toString(((IvParameters)this).a) + "\n");
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block7: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.b = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
                    this.c = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                    if (this.c < 8 || this.c > 127) {
                        throw new IOException("Invalid number of rounds: " + this.c);
                    }
                    this.a = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue() >> 1;
                    if (this.a != 32) {
                        throw new IOException("Invalid word size. Only 32 supported at this time.");
                    }
                    if (aSN1Object.countComponents() == 4) {
                        ((IvParameters)this).a = (byte[])aSN1Object.getComponentAt(3).getValue();
                        if (((IvParameters)this).a == null || ((IvParameters)this).a.length != 8) {
                            throw new IOException("Cannot init RC5 params. Invalid IV; must be 8 octets long.");
                        }
                    }
                    break block7;
                }
                throw new IOException("Cannot decode RC5 params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)algorithmParameterSpec;
            this.b = rC5ParameterSpec.getVersion();
            this.c = rC5ParameterSpec.getRounds();
            if (this.c < 8 || this.c > 127) {
                throw new InvalidParameterSpecException("Invalid number of rounds: " + this.c);
            }
            this.a = rC5ParameterSpec.getWordSize();
            if (this.a != 32) {
                throw new InvalidParameterSpecException("Invalid word size. Only 32 supported at this time.");
            }
            ((IvParameters)this).a = rC5ParameterSpec.getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.b = 16;
            this.c = 12;
            this.a = 32;
            ((IvParameters)this).a = ivParameterSpec.getIV();
        } else {
            throw new InvalidParameterSpecException("Parameter must be RC5ParameterSpec.");
        }
        if (((IvParameters)this).a != null && ((IvParameters)this).a.length != 8) {
            throw new InvalidParameterSpecException("Invalid IV; must be 8 octets long.");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        RC5ParameterSpec rC5ParameterSpec = ((IvParameters)this).a == null ? new RC5ParameterSpec(this.b, this.c, this.a) : new RC5ParameterSpec(this.b, this.c, this.a, ((IvParameters)this).a);
        if (!rC5ParameterSpec.getClass().isAssignableFrom(clazz)) {
            return super.engineGetParameterSpec(clazz);
        }
        return rC5ParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            ((ASN1Object)sEQUENCE).addComponent(new INTEGER(this.b));
            ((ASN1Object)sEQUENCE).addComponent(new INTEGER(this.c));
            ((ASN1Object)sEQUENCE).addComponent(new INTEGER(this.a << 1));
            if (((IvParameters)this).a != null) {
                ((ASN1Object)sEQUENCE).addComponent(new OCTET_STRING(((IvParameters)this).a));
            }
            return DerCoder.encode(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new IOException("Cannot encode RC5 parameters: " + codingException.getMessage());
        }
    }
}

