/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.DigestedDataStream;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class DigestedData
extends DigestedDataStream
implements Content {
    byte[] b;
    private ContentInfo a;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + ((DigestedDataStream)this).a + "\n");
        if (this.c != null) {
            stringBuffer.append("digestAlgorithm: " + this.c.getName());
        }
        stringBuffer.append("ContentInfo: " + this.a);
        stringBuffer.append("\n");
        stringBuffer.append("digest: " + Util.toString(this.d));
        return stringBuffer.toString();
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (this.c == null) {
            throw new PKCSException("No digest algorithm set!");
        }
        if (this.a == null) {
            throw new PKCSException("No content info set!");
        }
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (n2 > 0) {
            this.a.getContent().setBlockSize(n2);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent(new INTEGER(((DigestedDataStream)this).a));
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(this.a.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.d));
        return sEQUENCE;
    }

    protected void setupMessageDigest(AlgorithmID algorithmID, boolean bl) throws NoSuchAlgorithmException {
        ((DigestedDataStream)this).b = algorithmID.getMessageDigestInstance();
        if (this.b == null) {
            throw new NoSuchAlgorithmException("No content to digest!");
        }
        ((DigestedDataStream)this).b.update(this.b);
        if (bl) {
            this.f = ((DigestedDataStream)this).b.digest();
            return;
        }
        this.d = ((DigestedDataStream)this).b.digest();
    }

    public InputStream getInputStream() {
        if (this.b == null) {
            return null;
        }
        return new ByteArrayInputStream(this.b);
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public Object getContentInfo() {
        return this.a;
    }

    public byte[] getContent() {
        return this.b;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        ((DigestedDataStream)this).a = derInputStream.readInteger().intValue();
        this.c = new AlgorithmID(derInputStream);
        this.a = new ContentInfo(derInputStream);
        this.content_type = this.a.getContentType();
        if (!this.a.hasContent()) {
            this.mode = 2;
        } else {
            if (this.content_type.equals(ObjectID.pkcs7_data)) {
                this.b = ((Data)this.a.getContent()).getData();
            }
            try {
                this.setupMessageDigest(this.c, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSParsingException(noSuchAlgorithmException.getMessage());
            }
        }
        this.d = derInputStream.readOctetStringByteArray();
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID, int n2) throws PKCSException {
        this();
        if (algorithmID == null) {
            throw new PKCSException("No digestAlgorithm specified!");
        }
        if (n2 != 1 && n2 != 2) {
            throw new PKCSException("Illegal mode specification: " + n2 + "!");
        }
        this.content_type = ObjectID.pkcs7_data;
        this.mode = n2;
        this.b = byArray;
        this.a = n2 == 1 ? new ContentInfo(new Data(byArray)) : new ContentInfo(this.content_type);
        this.c = (AlgorithmID)algorithmID.clone();
        try {
            this.setupMessageDigest(this.c, false);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.getMessage());
        }
    }

    public DigestedData(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this.b = byArray;
        this.mode = 2;
        this.content_type = ObjectID.pkcs7_data;
        this.c = algorithmID;
        this.setupMessageDigest(algorithmID, true);
    }

    public DigestedData(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public DigestedData(Content content, AlgorithmID algorithmID, byte[] byArray) throws PKCSException {
        this();
        this.a = new ContentInfo(content);
        this.content_type = this.a.getContentType();
        if (this.content_type.equals(ObjectID.pkcs7_data)) {
            this.b = ((Data)content).getData();
        }
        this.c = algorithmID;
        this.d = byArray;
    }

    public DigestedData(ObjectID objectID, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.mode = 2;
        this.content_type = objectID;
        this.a = new ContentInfo(objectID);
        this.c = algorithmID;
        this.d = byArray;
    }

    public DigestedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected DigestedData() {
        this.block_size = -1;
    }
}

