/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.Util;

public class DigestInfo
implements ASN1Type {
    private byte[] b;
    private AlgorithmID a;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digest_algorithm: " + this.a + "\n");
        stringBuffer.append("digest: " + this.b.length + " Bytes [" + Util.toString(this.b, 0, 5) + "...]\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] toByteArray() {
        return DerCoder.encode(this.toASN1Object());
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.b));
        return sEQUENCE;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.a;
    }

    public byte[] getDigest() {
        return this.b;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.a = new AlgorithmID(aSN1Object.getComponentAt(0));
            this.b = (byte[])aSN1Object.getComponentAt(1).getValue();
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public DigestInfo(AlgorithmID algorithmID, byte[] byArray) {
        this.a = algorithmID;
        this.b = byArray;
    }

    public DigestInfo(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }
}

