/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.security.random.SecRandom;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.CriticalObject;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class RSACipher
extends CipherSpi {
    private byte[] m;
    private byte[] r;
    private byte[] o;
    private MessageDigest n;
    private int f = -1;
    private int d = 2;
    private SecureRandom a;
    protected RSAPublicKey pubKey;
    protected RSAPrivateKey privKey;
    private int e;
    private static final int q = 4;
    private static final int g = 3;
    private static final int h = 2;
    private static final int i = 1;
    private static final String p = "OAEP";
    private static final String j = "PKCS1PaddingSSL2";
    private static final String k = "PKCS1Padding";
    private static final String l = "NoPadding";

    protected byte[] rawCrypt(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray2 = this.pubKey != null ? this.pubKey.crypt(bigInteger).toByteArray() : this.privKey.crypt(bigInteger).toByteArray();
        if (byArray2[0] == 0) {
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray2.length - 1);
            CriticalObject.destroy(byArray2);
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private byte[] b(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3;
        int n4 = byArray.length;
        int n5 = 0;
        int n6 = this.a();
        int n7 = n6 - 3 - n4;
        if (n7 < 8) {
            throw new BadPaddingException("PKCS#1 requires data at least 11 bytes shorter than the modulus!");
        }
        int n8 = this.f;
        if (n8 == -1) {
            n8 = this.pubKey != null ? 2 : 1;
        }
        byte[] byArray2 = new byte[n6];
        byArray2[n5++] = 0;
        byArray2[n5++] = (byte)n8;
        if (n8 == 2) {
            if (this.a == null) {
                this.a = SecRandom.getDefault();
            }
            n3 = 0;
            while (n3 < n7) {
                if (this.d == 3 && n7 - n3 <= 8) {
                    n2 = 3;
                } else {
                    while ((n2 = this.a.nextInt() & 0xFF) == 0) {
                    }
                }
                byArray2[n5++] = (byte)n2;
                ++n3;
            }
        } else {
            if (n8 == 0) {
                n3 = 0;
                if (byArray[0] == 0) {
                    throw new BadPaddingException("For block type 0 data must begin with nonzero value");
                }
            } else {
                n3 = 255;
            }
            n2 = 0;
            while (n2 < n7) {
                byArray2[n5++] = (byte)n3;
                ++n2;
            }
        }
        byArray2[n5++] = 0;
        System.arraycopy(byArray, 0, byArray2, n5, n4);
        byte[] byArray3 = this.rawCrypt(byArray2);
        CriticalObject.destroy(byArray2);
        if (byArray3.length < n6) {
            byte[] byArray4 = new byte[n6];
            System.arraycopy(byArray3, 0, byArray4, n6 - byArray3.length, byArray3.length);
            CriticalObject.destroy(byArray3);
            byArray3 = byArray4;
        }
        return byArray3;
    }

    private byte[] a(byte[] byArray) throws BadPaddingException {
        int n2;
        if (this.d == 3) {
            throw new BadPaddingException("SSL2 variant of PKCS#1 padding not supported in decryption mode!");
        }
        int n3 = this.a();
        if (byArray.length != n3) {
            throw new BadPaddingException("Invalid PKCS#1 padding: encrypted message is not k OCTETS long!");
        }
        byte[] byArray2 = this.rawCrypt(byArray);
        int n4 = byArray2.length;
        if (n4 >= n3) {
            throw new BadPaddingException("Invalid PKCS#1 padding: no leading zero!");
        }
        if (n4 < n3 - 1) {
            if (this.privKey != null) {
                throw new BadPaddingException("Invalid PKCS#1 block type 0 for private key decryption!");
            }
            if (this.f != -1 && this.f != 0) {
                throw new BadPaddingException("PKCS#1 padding type does not match specified type!");
            }
            return byArray2;
        }
        int n5 = 0;
        byte by = byArray2[n5];
        if (by == 1) {
            if (this.privKey != null) {
                throw new BadPaddingException("Invalid PKCS#1 block type 1 for private key decryption!");
            }
        } else if (by == 2) {
            if (this.pubKey != null) {
                throw new BadPaddingException("Invalid PKCS#1 block type 2 for public key decryption!");
            }
        } else {
            throw new BadPaddingException("Invalid PKCS#1 block type " + by + "!");
        }
        if (this.f != -1 && this.f != by) {
            throw new BadPaddingException("PKCS#1 padding type does not match specified type!");
        }
        while ((n2 = byArray2[++n5] & 0xFF) != 0) {
            if (n5 >= n4) {
                throw new BadPaddingException("Encryption block has wrong format!");
            }
            if (by != 1 || n2 == 255) continue;
            throw new BadPaddingException("Invalid block type 1 padding byte " + n2 + "!");
        }
        if (n5 - 1 < 8) {
            throw new BadPaddingException("Padding string must be at least 8 octets long!");
        }
        byte[] byArray3 = new byte[n4 - n5 - 1];
        System.arraycopy(byArray2, n5 + 1, byArray3, 0, n4 - n5 - 1);
        CriticalObject.destroy(byArray2);
        return byArray3;
    }

    private byte[] f(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = this.b();
        int n2 = byArray2.length;
        int n3 = this.a();
        int n4 = n3 - 1;
        if (byArray.length > n4 - 1 - 2 * n2) {
            throw new BadPaddingException("Message to long for OAEP, must be 42 bytes less than modulus");
        }
        if (this.a == null) {
            this.a = SecRandom.getDefault();
        }
        if (this.m == null) {
            this.m = new byte[n2];
        }
        this.a.nextBytes(this.m);
        byte[] byArray3 = new byte[n4];
        int n5 = 0;
        int n6 = n2;
        int n7 = byArray3.length - n2;
        int n8 = n6;
        System.arraycopy(this.m, 0, byArray3, n5, n6);
        System.arraycopy(byArray2, 0, byArray3, n8, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, n4 - byArray.length, byArray.length);
        byArray3[n4 - byArray.length - 1] = 1;
        this.a(byArray3, n5, n6, n7, byArray3, n8);
        this.a(byArray3, n8, n7, n6, byArray3, n5);
        byte[] byArray4 = this.rawCrypt(byArray3);
        if (byArray4.length < n3) {
            byte[] byArray5 = new byte[n3];
            System.arraycopy(byArray4, 0, byArray5, n3 - byArray4.length, byArray4.length);
            CriticalObject.destroy(byArray4);
            byArray4 = byArray5;
        }
        return byArray4;
    }

    private byte[] e(byte[] byArray) throws BadPaddingException {
        byte[] byArray2;
        int n2;
        int n3 = this.a();
        if (byArray.length != n3) {
            throw new BadPaddingException("Invalid OAEP: encrypted message and modulus lengths do not match!");
        }
        byte[] byArray3 = this.rawCrypt(byArray);
        int n4 = byArray3.length;
        if (n4 < 2 * (n2 = (byArray2 = this.b()).length) + 1) {
            throw new BadPaddingException("Invalid OAEP: decrypted message too short");
        }
        int n5 = 0;
        int n6 = n2;
        int n7 = n4 - n2;
        int n8 = n6;
        this.a(byArray3, n8, n7, n6, byArray3, n5);
        this.a(byArray3, n5, n6, n7, byArray3, n8);
        int n9 = 0;
        while (n9 < n2) {
            if (byArray3[n8 + n9] != byArray2[n9]) {
                throw new BadPaddingException("Invalid OAEP: parameter hashes do not match!");
            }
            ++n9;
        }
        while (n9 < n7 && byArray3[n8 + n9] == 0) {
            ++n9;
        }
        if (n9 == n7 || byArray3[n8 + n9++] != 1) {
            throw new BadPaddingException("Invalid OAEP: invalid padding string!");
        }
        int n10 = n7 - n9;
        byte[] byArray4 = new byte[n10];
        System.arraycopy(byArray3, n8 + n9, byArray4, 0, n10);
        return byArray4;
    }

    private static byte[] d(byte[] byArray) {
        int n2;
        int n3 = 0;
        do {
            n2 = n3++;
        } while ((byArray[n2] = (byte)(byArray[n2] + 1)) == 0 && n3 < byArray.length);
        return byArray;
    }

    private MessageDigest c() {
        if (this.n == null) {
            try {
                this.n = MessageDigest.getInstance("SHA1", "IAIK");
            }
            catch (Exception exception) {
                throw new RuntimeException("MessageDigest SHA not available: " + exception.toString());
            }
        }
        return this.n;
    }

    protected AlgorithmParameters getParameters() {
        throw new RuntimeException("Method not supported.");
    }

    private int a() {
        BigInteger bigInteger = this.pubKey != null ? this.pubKey.getModulus() : this.privKey.getModulus();
        return (bigInteger.bitLength() + 7) / 8;
    }

    private byte[] b() {
        if (this.o == null) {
            this.o = this.c().digest();
        }
        return this.o;
    }

    private static int a(int n2) {
        if (n2 == 3) {
            return 1;
        }
        if (n2 == 4) {
            return 2;
        }
        return n2;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not encode key for wrapping!");
        }
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Could not wrap key: " + badPaddingException.toString());
        }
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        throw new RuntimeException("Method not supported.");
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        throw new RuntimeException("Method not supported.");
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return Util.decodeKey(n2, string, byArray2);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Could not unwrap key: " + badPaddingException.toString());
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase(k)) {
            this.d = 2;
            return;
        }
        if (string.equalsIgnoreCase(l)) {
            this.d = 1;
            return;
        }
        if (string.equalsIgnoreCase(j)) {
            this.d = 3;
            return;
        }
        if (string.toUpperCase().startsWith(p)) {
            this.d = 4;
            return;
        }
        throw new NoSuchPaddingException("Unknown padding: " + string);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        int n2;
        if (string.equals("ECB")) {
            this.f = -1;
            return;
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchAlgorithmException("Bad block type for PKCS1Padding");
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new NoSuchAlgorithmException("Block type must be 0, 1 or 2.");
        }
        this.f = n2;
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n2, key, secureRandom);
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.e = n2 = RSACipher.a(n2);
        this.a = secureRandom;
        this.pubKey = null;
        this.privKey = null;
        if (key == null) {
            throw new NullPointerException("Key is null!");
        }
        try {
            this.pubKey = Util.getRSAPublicKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            try {
                this.privKey = Util.getRSAPrivateKey(key);
            }
            catch (InvalidKeyException invalidKeyException2) {
                throw new InvalidKeyException("Class does not represent an RSA key: " + key.getClass().getName());
            }
        }
        catch (Exception exception) {
            if (exception instanceof InvalidKeyException) {
                throw (InvalidKeyException)exception;
            }
            throw new InvalidKeyException("Unable to init RSA key: " + exception.toString());
        }
        if (this.d == 2 && this.f != -1) {
            if (n2 == 1) {
                if (this.f == 2) {
                    if (this.privKey != null) {
                        throw new InvalidKeyException("Must use public key for encryption with block type 2!");
                    }
                } else if (this.pubKey != null) {
                    throw new InvalidKeyException("Must use private key for encryption with block type 0 and 1!");
                }
            } else if (this.f == 2) {
                if (this.pubKey != null) {
                    throw new InvalidKeyException("Must use private key for decryption with block type 2!");
                }
            } else if (this.privKey != null) {
                throw new InvalidKeyException("Must use public key for decryption with block type 0 and 1!");
            }
        }
        if (this.d == 2) {
            if (this.a() < 41) {
                throw new InvalidKeyException("PKCS#1 requires a modulus of at least 328 bits!");
            }
        } else if (this.d == 4) {
            if (this.a() < 42) {
                throw new InvalidKeyException("OAEP requires a modulus of at least 336 bits!");
            }
            if (n2 == 1) {
                if (this.pubKey == null) {
                    throw new InvalidKeyException("OAEP cannot be used to generate signatures");
                }
            } else if (this.privKey == null) {
                throw new InvalidKeyException("OAEP cannot be used to verify signatures");
            }
        }
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(n2, key, secureRandom);
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected int engineGetOutputSize(int n2) {
        return 0;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        try {
            RSAPublicKey rSAPublicKey = Util.getRSAPublicKey(key);
            return rSAPublicKey.getModulus().bitLength();
        }
        catch (InvalidKeyException invalidKeyException) {
            try {
                RSAPrivateKey rSAPrivateKey = Util.getRSAPrivateKey(key);
                return rSAPrivateKey.getModulus().bitLength();
            }
            catch (InvalidKeyException invalidKeyException2) {
                throw new InvalidKeyException("Not an RSA key!");
            }
        }
    }

    protected byte[] engineGetIV() {
        throw new RuntimeException("Method not supported.");
    }

    protected int engineGetBlockSize() {
        throw new RuntimeException("Method not supported.");
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, ShortBufferException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        try {
            System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
            CriticalObject.destroy(byArray3);
        }
        catch (Exception exception) {
            throw new ShortBufferException("Buffer to short to hold result.");
        }
        return byArray3.length;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException {
        byte[] byArray2;
        if (n2 != 0 || n3 != byArray.length) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        } else {
            byArray2 = byArray;
        }
        switch (this.d) {
            case 1: {
                return this.rawCrypt(byArray2);
            }
            case 4: {
                if (this.e == 1) {
                    return this.f(byArray2);
                }
                return this.e(byArray2);
            }
        }
        if (this.e == 1) {
            return this.b(byArray2);
        }
        return this.a(byArray2);
    }

    private void a(byte[] byArray, int n2, int n3, int n4, byte[] byArray2, int n5) {
        MessageDigest messageDigest = this.c();
        if (this.r == null) {
            this.r = new byte[4];
        } else {
            this.r[0] = 0;
            this.r[1] = 0;
            this.r[2] = 0;
            this.r[3] = 0;
        }
        int n6 = 0;
        while (n6 < n4) {
            messageDigest.update(byArray, n2, n3);
            messageDigest.update(this.r);
            byte[] byArray3 = messageDigest.digest();
            CryptoUtils.increment(this.r);
            int n7 = 0;
            while (n7 < byArray3.length && n6 < n4) {
                int n8 = n5++;
                byArray2[n8] = (byte)(byArray2[n8] ^ byArray3[n7++]);
                ++n6;
            }
        }
    }
}

