/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1String
extends ASN1Object {
    protected byte[] value;

    public String toString() {
        return String.valueOf(super.toString()) + "\"" + this.getValue() + "\"";
    }

    public int hashCode() {
        return this.asnType.hashCode() ^ Util.calculateHashCode(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ASN1String)) {
            return false;
        }
        ASN1String aSN1String = (ASN1String)object;
        if (!this.asnType.equals(aSN1String.asnType)) {
            return false;
        }
        return CryptoUtils.equalsBlock(this.value, aSN1String.value);
    }

    protected void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.value);
    }

    protected void decode(int n2, InputStream inputStream) throws IOException {
        this.value = new byte[n2];
        Util.fillArray(this.value, inputStream);
    }

    protected ASN1String() {
        this.isStringType = true;
    }
}

