/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.StringTokenizer;

public class LDAPFilter
implements Cloneable {
    private static final int DEFAULT_FILTER_LENGTH = 256;
    private String m_strFilter = null;
    private String m_strDescription;
    private int m_nScope;
    private boolean m_bIsExact;
    private String m_strMatchPattern;
    private String m_strDelimeter;
    private String m_strFilterTemplate;
    private int m_nLine;
    private String m_strSuffix;
    private String m_strPrefix;

    public LDAPFilter(String string, String string2, String string3, String string4, int n) throws IllegalArgumentException {
        this.m_strMatchPattern = this.convertMatchPattern(string);
        this.m_strDelimeter = string2;
        this.m_strFilterTemplate = string3;
        this.m_strDescription = string4;
        this.m_nScope = n;
    }

    public LDAPFilter(String string, String string2, String string3, String string4, String string5) throws IllegalArgumentException {
        if (string5.equals("base")) {
            this.m_nScope = 0;
        } else if (string5.equals("onelevel")) {
            this.m_nScope = 1;
        } else if (string5.equals("subtree")) {
            this.m_nScope = 2;
        }
        this.m_strMatchPattern = string;
        this.m_strDelimeter = string2;
        this.m_strFilterTemplate = string3;
        this.m_strDescription = string4;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    String convertMatchPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 1);
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '.') {
                if (bl) {
                    stringBuffer.append("\\");
                }
            } else if (cArray[n] == '[') {
                bl = true;
            } else if (cArray[n] == ']') {
                bl = false;
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    void createFilterString(String var1_1, String var2_2, String var3_3) {
        var4_4 = new StringTokenizer(var1_1, this.m_strDelimeter);
        var5_5 = new String[var4_4.countTokens()];
        var6_6 = var4_4.countTokens();
        var7_7 = 0;
        while (var7_7 < var6_6) {
            var5_5[var7_7] = var4_4.nextToken();
            ++var7_7;
        }
        var8_8 = new StringBuffer(256);
        if (var2_2 != null) {
            var8_8.append(var2_2);
        }
        var9_9 = this.m_strFilterTemplate.toCharArray();
        var10_10 = 0;
        while (var10_10 < var9_9.length) {
            block13: {
                block11: {
                    block12: {
                        if (var9_9[var10_10] != '%') break block11;
                        if (var9_9[++var10_10] != 'v') break block12;
                        if (var10_10 == var9_9.length - 1) {
                            var8_8.append(var1_1);
                            break;
                        }
                        switch (var9_9[++var10_10]) {
                            case '$': {
                                var8_8.append(var5_5[var5_5.length]);
                                break;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var11_11 = Integer.parseInt(new Character(var9_9[var10_10]).toString());
                                --var11_11;
                                if (var9_9[++var10_10] != '-') ** GOTO lbl54
                                if (!Character.isDigit(var9_9[++var10_10])) ** GOTO lbl43
                                var12_12 = Integer.parseInt(new Character(var9_9[var10_10]).toString());
                                --var12_12;
                                var13_13 = var11_11;
                                while (var13_13 <= var12_12) {
                                    var8_8.append(var5_5[var13_13]);
                                    var8_8.append(var13_13 == var12_12 ? "" : " ");
                                    ++var13_13;
                                }
                                break block13;
lbl43:
                                // 1 sources

                                var12_12 = var11_11;
                                while (var12_12 < var5_5.length) {
                                    var8_8.append(var5_5[var12_12]);
                                    var8_8.append(var12_12 == var5_5.length - 1 ? "" : " ");
                                    ++var12_12;
                                }
                                var8_8.append(var9_9[var10_10]);
                                break;
lbl54:
                                // 1 sources

                                var8_8.append(var5_5[var11_11]);
                                var8_8.append(var9_9[var10_10]);
                                break;
                            }
                            default: {
                                var8_8.append(var1_1);
                                var8_8.append(var9_9[var10_10]);
                                break;
                            }
                        }
                        break block13;
                    }
                    var8_8.append("%");
                    var8_8.append(var9_9[var10_10]);
                    break block13;
                }
                var8_8.append(var9_9[var10_10]);
            }
            ++var10_10;
        }
        if (var3_3 != null) {
            var8_8.append(var3_3);
        }
        this.m_strFilter = var8_8.toString();
    }

    public String getDelimeter() {
        return this.m_strDelimeter;
    }

    public String getDescription() {
        return this.m_strDescription;
    }

    public String getFilter() {
        return this.m_strFilter;
    }

    public String getFilter(String string) {
        this.createFilterString(string, this.m_strPrefix, this.m_strSuffix);
        return this.m_strFilter;
    }

    public String getFilter(String string, String string2, String string3) {
        this.createFilterString(string, string2, string3);
        return this.m_strFilter;
    }

    public String getFilterTemplate() {
        return this.m_strFilterTemplate;
    }

    public String getLineNumber() {
        return Integer.toString(this.m_nLine);
    }

    public String getMatchPattern() {
        return this.m_strMatchPattern;
    }

    public String getScope() {
        switch (this.m_nScope) {
            case 0: {
                return "base";
            }
            case 1: {
                return "onelevel";
            }
            case 2: {
                return "subtree";
            }
        }
        return "UNKNOWN!";
    }

    public void setFilterAffixes(String string, String string2) {
        this.m_strPrefix = string;
        this.m_strSuffix = string2;
    }

    void setLine(int n) {
        this.m_nLine = n;
    }

    public void setupFilter(String string) {
        this.createFilterString(string, null, null);
    }

    public void setupFilter(String string, String string2, String string3) {
        this.createFilterString(string, string2, string3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("      matchPtn: \"" + this.m_strMatchPattern + "\"\n");
        stringBuffer.append("      delim:    \"" + this.m_strDelimeter + "\"\n");
        stringBuffer.append("      filttmpl: \"" + this.m_strFilterTemplate + "\"\n");
        stringBuffer.append("      descript: \"" + this.m_strDescription + "\"\n");
        switch (this.m_nScope) {
            case 0: {
                stringBuffer.append("      scope: \"LDAPConnection.SCOPE_BASE\"\n");
                break;
            }
            case 1: {
                stringBuffer.append("      scope: \"LDAPConnection.SCOPE_ONE\"\n");
                break;
            }
            case 2: {
                stringBuffer.append("      scope: \"LDAPConnection.SCOPE_SUB\"\n");
                break;
            }
        }
        stringBuffer.append("      line:     \"" + this.m_nLine + "\"\n");
        stringBuffer.append("      FILTER:   \"" + this.m_strFilter + "\"\n");
        return stringBuffer.toString();
    }
}

