/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPVirtualListResponse
extends LDAPControl {
    public static final String VIRTUALLISTRESPONSE = "2.16.840.1.113730.3.4.10";
    private int m_firstPosition = 0;
    private int m_contentCount = 0;
    private int m_resultCode = -1;
    private String m_context = null;

    LDAPVirtualListResponse() {
        super(VIRTUALLISTRESPONSE, true, null);
    }

    public LDAPVirtualListResponse(String string, boolean bl, byte[] byArray) throws LDAPException {
        super(VIRTUALLISTRESPONSE, bl, byArray);
        if (!string.equals(VIRTUALLISTRESPONSE)) {
            throw new LDAPException("oid must be LDAPVirtualListResponse.VIRTUALLISTRESPONSE", 89);
        }
        this.parseResponse();
    }

    public LDAPVirtualListResponse(byte[] byArray) {
        super(VIRTUALLISTRESPONSE, true, null);
        this.m_value = byArray;
        this.parseResponse();
    }

    public int getContentCount() {
        return this.m_contentCount;
    }

    public String getContext() {
        return this.m_context;
    }

    public int getFirstPosition() {
        return this.m_firstPosition;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    private void parseResponse() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getValue());
        BERSequence bERSequence = new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[]{0};
        try {
            BERSequence bERSequence2 = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
            this.m_firstPosition = ((BERInteger)bERSequence2.elementAt(0)).getValue();
            this.m_contentCount = ((BERInteger)bERSequence2.elementAt(1)).getValue();
            this.m_resultCode = ((BEREnumerated)bERSequence2.elementAt(2)).getValue();
            if (bERSequence2.size() > 3) {
                BEROctetString bEROctetString = (BEROctetString)bERSequence2.elementAt(3);
                this.m_context = new String(bEROctetString.getValue(), "UTF8");
            }
        }
        catch (Exception exception) {
            this.m_resultCode = -1;
            this.m_contentCount = -1;
            this.m_firstPosition = -1;
            this.m_context = null;
        }
    }

    public static LDAPVirtualListResponse parseResponse(LDAPControl[] lDAPControlArray) {
        LDAPVirtualListResponse lDAPVirtualListResponse = null;
        int n = 0;
        while (lDAPControlArray != null && n < lDAPControlArray.length) {
            if (lDAPControlArray[n].getID().equals(VIRTUALLISTRESPONSE)) {
                lDAPVirtualListResponse = new LDAPVirtualListResponse(lDAPControlArray[n].getValue());
                lDAPVirtualListResponse.parseResponse();
                break;
            }
            ++n;
        }
        if (lDAPVirtualListResponse != null) {
            super.parseResponse();
        }
        return lDAPVirtualListResponse;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{VirtListResponseCtrl:");
        stringBuffer.append(" isCritical=");
        stringBuffer.append(this.isCritical());
        stringBuffer.append(" firstPosition=");
        stringBuffer.append(this.m_firstPosition);
        stringBuffer.append(" contentCount=");
        stringBuffer.append(this.m_contentCount);
        stringBuffer.append(" resultCode=");
        stringBuffer.append(this.m_resultCode);
        if (this.m_context != null) {
            stringBuffer.append(" conext=");
            stringBuffer.append(this.m_context);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

