/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPFilter;
import netscape.ldap.client.JDAPFilterOpers;
import netscape.ldap.client.opers.JDAPBaseDNRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class JDAPSearchRequest
extends JDAPBaseDNRequest
implements JDAPProtocolOp {
    public static final int BASE_OBJECT = 0;
    public static final int SINGLE_LEVEL = 1;
    public static final int WHOLE_SUBTREE = 2;
    public static final int NEVER_DEREF_ALIASES = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASE_OBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    public static final String DEFAULT_FILTER = "(objectclass=*)";
    protected String m_base_dn = null;
    protected int m_scope;
    protected int m_deref;
    protected int m_size_limit;
    protected int m_time_limit;
    protected boolean m_attrs_only;
    protected String m_filter = null;
    protected JDAPFilter m_parsedFilter = null;
    protected String[] m_attrs = null;

    public JDAPSearchRequest(String string, int n, int n2, int n3, int n4, boolean bl, String string2, String[] stringArray) throws IllegalArgumentException {
        this.m_base_dn = string;
        this.m_scope = n;
        this.m_deref = n2;
        this.m_size_limit = n3;
        this.m_time_limit = n4;
        this.m_attrs_only = bl;
        this.m_filter = string2 == null ? DEFAULT_FILTER : string2;
        this.m_parsedFilter = JDAPFilter.getFilter(JDAPFilterOpers.convertLDAPv2Escape(this.m_filter));
        if (this.m_parsedFilter == null) {
            throw new IllegalArgumentException("Bad search filter");
        }
        this.m_attrs = stringArray;
    }

    public BERElement getBERElement() {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BEROctetString(this.m_base_dn));
        bERSequence.addElement(new BEREnumerated(this.m_scope));
        bERSequence.addElement(new BEREnumerated(this.m_deref));
        bERSequence.addElement(new BERInteger(this.m_size_limit));
        bERSequence.addElement(new BERInteger(this.m_time_limit));
        bERSequence.addElement(new BERBoolean(this.m_attrs_only));
        bERSequence.addElement(this.m_parsedFilter.getBERElement());
        BERSequence bERSequence2 = new BERSequence();
        if (this.m_attrs != null) {
            int n = 0;
            while (n < this.m_attrs.length) {
                bERSequence2.addElement(new BEROctetString(this.m_attrs[n]));
                ++n;
            }
        }
        bERSequence.addElement(bERSequence2);
        BERTag bERTag = new BERTag(99, bERSequence, true);
        return bERTag;
    }

    public String getBaseDN() {
        return this.m_base_dn;
    }

    public int getType() {
        return 3;
    }

    public void setBaseDN(String string) {
        this.m_base_dn = string;
    }

    public String toString() {
        String string = null;
        if (this.m_attrs != null) {
            string = "";
            int n = 0;
            while (n < this.m_attrs.length) {
                if (n != 0) {
                    string = String.valueOf(string) + "+";
                }
                string = String.valueOf(string) + this.m_attrs[n];
                ++n;
            }
        }
        return "SearchRequest {baseObject=" + this.m_base_dn + ", scope=" + this.m_scope + ", derefAliases=" + this.m_deref + ",sizeLimit=" + this.m_size_limit + ", timeLimit=" + this.m_time_limit + ", attrsOnly=" + this.m_attrs_only + ", filter=" + this.m_filter + ", attributes=" + string + "}";
    }
}

