/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.DataLayer;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.ldap.LDAPEventManager;
import java.io.Serializable;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class SMSLdapObject
extends SMSObject
implements SMSObjectListener {
    static DataLayer dlayer;
    static int connNumRetry;
    static int connRetryInterval;
    static HashSet retryErrorCodes;
    static String baseDN;
    static Set entriesPresent;
    static Set entriesNotPresent;
    static ResourceBundle bundle;
    static boolean initialized;
    static Debug debug;
    static String[] OU_ATTR;

    public SMSLdapObject() throws SMSException {
        if (!initialized) {
            this.initialize();
        }
    }

    private synchronized void initialize() throws SMSException {
        if (initialized) {
            return;
        }
        debug = this.debug();
        AMResourceBundleCache aMResourceBundleCache = AMResourceBundleCache.getInstance();
        bundle = aMResourceBundleCache.getResBundle("amSDK", Locale.ENGLISH);
        SMSLdapObject.OU_ATTR[0] = this.getNamingAttribute();
        try {
            ServerInstance serverInstance = null;
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            if (dSConfigMgr != null) {
                serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
            }
            if (serverInstance != null) {
                dlayer = DataLayer.getInstance(serverInstance);
                baseDN = serverInstance.getBaseDN();
            }
            if (dSConfigMgr == null || serverInstance == null || dlayer == null) {
                debug.error("SMSLdapObject: Unable to initialize LDAP");
                throw new SMSException("amSDK", "ums-configmanagererror", null);
            }
            debug.message("SMSLdapObject: LDAP Initialized successfully");
            connNumRetry = DataLayer.getConnNumRetry();
            connRetryInterval = DataLayer.getConnRetryInterval();
            retryErrorCodes = DataLayer.getRetryErrorCodes();
            String string = "ou=services," + baseDN;
            if (!SMSLdapObject.entryExists(string)) {
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add("top");
                hashSet.add("organizationalunit");
                hashMap.put("objectclass", hashSet);
                SMSLdapObject.create(LDAPEventManager.adminPrincipal, string, hashMap);
            }
            LDAPEventManager.addObjectChangeListener(this);
        }
        catch (Exception exception) {
            debug.error("SMSEntry: Unable to initalize(exception):", (Throwable)exception);
            throw new SMSException("amSDK", "ums-configmanagererror", null);
        }
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map read(SSOToken sSOToken, String string) throws SMSException, SSOException {
        String[] stringArray;
        Serializable serializable;
        if (string == null || string.length() == 0 || !DN.isDN(string)) {
            debug.error("SMSLdapObject: Invalid DN=" + string);
            throw new SMSException(new LDAPException(bundle.getString("sms-INVALID_DN") + string, 32));
        }
        if (entriesNotPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject:read Entry not present: " + string + " (checked in cached)");
            }
            return null;
        }
        LDAPAttributeSet lDAPAttributeSet = null;
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
        try {
            block24: {
                try {
                    serializable = null;
                    int n = 0;
                    while (n <= connNumRetry) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject.read() retry: " + n);
                        }
                        try {
                            serializable = lDAPConnection.read(string, this.getAttributeNames());
                            break;
                        }
                        catch (LDAPException lDAPException) {
                            if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                                throw lDAPException;
                            }
                            ++n;
                            try {
                                Thread.currentThread();
                                Thread.sleep(connRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (serializable == null) {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSLdapObject: insufficient access rights to access DN=" + string);
                        }
                        throw new SMSException("amSDK", "sms-INSUFFICIENT_ACCESS_RIGHTS", null);
                    }
                    lDAPAttributeSet = serializable.getAttributeSet();
                    if (!debug.messageEnabled()) break block24;
                    debug.message("SMSLdapObject: reading entry: " + string);
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) {
                        this.objectChanged(string, 1);
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject: entry not present:" + string);
                        }
                    } else {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSLdapObject: Error in accessing entry DN: " + string, (Throwable)lDAPException);
                        }
                        throw new SMSException(lDAPException);
                    }
                    stringArray = null;
                    dlayer.releaseConnection(lDAPConnection);
                }
            }
            stringArray = null;
            dlayer.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        serializable = null;
        if (lDAPAttributeSet != null) {
            Enumeration enumeration = lDAPAttributeSet.getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                String string2 = lDAPAttribute.getName();
                if (lDAPAttribute == null) continue;
                HashSet<String> hashSet = new HashSet<String>();
                stringArray = lDAPAttribute.getStringValueArray();
                int n = 0;
                while (n < stringArray.length) {
                    hashSet.add(stringArray[n]);
                    ++n;
                }
                if (serializable == null) {
                    serializable = new HashMap(10);
                }
                serializable.put(string2, hashSet);
            }
        }
        return serializable;
    }

    public void create(SSOToken sSOToken, String string, Map map) throws SMSException, SSOException {
        SMSLdapObject.create(sSOToken.getPrincipal(), string, map);
        this.objectChanged(string, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void create(Principal principal, String string, Map map) throws SMSException, SSOException {
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(principal);
        try {
            try {
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.save() retry: " + n);
                    }
                    try {
                        LDAPAttributeSet lDAPAttributeSet = SMSLdapObject.copyMapToAttrSet(map);
                        lDAPConnection.add(new LDAPEntry(string, lDAPAttributeSet));
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSLdapObject::create() Error in creating entry: " + string + "\nBy Principal: " + principal.getName(), (Throwable)lDAPException);
                throw new SMSException(lDAPException);
            }
            Object var8_9 = null;
            dlayer.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully created entry: " + string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modify(SSOToken sSOToken, String string, ModificationItem[] modificationItemArray) throws SMSException, SSOException {
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
        try {
            try {
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.save() retry: " + n);
                    }
                    try {
                        LDAPModificationSet lDAPModificationSet = SMSLdapObject.copyModItemsToLDAPModSet(modificationItemArray);
                        lDAPConnection.modify(string, lDAPModificationSet);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSLdapObject::save() Error in modifying entry: " + string + "\nBy Principal: " + sSOToken.getPrincipal().getName(), (Throwable)lDAPException);
                throw new SMSException(lDAPException);
            }
            Object var9_10 = null;
            dlayer.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully modified entry: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSOToken sSOToken, String string) throws SMSException, SSOException {
        Object object;
        Iterator iterator = this.subEntries(sSOToken, string, "*", 0, false, false).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting sub-entry: " + (String)object);
            }
            this.delete(sSOToken, this.getNamingAttribute() + "=" + (String)object + "," + string);
        }
        object = SMSLdapObject.getConnection(sSOToken.getPrincipal());
        try {
            SMSLdapObject.delete((LDAPConnection)object, string);
            Object var6_5 = null;
            dlayer.releaseConnection((LDAPConnection)object);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            dlayer.releaseConnection((LDAPConnection)object);
            throw throwable;
        }
        this.objectChanged(string, 1);
    }

    private static void delete(LDAPConnection lDAPConnection, String string) throws SMSException {
        try {
            int n = 0;
            while (n <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.delete() retry: " + n);
                }
                try {
                    lDAPConnection.delete(string);
                    break;
                }
                catch (LDAPException lDAPException) {
                    if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                        throw lDAPException;
                    }
                    ++n;
                    try {
                        Thread.currentThread();
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (LDAPException lDAPException) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject: Unable to delete entry: " + string, (Throwable)lDAPException);
            }
            throw new SMSException(lDAPException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set subEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        Object object;
        LDAPSearchResults lDAPSearchResults;
        block23: {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: SubEntries search: " + string);
            }
            Object[] objectArray = new String[]{string2};
            String string3 = MessageFormat.format(this.getSearchFilter(), objectArray);
            LDAPConnection lDAPConnection = SMSLdapObject.getConnection(sSOToken.getPrincipal());
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(n);
            lDAPSearchConstraints.setServerTimeLimit(0);
            lDAPSearchResults = null;
            try {
                Object var16_19;
                try {
                    int n2 = 0;
                    while (n2 <= connNumRetry) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject.subEntries() retry: " + n2);
                        }
                        try {
                            lDAPSearchResults = lDAPConnection.search(string, 1, string3, OU_ATTR, false, lDAPSearchConstraints);
                            if (!bl) break;
                            object = new LDAPCompareAttrNames(this.getNamingAttribute(), bl2);
                            lDAPSearchResults.sort((LDAPEntryComparator)object);
                            break;
                        }
                        catch (LDAPException lDAPException) {
                            if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n2 == connNumRetry) {
                                throw lDAPException;
                            }
                            ++n2;
                            try {
                                Thread.currentThread();
                                Thread.sleep(connRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSLdapObject: entry not present:" + string);
                        }
                    } else {
                        if (debug.warningEnabled()) {
                            debug.warning("SMSLdapObject: Unable to search for sub-entries: " + string, (Throwable)lDAPException);
                        }
                        throw new SMSException(lDAPException);
                    }
                    var16_19 = null;
                    dlayer.releaseConnection(lDAPConnection);
                    break block23;
                }
                var16_19 = null;
                dlayer.releaseConnection(lDAPConnection);
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                dlayer.releaseConnection(lDAPConnection);
                throw throwable;
            }
        }
        object = new OrderedSet();
        while (true) {
            LDAPEntry lDAPEntry;
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: Successfully obtained sub-entries for : " + string);
                }
                return object;
            }
            try {
                lDAPEntry = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining sub-entries: " + string, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException);
            }
            object.add(new DN(lDAPEntry.getDN()).explodeDN(true)[0]);
        }
    }

    public String toString() {
        return "SMSLdapObject";
    }

    private static LDAPConnection getConnection(Principal principal) throws SMSException {
        LDAPConnection lDAPConnection = dlayer.getConnection(principal);
        if (lDAPConnection == null) {
            debug.error("SMSLdapObject: Unable to get connection to LDAP server for the principal: " + principal);
            throw new SMSException(new LDAPException(bundle.getString("sms-SERVER_DOWN")));
        }
        return lDAPConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set search(SSOToken sSOToken, String string, String string2) throws SSOException, SMSException {
        Serializable serializable;
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: search filter: " + string2);
        }
        LDAPConnection lDAPConnection = SMSLdapObject.getConnection(LDAPEventManager.adminPrincipal);
        LDAPSearchResults lDAPSearchResults = null;
        OrderedSet orderedSet = new OrderedSet();
        try {
            try {
                serializable = lDAPConnection.getSearchConstraints();
                ((LDAPSearchConstraints)serializable).setMaxResults(0);
                ((LDAPSearchConstraints)serializable).setServerTimeLimit(0);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.search() retry: " + n);
                    }
                    try {
                        lDAPSearchResults = lDAPConnection.search(string, 2, string2, null, false, (LDAPSearchConstraints)serializable);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSLdapObject: LDAP exception in search for filter match: " + string2, (Throwable)lDAPException);
                throw new SMSException(lDAPException);
            }
            Object var12_13 = null;
            if (lDAPConnection != null) {
                dlayer.releaseConnection(lDAPConnection);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (lDAPConnection != null) {
                dlayer.releaseConnection(lDAPConnection);
            }
            throw throwable;
        }
        while (true) {
            if (!lDAPSearchResults.hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject::search returned successfully: " + string2 + "\n\tObjects: " + orderedSet);
                }
                return orderedSet;
            }
            try {
                serializable = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in searching for filter match: " + string2, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException);
            }
            orderedSet.add(((LDAPEntry)serializable).getDN());
        }
    }

    public boolean entryExists(SSOToken sSOToken, String string) {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: checking if entry exists: " + string);
        }
        if (entriesPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + string);
            }
            return true;
        }
        if (entriesNotPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + string);
            }
            return false;
        }
        boolean bl = SMSLdapObject.entryExists(string);
        if (bl) {
            HashSet<String> hashSet = new HashSet<String>(entriesPresent);
            hashSet.add(string);
            entriesPresent = hashSet;
        } else {
            HashSet<String> hashSet = new HashSet<String>(entriesNotPresent);
            hashSet.add(string);
            entriesNotPresent = hashSet;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean entryExists(String string) {
        boolean bl;
        block11: {
            bl = false;
            LDAPConnection lDAPConnection = null;
            try {
                try {
                    lDAPConnection = SMSLdapObject.getConnection(LDAPEventManager.adminPrincipal);
                    lDAPConnection.read(string, OU_ATTR);
                    bl = true;
                }
                catch (LDAPException lDAPException) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject:entryExists: " + string + "does not exist");
                    }
                    Object var6_4 = null;
                    if (lDAPConnection != null) {
                        dlayer.releaseConnection(lDAPConnection);
                    }
                    break block11;
                }
                catch (SMSException sMSException) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject: SMSException while  checking for entry: " + string, (Throwable)sMSException);
                    }
                    Object var6_5 = null;
                    if (lDAPConnection != null) {
                        dlayer.releaseConnection(lDAPConnection);
                    }
                }
                Object var6_3 = null;
                if (lDAPConnection != null) {
                    dlayer.releaseConnection(lDAPConnection);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (lDAPConnection != null) {
                    dlayer.releaseConnection(lDAPConnection);
                }
                throw throwable;
            }
        }
        return bl;
    }

    public String getRootSuffix() {
        return baseDN;
    }

    public String registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        return LDAPEventManager.addObjectChangeListener(sMSObjectListener);
    }

    public void deregisterCallbackHandler(String string) {
        LDAPEventManager.removeObjectChangeListener(string);
    }

    private static LDAPAttributeSet copyMapToAttrSet(Map map) {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[map.size()];
        Iterator iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            lDAPAttributeArray[n] = new LDAPAttribute(string, set.toArray(new String[set.size()]));
            ++n;
        }
        return new LDAPAttributeSet(lDAPAttributeArray);
    }

    private static LDAPModificationSet copyModItemsToLDAPModSet(ModificationItem[] modificationItemArray) throws SMSException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        try {
            int n = 0;
            while (n < modificationItemArray.length) {
                Attribute attribute = modificationItemArray[n].getAttribute();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(attribute.getID());
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    lDAPAttribute.addValue((String)namingEnumeration.next());
                }
                switch (modificationItemArray[n].getModificationOp()) {
                    case 1: {
                        lDAPModificationSet.add(0, lDAPAttribute);
                        break;
                    }
                    case 2: {
                        lDAPModificationSet.add(2, lDAPAttribute);
                        break;
                    }
                    case 3: {
                        lDAPModificationSet.add(1, lDAPAttribute);
                    }
                }
                ++n;
            }
        }
        catch (NamingException namingException) {
            throw new SMSException(namingException);
        }
        return lDAPModificationSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectChanged(String string, int n) {
        string = new DN(string).toRFCString().toLowerCase();
        Set set = entriesPresent;
        synchronized (set) {
            if (n == 1) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesPresent.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string.equals(new DN(string2).toRFCString().toLowerCase())) continue;
                    hashSet.add(string2);
                }
                entriesPresent = hashSet;
            } else if (n == 0) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesNotPresent.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string.equals(new DN(string3).toRFCString().toLowerCase())) continue;
                    hashSet.add(string3);
                }
                entriesNotPresent = hashSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allObjectsChanged() {
        SMSEntry.debug.error("SMSLDAPObject: got notifications, all objects changed");
        Set set = entriesPresent;
        synchronized (set) {
            entriesPresent.clear();
            entriesNotPresent.clear();
        }
    }

    static {
        connNumRetry = 3;
        connRetryInterval = 1000;
        retryErrorCodes = new HashSet();
        entriesPresent = new HashSet();
        entriesNotPresent = new HashSet();
        OU_ATTR = new String[1];
    }
}

