/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.EventService;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class LDAPEventManager
implements IDSEventListener {
    protected static String listenerID;
    protected static ServerInstance serInstance;
    protected static Map changeListeners;
    protected static Principal adminPrincipal;

    LDAPEventManager() {
    }

    static synchronized String addObjectChangeListener(SMSObjectListener sMSObjectListener) {
        String string = SMSUtils.getUniqueID();
        changeListeners.put(string, sMSObjectListener);
        return string;
    }

    static synchronized void removeObjectChangeListener(String string) {
        changeListeners.remove(string);
    }

    public synchronized void entryChanged(DSEvent dSEvent) {
        int n = dSEvent.getEventType();
        String string = dSEvent.getID();
        switch (n) {
            case 1: {
                n = 0;
                break;
            }
            case 2: 
            case 8: {
                n = 1;
                break;
            }
            case 4: {
                n = 3;
            }
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSEventListener::entry changed for: " + string + " sending object changed notifications");
        }
        Iterator iterator = changeListeners.values().iterator();
        while (iterator.hasNext()) {
            SMSObjectListener sMSObjectListener = (SMSObjectListener)iterator.next();
            sMSObjectListener.objectChanged(string, n);
        }
    }

    public void eventError(String string) {
        SMSEntry.debug.error("SMSEventListener.eventError(): " + string);
    }

    public void allEntriesChanged() {
        SMSEntry.debug.error("LDAPEventManager: received all entries changed event from EventService");
        Iterator iterator = changeListeners.values().iterator();
        while (iterator.hasNext()) {
            SMSObjectListener sMSObjectListener = (SMSObjectListener)iterator.next();
            sMSObjectListener.allObjectsChanged();
        }
    }

    private static SSOToken getSSOToken() throws SSOException {
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            serInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            AuthPrincipal authPrincipal = new AuthPrincipal(serInstance.getAuthID());
            String string = (String)AccessController.doPrivileged(new ServerInstanceAction(serInstance));
            AuthContext authContext = new AuthContext(authPrincipal, serInstance.getPasswd().toCharArray());
            return authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new SSOException(SSOProviderBundle.rbName, "invalidadmin", null);
        }
    }

    static {
        changeListeners = new HashMap();
        try {
            EventService eventService = EventService.getEventService();
            SSOToken sSOToken = LDAPEventManager.getSSOToken();
            adminPrincipal = sSOToken.getPrincipal();
            listenerID = eventService.addListener(sSOToken, new LDAPEventManager(), serInstance.getBaseDN(), 2, "(|(objectclass=sunService)(objectclass=sunServiceComponent))", 15);
            SMSEntry.debug.message("Initialized LDAPEvent listner");
        }
        catch (Exception exception) {
            SMSEntry.debug.error("Unable to intialize LDAP listener: " + exception);
        }
    }
}

