/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.jaxrpc;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.jaxrpc.SMSJAXRPCObjectImpl;
import com.sun.identity.sm.jaxrpc.SMSObjectIF;
import com.sun.identity.sm.jaxrpc.SMSObjectService_Impl;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.directory.ModificationItem;
import javax.xml.rpc.Stub;
import netscape.ldap.util.DN;

public class SMSJAXRPCObject
extends SMSObject
implements SMSObjectListener {
    private static SMSObjectIF remoteStub;
    private static boolean serverFailed;
    private static String baseDN;
    private static Set entriesPresent;
    private static Set entriesNotPresent;
    private static Debug debug;
    private static Map objectListeners;
    private static int RETRIES;
    private static final String SERVICE_NAME = "SMSJAXRPCObject";
    private static final String INTERFACE_NAME = "SMSObjectIF";
    private static final String SMS_URL = "com.sun.identity.sm.jaxrpc.url";

    public SMSJAXRPCObject() {
        NotificationThread notificationThread = new NotificationThread(this);
        notificationThread.start();
        this.registerCallbackHandler(this);
    }

    public Map read(SSOToken sSOToken, String string) throws SMSException, SSOException {
        RemoteException remoteException = null;
        int n = 0;
        while (n < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                return sMSObjectIF.read(sSOToken.getTokenID().toString(), string);
            }
            catch (RemoteException remoteException2) {
                serverFailed = true;
                remoteException = remoteException2;
                debug.error("SMSJAXRPCObject:read -- RemoteException:", (Throwable)remoteException2);
                ++n;
            }
        }
        throw new SMSException(remoteException);
    }

    public void create(SSOToken sSOToken, String string, Map map) throws SMSException, SSOException {
        RemoteException remoteException = null;
        int n = 0;
        while (n < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                sMSObjectIF.create(sSOToken.getTokenID().toString(), string, map);
                return;
            }
            catch (RemoteException remoteException2) {
                serverFailed = true;
                remoteException = remoteException2;
                debug.error("SMSJAXRPCObject:create", (Throwable)remoteException2);
                ++n;
            }
        }
        throw new SMSException(remoteException);
    }

    public void modify(SSOToken sSOToken, String string, ModificationItem[] modificationItemArray) throws SMSException, SSOException {
        RemoteException remoteException = null;
        int n = 0;
        while (n < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                sMSObjectIF.modify(sSOToken.getTokenID().toString(), string, SMSJAXRPCObjectImpl.toMods(modificationItemArray));
                return;
            }
            catch (RemoteException remoteException2) {
                serverFailed = true;
                remoteException = remoteException2;
                debug.error("SMSJAXRPCObject:modify", (Throwable)remoteException2);
                ++n;
            }
        }
        throw new SMSException(remoteException);
    }

    public void delete(SSOToken sSOToken, String string) throws SMSException, SSOException {
        RemoteException remoteException = null;
        int n = 0;
        while (n < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                sMSObjectIF.delete(sSOToken.getTokenID().toString(), string);
                return;
            }
            catch (RemoteException remoteException2) {
                serverFailed = true;
                remoteException = remoteException2;
                debug.error("SMSJAXRPCObject:delete", (Throwable)remoteException2);
                ++n;
            }
        }
        throw new SMSException(remoteException);
    }

    public Set subEntries(SSOToken sSOToken, String string, String string2, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        RemoteException remoteException = null;
        int n2 = 0;
        while (n2 < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                return sMSObjectIF.subEntries(sSOToken.getTokenID().toString(), string, string2, n, bl, bl2);
            }
            catch (RemoteException remoteException2) {
                serverFailed = true;
                remoteException = remoteException2;
                debug.error("SMSJAXRPCObject:subEntries", (Throwable)remoteException2);
                ++n2;
            }
        }
        throw new SMSException(remoteException);
    }

    public Set search(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        RemoteException remoteException = null;
        int n = 0;
        while (n < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                return sMSObjectIF.search(sSOToken.getTokenID().toString(), string, string2);
            }
            catch (RemoteException remoteException2) {
                serverFailed = true;
                remoteException = remoteException2;
                debug.error("SMSJAXRPCObject:search", (Throwable)remoteException2);
                ++n;
            }
        }
        throw new SMSException(remoteException);
    }

    public boolean entryExists(SSOToken sSOToken, String string) {
        HashSet<String> hashSet;
        if (entriesPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + string);
            }
            return true;
        }
        if (entriesNotPresent.contains(string)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + string);
            }
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < RETRIES) {
            try {
                hashSet = SMSJAXRPCObject.getRemoteStub();
                bl = hashSet.entryExists(sSOToken.getTokenID().toString(), string);
                break;
            }
            catch (Exception exception) {
                serverFailed = true;
                debug.error("SMSJAXRPCObject:entryExisits", (Throwable)exception);
                ++n;
            }
        }
        if (bl) {
            hashSet = new HashSet(entriesPresent);
            hashSet.add(string);
            entriesPresent = hashSet;
        } else {
            hashSet = new HashSet<String>(entriesNotPresent);
            hashSet.add(string);
            entriesNotPresent = hashSet;
        }
        return bl;
    }

    public String getRootSuffix() {
        int n = 0;
        while (baseDN == null && n < RETRIES) {
            try {
                SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                baseDN = sMSObjectIF.getRootSuffix();
                break;
            }
            catch (Exception exception) {
                serverFailed = true;
                debug.error("SMSJAXRPCObject:entryExisits", (Throwable)exception);
                ++n;
            }
        }
        return baseDN;
    }

    public synchronized String registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        return this.registerCallbackHandler(sMSObjectListener);
    }

    protected String registerCallbackHandler(SMSObjectListener sMSObjectListener) {
        String string = SMSUtils.getUniqueID();
        objectListeners.put(string, sMSObjectListener);
        return string;
    }

    public synchronized void deregisterCallbackHandler(String string) {
        objectListeners.remove(string);
    }

    protected static SMSObjectIF getRemoteStub() throws SMSException {
        if (remoteStub == null || serverFailed) {
            remoteStub = SMSJAXRPCObject.getValidServer();
            serverFailed = false;
        }
        return remoteStub;
    }

    protected static synchronized SMSObjectIF getValidServer() throws SMSException {
        SMSObjectIF sMSObjectIF;
        Exception exception;
        boolean bl;
        block11: {
            bl = false;
            exception = null;
            sMSObjectIF = null;
            try {
                Enumeration enumeration;
                Object object;
                String string = SystemProperties.get((String)SMS_URL);
                boolean bl2 = false;
                if (string != null) {
                    bl2 = true;
                    object = new StringTokenizer(string, ",");
                    Vector<String> vector = new Vector<String>();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string2 = ((StringTokenizer)object).nextToken();
                        string2 = string2.endsWith("/") ? string2 + INTERFACE_NAME : string2 + "/SMSObjectIF";
                        vector.add(((StringTokenizer)object).nextToken());
                    }
                    enumeration = vector.elements();
                } else {
                    enumeration = WebtopNaming.getPlatformServerList().elements();
                }
                while (enumeration.hasMoreElements() && !bl) {
                    object = new URL((String)enumeration.nextElement());
                    sMSObjectIF = bl2 ? SMSJAXRPCObject.getServiceEndPoint(((URL)object).toString()) : SMSJAXRPCObject.getServiceEndPoint(((URL)object).getProtocol(), ((URL)object).getHost(), Integer.toString(((URL)object).getPort()));
                    try {
                        sMSObjectIF.checkForLocal();
                        if (debug.messageEnabled()) {
                            debug.message("SMSJAXRPCObject(): Using the remote URL: " + ((URL)object).toString());
                        }
                        bl = true;
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!debug.warningEnabled()) continue;
                        debug.warning("SMSJAXRPCObject:getRemoteStub: server (" + object + ") error: ", (Throwable)exception2);
                    }
                }
            }
            catch (Exception exception3) {
                exception = exception3;
                if (!debug.warningEnabled()) break block11;
                debug.warning("SMSJAXRPCObject:getRemoteStub: generic error: ", (Throwable)exception3);
            }
        }
        if (!bl) {
            if (exception != null) {
                throw new SMSException(exception);
            }
            throw new SMSException(SMSException.STATUS_REPEATEDLY_FAILED, SMSEntry.bundle.getString("sms-SERVER_DOWN"));
        }
        return sMSObjectIF;
    }

    protected static SMSObjectIF getServiceEndPoint(String string, String string2, String string3) throws Exception {
        URL uRL = WebtopNaming.getServiceURL((String)SERVICE_NAME, (String)string, (String)string2, (String)string3);
        String string4 = uRL.toString() + "/" + INTERFACE_NAME;
        return SMSJAXRPCObject.getServiceEndPoint(string4);
    }

    protected static SMSObjectIF getServiceEndPoint(String string) throws Exception {
        if (debug.messageEnabled()) {
            debug.message("SMSJAXRPCObject Endpoint URL: " + string);
        }
        Stub stub = (Stub)new SMSObjectService_Impl().getSMSObjectIFPort();
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string);
        return (SMSObjectIF)stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectChanged(String string, int n) {
        string = new DN(string).toRFCString().toLowerCase();
        Set set = entriesPresent;
        synchronized (set) {
            if (n == 1) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesPresent.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string.equals(new DN(string2).toRFCString().toLowerCase())) continue;
                    hashSet.add(string2);
                }
                entriesPresent = hashSet;
            } else if (n == 0) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = entriesNotPresent.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string.equals(new DN(string3).toRFCString().toLowerCase())) continue;
                    hashSet.add(string3);
                }
                entriesNotPresent = hashSet;
            }
        }
    }

    public void allObjectsChanged() {
    }

    static {
        entriesPresent = new HashSet();
        entriesNotPresent = new HashSet();
        debug = SMSEntry.debug;
        objectListeners = new HashMap();
        RETRIES = 3;
    }

    static class NotificationThread
    extends Thread {
        static final String CACHE_TIME_PROPERTY = "com.sun.identity.sm.cacheTime";
        static int pollingTime = 1;
        static int sleepTime = 60000;

        NotificationThread(SMSJAXRPCObject sMSJAXRPCObject) {
            block2: {
                this.setDaemon(true);
                String string = SystemProperties.get((String)CACHE_TIME_PROPERTY);
                if (string == null) break block2;
                try {
                    pollingTime = Integer.parseInt(string);
                    sleepTime = pollingTime * 1000 * 60;
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("SMSJAXRPCObject::NotificationThread:: Cache Time error: " + string, (Throwable)numberFormatException);
                }
            }
        }

        public void run() {
            boolean bl = false;
            while (true) {
                try {
                    while (true) {
                        if (bl) {
                            Thread.sleep(sleepTime);
                        }
                        SMSObjectIF sMSObjectIF = SMSJAXRPCObject.getRemoteStub();
                        Set set = sMSObjectIF.objectsChanged(pollingTime);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            String string2 = string.substring(4);
                            int n = 3;
                            if (string.startsWith("ADD:")) {
                                n = 0;
                            }
                            if (string.startsWith("DEL:")) {
                                n = 1;
                            }
                            Iterator iterator2 = objectListeners.values().iterator();
                            while (iterator2.hasNext()) {
                                SMSObjectListener sMSObjectListener = (SMSObjectListener)iterator2.next();
                                sMSObjectListener.objectChanged(string2, n);
                            }
                        }
                        bl = true;
                    }
                }
                catch (SMSException sMSException) {
                    if (sMSException.getExceptionCode() != SMSException.STATUS_REPEATEDLY_FAILED) {
                        bl = false;
                    }
                    debug.warning("SMSJAXRPCObject::NotificationThread:run SMSException", (Throwable)sMSException);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                    debug.warning("SMSJAXRPCObject::NotificationThread:run Interrupted Exception", (Throwable)interruptedException);
                    continue;
                }
                catch (RemoteException remoteException) {
                    bl = false;
                    debug.warning("SMSJAXRPCObject::NotificationThread:run Remote Exception", (Throwable)remoteException);
                    continue;
                }
                break;
            }
        }
    }
}

