/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.InvalidAttributeNameException;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceAttributeValidator;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceSchemaImpl {
    Node schemaNode;
    String name;
    String i18nKey;
    String statusAttribute;
    String validate;
    Set serviceAttributes;
    Map attrSchemas;
    Map attrValidators;
    Map attrDefaults;
    Map attrReadOnlyDefaults;
    Map subSchemas;
    ServiceSchemaManagerImpl ssm;
    static Debug debug = SMSEntry.debug;

    ServiceSchemaImpl() {
    }

    protected ServiceSchemaImpl(Node node) {
        this(null, node);
    }

    protected ServiceSchemaImpl(ServiceSchemaManagerImpl serviceSchemaManagerImpl, Node node) {
        this.ssm = serviceSchemaManagerImpl;
        this.update(node);
    }

    String getName() {
        return this.name;
    }

    String getI18NKey() {
        if (this.ssm != null) {
            return this.ssm.getI18NKey();
        }
        return this.i18nKey;
    }

    String getStatusAttribute() {
        return this.statusAttribute;
    }

    String getValidate() {
        return this.validate;
    }

    Set getAttributeSchemaNames() {
        return new HashSet(this.attrSchemas.keySet());
    }

    Set getServiceAttributeNames() {
        return new HashSet(this.serviceAttributes);
    }

    AttributeSchemaImpl getAttributeSchema(String string) {
        return (AttributeSchemaImpl)this.attrSchemas.get(string);
    }

    Set getAttributeSchemas() {
        return new HashSet(this.attrSchemas.values());
    }

    Map getAttributeDefaults() {
        return SMSUtils.copyAttributes(this.attrDefaults);
    }

    Map getReadOnlyAttributeDefaults() {
        return this.attrReadOnlyDefaults;
    }

    Set getSubSchemaNames() {
        return new HashSet(this.subSchemas.keySet());
    }

    ServiceSchemaImpl getSubSchema(String string) throws SMSException {
        return (ServiceSchemaImpl)this.subSchemas.get(string);
    }

    boolean validateAttributes(Map map, boolean bl) throws SMSException {
        if (this.validate != null && this.validate.equalsIgnoreCase("no")) {
            return true;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equalsIgnoreCase("cospriority")) continue;
            Set set = (Set)map.get(string);
            this.validateAttrValues(string, set, bl);
            this.validatePlugin(string, set);
        }
        return true;
    }

    public String toString() {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.getName() != null) {
            stringBuffer.append("Schema name: ").append(this.getName()).append("\n");
        }
        if (this.attrSchemas.size() > 0) {
            stringBuffer.append("Attribute Schemas:\n");
            iterator = this.attrSchemas.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.attrSchemas.get(iterator.next()).toString());
            }
        }
        if (this.subSchemas.size() > 0) {
            stringBuffer.append("Sub-Schemas:\n");
            iterator = this.subSchemas.keySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.subSchemas.get(iterator.next()).toString());
            }
        }
        return stringBuffer.toString();
    }

    Node getSchemaNode() {
        return this.schemaNode;
    }

    synchronized void update(Node node) {
        this.schemaNode = node;
        if (this.schemaNode == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceSchemaImpl::update schema node is NULL");
            }
            this.name = "";
            this.i18nKey = null;
            this.statusAttribute = null;
            this.serviceAttributes = new HashSet();
            this.attrDefaults = this.subSchemas = new HashMap();
            this.attrValidators = this.subSchemas;
            this.attrSchemas = this.subSchemas;
            this.attrReadOnlyDefaults = Collections.unmodifiableMap(new HashMap());
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"name");
        this.i18nKey = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"i18nKey");
        this.statusAttribute = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"statusAttribute");
        this.validate = XMLUtils.getNodeAttributeValue((Node)this.schemaNode, (String)"validate");
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, AttributeSchemaImpl> hashMap = new HashMap<String, AttributeSchemaImpl>();
        HashMap<String, AttributeValidator> hashMap2 = new HashMap<String, AttributeValidator>();
        HashMap<String, Set> hashMap3 = new HashMap<String, Set>();
        HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
        HashMap hashMap5 = new HashMap();
        NodeList nodeList = this.schemaNode.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            Node node2 = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            if (node2.getNodeName().equals("AttributeSchema")) {
                object = null;
                if (this.attrSchemas != null) {
                    object = (AttributeSchemaImpl)this.attrSchemas.get(string);
                }
                if (object == null) {
                    object = new AttributeSchemaImpl(node2);
                } else {
                    ((AttributeSchemaImpl)object).update(node2);
                }
                hashMap.put(string, (AttributeSchemaImpl)object);
                if (!((AttributeSchemaImpl)object).isStatusAttribute() && !((AttributeSchemaImpl)object).isServiceIdentifier()) {
                    hashSet.add(string);
                }
                hashMap2.put(string, new AttributeValidator((AttributeSchemaImpl)object));
                hashMap3.put(string, ((AttributeSchemaImpl)object).getDefaultValues());
                hashMap5.put(string, Collections.unmodifiableSet(((AttributeSchemaImpl)object).getDefaultValues()));
            } else if (node2.getNodeName().equals("SubSchema")) {
                object = null;
                if (this.subSchemas != null) {
                    object = (ServiceSchemaImpl)this.subSchemas.get(string);
                }
                if (object == null) {
                    hashMap4.put(string, new ServiceSchemaImpl(node2));
                } else {
                    ((ServiceSchemaImpl)object).update(node2);
                    hashMap4.put(string, object);
                }
            }
            ++n;
        }
        this.serviceAttributes = hashSet;
        this.attrSchemas = hashMap;
        this.attrValidators = hashMap2;
        this.attrDefaults = hashMap3;
        this.attrReadOnlyDefaults = Collections.unmodifiableMap(hashMap5);
        this.subSchemas = hashMap4;
    }

    AttributeValidator getAttributeValidator(String string) {
        AttributeValidator attributeValidator = (AttributeValidator)this.attrValidators.get(string);
        if (attributeValidator == null) {
            AttributeSchemaImpl attributeSchemaImpl = this.getAttributeSchema(string);
            if (attributeSchemaImpl == null) {
                return null;
            }
            attributeValidator = new AttributeValidator(attributeSchemaImpl);
            this.attrValidators.put(string, attributeValidator);
        }
        return attributeValidator;
    }

    void validateAttrValues(String string, Set set, boolean bl) throws SMSException {
        AttributeValidator attributeValidator = this.getAttributeValidator(string);
        if (attributeValidator == null) {
            Object[] objectArray = new String[]{string};
            throw new InvalidAttributeNameException("amSDK", "sms-validation_failed_invalid_name", objectArray);
        }
        attributeValidator.validate(set, bl);
    }

    boolean validatePlugin(String string, Set set) throws SMSException, InvalidAttributeNameException {
        AttributeSchemaImpl attributeSchemaImpl = this.getAttributeSchema(string);
        if (attributeSchemaImpl == null) {
            Object[] objectArray = new String[]{string};
            throw new InvalidAttributeNameException("amSDK", "sms-validation_failed_invalid_name", objectArray);
        }
        String string2 = attributeSchemaImpl.getValidator();
        if (string2 == null) {
            return true;
        }
        AttributeSchemaImpl attributeSchemaImpl2 = this.getAttributeSchema(string2);
        if (attributeSchemaImpl2 == null) {
            if (debug.warningEnabled()) {
                debug.warning("ServiceConfigValidator.validatePlugin: no definition found for the validator " + string2);
            }
            return true;
        }
        Set set2 = attributeSchemaImpl2.getDefaultValues();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            String string3 = (String)iterator.next();
            if (debug.messageEnabled()) {
                debug.message("ServiceConfigValidator.validatePlugin: validate the attribute " + string + " by the validator " + string3);
            }
            ServiceAttributeValidator serviceAttributeValidator = null;
            try {
                objectArray = Class.forName(string3);
                serviceAttributeValidator = (ServiceAttributeValidator)objectArray.newInstance();
            }
            catch (Exception exception) {
                debug.error("ServiceConfigValidator.validatePlugin: unable to instantiate the validator class " + string3);
                Object[] objectArray2 = new String[]{string3};
                throw new SMSException("amSDK", "sms-validator_cannot_instantiate_class", objectArray2);
            }
            if (serviceAttributeValidator.validate(set)) continue;
            if (debug.messageEnabled()) {
                debug.message("ServiceConfigValidator.validatePlugin: validation failed for the the attribute: " + string + " and its values: " + set);
            }
            objectArray = new String[]{string};
            throw new InvalidAttributeValueException("amSDK", "sms-attribute-values-does-not-match-schema", objectArray);
        }
        return true;
    }
}

