/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.InvalidAttributeNameException;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceSchema {
    ServiceSchemaImpl ss;
    String componentName;
    SchemaType type;
    ServiceSchemaManager ssm;
    String statusAttribute;
    static Debug debug = SMSEntry.debug;

    private ServiceSchema() {
    }

    protected ServiceSchema(ServiceSchemaImpl serviceSchemaImpl, String string, SchemaType schemaType, ServiceSchemaManager serviceSchemaManager) {
        this.ss = serviceSchemaImpl;
        this.componentName = string;
        this.type = schemaType;
        this.ssm = serviceSchemaManager;
    }

    protected ServiceSchema(ServiceSchemaImpl serviceSchemaImpl, String string, SchemaType schemaType, ServiceSchemaManager serviceSchemaManager, String string2) {
        this.ss = serviceSchemaImpl;
        this.componentName = string;
        this.type = schemaType;
        this.ssm = serviceSchemaManager;
        this.statusAttribute = string2;
    }

    public String getServiceName() {
        return this.ssm.getName();
    }

    public String getVersion() {
        return this.ssm.getVersion();
    }

    public String getName() {
        return this.ss.getName();
    }

    public SchemaType getServiceType() {
        return this.type;
    }

    public String getI18NKey() {
        return this.ss.getI18NKey();
    }

    public void setI18Nkey(String string) throws SMSException, SSOException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Node node = this.ss.getSchemaNode();
        ((Element)node).setAttribute("i18nKey", string);
        this.ssm.replaceSchema(ServiceSchemaManagerImpl.getInstance(this.ssm.getSSOToken(), this.ssm.getName(), this.ssm.getVersion()).getDocument());
        this.ss.i18nKey = string;
    }

    public String getPropertiesViewBeanURL() {
        return this.ssm.getPropertiesViewBeanURL();
    }

    public String getStatusAttribute() {
        return this.ss.getStatusAttribute();
    }

    public Set getAttributeSchemaNames() {
        return this.ss.getAttributeSchemaNames();
    }

    public AttributeSchema getAttributeSchema(String string) {
        AttributeSchemaImpl attributeSchemaImpl = this.ss.getAttributeSchema(string);
        return attributeSchemaImpl == null ? null : new AttributeSchema(attributeSchemaImpl, this.ssm, this);
    }

    public Set getAttributeSchemas() {
        HashSet<AttributeSchema> hashSet = new HashSet<AttributeSchema>();
        Iterator iterator = this.getAttributeSchemaNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            hashSet.add(this.getAttributeSchema(string));
        }
        return hashSet;
    }

    public Set getServiceAttributeNames() {
        return this.ss.getServiceAttributeNames();
    }

    public Map validateAndInheritDefaults(Map map, boolean bl) throws SMSException {
        Object object;
        SMSEntry.validateToken(this.ssm.getSSOToken());
        if (map == null || map.isEmpty()) {
            map = new HashMap();
        }
        Iterator iterator = map.keySet().iterator();
        Set set = this.ss.getAttributeSchemaNames();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (set.contains(object)) continue;
            debug.error("ServiceSchema.validateAndInheritDefaults: " + (String)object + " is not listed in the service " + this.getServiceName());
            throw new InvalidAttributeNameException("amSDK", "services_validator_invalid_attr_name", null);
        }
        object = this.ss.getAttributeSchemaNames().iterator();
        while (object.hasNext()) {
            Set set2;
            String string = (String)object.next();
            AttributeSchemaImpl attributeSchemaImpl = this.ss.getAttributeSchema(string);
            AttributeValidator attributeValidator = this.ss.getAttributeValidator(string);
            String string2 = attributeSchemaImpl.getAny();
            if (string2 != null && string2.indexOf("required") > -1) {
                set2 = (Set)map.get(string);
                if (set2 != null && set2.isEmpty()) {
                    debug.error("ServiceSchema.validateAndInheritDefaults: " + string + " is a required attribute and cannot" + " be deleted");
                    Object[] objectArray = new Object[]{string};
                    throw new SMSException("amSDK", "sms-required-attribute-delete", objectArray);
                }
                if (bl) {
                    map = attributeValidator.inheritDefaults(map);
                }
            }
            if ((set2 = (Set)map.get(string)) == null) continue;
            attributeValidator.validate(set2, false);
        }
        if (debug.messageEnabled()) {
            debug.error("ServiceSchema.validate&InheritDef:  returning attrMap: " + ((Object)map).toString());
        }
        return map;
    }

    public void addAttributeSchema(InputStream inputStream) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Document document = SMSSchema.getXMLDocument(inputStream, false);
        NodeList nodeList = document.getElementsByTagName("AttributeSchema");
        Set set = this.ss.getAttributeSchemaNames();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            AttributeSchemaImpl attributeSchemaImpl = new AttributeSchemaImpl(node);
            if (set.contains(attributeSchemaImpl.getName())) {
                Object[] objectArray = new Object[]{attributeSchemaImpl.getName()};
                throw new SMSException("amSDK", "sms-attributeschema-already-exists", objectArray);
            }
            ++n;
        }
        this.appendChildNode(nodeList);
    }

    public void removeAttributeSchema(String string) throws SSOException, SMSException {
        this.removeChildNode("AttributeSchema", string);
    }

    public Map getAttributeDefaults() {
        return this.ss.getAttributeDefaults();
    }

    public Map getReadOnlyAttributeDefaults() {
        return this.ss.getReadOnlyAttributeDefaults();
    }

    public void setAttributeDefaults(Map map) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Document document = this.ssm.getDocumentCopy();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = this.getAttributeSchema(string);
            if (attributeSchema == null) {
                throw new SchemaException("invalid-attr-name: " + string);
            }
            attributeSchema.setDefaultValues((Set)map.get(string), document);
        }
        this.ssm.replaceSchema(document);
    }

    public void setAttributeDefaults(String string, Set set) throws SchemaException, SMSException, SSOException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        AttributeSchema attributeSchema = this.getAttributeSchema(string);
        if (attributeSchema == null) {
            Object[] objectArray = new Object[]{string};
            throw new SchemaException("amSDK", "sms-invalid-attr-name", objectArray);
        }
        attributeSchema.setDefaultValues(set);
    }

    public void removeAttributeDefaults(Set set) throws SMSException, SSOException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AttributeSchema attributeSchema = this.getAttributeSchema(string);
            if (attributeSchema == null) {
                throw new InvalidAttributeNameException("amSDK", "services_validator_invalid_attr_name", null);
            }
            attributeSchema.removeDefaultValues();
        }
    }

    public Set getSubSchemaNames() {
        return this.ss.getSubSchemaNames();
    }

    public ServiceSchema getSubSchema(String string) throws SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        ServiceSchema serviceSchema = null;
        ServiceSchemaImpl serviceSchemaImpl = this.ss.getSubSchema(string);
        if (serviceSchemaImpl != null) {
            serviceSchema = new ServiceSchema(serviceSchemaImpl, this.componentName + "/" + string, this.type, this.ssm);
        }
        return serviceSchema;
    }

    public void addSubSchema(InputStream inputStream) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Document document = SMSSchema.getXMLDocument(inputStream, false);
        NodeList nodeList = document.getElementsByTagName("SubSchema");
        Set set = this.ss.getSubSchemaNames();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
            if (set.contains(string)) {
                Object[] objectArray = new Object[]{string};
                throw new SMSException("amSDK", "sms-subschema-already-exists", objectArray);
            }
            ++n;
        }
        this.appendChildNode(nodeList);
    }

    public void removeSubSchema(String string) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        this.removeChildNode("SubSchema", string);
    }

    public boolean validateAttributes(Map map) throws SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        return this.ss.validateAttributes(map, false);
    }

    public String toString() {
        return this.ss.toString();
    }

    public Node getSchemaNode() {
        Node node = null;
        try {
            node = this.getSchemaNode(this.ssm.getDocumentCopy());
        }
        catch (SMSException sMSException) {
            debug.error("ServiceSchema::getSchemaNode: invalid schema");
        }
        return node;
    }

    void appendChildNode(InputStream inputStream, String string) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("ServiceSchema::appendChildNode called for: " + this.getServiceName() + "(" + this.ssm.getVersion() + ") " + this.componentName + " + " + string);
        }
        Document document = SMSSchema.getXMLDocument(inputStream, false);
        NodeList nodeList = document.getElementsByTagName(string);
        this.appendChildNode(nodeList);
    }

    void appendChildNode(NodeList nodeList) throws SSOException, SMSException {
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new SMSException("amSDK", "sms-SMSSchema_no_schema_element", null);
        }
        Document document = this.ssm.getDocumentCopy();
        try {
            Node node = this.getSchemaNode(document);
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                Node node3 = document.importNode(node2, true);
                node.appendChild(node3);
                ++n;
            }
        }
        catch (Exception exception) {
            throw new SMSException(exception.getMessage(), exception);
        }
        this.ssm.replaceSchema(document);
    }

    void removeChildNode(String string, String string2) throws SSOException, SMSException {
        Node node;
        Document document;
        Node node2;
        if (debug.messageEnabled()) {
            debug.message("ServiceSchema::appendChildNode called for: " + this.getServiceName() + "(" + this.ssm.getVersion() + ") " + this.componentName);
        }
        if ((node2 = this.getSchemaNode(document = this.ssm.getDocumentCopy())) != null && (node = XMLUtils.getNamedChildNode((Node)node2, (String)string, (String)"name", (String)string2)) != null) {
            node2.removeChild(node);
        }
        this.ssm.replaceSchema(document);
    }

    Node getSchemaNode(Document document) throws SMSException {
        NodeList nodeList = document.getElementsByTagName("Schema");
        if (nodeList == null || nodeList.getLength() == 0) {
            this.throwInvalidSchemaException();
        }
        Node node = nodeList.item(0);
        String string = "Global";
        if (this.type.equals(SchemaType.ORGANIZATION)) {
            string = "Organization";
        } else if (this.type.equals(SchemaType.DYNAMIC)) {
            string = "Dynamic";
        } else if (this.type.equals(SchemaType.USER)) {
            string = "User";
        } else if (this.type.equals(SchemaType.POLICY)) {
            string = "Policy";
        } else if (this.type.equals(SchemaType.GROUP)) {
            string = "Group";
        } else if (this.type.equals(SchemaType.DOMAIN)) {
            string = "Domain";
        }
        Node node2 = XMLUtils.getChildNode((Node)node, (String)string);
        if (node2 == null) {
            this.throwInvalidSchemaException();
        }
        if (this.componentName == null || this.componentName.length() == 0) {
            return node2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.componentName, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.length() == 0 || (node2 = XMLUtils.getNamedChildNode((Node)node2, (String)"SubSchema", (String)"name", (String)string2)) != null) continue;
            this.throwInvalidSchemaException();
        }
        return node2;
    }

    void throwInvalidSchemaException() throws SMSException {
        SMSEntry.debug.error("ServiceSchema::getSchemaNode: Invalid service schema XML: " + this.getServiceName() + "(" + this.ssm.getVersion() + ")");
        throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
    }
}

