/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceManager {
    private static boolean initialized;
    private static SSOTokenManager ssoTokenManager;
    protected static final String serviceDN;
    protected static SMSEntry smsEntry;
    protected static CachedSubEntries serviceNames;
    protected static HashMap serviceVersions;
    protected static HashMap serviceNameDefaultVersion;
    private SSOToken token;
    protected HashMap serviceSchemaMgrs = new HashMap();
    protected HashMap serviceConfigMgrs = new HashMap();
    private static Debug debug;

    public ServiceManager(SSOToken sSOToken) throws SSOException, SMSException {
        ServiceManager.initialize(sSOToken);
        ssoTokenManager.validateToken(sSOToken);
        this.token = sSOToken;
    }

    public ServiceSchemaManager getSchemaManager(String string, String string2) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string3 = ServiceManager.getCacheIndex(string, string2);
        ServiceSchemaManager serviceSchemaManager = (ServiceSchemaManager)this.serviceSchemaMgrs.get(string3);
        if (serviceSchemaManager == null) {
            serviceSchemaManager = new ServiceSchemaManager(this.token, string, string2);
            if (SMSEntry.cacheSMSEntries) {
                this.serviceSchemaMgrs.put(string3, serviceSchemaManager);
            }
        }
        return serviceSchemaManager;
    }

    public ServiceConfigManager getConfigManager(String string, String string2) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        String string3 = ServiceManager.getCacheIndex(string, string2);
        ServiceConfigManager serviceConfigManager = (ServiceConfigManager)this.serviceConfigMgrs.get(string3);
        if (serviceConfigManager == null) {
            serviceConfigManager = new ServiceConfigManager(this.token, string, string2);
            if (SMSEntry.cacheSMSEntries) {
                this.serviceConfigMgrs.put(string3, serviceConfigManager);
            }
        }
        return serviceConfigManager;
    }

    public Set getServiceNames() throws SMSException {
        try {
            return serviceNames.getSubEntries();
        }
        catch (SSOException sSOException) {
            debug.error("ServiceManager: Unable to get service names", (Throwable)sSOException);
            throw new SMSException(sSOException);
        }
    }

    public Set getServiceVersions(String string) throws SMSException {
        try {
            return ServiceManager.getVersions(this.token, string);
        }
        catch (SSOException sSOException) {
            debug.error("ServiceManager: Unable to get service vers", (Throwable)sSOException);
            throw new SMSException(sSOException);
        }
    }

    public Set registerServices(InputStream inputStream) throws SMSException, SSOException {
        SMSEntry.validateToken(this.token);
        HashSet<String> hashSet = new HashSet<String>();
        Document document = SMSSchema.getXMLDocument(inputStream);
        NodeList nodeList = document.getElementsByTagName("Service");
        int n = 0;
        while (nodeList != null && n < nodeList.getLength()) {
            Node node;
            Object object;
            Node node2 = nodeList.item(n);
            String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"name");
            String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"version");
            SMSSchema sMSSchema = new SMSSchema(string, string2, document);
            if (XMLUtils.getChildNode((Node)node2, (String)"Schema") != null) {
                ServiceManager.validateServiceSchema(node2);
                ServiceSchemaManager.createService(this.token, sMSSchema);
                serviceNames.add(string);
                object = (CachedSubEntries)serviceVersions.get(string);
                if (object == null) {
                    object = CachedSubEntries.getInstance(this.token, ServiceManager.getServiceNameDN(string));
                    serviceVersions.put(string, object);
                }
                ((CachedSubEntries)object).add(string2);
                hashSet.add(string);
            }
            object = XMLUtils.getChildNodes((Node)node2, (String)"PluginSchema").iterator();
            while (object.hasNext()) {
                node = (Node)object.next();
                PluginSchema.createPluginSchema(this.token, node, sMSSchema);
            }
            node = XMLUtils.getChildNode((Node)node2, (String)"Configuration");
            if (node != null) {
                CreateServiceConfig.createService(this, string, string2, node);
            }
            ++n;
        }
        return hashSet;
    }

    public void removeService(String string, String string2) throws SMSException, SSOException {
        SMSEntry sMSEntry;
        CachedSMSEntry cachedSMSEntry;
        Object object;
        SMSEntry.validateToken(this.token);
        Object[] objectArray = new String[]{string, string2};
        Iterator iterator = SMSEntry.search(MessageFormat.format("(&(objectclass=sunService)(ou={0})(ou={1}))", objectArray)).iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            cachedSMSEntry = CachedSMSEntry.getInstance(this.token, (String)object, null);
            sMSEntry = cachedSMSEntry.getSMSEntry();
            sMSEntry.delete(this.token);
            cachedSMSEntry.refresh(sMSEntry);
        }
        object = (CachedSubEntries)serviceVersions.get(string);
        if (object != null) {
            ((CachedSubEntries)object).remove(string2);
            if (((CachedSubEntries)object).isEmpty()) {
                serviceNames.remove(string);
                serviceVersions.remove(string);
                cachedSMSEntry = CachedSMSEntry.getInstance(this.token, ServiceManager.getServiceNameDN(string), null);
                sMSEntry = cachedSMSEntry.getClonedSMSEntry();
                sMSEntry.delete(this.token);
            }
        }
    }

    public void deleteService(String string) throws SMSException, SSOException {
        Iterator iterator = this.getServiceVersions(string).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(this.token, ServiceManager.getServiceNameDN(string, string2), null);
            SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
            String[] stringArray = new String[]{SMSSchema.getDummyXML(string, string2)};
            sMSEntry.setAttribute("sunServiceSchema", stringArray);
            sMSEntry.save(this.token);
            cachedSMSEntry.refresh(sMSEntry);
        }
    }

    public static String getBaseDN() {
        return SMSEntry.baseDN;
    }

    public synchronized void clearCache() {
        this.serviceSchemaMgrs = new HashMap();
        this.serviceConfigMgrs = new HashMap();
        CachedSMSEntry.clearCache();
        ServiceSchemaManagerImpl.clearCache();
        PluginSchemaImpl.clearCache();
        ServiceInstanceImpl.clearCache();
        ServiceConfigImpl.clearCache();
    }

    SSOToken getSSOToken() {
        return this.token;
    }

    protected static String getCacheIndex(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(20);
        return stringBuffer.append(string).append(string2).toString().toLowerCase();
    }

    protected static String getServiceNameDN(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou").append("=").append(string).append(",").append(serviceDN);
        return stringBuffer.toString();
    }

    protected static String getServiceNameDN(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou").append("=").append(string2).append(",").append(ServiceManager.getServiceNameDN(string));
        return stringBuffer.toString();
    }

    protected static Set getVersions(SSOToken sSOToken, String string) throws SMSException, SSOException {
        CachedSubEntries cachedSubEntries = (CachedSubEntries)serviceVersions.get(string);
        if (cachedSubEntries == null) {
            cachedSubEntries = CachedSubEntries.getInstance(sSOToken, ServiceManager.getServiceNameDN(string));
            if (cachedSubEntries.getSMSEntry().isNewEntry() || cachedSubEntries.getSubEntries().isEmpty()) {
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", null);
            }
            serviceVersions.put(string, cachedSubEntries);
        }
        return cachedSubEntries.getSubEntries();
    }

    protected static String serviceDefaultVersion(SSOToken sSOToken, String string) throws SMSException, SSOException {
        String string2 = (String)serviceNameDefaultVersion.get(string);
        if (string2 == null) {
            Iterator iterator = ServiceManager.getVersions(sSOToken, string).iterator();
            if (!iterator.hasNext()) {
                throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", null);
            }
            string2 = (String)iterator.next();
            serviceNameDefaultVersion.put(string, string2);
        }
        return string2;
    }

    protected static void checkServiceNameAndVersion(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        Set set = ServiceManager.getVersions(sSOToken, string);
        if (set == null || !set.contains(string2)) {
            throw new ServiceNotFoundException("amSDK", "sms-service_does_not_exist", null);
        }
    }

    protected static boolean validateServiceSchema(Node node) throws SMSException {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Schema");
        String[] stringArray = new String[]{"Global", "Organization", "Dynamic", "User", "Policy", "Group", "Domain"};
        int n = 0;
        while (n < stringArray.length) {
            Node node3 = XMLUtils.getChildNode((Node)node2, (String)stringArray[n]);
            if (node3 != null) {
                ServiceSchemaImpl serviceSchemaImpl = new ServiceSchemaImpl(null, node3);
                Map map = serviceSchemaImpl.getAttributeDefaults();
                serviceSchemaImpl.validateAttributes(map, false);
            }
            ++n;
        }
        return true;
    }

    static void initialize(SSOToken sSOToken) throws SMSException, SSOException {
        SMSEntry.validateToken(sSOToken);
        if (initialized) {
            return;
        }
        try {
            serviceNames = CachedSubEntries.getInstance(sSOToken, serviceDN);
            if (serviceNames.getSMSEntry().isNewEntry()) {
                if (debug.warningEnabled()) {
                    debug.warning("SeviceManager:: Root service node does not exists: " + serviceDN);
                }
                Object[] objectArray = new String[]{serviceDN};
                throw new SMSException("amSDK", "sms-services_node_does_not_exist", objectArray);
            }
            if (SMSEntry.cacheSMSEntries) {
                Iterator iterator = serviceNames.getSubEntries().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    try {
                        ServiceManager.getVersions(sSOToken, string);
                    }
                    catch (SMSException sMSException) {
                        debug.error("ServiceManager::unable to get versions for: " + string, (Throwable)sMSException);
                    }
                }
            }
        }
        catch (SMSException sMSException) {
            debug.error("ServiceManager::unable to get services node: " + serviceDN, (Throwable)sMSException);
            throw sMSException;
        }
        catch (SSOException sSOException) {
            debug.error("ServiceManager::unable to get services node -- ssoToken problem: " + serviceDN, (Throwable)sSOException);
            throw sSOException;
        }
        initialized = true;
    }

    static {
        ssoTokenManager = SMSEntry.tm;
        serviceDN = "ou=services," + SMSEntry.baseDN;
        serviceVersions = new HashMap();
        serviceNameDefaultVersion = new HashMap();
        debug = SMSEntry.debug;
    }
}

