/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ServiceInstanceImpl {
    private String name;
    private String group;
    private String uri;
    private CachedSMSEntry smsEntry;
    private Map attributes;
    private static Map serviceInstances = new HashMap();
    private static Map userPrincipals = new HashMap();
    private static final String serviceInsMutex = "ServiceInstanceMutex";
    private static Debug debug = SMSEntry.debug;

    private ServiceInstanceImpl(String string, CachedSMSEntry cachedSMSEntry) {
        this.name = string;
        this.smsEntry = cachedSMSEntry;
        this.smsEntry.addServiceListener(this);
        this.update();
    }

    String getName() {
        return this.name;
    }

    String getGroup() {
        return this.group;
    }

    String getURI() {
        return this.uri;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("\nService Instance: ").append(this.name).append("\n\tGroup: ").append(this.getGroup()).append("\n\tURI: ").append(this.getURI()).append("\n\tAttributes: ").append(this.attributes);
        return stringBuffer.toString();
    }

    Map getAttributes() {
        return SMSUtils.copyAttributes(this.attributes);
    }

    SMSEntry getSMSEntry() {
        return this.smsEntry.getClonedSMSEntry();
    }

    void refresh(SMSEntry sMSEntry) throws SMSException {
        this.smsEntry.refresh(sMSEntry);
    }

    void updateupdateAndNotifyListeners() {
        this.update();
    }

    void update() {
        this.attributes = SMSUtils.getAttrsFromEntry(this.smsEntry.getSMSEntry());
        this.group = "default";
        String[] stringArray = this.smsEntry.getSMSEntry().getAttributeValues("sunserviceID");
        if (stringArray != null) {
            this.group = stringArray[0];
        }
        this.uri = null;
        String[] stringArray2 = this.smsEntry.getSMSEntry().getAttributeValues("labeleduri");
        if (stringArray2 != null) {
            this.uri = stringArray2[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceInstanceImpl getInstance(SSOToken sSOToken, String string, String string2, String string3) throws SMSException, SSOException {
        String string4;
        ServiceInstanceImpl serviceInstanceImpl;
        if (debug.messageEnabled()) {
            debug.message("ServiceInstanceImpl::getInstance: called: " + string + "(" + string2 + ")" + " Instance: " + string3);
        }
        if ((serviceInstanceImpl = ServiceInstanceImpl.getFromCache(string4 = ServiceInstanceImpl.getCacheName(string, string2, string3), string, string2, string3, sSOToken)) != null) {
            if (!SMSEntry.cacheSMSEntries) {
                serviceInstanceImpl.update();
            }
            return serviceInstanceImpl;
        }
        String string5 = serviceInsMutex;
        synchronized (serviceInsMutex) {
            serviceInstanceImpl = ServiceInstanceImpl.getFromCache(string4, string, string2, string3, sSOToken);
            if (serviceInstanceImpl == null) {
                CachedSMSEntry cachedSMSEntry = ServiceInstanceImpl.checkAndUpdatePermission(string4, string, string2, string3, sSOToken);
                serviceInstanceImpl = new ServiceInstanceImpl(string3, cachedSMSEntry);
                HashMap<String, ServiceInstanceImpl> hashMap = new HashMap<String, ServiceInstanceImpl>(serviceInstances);
                hashMap.put(string4, serviceInstanceImpl);
                serviceInstances = hashMap;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (debug.messageEnabled()) {
                debug.message("ServiceInstanceImpl::getInstance: success: " + string + "(" + string2 + ")" + " Instance: " + string3);
            }
            return serviceInstanceImpl;
        }
    }

    static void clearCache() {
        serviceInstances = new HashMap();
    }

    static String getCacheName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string).append(string2).append(string3);
        return stringBuffer.toString().toLowerCase();
    }

    static ServiceInstanceImpl getFromCache(String string, String string2, String string3, String string4, SSOToken sSOToken) throws SMSException, SSOException {
        Set set;
        ServiceInstanceImpl serviceInstanceImpl = (ServiceInstanceImpl)serviceInstances.get(string);
        if (serviceInstanceImpl != null && !serviceInstanceImpl.smsEntry.isValid()) {
            serviceInstanceImpl = null;
        }
        if (serviceInstanceImpl != null && !(set = (Set)userPrincipals.get(string)).contains(sSOToken.getTokenID().toString())) {
            ServiceInstanceImpl.checkAndUpdatePermission(string, string2, string3, string4, sSOToken);
        }
        return serviceInstanceImpl;
    }

    static synchronized CachedSMSEntry checkAndUpdatePermission(String string, String string2, String string3, String string4, SSOToken sSOToken) throws SMSException, SSOException {
        String string5 = "ou=" + string4 + "," + "ou=Instances," + ServiceManager.getServiceNameDN(string2, string3);
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, string5, null);
        if (cachedSMSEntry.isNewEntry()) {
            Object[] objectArray = new String[]{string4};
            throw new SMSException("amSDK", "sms-no-such-instance", objectArray);
        }
        HashSet<String> hashSet = (HashSet<String>)userPrincipals.get(string);
        hashSet = hashSet == null ? new HashSet<String>() : new HashSet(hashSet);
        hashSet.add(sSOToken.getTokenID().toString());
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(userPrincipals);
        hashMap.put(string, hashSet);
        userPrincipals = hashMap;
        return cachedSMSEntry;
    }
}

