/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.XMLHandler;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSErrorHandler;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SMSSchema {
    private static final String TEXT_NODE = "#text";
    private static final String SLASH_ESC_SEQ = "&#47;";
    private static final String SCHEMA_PREFIX_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<ServicesConfiguration><Service name=\"";
    private static final String SCHEMA_PREFIX_2 = "\" version=\"";
    private static final String SCHEMA_PREFIX_3 = "\">";
    private static final String SCHEMA_SUFFIX = "</Service></ServicesConfiguration>";
    private static final String PLUGIN_PREFIX_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<ServicesConfiguration><Service name=\"";
    private static final String PLUGIN_PREFIX_2 = "\" version=\"";
    private static final String PLUGIN_PREFIX_3 = "\">";
    private static final String PLUGIN_SUFFIX = "</Service></ServicesConfiguration>";
    private Document document;
    private String serviceName;
    private String version;
    private static MessageFormat msgFormatter = new MessageFormat("");

    SMSSchema(Document document) throws SMSException {
        this.document = document;
        this.serviceName = this.getServiceName();
        this.version = this.getServiceVersion();
    }

    SMSSchema(String string, Document document) throws SMSException {
        this(document);
        this.serviceName = string;
    }

    SMSSchema(String string, String string2, Document document) throws SMSException {
        this(string, document);
        this.version = string2;
    }

    SMSSchema(String string, InputStream inputStream) throws SMSException {
        this(inputStream);
        this.serviceName = string;
    }

    SMSSchema(InputStream inputStream) throws SMSException {
        this(SMSSchema.getXMLDocument(inputStream));
    }

    protected String getServiceName() throws SMSException {
        if (this.serviceName == null) {
            this.serviceName = this.getServiceAttribute("name");
        }
        return this.serviceName;
    }

    protected String getServiceVersion() throws SMSException {
        if (this.version == null) {
            this.version = this.getServiceAttribute("version");
        }
        return this.version;
    }

    private String getServiceAttribute(String string) throws SMSException {
        NodeList nodeList = this.document.getElementsByTagName("Service");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        String string2 = XMLUtils.getNodeAttributeValue((Node)nodeList.item(0), (String)string);
        if (string2 == null) {
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        return string2;
    }

    protected Node getServiceNode() throws SMSException {
        NodeList nodeList = this.document.getElementsByTagName("Service");
        if (nodeList == null || nodeList.getLength() == 0) {
            SMSEntry.debug.error("SMSSchema::getSchema: No Service node not found in XML input.");
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        Node node = null;
        boolean bl = false;
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            node = nodeList.item(n2);
            if (XMLUtils.getNodeAttributeValue((Node)node, (String)"name").equalsIgnoreCase(this.serviceName) && XMLUtils.getNodeAttributeValue((Node)node, (String)"version").equalsIgnoreCase(this.version)) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            SMSEntry.debug.error("SMSSchema::getSchema: Service not found :" + this.serviceName);
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        return node;
    }

    protected String getSchema(String string) throws SMSException {
        String string2 = this.serviceName;
        this.serviceName = string;
        String string3 = this.getSchema();
        this.serviceName = string2;
        return string3;
    }

    public String getSchema() throws SMSException {
        Node node = null;
        node = XMLUtils.getChildNode((Node)this.getServiceNode(), (String)"Schema");
        if (node == null) {
            throw new SMSException("amSDK", "IUMSConstants.SMS_SMSSchema_no_service_element", null);
        }
        return SMSSchema.schemaToXML(node, this.getServiceName(), this.getServiceVersion());
    }

    public String getPluginSchema(String string, String string2) throws SMSException {
        String string3 = this.serviceName;
        this.serviceName = string;
        String string4 = this.getPluginSchema(string2);
        this.serviceName = string3;
        return string4;
    }

    public String getPluginSchema(String string) throws SMSException {
        Node node = this.getServiceNode();
        Iterator iterator = XMLUtils.getChildNodes((Node)node, (String)"PluginSchema").iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (!XMLUtils.getNodeAttributeValue((Node)node2, (String)"name").equalsIgnoreCase(string)) continue;
            return PLUGIN_PREFIX_1 + this.getServiceName() + "\" version=\"" + this.getServiceVersion() + "\">" + SMSSchema.nodeToString(node2) + "</Service></ServicesConfiguration>";
        }
        throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
    }

    static String schemaToXML(Node node, String string, String string2) {
        return SCHEMA_PREFIX_1 + string + "\" version=\"" + string2 + "\">" + SMSSchema.nodeToString(node) + "</Service></ServicesConfiguration>";
    }

    public static String getDummyXML(String string, String string2) {
        return SCHEMA_PREFIX_1 + string + "\" version=\"" + string2 + "\"></Service></ServicesConfiguration>";
    }

    public static String nodeToString(Node node) {
        String string = node.getNodeName();
        if (string.equalsIgnoreCase("#comment")) {
            return new String("");
        }
        String string2 = "<" + string + SMSSchema.getNodeAttributes(node) + ">";
        string2 = string2 + SMSSchema.getNodeValue(node);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            string2 = node2.getNodeName().equalsIgnoreCase(TEXT_NODE) ? string2 + SMSSchema.escapeSpecialCharacters(node2.getNodeValue()) : string2 + SMSSchema.nodeToString(node2);
            ++n2;
        }
        string2 = string2 + "</" + string + ">";
        return string2;
    }

    private static String getNodeAttributes(Node node) {
        String string = "";
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        if (namedNodeMap == null || n == 0) {
            return "";
        }
        int n2 = 0;
        while (n2 < n) {
            Node node2 = namedNodeMap.item(n2);
            string = string + " " + node2.getNodeName() + "=\"" + SMSSchema.getNodeValue(node2) + "\" ";
            ++n2;
        }
        return string;
    }

    private static String getNodeValue(Node node) {
        String string = node.getNodeValue();
        if (string != null && !string.equals("")) {
            return string.trim();
        }
        return "";
    }

    public static Document getXMLDocument(String string, boolean bl) throws SchemaException, SMSException {
        return SMSSchema.getXMLDocument(SMSSchema.getServiceSchemaInputStream(string), bl);
    }

    public static Document getXMLDocument(InputStream inputStream) throws SchemaException, SMSException {
        return SMSSchema.getXMLDocument(inputStream, true);
    }

    public static Document getXMLDocument(InputStream inputStream, boolean bl) throws SchemaException, SMSException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SMSErrorHandler());
            documentBuilder.setEntityResolver((EntityResolver)new XMLHandler());
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (SAXParseException sAXParseException) {
            Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
            throw new SchemaException("amSDK", "sms-SMSSchema_parser_error", objectArray);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{new String(sAXException.toString())};
            throw new SchemaException("amSDK", "sms-SMSSchema_exception_message", objectArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{new String(parserConfigurationException.toString())};
            throw new SchemaException("amSDK", "sms-SMSSchema_invalid_xml_document", objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{new String(iOException.toString())};
            throw new SchemaException("amSDK", "sms-SMSSchema_invalid_input_stream", objectArray);
        }
    }

    static InputStream getServiceSchemaInputStream(String string) throws SMSException {
        ByteArrayInputStream byteArrayInputStream;
        if (string == null || string.equals("")) {
            throw new SMSException("amSDK", "sms-SMSSchema_service_notfound", null);
        }
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            SMSEntry.debug.error("SMSSchema: Unsupported encoding ", (Throwable)exception);
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        }
        return byteArrayInputStream;
    }

    Document getDocument() {
        return this.document;
    }

    protected static String escapeSpecialCharacters(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unescapeName(String string) {
        if (string != null && string.trim().length() > 0) {
            int n = string.indexOf(SLASH_ESC_SEQ);
            while (n != -1) {
                string = string.substring(0, n) + "/" + string.substring(n + 5);
                n = string.indexOf(SLASH_ESC_SEQ, n + 1);
            }
        }
        return string;
    }
}

