/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.event.EventException;
import com.iplanet.services.util.XMLException;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.common.L10NMessage;
import com.sun.identity.sm.SMSEntry;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class SMSException
extends Exception
implements L10NMessage {
    AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    Debug debug = Debug.getInstance((String)"amSDK");
    private int exceptionStatus = STATUS_NONE;
    private Throwable rootCause;
    private String message;
    private String bundleName;
    private String errorCode;
    private Object[] args;
    private ResourceBundle bundle;
    public static int STATUS_NONE = -1;
    public static int STATUS_RETRY = 0;
    public static int STATUS_REPEATEDLY_FAILED = 0;
    public static int STATUS_ABORT = 1;
    public static int STATUS_QUO_ANTE = 2;
    public static int STATUS_LDAP_OP_FAILED = 3;
    public static int STATUS_CONFIG_PROBLEM = 4;
    public static int STATUS_UNKNOWN_EXCEPTION = 5;
    public static int STATUS_NO_PERMISSION = 8;

    public SMSException() {
        this.exceptionStatus = STATUS_NONE;
    }

    public SMSException(int n) {
        this.exceptionStatus = n;
    }

    public SMSException(int n, String string) {
        this.message = string;
        this.exceptionStatus = n;
    }

    public SMSException(String string) {
        this.message = string;
        this.exceptionStatus = STATUS_NONE;
    }

    public SMSException(Throwable throwable) {
        this.rootCause = throwable;
        this.exceptionMapper();
    }

    public SMSException(String string, Throwable throwable) {
        this.rootCause = throwable;
        this.exceptionMapper();
    }

    public SMSException(String string, String string2, Object[] objectArray) {
        this.exceptionStatus = STATUS_NONE;
        this.bundleName = string;
        this.errorCode = string2;
        this.args = objectArray;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public String getL10NMessage(java.util.Locale locale) {
        String string = this.errorCode;
        if (this.bundleName != null && locale != null) {
            this.bundle = this.amCache.getResBundle(this.bundleName, locale);
            String string2 = Locale.getString((ResourceBundle)this.bundle, (String)this.errorCode, (Debug)this.debug);
            string = this.args == null || this.args.length == 0 ? string2 : MessageFormat.format(string2, this.args);
        }
        return string;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public int getExceptionCode() {
        return this.exceptionStatus;
    }

    void setExceptionCode(int n) {
        this.exceptionStatus = n;
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.exceptionStatus != -1) {
            stringBuffer.append("SMSException Exception Code:");
            stringBuffer.append(this.exceptionStatus);
            stringBuffer.append('\n');
        }
        if ((string = this.message) != null && string.length() > 0) {
            stringBuffer.append("Message:");
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        if (this.rootCause != null) {
            stringBuffer.append("-----------------------------------------------------\n");
            stringBuffer.append("The lower level exception message\n");
            stringBuffer.append(this.rootCause.getMessage());
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String getMessage() {
        return this.message;
    }

    private String getString(String string) {
        this.errorCode = string;
        return Locale.getString((ResourceBundle)this.bundle, (String)string, (Debug)this.debug);
    }

    private void exceptionMapper() {
        if (this.rootCause == null) {
            return;
        }
        this.bundle = this.amCache.getResBundle("amSDK", java.util.Locale.ENGLISH);
        if (this.rootCause instanceof LDAPException) {
            this.message = this.mapLDAPException();
        } else if (!(this.rootCause instanceof LDAPServiceException)) {
            if (this.rootCause instanceof EventException) {
                this.exceptionStatus = STATUS_ABORT;
                this.message = this.getString("sms-EVENT_NOTIFICATION_FAILED");
            } else if (this.rootCause instanceof XMLException) {
                this.exceptionStatus = STATUS_ABORT;
                this.message = this.getString("sms-XML_PARSER_EXCEPTION");
            } else if (this.rootCause instanceof InvalidAuthContextException) {
                this.message = this.getString("sms-AUTHENTICATION_ERROR");
                this.exceptionStatus = STATUS_ABORT;
            } else if (this.rootCause instanceof SSOException) {
                this.message = this.getString("sms-AUTHENTICATION_ERROR");
                this.exceptionStatus = STATUS_ABORT;
            } else {
                this.message = this.getString("sms-UNKNOWN_EXCEPTION_OCCURED");
                this.exceptionStatus = STATUS_UNKNOWN_EXCEPTION;
            }
        }
    }

    private String mapLDAPException() {
        int n = ((LDAPException)this.rootCause).getLDAPResultCode();
        String string = null;
        switch (n) {
            case 80: 
            case 81: {
                string = this.getString("sms-SERVER_DOWN");
                this.exceptionStatus = STATUS_RETRY;
                break;
            }
            case 92: {
                string = this.getString("sms-LDAP_NOT_SUPPORTED");
                this.exceptionStatus = STATUS_ABORT;
                break;
            }
            case 51: {
                string = this.getString("sms-LDAP_SERVER_BUSY");
                this.exceptionStatus = STATUS_RETRY;
                break;
            }
            case 49: {
                string = this.getString("INVALID_CREDENTIALS");
                this.exceptionStatus = STATUS_CONFIG_PROBLEM;
                break;
            }
            case 32: {
                string = this.getString("sms-NO_SUCH_OBJECT");
                this.exceptionStatus = STATUS_LDAP_OP_FAILED;
                break;
            }
            case 50: {
                string = this.getString("sms-INSUFFICIENT_ACCESS_RIGHTS");
                this.exceptionStatus = STATUS_NO_PERMISSION;
                break;
            }
            case 11: {
                string = this.getString("sms-ADMIN_LIMIT_EXCEEDED");
                this.exceptionStatus = STATUS_ABORT;
                break;
            }
            case 3: {
                string = this.getString("sms-TIME_LIMIT_EXCEEDED");
                this.exceptionStatus = STATUS_ABORT;
                break;
            }
            case 10: {
                string = this.getString("sms-LDAP_REFERRAL_EXCEPTION");
                this.exceptionStatus = STATUS_CONFIG_PROBLEM;
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 20: 
            case 34: 
            case 64: 
            case 65: 
            case 68: {
                SMSEntry.debug.error(this.rootCause.toString());
                string = this.getString("sms-LDAP_OPERATION_FAILED");
                this.exceptionStatus = STATUS_LDAP_OP_FAILED;
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                this.exceptionStatus = STATUS_QUO_ANTE;
                break;
            }
            default: {
                string = this.getString("sms-UNEXPECTED_LDAP_EXCEPTION");
                this.exceptionStatus = STATUS_UNKNOWN_EXCEPTION;
            }
        }
        return string;
    }
}

