/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class SMSEventListenerManager
implements SMSObjectListener {
    protected static HashMap notificationObjects = new HashMap();
    protected static HashMap allChanges = new HashMap();
    protected static HashMap nodeChanges = new HashMap();
    protected static HashMap subNodeChanges = new HashMap();
    private static Debug debug = Debug.getInstance((String)"amSMSEvent");
    protected static boolean initialized;

    static void initialize(SSOToken sSOToken) {
        block2: {
            if (initialized) break block2;
            try {
                SMSEntry.registerCallbackHandler(sSOToken, new SMSEventListenerManager());
                debug.message("Initialized SMS Event listner");
                initialized = true;
            }
            catch (Exception exception) {
                debug.error("Unable to intialize SMS listener: " + exception);
            }
        }
    }

    SMSEventListenerManager() {
    }

    public void objectChanged(String string, int n) {
        if (debug.messageEnabled()) {
            debug.message("SMSEventListener::entry changed for: " + string + " type: " + n);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        SMSEventListenerManager.sendNotifications((Set)nodeChanges.get(string2), null, n);
        if (n == 0 || n == 1) {
            if (debug.messageEnabled()) {
                debug.message("SMSEventListener::entry changed for: " + string2 + " sending notifications to its parents");
            }
            SMSEventListenerManager.sendNotifications((Set)subNodeChanges.get(new DN(string2).getParent().toRFCString().toLowerCase()), string, n);
        }
        SMSEventListenerManager.sendAllChangesNotification(string2, n);
    }

    public void allObjectsChanged() {
        debug.error("SMSEventListenerManager:Got notice from LDAPEventListener all changes ");
    }

    protected static String notifyAllNodeChanges(SSOToken sSOToken, ServiceConfigManagerImpl serviceConfigManagerImpl) {
        SMSEventListenerManager.initialize(sSOToken);
        String string = SMSUtils.getUniqueID();
        allChanges.put(string, serviceConfigManagerImpl);
        return string;
    }

    protected static String notifyChangesToNode(SSOToken sSOToken, String string, Method method, Object object, Object[] objectArray) {
        SMSEventListenerManager.initialize(sSOToken);
        String string2 = new DN(string).toRFCString().toLowerCase();
        return SMSEventListenerManager.addNotificationObject(nodeChanges, string2, method, object, objectArray);
    }

    protected static String notifyChangesToSubNodes(SSOToken sSOToken, String string, Method method, Object object, Object[] objectArray) {
        SMSEventListenerManager.initialize(sSOToken);
        String string2 = new DN(string).toRFCString().toLowerCase();
        return SMSEventListenerManager.addNotificationObject(subNodeChanges, string2, method, object, objectArray);
    }

    protected static void removeNotification(String string) {
        NotificationObject notificationObject = (NotificationObject)notificationObjects.get(string);
        if (notificationObject != null) {
            notificationObject.set.remove(notificationObject);
        }
        allChanges.remove(string);
    }

    private static String addNotificationObject(Map map, String string, Method method, Object object, Object[] objectArray) {
        String string2 = new DN(string).toRFCString().toLowerCase();
        HashSet<NotificationObject> hashSet = (HashSet<NotificationObject>)map.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<NotificationObject>();
            map.put(string2, hashSet);
        }
        NotificationObject notificationObject = new NotificationObject(method, object, objectArray, hashSet);
        hashSet.add(notificationObject);
        notificationObjects.put(notificationObject.getID(), notificationObject);
        return notificationObject.getID();
    }

    private static void sendAllChangesNotification(String string, int n) {
        Iterator iterator = allChanges.values().iterator();
        while (iterator.hasNext()) {
            ServiceConfigManagerImpl serviceConfigManagerImpl = (ServiceConfigManagerImpl)iterator.next();
            serviceConfigManagerImpl.entryChanged(string, n);
        }
    }

    private static void sendNotifications(Set set, String string, int n) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                NotificationObject notificationObject = (NotificationObject)iterator.next();
                if (string != null && notificationObject.object instanceof CachedSubEntries) {
                    CachedSubEntries cachedSubEntries = (CachedSubEntries)notificationObject.object;
                    if (n == 0) {
                        cachedSubEntries.add(new DN(string).explodeDN(true)[0]);
                        continue;
                    }
                    cachedSubEntries.remove(new DN(string).explodeDN(true)[0]);
                    continue;
                }
                notificationObject.method.invoke(notificationObject.object, notificationObject.args);
            }
            catch (Exception exception) {
                debug.error("SMSEvent notification: Unable to send notification: ", (Throwable)exception);
            }
        }
    }

    private static class NotificationObject {
        String id;
        Method method;
        Object object;
        Object[] args;
        Set set;

        NotificationObject(Method method, Object object, Object[] objectArray, Set set) {
            this.method = method;
            this.object = object;
            this.args = objectArray;
            this.set = set;
        }

        String getID() {
            if (this.id == null) {
                this.id = SMSUtils.getUniqueID();
            }
            return this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof NotificationObject) {
                NotificationObject notificationObject = (NotificationObject)object;
                if (this.id == notificationObject.id) {
                    return true;
                }
            }
            return false;
        }
    }
}

