/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObject;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPException;

public class SMSEntry
implements Cloneable {
    public static Debug debug = Debug.getInstance((String)"amSMS");
    public static SSOTokenManager tm;
    static String CACHE_PROPERTY;
    static boolean cacheSMSEntries;
    public static ResourceBundle bundle;
    static String DEFAULT_ORG_PROPERTY;
    static String baseDN;
    static SMSException initializationException;
    static final String SMS_OBJECT_PROPERTY = "com.sun.identity.sm.sms_object_class_name";
    static final String DEFAULT_SMS_CLASS_NAME = "com.sun.identity.sm.ldap.SMSLdapObject";
    static SMSObject smsObject;
    private SSOToken ssoToken;
    protected String dn;
    private boolean newEntry;
    private boolean readOnly;
    private Map attrSet;
    private Set modSet;
    public static final String PLACEHOLDER_RDN = "ou";
    public static final String ORGANIZATION_RDN = "o";
    public static final String DC_RDN = "dc";
    public static final String SERVICES_NODE = "services";
    public static final String SERVICES_RDN = "ou=services";
    public static final String COMMA = ",";
    public static final String EQUALS = "=";
    static final int ORG_UNIT_OBJECT = 1;
    static final int SERVICE_OBJECT = 2;
    static final int SERVICE_COMP_OBJECT = 3;
    public static final String ATTR_SCHEMA = "sunServiceSchema";
    public static final String ATTR_PLUGIN_SCHEMA = "sunPluginSchema";
    public static final String ATTR_KEYVAL = "sunKeyValue";
    public static final String ATTR_OBJECTCLASS = "objectclass";
    public static final String ATTR_PRIORITY = "sunsmspriority";
    public static final String ATTR_SERVICE_ID = "sunserviceID";
    public static final String ATTR_LABELED_URI = "labeleduri";
    public static final String ATTR_MODIFY_TIMESTAMP = "modifytimestamp";
    public static final String[] SMS_ATTRIBUTES;
    public static final String OC_TOP = "top";
    public static final String OC_ORG_UNIT = "organizationalunit";
    public static final String OC_SERVICE = "sunService";
    public static final String OC_SERVICE_COMP = "sunServiceComponent";
    protected static final String FILTER_PATTERN_ALL = "(|(&(objectclass=top)(ou={0}))(&(objectclass=top)(sunserviceID={0})))";
    protected static final String FILTER_PATTERN_SERVICE = "(&(objectclass=sunService)(ou={0})(ou={1}))";
    public static final String FILTER_SERVICE_COMPONENTS = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";

    SMSEntry(SSOToken sSOToken, String string) throws SSOException, SMSException {
        if (initializationException != null) {
            throw initializationException;
        }
        this.ssoToken = sSOToken;
        this.dn = string;
        this.read();
    }

    public Map getAttributes() {
        return this.attrSet;
    }

    String[] getAttributeValues(String string) {
        return this.getAttributeValues(string, false);
    }

    String[] getAttributeValues(String string, boolean bl) {
        if (bl || !cacheSMSEntries) {
            try {
                this.read();
            }
            catch (SMSException sMSException) {
                debug.error("SMSLdapEntry: Error in reading attrs: " + sMSException);
            }
            catch (SSOException sSOException) {
                debug.error("SMSLdapEntry: SSOToken problem in reading attrs: " + (Object)((Object)sSOException));
            }
        }
        Set set = this.attrSet == null ? null : (Set)this.attrSet.get(string);
        return set == null ? null : set.toArray(new String[set.size()]);
    }

    void addAttribute(String string, String string2) throws SMSException {
        HashSet<String> hashSet = null;
        if (this.attrSet == null) {
            this.attrSet = new HashMap();
        } else if (this.attrSet.containsKey(string) && (hashSet = (Set)this.attrSet.get(string)).contains(string2)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry: Duplicate value for addition");
            }
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20));
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        hashSet.add(string2);
        this.attrSet.put(string, hashSet);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        this.modSet.add(new ModificationItem(1, new BasicAttribute(string, string2)));
    }

    void setAttribute(String string, String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        BasicAttribute basicAttribute = new BasicAttribute(string);
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            hashSet.add(stringArray[n]);
            basicAttribute.add(stringArray[n]);
            ++n;
        }
        this.attrSet = this.attrSet == null ? new HashMap() : this.attrSet;
        Set set = this.modSet = this.modSet == null ? new HashSet() : this.modSet;
        if (!this.attrSet.containsKey(string)) {
            this.modSet.add(new ModificationItem(1, basicAttribute));
        } else {
            this.modSet.add(new ModificationItem(2, basicAttribute));
        }
        this.attrSet.put(string, hashSet);
    }

    void removeAttribute(String string, String string2) throws SMSException {
        Set set = null;
        if (this.attrSet == null || (set = (Set)this.attrSet.get(string)) == null || !set.contains(string2)) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20));
        }
        set.remove(string2);
        this.attrSet.put(string, set);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        this.modSet.add(new ModificationItem(3, new BasicAttribute(string, string2)));
    }

    void removeAttribute(String string) throws SMSException {
        Set set = (Set)this.attrSet.get(string);
        if (set == null) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20));
        }
        this.attrSet.remove(string);
        if (this.modSet == null) {
            this.modSet = new HashSet();
        }
        BasicAttribute basicAttribute = new BasicAttribute(string, set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            basicAttribute.add(iterator.next());
        }
        this.modSet.add(new ModificationItem(3, basicAttribute));
    }

    boolean containsAttrValue(String string, String string2) {
        Set set;
        if (this.attrSet != null && (set = (Set)this.attrSet.get(string)) != null) {
            return set.contains(string2);
        }
        return false;
    }

    void read() throws SSOException, SMSException {
        this.read(this.ssoToken);
    }

    void read(SSOToken sSOToken) throws SSOException, SMSException {
        this.attrSet = smsObject.read(sSOToken, this.dn);
        this.newEntry = this.attrSet == null;
    }

    void save() throws SSOException, SMSException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to save an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION);
        }
        this.save(this.ssoToken);
    }

    void save(SSOToken sSOToken) throws SSOException, SMSException {
        if (this.newEntry && this.attrSet != null) {
            smsObject.create(sSOToken, this.dn, this.attrSet);
        } else if (this.modSet != null) {
            smsObject.modify(sSOToken, this.dn, this.modSet.toArray(new ModificationItem[this.modSet.size()]));
        }
        this.newEntry = false;
    }

    void delete() throws SMSException, SSOException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to delete an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION);
        }
        this.delete(this.ssoToken);
    }

    void delete(SSOToken sSOToken) throws SMSException, SSOException {
        smsObject.delete(sSOToken, this.dn);
        this.newEntry = true;
        this.attrSet = null;
        this.modSet = null;
    }

    Set subEntries(String string, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        return this.subEntries(this.ssoToken, string, n, bl, bl2);
    }

    Set subEntries(SSOToken sSOToken, String string, int n, boolean bl, boolean bl2) throws SMSException, SSOException {
        return smsObject.subEntries(sSOToken, this.dn, string, n, bl, bl2);
    }

    static Set search(String string) throws SMSException {
        try {
            return smsObject.search(null, baseDN, string);
        }
        catch (SSOException sSOException) {
            debug.error("SMSEntry: Sarch ERROR: " + string, (Throwable)sSOException);
            throw new SMSException(bundle.getString("sms-error-in-searching"), sSOException);
        }
    }

    void refresh(SMSEntry sMSEntry) {
        this.attrSet = sMSEntry.attrSet != null ? SMSUtils.copyAttributes(sMSEntry.attrSet) : null;
        this.newEntry = sMSEntry.newEntry;
        this.modSet = null;
    }

    public static boolean checkIfEntryExists(String string, SSOToken sSOToken) {
        try {
            return smsObject.entryExists(sSOToken, string);
        }
        catch (Exception exception) {
            debug.error("SMSEntry: Error in checking if entry exists: " + string, (Throwable)exception);
            return false;
        }
    }

    public static void registerCallbackHandler(SSOToken sSOToken, SMSObjectListener sMSObjectListener) throws SMSException, SSOException {
        smsObject.registerCallbackHandler(sSOToken, sMSObjectListener);
    }

    String getDN() {
        return this.dn;
    }

    Principal getPrincipal() {
        try {
            return this.ssoToken.getPrincipal();
        }
        catch (SSOException sSOException) {
            return null;
        }
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    void setReadOnly() {
        this.readOnly = true;
    }

    boolean isNewEntry() {
        return this.newEntry;
    }

    public static SMSObject getSMSObject() {
        return smsObject;
    }

    public static void validateToken(SSOToken sSOToken) throws SMSException {
        try {
            tm.validateToken(sSOToken);
        }
        catch (SSOException sSOException) {
            throw new SMSException(sSOException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SMSEntry sMSEntry = (SMSEntry)super.clone();
        sMSEntry.ssoToken = this.ssoToken;
        sMSEntry.dn = this.dn;
        sMSEntry.newEntry = this.newEntry;
        sMSEntry.modSet = null;
        sMSEntry.attrSet = this.attrSet != null ? SMSUtils.copyAttributes(this.attrSet) : null;
        if (debug.messageEnabled()) {
            debug.message("SMSEntry being cloned: " + this.dn);
        }
        return sMSEntry;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DN\t\t: " + this.dn + "\n");
        if (this.newEntry) {
            stringBuffer.append("\t(NEW Entry)");
        }
        stringBuffer.append("Attribute Set\t: " + this.attrSet + "\n");
        stringBuffer.append("Modifcation Set\t: " + this.modSet + "\n");
        return stringBuffer.toString();
    }

    static {
        CACHE_PROPERTY = "com.iplanet.am.sdk.caching.enabled";
        DEFAULT_ORG_PROPERTY = "com.iplanet.am.defaultOrg";
        String string = System.getProperty(CACHE_PROPERTY, SystemProperties.get((String)CACHE_PROPERTY, (String)"true"));
        if (string.equalsIgnoreCase("true")) {
            cacheSMSEntries = true;
        }
        debug.message("SMSEntry: cache enabled: " + cacheSMSEntries);
        AMResourceBundleCache aMResourceBundleCache = AMResourceBundleCache.getInstance();
        bundle = aMResourceBundleCache.getResBundle("amSDK", Locale.ENGLISH);
        String string2 = SystemProperties.get((String)SMS_OBJECT_PROPERTY, (String)DEFAULT_SMS_CLASS_NAME);
        try {
            Class<?> clazz = Class.forName(string2);
            smsObject = (SMSObject)clazz.newInstance();
            tm = SSOTokenManager.getInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.error("SMSObject class not found: " + string2);
            initializationException = new SMSException(classNotFoundException);
        }
        catch (Exception exception) {
            debug.error("SMSEntry: error in instantiation of: " + string2);
            initializationException = new SMSException(exception);
        }
        if (smsObject == null) {
            debug.error("SMSEntry: Using default LDAP implementation");
            try {
                smsObject = (SMSObject)Class.forName(DEFAULT_SMS_CLASS_NAME).newInstance();
                initializationException = null;
            }
            catch (Exception exception) {
                debug.error("SMSEntry: Error in getting default SMSObject", (Throwable)exception);
            }
        }
        if ((baseDN = smsObject.getRootSuffix()) == null) {
            initializationException = new SMSException(bundle.getString("sms-invalid-dn"));
        }
        SMS_ATTRIBUTES = new String[]{PLACEHOLDER_RDN, ATTR_SCHEMA, ATTR_PLUGIN_SCHEMA, ATTR_KEYVAL, ATTR_OBJECTCLASS, ATTR_PRIORITY, ATTR_SERVICE_ID, ATTR_LABELED_URI, ATTR_MODIFY_TIMESTAMP};
    }
}

