/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginSchema {
    protected PluginSchemaImpl psi;
    protected SSOToken token;
    protected String serviceName;
    protected String version;
    protected String pluginName;

    private PluginSchema() {
    }

    protected PluginSchema(SSOToken sSOToken, String string, String string2, String string3, String string4, String string5) throws SMSException {
        this.psi = PluginSchemaImpl.getInstance(sSOToken, string, string2, string3, string4, string5);
        if (this.psi == null) {
            throw new SMSException("amSDK", "sms-plugin-schema-name-not-found", null);
        }
        this.token = sSOToken;
        this.serviceName = string;
        this.version = string2;
        this.pluginName = string3;
    }

    public String getName() {
        return this.pluginName;
    }

    public String getInterfaceName() {
        return this.psi.getInterfaceName();
    }

    public String getClassName() {
        return this.psi.getClassName();
    }

    public String getJarURL() {
        return this.psi.getJarURL();
    }

    public String getI18NJarURL() {
        return this.psi.getI18NJarURL();
    }

    public String getI18NFileName() {
        return this.psi.getI18NFileName();
    }

    public String getPropertiesViewBeanURL() {
        return this.psi.getPropertiesViewBeanURL();
    }

    public String getI18NKey() {
        return this.psi.getI18NKey();
    }

    public Set getAttributeSchemaNames() {
        return this.psi.getAttributeSchemaNames();
    }

    public AttributeSchema getAttributeSchema(String string) {
        AttributeSchemaImpl attributeSchemaImpl = this.psi.getAttributeSchema(string);
        if (attributeSchemaImpl != null) {
            return new AttributeSchema(attributeSchemaImpl, this);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("PluginSchema name: " + this.getName()).append("\n\tInterface name: " + this.getInterfaceName()).append("\n\tClass name: " + this.getClassName()).append("\n\tJar URL: " + this.getJarURL()).append("\n\tI18N URL: " + this.getI18NJarURL()).append("\n\tI18N File name: " + this.getI18NFileName()).append("\n\tI18N Key: " + this.getI18NKey());
        Iterator iterator = this.getAttributeSchemaNames().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n").append(this.getAttributeSchema((String)iterator.next()));
        }
        return stringBuffer.toString();
    }

    protected Document getDocumentCopy() throws SMSException {
        return this.psi.getDocumentCopy();
    }

    protected Node getPluginSchemaNode(Document document) throws SMSException {
        NodeList nodeList = document.getElementsByTagName("PluginSchema");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new SMSException("amSDK", "sms-invalid-plugin-schema-document", null);
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            if (XMLUtils.getNodeAttributeValue((Node)nodeList.item(n), (String)"name").equals(this.pluginName)) {
                return nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    protected void replacePluginSchema(Document document) throws SSOException, SMSException {
        SMSSchema sMSSchema = new SMSSchema(document);
        String string = sMSSchema.getPluginSchema(this.pluginName);
        String[] stringArray = new String[]{string};
        CachedSMSEntry cachedSMSEntry = this.psi.getCachedSMSEntry();
        SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
        sMSEntry.setAttribute("sunPluginSchema", stringArray);
        sMSEntry.save(this.token);
        cachedSMSEntry.refresh(sMSEntry);
    }

    static void createPluginSchema(SSOToken sSOToken, Node node, SMSSchema sMSSchema) throws SMSException, SSOException {
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
        String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"interfaceName");
        String string3 = DNMapper.orgNameToDN(XMLUtils.getNodeAttributeValue((Node)node, (String)"organizationName"));
        ServiceSchemaManagerImpl serviceSchemaManagerImpl = ServiceSchemaManagerImpl.getInstance(sSOToken, sMSSchema.getServiceName(), sMSSchema.getServiceVersion());
        if (!serviceSchemaManagerImpl.getPluginInterfaceNames().contains(string2)) {
            throw new SMSException("amSDK", "sms-invalid-plugin-interface-name", null);
        }
        CreateServiceConfig.checkBaseNodesForOrg(sSOToken, string3, sMSSchema.getServiceName(), sMSSchema.getServiceVersion());
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ou=").append(string2).append(",").append("ou=PluginConfig,").append("ou=").append(sMSSchema.getServiceVersion()).append(",").append("ou=").append(sMSSchema.getServiceName()).append(",").append("ou=services").append(",").append(string3);
        CreateServiceConfig.checkAndCreateOrgUnitNode(sSOToken, stringBuffer.toString());
        String string4 = "ou=" + string + "," + stringBuffer.toString();
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(sSOToken, string4, null);
        SMSEntry sMSEntry = cachedSMSEntry.getClonedSMSEntry();
        if (!sMSEntry.isNewEntry()) {
            throw new SMSException("plugin-schema-already-exists");
        }
        sMSEntry.addAttribute("objectclass", "top");
        sMSEntry.addAttribute("objectclass", "sunService");
        sMSEntry.addAttribute("objectclass", "sunServiceComponent");
        sMSEntry.addAttribute("sunPluginSchema", sMSSchema.getPluginSchema(string));
        sMSEntry.save(sSOToken);
        cachedSMSEntry.refresh(sMSEntry);
    }
}

