/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class PluginConfig {
    private String name;
    private SSOToken token;
    private PluginConfigImpl pc;
    private PluginSchemaImpl ps;
    private ServiceConfigManager scm;

    private PluginConfig() {
    }

    protected PluginConfig(String string, ServiceConfigManager serviceConfigManager, PluginConfigImpl pluginConfigImpl) throws SMSException, SSOException {
        this.scm = serviceConfigManager;
        this.token = serviceConfigManager.getSSOToken();
        this.pc = pluginConfigImpl;
        this.ps = pluginConfigImpl.getPluginSchemaImpl();
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public int getPriority() {
        return this.pc.getPriority();
    }

    public void setPriority(int n) throws SSOException, SMSException {
        StringBuffer stringBuffer = new StringBuffer(8);
        String[] stringArray = new String[]{stringBuffer.append(n).toString()};
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        sMSEntry.setAttribute("sunsmspriority", stringArray);
        this.saveSMSEntry(sMSEntry);
    }

    public Map getAttributes() {
        return this.pc.getAttributes();
    }

    public void setAttributes(Map map) throws SMSException, SSOException {
        Object object;
        HashMap hashMap = new HashMap(map);
        Map map2 = this.getAttributes();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (hashMap.containsKey(object)) continue;
            hashMap.put(object, map2.get(object));
        }
        this.ps.validateAttributes(hashMap, true);
        object = this.pc.getSMSEntry();
        SMSUtils.setAttributeValuePairs((SMSEntry)object, hashMap);
        this.saveSMSEntry((SMSEntry)object);
    }

    public void addAttribute(String string, Set hashSet) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet hashSet2 = hashSet;
        Set set = (Set)map.get(string);
        if (set != null) {
            hashSet2 = new HashSet();
            hashSet2.addAll(set);
            hashSet2.addAll(hashSet);
        }
        this.ps.validateAttrValues(string, hashSet2, true);
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        SMSUtils.addAttribute(sMSEntry, string, hashSet);
        this.saveSMSEntry(sMSEntry);
    }

    public void removeAttribute(String string) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        SMSUtils.removeAttribute(sMSEntry, string);
        this.saveSMSEntry(sMSEntry);
    }

    public void removeAttributeValues(String string, Set set) throws SMSException, SSOException {
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        SMSUtils.removeAttributeValues(sMSEntry, string, set);
        this.saveSMSEntry(sMSEntry);
    }

    public void replaceAttributeValue(String string, String string2, String string3) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet<String> hashSet = new HashSet<String>();
        Set set = (Set)map.get(string);
        if (set != null) {
            hashSet.addAll(set);
            hashSet.remove(string2);
        }
        hashSet.add(string3);
        this.ps.validateAttrValues(string, hashSet, true);
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        SMSUtils.replaceAttributeValue(sMSEntry, string, string2, string3);
        this.saveSMSEntry(sMSEntry);
    }

    public void replaceAttributeValues(String string, Set set, Set set2) throws SMSException, SSOException {
        Map map = this.getAttributes();
        HashSet hashSet = new HashSet();
        Set set3 = (Set)map.get(string);
        if (set3 != null) {
            hashSet.addAll(set3);
            hashSet.removeAll(set);
        }
        hashSet.addAll(set2);
        this.ps.validateAttrValues(string, hashSet, true);
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        SMSUtils.replaceAttributeValues(sMSEntry, string, set, set2);
        this.saveSMSEntry(sMSEntry);
    }

    public String getDN() {
        return this.pc.getDN();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Plugin name: " + this.getName());
        stringBuffer.append("\n\tAttributes: " + this.getAttributes()).append("\n");
        return stringBuffer.toString();
    }

    void saveSMSEntry(SMSEntry sMSEntry) throws SMSException, SSOException {
        if (sMSEntry.isNewEntry()) {
            CreateServiceConfig.checkBaseNodesForOrg(this.token, DNMapper.orgNameToDN(this.pc.getOrganizationName()), this.getServiceName(), this.getVersion());
            sMSEntry.addAttribute("objectclass", "top");
            sMSEntry.addAttribute("objectclass", "sunServiceComponent");
        }
        sMSEntry.save(this.token);
        this.pc.refresh(sMSEntry);
    }

    void delete() throws SMSException, SSOException {
        SMSEntry sMSEntry = this.pc.getSMSEntry();
        DN dN = new DN(sMSEntry.getDN());
        CachedSubEntries cachedSubEntries = CachedSubEntries.getInstance(this.token, dN.getParent().toString());
        cachedSubEntries.remove(this.getName());
        sMSEntry.delete(this.token);
        this.pc.refresh(sMSEntry);
    }
}

