/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import netscape.ldap.util.DN;

class CachedSubEntries {
    protected static HashMap smsEntries = new HashMap(100);
    protected Set subEntries;
    protected CachedSMSEntry cEntry;
    protected SMSEntry entry;
    protected DN dn;
    protected String notificationID;
    private static Debug debug = SMSEntry.debug;

    private CachedSubEntries(SSOToken sSOToken, String string) throws SMSException {
        try {
            this.cEntry = CachedSMSEntry.getInstance(sSOToken, string, null);
            this.entry = this.cEntry.smsEntry;
            this.dn = this.cEntry.dn;
            this.update();
            Class<?> clazz = Class.forName("com.sun.identity.sm.CachedSubEntries");
            this.notificationID = SMSEventListenerManager.notifyChangesToSubNodes(sSOToken, string, clazz.getDeclaredMethod("update", null), this, null);
        }
        catch (Exception exception) {
            debug.error("CachedSubEntries: unable to register for notifications: ", (Throwable)exception);
        }
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::init: " + string);
        }
    }

    protected Set getSubEntries() throws SMSException, SSOException {
        TreeSet treeSet = null;
        if (!SMSEntry.cacheSMSEntries) {
            treeSet = this.getSubEntries("*");
        } else {
            treeSet = new TreeSet();
            treeSet.addAll(this.subEntries);
        }
        return treeSet;
    }

    protected Set getSubEntries(String string) throws SMSException, SSOException {
        SSOToken sSOToken = this.cEntry.getValidSSOToken();
        if (sSOToken == null) {
            smsEntries.remove(this.dn.toRFCString().toLowerCase());
            SMSEventListenerManager.removeNotification(this.notificationID);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"));
        }
        return this.getSubEntries(sSOToken, string);
    }

    protected Set getSubEntries(SSOToken sSOToken, String string) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.dn + " pattern: " + string);
        }
        return this.entry.subEntries(sSOToken, string, 0, true, true);
    }

    protected void add(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.subEntries);
        treeSet.add(string);
        this.subEntries = treeSet;
    }

    protected void remove(String string) {
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.subEntries);
        treeSet.remove(string);
        this.subEntries = treeSet;
    }

    protected boolean isEmpty() {
        return this.subEntries.isEmpty();
    }

    protected boolean contains(String string) {
        return this.subEntries.contains(string);
    }

    protected SMSEntry getSMSEntry() {
        return this.entry;
    }

    protected void update() {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::update called for dn: " + this.dn);
        }
        try {
            this.subEntries = this.getSubEntries("*");
        }
        catch (Exception exception) {
            debug.error("CachedSubEntries:update: ERROR DN: " + this.dn, (Throwable)exception);
        }
    }

    protected void finalize() throws Throwable {
        SMSEventListenerManager.removeNotification(this.notificationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CachedSubEntries getInstance(SSOToken sSOToken, String string) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::getInstance DN: " + string);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        CachedSubEntries cachedSubEntries = null;
        cachedSubEntries = (CachedSubEntries)smsEntries.get(string2);
        if (cachedSubEntries == null) {
            HashMap hashMap = smsEntries;
            synchronized (hashMap) {
                cachedSubEntries = (CachedSubEntries)smsEntries.get(string2);
                if (cachedSubEntries == null) {
                    cachedSubEntries = new CachedSubEntries(sSOToken, string);
                    smsEntries.put(string2, cachedSubEntries);
                }
            }
        } else {
            cachedSubEntries.cEntry.addPrincipal(sSOToken);
        }
        return cachedSubEntries;
    }
}

