/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.ums.validation.BooleanValidator;
import com.iplanet.ums.validation.DNValidator;
import com.iplanet.ums.validation.FloatValidator;
import com.iplanet.ums.validation.MailAddressValidator;
import com.iplanet.ums.validation.NumberValidator;
import com.iplanet.ums.validation.URLValidator;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.InvalidAttributeValueException;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class AttributeValidator {
    static final MailAddressValidator mailValidator = new MailAddressValidator();
    static final BooleanValidator boolValidator = new BooleanValidator();
    static final NumberValidator numberValidator = new NumberValidator();
    static final URLValidator urlValidator = new URLValidator();
    static final FloatValidator floatValidator = new FloatValidator();
    static final DNValidator dnValidator = new DNValidator();
    static Debug debug = SMSEntry.debug;
    private AttributeSchemaImpl as;

    AttributeValidator(AttributeSchemaImpl attributeSchemaImpl) {
        this.as = attributeSchemaImpl;
    }

    private boolean validateSyntax(Set set, boolean bl) throws SMSException {
        AttributeSchema.Syntax syntax = this.as.getSyntax();
        if (syntax == null) {
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.STRING) || syntax.equals(AttributeSchema.Syntax.PARAGRAPH) || syntax.equals(AttributeSchema.Syntax.URL) || syntax.equals(AttributeSchema.Syntax.XML) || syntax.equals(AttributeSchema.Syntax.BOOLEAN) || syntax.equals(AttributeSchema.Syntax.DATE)) {
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.EMAIL)) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (mailValidator.validate((String)iterator.next())) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.PASSWORD) || syntax.equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            if (bl) {
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = new HashSet<String>();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashSet.add((String)AccessController.doPrivileged(new EncodeAction(string)));
                    hashSet2.add(string);
                }
                set.removeAll(hashSet2);
                set.addAll(hashSet);
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMERIC) || syntax.equals(AttributeSchema.Syntax.NUMBER)) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (numberValidator.validate((String)iterator.next())) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.PERCENT) || syntax.equals(AttributeSchema.Syntax.DECIMAL_NUMBER)) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (floatValidator.validate((String)iterator.next())) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.NUMBER_RANGE)) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                int n;
                int n2;
                int n3;
                String string = (String)iterator.next();
                try {
                    n3 = Integer.parseInt(string);
                    String string2 = this.as.getStartRange();
                    String string3 = this.as.getEndRange();
                    if (string2 == null && string3 == null) {
                        return true;
                    }
                    n2 = Integer.parseInt(string2);
                    n = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    return false;
                }
                if (n3 >= n2 && n3 <= n) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.DECIMAL_RANGE)) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                float f;
                float f2;
                float f3;
                String string = (String)iterator.next();
                try {
                    f3 = Float.parseFloat(string);
                    String string4 = this.as.getStartRange();
                    String string5 = this.as.getEndRange();
                    if (string4 == null && string5 == null) {
                        return true;
                    }
                    f2 = Float.parseFloat(string4);
                    f = Float.parseFloat(string5);
                }
                catch (Exception exception) {
                    return false;
                }
                if (!(f3 < f2) && !(f3 > f)) continue;
                return false;
            }
            return true;
        }
        if (syntax.equals(AttributeSchema.Syntax.DN)) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (dnValidator.validate((String)iterator.next())) continue;
                return false;
            }
            return true;
        }
        Object[] objectArray = new String[]{this.as.getName()};
        throw new SMSException("amSDK", "sms-invalid_attribute_syntax", objectArray);
    }

    private boolean validateString(String string) {
        return string.indexOf(34) == -1 && string.indexOf(62) == -1 && string.indexOf(60) == -1 && string.indexOf(39) == -1 && string.indexOf(38) == -1;
    }

    private boolean validateType(Set set) throws SMSException {
        AttributeSchema.Type type = this.as.getType();
        if (type == null) {
            return true;
        }
        if (type.equals(AttributeSchema.Type.SINGLE)) {
            return set.size() <= 1;
        }
        if (type.equals(AttributeSchema.Type.LIST)) {
            int n = set.size();
            int n2 = this.as.getMinValue();
            int n3 = this.as.getMaxValue();
            return n2 == -1 || n3 == -1 || n >= n2 && n <= n3;
        }
        if (type.equals(AttributeSchema.Type.SINGLE_CHOICE)) {
            String string;
            if (set.size() > 1) {
                return false;
            }
            String[] stringArray = this.as.getChoiceValues();
            Iterator iterator = set.iterator();
            String string2 = string = iterator.hasNext() ? (String)iterator.next() : null;
            if (string == null) {
                return true;
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (type.equals(AttributeSchema.Type.MULTIPLE_CHOICE)) {
            String[] stringArray = this.as.getChoiceValues();
            int n = set.size();
            int n4 = this.as.getMinValue();
            int n5 = this.as.getMaxValue();
            if (n4 != -1 && n5 != -1 && (n < n4 || n > n5)) {
                return false;
            }
            if (n == 0) {
                return true;
            }
            Iterator iterator = set.iterator();
            int n6 = stringArray.length;
            while (iterator.hasNext()) {
                boolean bl = false;
                String string = (String)iterator.next();
                int n7 = 0;
                while (n7 < n6) {
                    if (stringArray[n7].equalsIgnoreCase(string)) {
                        bl = true;
                        break;
                    }
                    ++n7;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        if (type.equals(AttributeSchema.Type.VALIDATOR)) {
            return true;
        }
        if (type.equals(AttributeSchema.Type.SIGNATURE)) {
            return true;
        }
        Object[] objectArray = new String[]{this.as.getName()};
        throw new SMSException("amSDK", "sms-invalid_attribute_type", objectArray);
    }

    boolean validate(Set set, boolean bl) throws SMSException {
        if (!this.validateType(set) || !this.validateSyntax(set, bl)) {
            if (debug.messageEnabled()) {
                debug.message("Validation Failed for attribute: " + this.as.getName() + " value:" + set);
            }
            Object[] objectArray = new String[]{this.as.getName()};
            throw new InvalidAttributeValueException("amSDK", "sms-attribute-values-does-not-match-schema", objectArray);
        }
        return true;
    }

    Map inheritDefaults(Map map) {
        Set set = (Set)map.get(this.as.getName());
        if (set == null) {
            Set set2 = this.as.getDefaultValues();
            map.put(this.as.getName(), this.as.getDefaultValues());
        } else if (this.as.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) || this.as.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add((String)AccessController.doPrivileged(new DecodeAction(string)));
            }
            map.put(this.as.getName(), hashSet);
        }
        return map;
    }

    Map decodeEncodedAttrs(Map map) {
        Set set = (Set)map.get(this.as.getName());
        if (set == null) {
            return map;
        }
        if (this.as.getSyntax().equals(AttributeSchema.Syntax.PASSWORD) || this.as.getSyntax().equals(AttributeSchema.Syntax.ENCRYPTED_PASSWORD)) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add((String)AccessController.doPrivileged(new DecodeAction(string)));
            }
            map.put(this.as.getName(), hashSet);
        }
        return map;
    }
}

