/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.PluginSchema;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeSchema {
    private static Debug debug = SMSEntry.debug;
    ServiceSchemaManager ssm;
    ServiceSchema ss;
    PluginSchema ps;
    AttributeSchemaImpl as;
    private static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String DEFAULT_VALUES_BEGIN = "<DefaultValues>";
    private static final String DEFAULT_VALUES_END = "</DefaultValues>";
    private static final String VALUE_BEGIN = "<Value>";
    private static final String VALUE_END = "</Value>";
    private static final String CHOICE_VALUES_BEGIN = "<ChoiceValues>";
    private static final String CHOICE_VALUES_END = "</ChoiceValues>";
    private static final String CHOICE_VALUE_KEY = "<ChoiceValue i18nKey=\"{0}\">{1}</ChoiceValue>";
    private static final String CHOICE_VALUE = "<ChoiceValue>{0}</ChoiceValue>";

    private AttributeSchema() {
    }

    protected AttributeSchema(AttributeSchemaImpl attributeSchemaImpl, ServiceSchemaManager serviceSchemaManager, ServiceSchema serviceSchema) {
        this.ssm = serviceSchemaManager;
        this.ss = serviceSchema;
        this.as = attributeSchemaImpl;
        if (attributeSchemaImpl == null) {
            debug.error("AttributeSchema:: IMPL is NULL");
        }
    }

    protected AttributeSchema(AttributeSchemaImpl attributeSchemaImpl, PluginSchema pluginSchema) {
        this.as = attributeSchemaImpl;
        this.ps = pluginSchema;
    }

    public String getName() {
        return this.as.getName();
    }

    public Type getType() {
        return this.as.getType();
    }

    public void setType(String string) throws SMSException, SSOException {
        this.updateXMLDocument("type", string);
    }

    public UIType getUIType() {
        return this.as.getUIType();
    }

    public void setUIType(String string) throws SMSException, SSOException {
        this.updateXMLDocument("uitype", string);
    }

    public Syntax getSyntax() {
        return this.as.getSyntax();
    }

    public void setSyntax(String string) throws SMSException, SSOException {
        this.updateXMLDocument("syntax", string);
    }

    public String getI18NKey() {
        return this.as.getI18NKey();
    }

    public void setI18NKey(String string) throws SMSException, SSOException {
        this.updateXMLDocument("i18nKey", string);
    }

    public String getCosQualifier() {
        return this.as.getCosQualifier();
    }

    public void setCosQualifier(String string) throws SMSException, SSOException {
        this.updateXMLDocument("cosQualifier", string);
    }

    public Set getDefaultValues() {
        return this.as.getDefaultValues();
    }

    public void setDefaultValues(Set set) throws SMSException, SSOException {
        this.updateDefaultValues(set);
    }

    void setDefaultValues(Set set, Document document) throws SMSException, SSOException {
        this.updateDefaultValues(set, document);
    }

    public void addDefaultValue(String string) throws SMSException, SSOException {
        HashSet<String> hashSet = this.getDefaultValues();
        if (hashSet != Collections.EMPTY_SET) {
            hashSet.add(string);
        } else {
            hashSet = new HashSet<String>();
            hashSet.add(string);
        }
        this.updateDefaultValues(hashSet);
    }

    public void removeDefaultValues() throws SMSException, SSOException {
        this.updateDefaultValues(new HashSet());
    }

    public void removeDefaultValue(String string) throws SMSException, SSOException {
        Set set = this.getDefaultValues();
        if (set != Collections.EMPTY_SET) {
            set.remove(string);
            this.updateDefaultValues(set);
        }
    }

    public String[] getChoiceValues() {
        return this.as.getChoiceValues();
    }

    public String getChoiceValueI18NKey(String string) {
        return this.as.getChoiceValueI18NKey(string);
    }

    public void addChoiceValue(String string, String string2) throws SMSException, SSOException {
        Map map = this.as.getChoiceValuesMap();
        map.put(string, string2);
        this.updateChoiceValues(map);
    }

    public void removeChoiceValue(String string) throws SMSException, SSOException {
        Map map = this.as.getChoiceValuesMap();
        if (map.remove(string) != null) {
            this.updateChoiceValues(map);
        }
    }

    public String getStartRange() {
        return this.as.getStartRange();
    }

    public void setStartRange(String string) throws SMSException, SSOException {
        this.updateXMLDocument("rangeStart", string);
    }

    public String getEndRange() {
        return this.as.getEndRange();
    }

    public void setEndRange(String string) throws SMSException, SSOException {
        this.updateXMLDocument("rangeEnd", string);
    }

    public String getValidator() {
        return this.as.getValidator();
    }

    public void setValidator(String string) throws SMSException, SSOException {
        this.updateXMLDocument("validator", string);
    }

    public int getMinValue() {
        return this.as.getMinValue();
    }

    public void setMinValue(String string) throws SMSException, SSOException {
        this.updateXMLDocument("minValue", string);
    }

    public int getMaxValue() {
        return this.as.getMaxValue();
    }

    public void setMaxValue(String string) throws SMSException, SSOException {
        this.updateXMLDocument("maxValue", string);
    }

    public String getTrueValue() {
        return this.as.getTrueValue();
    }

    public String getTrueValueI18NKey() {
        return this.as.getTrueValueI18NKey();
    }

    public String getFalseValue() {
        return this.as.getFalseValue();
    }

    public String getFalseValueI18NKey() {
        return this.as.getFalseValueI18NKey();
    }

    public boolean isOptional() {
        return this.as.isOptional();
    }

    public boolean isServiceIdentifier() {
        return this.as.isServiceIdentifier();
    }

    public boolean isResourceNameAllowed() {
        return this.as.isResourceNameAllowed();
    }

    public boolean isStatusAttribute() {
        return this.as.isStatusAttribute();
    }

    public String getAny() {
        return this.as.getAny();
    }

    public void setAny(String string) throws SMSException, SSOException {
        this.updateXMLDocument("any", string);
    }

    public String getPropertiesViewBeanURL() {
        return this.as.getPropertiesViewBeanURL();
    }

    public void setPropertiesViewBeanUR(String string) throws SMSException, SSOException {
        this.updateXMLDocument("propertiesViewBeanURL", string);
    }

    public String toString() {
        return this.as.toString();
    }

    protected void updateDefaultValues(Set set) throws SMSException, SSOException {
        this.updateDefaultValues(set, null);
    }

    protected void updateDefaultValues(Set set, Document document) throws SMSException, SSOException {
        if (this.ss != null) {
            HashMap<String, Set> hashMap = new HashMap<String, Set>(1);
            hashMap.put(this.getName(), set);
            this.ss.validateAttributes(hashMap);
        }
        boolean bl = false;
        if (this.getSyntax().equals(Syntax.PASSWORD) || this.getSyntax().equals(Syntax.ENCRYPTED_PASSWORD)) {
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(XML_PREFIX).append(DEFAULT_VALUES_BEGIN);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(VALUE_BEGIN);
            if (bl) {
                String string = (String)AccessController.doPrivileged(new EncodeAction((String)iterator.next()));
                stringBuffer.append(string);
            } else {
                stringBuffer.append(SMSSchema.escapeSpecialCharacters((String)iterator.next()));
            }
            stringBuffer.append(VALUE_END);
        }
        stringBuffer.append(DEFAULT_VALUES_END);
        this.updateXMLDocument(stringBuffer, "DefaultValues", document);
    }

    protected void updateChoiceValues(Map map) throws SMSException, SSOException {
        this.updateChoiceValues(map, null);
    }

    protected void updateChoiceValues(Map map, Document document) throws SMSException, SSOException {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(XML_PREFIX).append(CHOICE_VALUES_BEGIN);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = new String[2];
            String string = SMSSchema.escapeSpecialCharacters((String)iterator.next());
            String string2 = (String)map.get(string);
            if (string2 == null) {
                objectArray[0] = string;
                stringBuffer.append(MessageFormat.format(CHOICE_VALUE, objectArray));
                continue;
            }
            objectArray[0] = string2;
            objectArray[1] = string;
            stringBuffer.append(MessageFormat.format(CHOICE_VALUE_KEY, objectArray));
        }
        stringBuffer.append(CHOICE_VALUES_END);
        this.updateXMLDocument(stringBuffer, "ChoiceValues", document);
    }

    protected void updateXMLDocument(StringBuffer stringBuffer, String string, Document document) throws SMSException, SSOException {
        try {
            Document document2 = SMSSchema.getXMLDocument(stringBuffer.toString(), false);
            Node node = XMLUtils.getRootNode((Document)document2, (String)string);
            Document document3 = null;
            document3 = document != null ? document : (this.ssm != null ? this.ssm.getDocumentCopy() : this.ps.getDocumentCopy());
            Node node2 = document3.importNode(node, true);
            Node node3 = null;
            node3 = this.ss != null ? this.ss.getSchemaNode(document3) : this.ps.getPluginSchemaNode(document3);
            Node node4 = XMLUtils.getNamedChildNode((Node)node3, (String)"AttributeSchema", (String)"name", (String)this.getName());
            Node node5 = XMLUtils.getChildNode((Node)node4, (String)string);
            if (node5 != null) {
                node4.replaceChild(node2, node5);
            } else {
                node4.appendChild(node2);
            }
            if (document == null) {
                if (this.ssm != null) {
                    this.ssm.replaceSchema(document3);
                } else {
                    this.ps.replacePluginSchema(document3);
                }
            }
        }
        catch (Exception exception) {
            throw new SMSException(exception.getMessage(), exception);
        }
    }

    protected void updateXMLDocument(String string, String string2) throws SMSException, SSOException {
        try {
            Document document = null;
            document = this.ssm != null ? this.ssm.getDocumentCopy() : this.ps.getDocumentCopy();
            Node node = null;
            node = this.ss != null ? this.ss.getSchemaNode(document) : this.ps.getPluginSchemaNode(document);
            Node node2 = XMLUtils.getNamedChildNode((Node)node, (String)"AttributeSchema", (String)"name", (String)this.getName());
            ((Element)node2).setAttribute(string, string2);
            if (this.ssm != null) {
                this.ssm.replaceSchema(document);
            } else {
                this.ps.replacePluginSchema(document);
            }
        }
        catch (Exception exception) {
            throw new SMSException(exception.getMessage(), exception);
        }
    }

    public static class Syntax {
        public static final Syntax BOOLEAN = new Syntax("boolean");
        public static final Syntax EMAIL = new Syntax("email");
        public static final Syntax URL = new Syntax("url");
        public static final Syntax STRING = new Syntax("string");
        public static final Syntax PARAGRAPH = new Syntax("paragraph");
        public static final Syntax XML = new Syntax("xml");
        public static final Syntax PASSWORD = new Syntax("password");
        public static final Syntax ENCRYPTED_PASSWORD = new Syntax("encrypted_password");
        public static final Syntax DATE = new Syntax("date");
        public static final Syntax NUMERIC = new Syntax("numeric");
        public static final Syntax NUMBER = new Syntax("number");
        public static final Syntax DECIMAL = new Syntax("decimal");
        public static final Syntax PERCENT = new Syntax("percent");
        public static final Syntax NUMBER_RANGE = new Syntax("number_range");
        public static final Syntax DECIMAL_RANGE = new Syntax("decimal_range");
        public static final Syntax DECIMAL_NUMBER = new Syntax("decimal_number");
        public static final Syntax DN = new Syntax("dn");
        private String attrSyntax;

        private Syntax() {
        }

        private Syntax(String string) {
            this.attrSyntax = string;
        }

        public String toString() {
            return this.attrSyntax;
        }

        public boolean equals(Object object) {
            if (object instanceof Syntax) {
                Syntax syntax = (Syntax)object;
                return syntax.attrSyntax.equals(this.attrSyntax);
            }
            return false;
        }

        public int hashCode() {
            return this.attrSyntax.hashCode();
        }
    }

    public static class UIType {
        public static final UIType RADIO = new UIType("radio");
        public static final UIType LINK = new UIType("link");
        public static final UIType BUTTON = new UIType("button");
        public static final UIType NAME_VALUE_LIST = new UIType("name_value_list");
        private String attrType;

        private UIType() {
        }

        private UIType(String string) {
            this.attrType = string;
        }

        public String toString() {
            return this.attrType;
        }

        public boolean equals(Object object) {
            if (object instanceof UIType) {
                UIType uIType = (UIType)object;
                return uIType.attrType.equals(this.attrType);
            }
            return false;
        }

        public int hashCode() {
            return this.attrType.hashCode();
        }
    }

    public static class Type {
        public static final Type SINGLE = new Type("single");
        public static final Type LIST = new Type("list");
        public static final Type SINGLE_CHOICE = new Type("single_choice");
        public static final Type MULTIPLE_CHOICE = new Type("multiple_choice");
        public static final Type SIGNATURE = new Type("signature");
        public static final Type VALIDATOR = new Type("validator");
        private String attrType;

        private Type() {
        }

        private Type(String string) {
            this.attrType = string;
        }

        public String toString() {
            return this.attrType;
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type type = (Type)object;
                return type.attrType.equals(this.attrType);
            }
            return false;
        }

        public int hashCode() {
            return this.attrType.hashCode();
        }
    }
}

