/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Base64;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.security.DecodeAction;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;

public class JKSKeyProvider
implements KeyProvider {
    private KeyStore ks = null;
    private String privateKeyPass = null;
    private String keystorePass = "";
    private String keystoreFile = "";
    HashMap keyTable = new HashMap();

    private void initialize() {
        block7: {
            String string;
            FileInputStream fileInputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            this.keystoreFile = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.keystore");
            if (this.keystoreFile == null || this.keystoreFile.equals("")) {
                SAMLUtils.debug.error("XML Siganture: keystore file does not exist");
            }
            if ((string = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.storepass")) != null) {
                try {
                    fileInputStream = new FileInputStream(string);
                    inputStreamReader = new InputStreamReader(fileInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    this.keystorePass = (String)AccessController.doPrivileged(new DecodeAction(bufferedReader.readLine()));
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SAMLUtils.debug.error("JKSKeyProvider.initialize: Unable to read keystore password file " + string);
                }
            } else {
                SAMLUtils.debug.error("XML signature: keystore password is null");
            }
            String string2 = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.keypass");
            if (string2 == null) break block7;
            try {
                fileInputStream = new FileInputStream(string2);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                this.privateKeyPass = (String)AccessController.doPrivileged(new DecodeAction(bufferedReader.readLine()));
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SAMLUtils.debug.error("JKSKeyProvider.initialize: Unable to read privatekey password file " + string);
            }
        }
    }

    public JKSKeyProvider() {
        this.initialize();
        String string = "JKS";
        try {
            this.ks = KeyStore.getInstance(string);
            FileInputStream fileInputStream = new FileInputStream(this.keystoreFile);
            this.ks.load(fileInputStream, this.keystorePass.toCharArray());
            Enumeration<String> enumeration = this.ks.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                Certificate certificate = this.getCertificate(string2);
                PublicKey publicKey = this.getPublicKey(string2);
                String string3 = Base64.encode((byte[])publicKey.getEncoded());
                this.keyTable.put(string3, certificate);
            }
            SAMLUtils.debug.message("KeyTable size = " + this.keyTable.size());
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
    }

    public void setKey(String string, String string2) {
        this.keystorePass = string;
        this.privateKeyPass = string2;
    }

    public X509Certificate getX509Certificate(String string) {
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)this.ks.getCertificate(string);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
        return x509Certificate;
    }

    public PublicKey getPublicKey(String string) {
        PublicKey publicKey = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)this.ks.getCertificate(string);
            publicKey = x509Certificate.getPublicKey();
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
        return publicKey;
    }

    public PrivateKey getPrivateKey(String string) {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)this.ks.getKey(string, this.privateKeyPass.toCharArray());
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
        return privateKey;
    }

    public String getCertificateAlias(Certificate certificate) {
        String string = null;
        try {
            if (this.ks != null) {
                string = this.ks.getCertificateAlias(certificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        return string;
    }

    public String getPrivateKeyPass() {
        return this.privateKeyPass;
    }

    public KeyStore getKeyStore() {
        return this.ks;
    }

    public void setCertificateEntry(String string, Certificate certificate) throws SAMLException {
        try {
            this.ks.setCertificateEntry(string, certificate);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
            throw new SAMLException(exception.getMessage());
        }
    }

    public Certificate getCertificate(String string) {
        try {
            return this.ks.getCertificate(string);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
            return null;
        }
    }

    public void store() throws SAMLException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.keystoreFile);
            this.ks.store(fileOutputStream, this.keystorePass.toCharArray());
            fileOutputStream.close();
            fileOutputStream = null;
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Keystore saved in " + this.keystoreFile);
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
            throw new SAMLException(exception.getMessage());
        }
    }

    public Certificate getCertificate(PublicKey publicKey) {
        String string = Base64.encode((byte[])publicKey.getEncoded());
        return (Certificate)this.keyTable.get(string);
    }
}

