/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Base64;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml.xmlsig.SignatureProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMSignatureProvider
implements SignatureProvider {
    private KeyProvider keystore;
    private String c14nMethod;
    private String transformAlg;
    private static final String DEF_ID_ATTRIBUTE = "id";
    private boolean checkCert;

    public AMSignatureProvider() {
        block13: {
            this.keystore = null;
            this.c14nMethod = null;
            this.transformAlg = null;
            this.checkCert = true;
            Init.init();
            try {
                this.keystore = (KeyProvider)Class.forName(SAMLUtils.bundle.getString("keyproviderimplclass")).newInstance();
            }
            catch (Exception exception) {
                SAMLUtils.debug.error("AMSignatureProvider:constructor error");
            }
            try {
                this.c14nMethod = SAMLUtils.bundle.getString("canonicalizationMethod");
                if (this.c14nMethod != null) {
                    this.c14nMethod = this.c14nMethod.trim();
                }
            }
            catch (Exception exception) {
                this.c14nMethod = null;
            }
            try {
                this.transformAlg = SAMLUtils.bundle.getString("transformAlgorithm");
                if (this.transformAlg != null) {
                    this.transformAlg = this.transformAlg.trim();
                }
            }
            catch (Exception exception) {
                this.transformAlg = null;
            }
            try {
                String string = SystemProperties.get((String)"com.sun.identity.saml.checkcert");
                if (string == null) break block13;
                if (string.trim().equalsIgnoreCase("off")) {
                    this.checkCert = false;
                    break block13;
                }
                if (string.trim().equalsIgnoreCase("on")) {
                    this.checkCert = true;
                    break block13;
                }
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SystemProperty: com.sun.identity.saml.checkcert has invalid value. Choose default, turn ON checkcert.");
                }
                this.checkCert = true;
            }
            catch (Exception exception) {
                this.checkCert = true;
            }
        }
    }

    public void initialize(KeyProvider keyProvider) {
        if (keyProvider == null) {
            SAMLUtils.debug.error("Key Provider is null");
        } else {
            this.keystore = keyProvider;
        }
    }

    public Element signXML(Document document, String string) throws XMLSignatureException {
        return this.signXML(document, string, SAMLUtils.bundle.getString("xmlsigalgorithm"));
    }

    public Element signXML(Document document, String string, String string2) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        XMLSignature xMLSignature = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"");
            if (this.keystore == null) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullkeystore"));
            }
            PrivateKey privateKey = this.keystore.getPrivateKey(string);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            element = document.getDocumentElement();
            if (string2 == null || string2.equals("")) {
                string2 = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            if (this.c14nMethod == null || this.c14nMethod.equals("")) {
                xMLSignature = new XMLSignature(document, "", string2);
            } else {
                if (!this.isValidCanonicalizationMethod(this.c14nMethod)) {
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidCanonicalizationMethod"));
                }
                xMLSignature = new XMLSignature(document, "", string2, this.c14nMethod);
            }
            element.appendChild(xMLSignature.getElement());
            xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            Transforms transforms = new Transforms(document);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            if (this.transformAlg != null && !this.transformAlg.equals("")) {
                if (!this.isValidTransformAlgorithm(this.transformAlg)) {
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidTransformAlgorithm"));
                }
                transforms.addTransform(this.transformAlg);
            }
            xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            X509Certificate x509Certificate = this.keystore.getX509Certificate(string);
            xMLSignature.addKeyInfo(x509Certificate);
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signXML Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        return xMLSignature.getElement();
    }

    public String signXML(String string, String string2) throws XMLSignatureException {
        return this.signXML(string, string2, SAMLUtils.bundle.getString("xmlsigalgorithm"));
    }

    public String signXML(String string, String string2, String string3) throws XMLSignatureException {
        Object object;
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string2 == null || string2.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        try {
            object = com.iplanet.am.util.XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug);
            element = this.signXML((Document)object, string2, string3);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signXML Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        object = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toString();
    }

    public Element signXML(Document document, String string, String string2, String string3) throws XMLSignatureException {
        return this.signXML(document, string, string2, DEF_ID_ATTRIBUTE, string3, false, null);
    }

    public Element signXML(Document document, String string, String string2, String string3, String string4) throws XMLSignatureException {
        return this.signXML(document, string, string2, DEF_ID_ATTRIBUTE, string3, false, string4);
    }

    public Element signXML(Document document, String string, String string2, String string3, String string4, boolean bl) throws XMLSignatureException {
        return this.signXML(document, string, string2, string3, string4, bl, null);
    }

    public String signXML(String string, String string2, String string3, String string4, String string5, boolean bl) throws XMLSignatureException {
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Document document = null;
        try {
            document = com.iplanet.am.util.XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signXML Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        Element element = this.signXML(document, string2, string3, string4, string5, bl, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    public Element signXML(Document document, String string, String string2, String string3, String string4, boolean bl, String string5) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        XMLSignature xMLSignature = null;
        try {
            Node node;
            Constants.setSignatureSpecNSprefix((String)"");
            PrivateKey privateKey = this.keystore.getPrivateKey(string);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            element = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@" + string3 + "=\"" + string4 + "\"]"));
            if (element == null) {
                SAMLUtils.debug.error("signXML: could not resolv id attribute");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidIDAttribute"));
            }
            if (!string4.equals(DEF_ID_ATTRIBUTE)) {
                IdResolver.registerElementById((Element)element, (String)string4);
            }
            if (string2 == null || string2.equals("")) {
                string2 = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            xMLSignature = new XMLSignature(document, "", string2, "http://www.w3.org/2001/10/xml-exc-c14n#");
            if (string5 == null) {
                element.appendChild(xMLSignature.getElement());
            } else {
                node = XPathAPI.selectSingleNode((Node)document, (String)string5);
                element.insertBefore(xMLSignature.getElement(), node);
            }
            xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            if (!string3.equals(DEF_ID_ATTRIBUTE)) {
                IdResolver.registerElementById((Element)element, (String)string4);
            }
            node = new Transforms(document);
            node.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            node.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            String string6 = "#" + string4;
            xMLSignature.addDocument(string6, (Transforms)node, "http://www.w3.org/2000/09/xmldsig#sha1");
            if (bl) {
                X509Certificate x509Certificate = this.keystore.getX509Certificate(string);
                xMLSignature.addKeyInfo(x509Certificate);
            }
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signXML Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        return xMLSignature.getElement();
    }

    public String signXML(String string, String string2, String string3, String string4) throws XMLSignatureException {
        Object object;
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string2 == null || string2.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        try {
            object = com.iplanet.am.util.XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug);
            element = this.signXML((Document)object, string2, string3, string4);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signXML Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        object = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toString();
    }

    public Element signXML(Document document, String string, String string2, List list) throws XMLSignatureException {
        return this.signXML(document, string, string2, null, list);
    }

    public Element signXML(Document document, String string, String string2, String string3, List list) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = document.getDocumentElement();
        XMLSignature xMLSignature = null;
        try {
            X509Certificate x509Certificate;
            Constants.setSignatureSpecNSprefix((String)"");
            PrivateKey privateKey = this.keystore.getPrivateKey(string);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            if (string2 == null || string2.equals("")) {
                string2 = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            xMLSignature = new XMLSignature(document, "", string2, "http://www.w3.org/2001/10/xml-exc-c14n#");
            element.appendChild(xMLSignature.getElement());
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                x509Certificate = new Transforms(document);
                if (string3 != null) {
                    x509Certificate.addTransform(string3);
                }
                x509Certificate.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                String string4 = (String)list.get(n2);
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("id = " + string4);
                }
                xMLSignature.addDocument("#" + string4, (Transforms)x509Certificate, "http://www.w3.org/2000/09/xmldsig#sha1");
                ++n2;
            }
            x509Certificate = this.keystore.getX509Certificate(string);
            xMLSignature.addKeyInfo(x509Certificate);
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signXML Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        return xMLSignature.getElement();
    }

    public String signXML(String string, String string2, String string3, List list) throws XMLSignatureException {
        Object object;
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string2 == null || string2.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        try {
            object = com.iplanet.am.util.XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug);
            element = this.signXML((Document)object, string2, string3, list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new XMLSignatureException(exception.getMessage());
        }
        object = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toString();
    }

    public Element signWithWSSSAMLTokenProfile(Document document, Certificate certificate, String string, String string2, List list) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (certificate == null) {
            SAMLUtils.debug.error("signWithWSSSAMLTokenProfile: Certificate is null");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string == null) {
            SAMLUtils.debug.error("signWithWSSSAMLTokenProfile: AssertionID is null");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = (Element)document.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "Security").item(0);
        XMLSignature xMLSignature = null;
        try {
            Object object;
            KeyInfo keyInfo;
            Constants.setSignatureSpecNSprefix((String)"");
            String string3 = this.keystore.getCertificateAlias(certificate);
            PrivateKey privateKey = this.keystore.getPrivateKey(string3);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            if (string2 == null || string2.equals("")) {
                string2 = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            xMLSignature = new XMLSignature(document, "", string2, "http://www.w3.org/2001/10/xml-exc-c14n#");
            element.appendChild(xMLSignature.getElement());
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                keyInfo = new Transforms(document);
                keyInfo.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                object = (String)list.get(n2);
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("id = " + (String)object);
                }
                xMLSignature.addDocument("#" + (String)object, (Transforms)keyInfo, "http://www.w3.org/2000/09/xmldsig#sha1");
                ++n2;
            }
            keyInfo = xMLSignature.getKeyInfo();
            object = document.createElementNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "SecurityTokenReference");
            keyInfo.addUnknownElement((Element)object);
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/ws/2003/06/secext");
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "urn:liberty:sec:2003-08");
            object.setAttributeNS(null, "Usage", "sec:MessageAuthentication");
            Element element2 = document.createElementNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "Reference");
            element2.setAttributeNS(null, "URI", "#" + string);
            object.appendChild(element2);
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signWithWSSX509TokenProfile Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAML Signed doc = " + com.iplanet.am.util.XMLUtils.print((Node)document.getDocumentElement()));
        }
        return xMLSignature.getElement();
    }

    public Element signWithWSSX509TokenProfile(Document document, Certificate certificate, String string, List list) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Soap Envlope: " + com.iplanet.am.util.XMLUtils.print((Node)document.getDocumentElement()));
        }
        Element element = (Element)document.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "Security").item(0);
        XMLSignature xMLSignature = null;
        try {
            Object object;
            KeyInfo keyInfo;
            Constants.setSignatureSpecNSprefix((String)"");
            String string2 = this.keystore.getCertificateAlias(certificate);
            PrivateKey privateKey = this.keystore.getPrivateKey(string2);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            if (string == null || string.equals("")) {
                string = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            xMLSignature = new XMLSignature(document, "", string, "http://www.w3.org/2001/10/xml-exc-c14n#");
            element.appendChild(xMLSignature.getElement());
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                keyInfo = new Transforms(document);
                keyInfo.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                object = (String)list.get(n2);
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("id = " + (String)object);
                }
                xMLSignature.addDocument("#" + (String)object, (Transforms)keyInfo, "http://www.w3.org/2000/09/xmldsig#sha1");
                ++n2;
            }
            keyInfo = xMLSignature.getKeyInfo();
            object = document.createElementNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "SecurityTokenReference");
            keyInfo.addUnknownElement((Element)object);
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/ws/2003/06/secext");
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "urn:liberty:sec:2003-08");
            object.setAttributeNS(null, "Usage", "sec:MessageAuthentication");
            Element element2 = (Element)element.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "BinarySecurityToken").item(0);
            String string3 = element2.getAttributeNS("http://schemas.xmlsoap.org/ws/2003/06/utility", "Id");
            Element element3 = document.createElementNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "Reference");
            object.appendChild(element3);
            element3.setAttributeNS(null, "URI", "#" + string3);
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("signWithWSSX509TokenProfile Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        return xMLSignature.getElement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verifyXMLSignature(Document document, String string) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            Object object;
            Object object2;
            Object object3;
            String[] stringArray = new String[]{"AssertionID", "RequestID", "ResponseID"};
            int n = 0;
            while (n < stringArray.length) {
                object3 = XPathAPI.selectNodeList((Node)document, (String)("//*[@" + stringArray[n] + "]"));
                if (object3 != null && object3.getLength() != 0) {
                    int n2 = object3.getLength();
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("found " + stringArray[n] + "=" + n2);
                    }
                    int n3 = 0;
                    while (n3 < n2) {
                        object2 = (Element)object3.item(n3);
                        object = object2.getAttribute(stringArray[n]);
                        if (object != null && !((String)object).equals("")) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("found " + stringArray[n] + "=" + (String)object + " elment=" + com.iplanet.am.util.XMLUtils.print((Node)object2));
                            }
                            IdResolver.registerElementById((Element)object2, (String)object);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            object3 = XMLUtils.createDSctx((Document)document, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"//ds:Signature", (Node)object3);
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("verifyXMLSignature: sigElements size = " + nodeList.getLength());
            }
            X509Certificate x509Certificate = this.keystore.getX509Certificate(string);
            object2 = this.keystore.getPublicKey(string);
            object = null;
            int n4 = 0;
            while (n4 < nodeList.getLength()) {
                object = (Element)nodeList.item(n4);
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Sig(" + n4 + ") = " + com.iplanet.am.util.XMLUtils.print((Node)object));
                }
                XMLSignature xMLSignature = new XMLSignature((Element)object, "");
                xMLSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
                KeyInfo keyInfo = xMLSignature.getKeyInfo();
                PublicKey publicKey = this.getX509PublicKey(document, keyInfo);
                if (publicKey != null) {
                    if (!xMLSignature.checkSignatureValue((Key)publicKey)) return false;
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("verifyXMLSignature: Signature " + n4 + " verified");
                    }
                } else {
                    if (string == null || string.equals("")) {
                        return false;
                    }
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Could not find a KeyInfo, try to use certAlias");
                    }
                    if (x509Certificate != null) {
                        if (!xMLSignature.checkSignatureValue(x509Certificate)) return false;
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("verifyXMLSignature: Signature " + n4 + " verified");
                        }
                    } else if (object2 != null) {
                        if (!xMLSignature.checkSignatureValue((Key)object2)) return false;
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("verifyXMLSignature: Signature " + n4 + " verified");
                        }
                    } else {
                        SAMLUtils.debug.error("Could not find public key based on certAlias to verify signature");
                        return false;
                    }
                }
                ++n4;
            }
            return true;
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("verifyXMLSignature Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
    }

    public boolean verifyXMLSignature(Document document) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(document, (String)null);
    }

    public boolean verifyXMLSignature(Element element) throws XMLSignatureException {
        if (element == null) {
            SAMLUtils.debug.error("signXML: element is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(com.iplanet.am.util.XMLUtils.print((Node)element));
    }

    public boolean verifyXMLSignature(Element element, String string) throws XMLSignatureException {
        return this.verifyXMLSignature(element, DEF_ID_ATTRIBUTE, string);
    }

    public boolean verifyXMLSignature(Element element, String string, String string2) throws XMLSignatureException {
        if (element == null) {
            SAMLUtils.debug.error("signXML: element is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(com.iplanet.am.util.XMLUtils.print((Node)element), string, string2);
    }

    public boolean verifyXMLSignature(Document document, Certificate certificate) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = this.keystore.getCertificateAlias(certificate);
        return this.verifyXMLSignature(document, string);
    }

    public boolean verifyXMLSignature(String string) throws XMLSignatureException {
        return this.verifyXMLSignature(string, null);
    }

    public boolean verifyXMLSignature(String string, String string2) throws XMLSignatureException {
        return this.verifyXMLSignature(string, DEF_ID_ATTRIBUTE, string2);
    }

    public boolean verifyXMLSignature(String string, String string2, String string3) throws XMLSignatureException {
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            X509Certificate x509Certificate;
            Object object;
            Object object2;
            Document document = com.iplanet.am.util.XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug);
            Element element = XMLUtils.createDSctx((Document)document, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
            XMLSignature xMLSignature = new XMLSignature(element2, "");
            xMLSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            String string4 = document.getDocumentElement().getAttribute(string2);
            Element element3 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@" + string2 + "=\"" + string4 + "\"]"));
            if (element3 == null) {
                SAMLUtils.debug.error("verifyXML: could not resolv id attribute");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidIDAttribute"));
            }
            String[] stringArray = new String[]{"AssertionID", "RequestID", "ResponseID"};
            int n = 0;
            while (n < stringArray.length) {
                object2 = XPathAPI.selectNodeList((Node)document, (String)("//*[@" + stringArray[n] + "]"));
                if (object2 != null && object2.getLength() != 0) {
                    int n2 = object2.getLength();
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("found " + stringArray[n] + "=" + n2);
                    }
                    int n3 = 0;
                    while (n3 < n2) {
                        object = (Element)object2.item(n3);
                        String string5 = object.getAttribute(stringArray[n]);
                        if (string5 != null && !string5.equals("")) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("found " + stringArray[n] + "=" + string5 + " elment=" + com.iplanet.am.util.XMLUtils.print((Node)object));
                            }
                            IdResolver.registerElementById((Element)object, (String)string5);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            object2 = xMLSignature.getKeyInfo();
            PublicKey publicKey = this.getX509PublicKey(document, (KeyInfo)object2);
            if (publicKey != null) {
                return xMLSignature.checkSignatureValue((Key)publicKey);
            }
            if (string3 == null || string3.equals("")) {
                return false;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Could not find a KeyInfo, try to use certAlias");
            }
            if ((x509Certificate = this.keystore.getX509Certificate(string3)) != null) {
                return xMLSignature.checkSignatureValue(x509Certificate);
            }
            object = this.keystore.getPublicKey(string3);
            if (object != null) {
                return xMLSignature.checkSignatureValue((Key)object);
            }
            SAMLUtils.debug.error("Could not find public key based on certAlias to verify signature");
            return false;
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("verifyXMLSignature Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
    }

    public KeyProvider getKeyProvider() {
        return this.keystore;
    }

    private PublicKey getX509PublicKey(Document document, KeyInfo keyInfo) {
        PublicKey publicKey;
        block9: {
            publicKey = null;
            try {
                if (keyInfo == null) break block9;
                if (keyInfo.containsX509Data()) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Found X509Data element in the KeyInfo");
                    }
                    X509Certificate x509Certificate = keyInfo.getX509Certificate();
                    if (this.checkCert) {
                        if (this.keystore.getCertificateAlias(x509Certificate) == null) {
                            SAMLUtils.debug.error("verifyXMLSignature: certificate is not trusted.");
                            throw new XMLSignatureException(SAMLUtils.bundle.getString("untrustedCertificate"));
                        }
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("verifyXMLSignature: certificate is trused.");
                        }
                    } else if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Skip checking whether the cert in the cert db.");
                    }
                    publicKey = this.getPublicKey(x509Certificate);
                    break block9;
                }
                publicKey = this.getWSSTokenProfilePublicKey(document);
            }
            catch (Exception exception) {
                SAMLUtils.debug.error("getX509Certificate(KeyInfo) Exception: ", (Throwable)exception);
            }
        }
        return publicKey;
    }

    private PublicKey getWSSTokenProfilePublicKey(Document document) {
        PublicKey publicKey;
        block9: {
            publicKey = null;
            try {
                SAMLUtils.debug.message("getWSSTTokenProfilePublicKey: entering");
                Element element = (Element)document.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "Security").item(0);
                Element element2 = XMLUtils.createDSctx((Document)document, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
                Element element3 = (Element)XPathAPI.selectSingleNode((Node)element, (String)"ds:Signature[1]", (Node)element2);
                Element element4 = (Element)element3.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
                Element element5 = (Element)element4.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "SecurityTokenReference").item(0);
                Element element6 = (Element)element4.getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2003/06/secext", "Reference").item(0);
                if (element6 != null) {
                    String string = element6.getAttribute("URI");
                    string = string.substring(1);
                    element2 = XMLUtils.createDSctx((Document)document, (String)"wsu", (String)"http://schemas.xmlsoap.org/ws/2003/06/utility");
                    Node node = XPathAPI.selectSingleNode((Node)document, (String)("//*[@wsu:Id=\"" + string + "\"]"), (Node)element2);
                    if (node != null) {
                        SAMLUtils.debug.message("X509 Token");
                        String string2 = ((Element)node).getAttribute("ValueType");
                        NodeList nodeList = node.getChildNodes();
                        node = nodeList.item(0);
                        String string3 = node.getNodeValue().trim();
                        publicKey = this.getPublicKey(this.getCertificate(string3, string2));
                    } else {
                        SAMLUtils.debug.message("SAML Token");
                        element6 = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@AssertionID=\"" + string + "\"]"));
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("SAML Assertion = " + com.iplanet.am.util.XMLUtils.print((Node)element6));
                        }
                        if ((element6 = (Element)element6.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0)) == null) {
                            SAMLUtils.debug.message("getWSSTokenProfilePublicKey: no KeyInfo found!");
                            throw new Exception(SAMLUtils.bundle.getString("nullKeyInfo"));
                        }
                        Element element7 = (Element)element6.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Data").item(0);
                        if (element7 != null) {
                            element6 = (Element)element7.getChildNodes().item(0);
                            String string4 = element7.getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("certString = " + string4);
                            }
                            return this.getPublicKey(this.getCertificate(string4, null));
                        }
                        publicKey = this.getPublicKeybyDSARSAkeyValue(document, element6);
                    }
                    break block9;
                }
                SAMLUtils.debug.error("getWSSTokenProfilePublicKey: unknow Security Token Reference");
            }
            catch (Exception exception) {
                SAMLUtils.debug.error("getWSSTokenProfilePublicKey Exception: ", (Throwable)exception);
            }
        }
        return publicKey;
    }

    private PublicKey getPublicKeybyDSARSAkeyValue(Document document, Element element) throws XMLSignatureException {
        PublicKey publicKey = null;
        Element element2 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue").item(0);
        if (element2 != null) {
            NodeList nodeList = element2.getChildNodes();
            int n = nodeList.getLength();
            if (n > 0) {
                Node node;
                BigInteger bigInteger = null;
                BigInteger bigInteger2 = null;
                BigInteger bigInteger3 = null;
                BigInteger bigInteger4 = null;
                int n2 = 0;
                while (n2 < n) {
                    node = nodeList.item(n2);
                    if (node.getNodeType() == 1) {
                        String string = node.getLocalName();
                        Node node2 = node.getChildNodes().item(0);
                        String string2 = node2.getNodeValue();
                        BigInteger bigInteger5 = new BigInteger(Base64.decode((String)string2));
                        if (string.equals("P")) {
                            bigInteger = bigInteger5;
                        } else if (string.equals("Q")) {
                            bigInteger2 = bigInteger5;
                        } else if (string.equals("G")) {
                            bigInteger3 = bigInteger5;
                        } else if (string.equals("Y")) {
                            bigInteger4 = bigInteger5;
                        } else {
                            throw new XMLSignatureException();
                        }
                    }
                    ++n2;
                }
                node = new DSAKeyValue(document, bigInteger, bigInteger2, bigInteger3, bigInteger4);
                try {
                    publicKey = node.getPublicKey();
                }
                catch (Exception exception) {
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
            }
        } else {
            Element element3 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue").item(0);
            if (element3 != null) {
                NodeList nodeList = element3.getChildNodes();
                int n = nodeList.getLength();
                BigInteger bigInteger = null;
                BigInteger bigInteger6 = null;
                if (n > 0) {
                    int n3 = 0;
                    while (n3 < n) {
                        Node node = nodeList.item(n3);
                        if (node.getNodeType() == 1) {
                            String string = node.getLocalName();
                            Node node3 = node.getChildNodes().item(0);
                            String string3 = node3.getNodeValue();
                            BigInteger bigInteger7 = new BigInteger(Base64.decode((String)string3));
                            if (string.equals("Exponent")) {
                                bigInteger6 = bigInteger7;
                            } else if (string.equals("Modulus")) {
                                bigInteger = bigInteger7;
                            } else {
                                throw new XMLSignatureException();
                            }
                        }
                        ++n3;
                    }
                }
                RSAKeyValue rSAKeyValue = new RSAKeyValue(document, bigInteger, bigInteger6);
                try {
                    publicKey = rSAKeyValue.getPublicKey();
                }
                catch (Exception exception) {
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("errorObtainPK"));
                }
            }
        }
        return publicKey;
    }

    /*
     * Unable to fully structure code
     */
    private X509Certificate getCertificate(String var1_1, String var2_2) {
        block5: {
            var3_3 = null;
            try {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("getCertificate(Assertion) : " + var1_1);
                }
                var4_4 = new StringBuffer(100);
                var4_4.append("-----BEGIN CERTIFICATE-----\n");
                var4_4.append(var1_1);
                var4_4.append("\n-----END CERTIFICATE-----");
                var5_6 = null;
                var5_6 = var4_4.toString().getBytes();
                var6_7 = CertificateFactory.getInstance("X.509");
                var7_8 = new ByteArrayInputStream(var5_6);
                if (var2_2 == null || !var2_2.equals("wsse:PKCS7")) ** GOTO lbl24
                var8_9 = var6_7.generateCertificates(var7_8);
                var9_10 = var8_9.iterator();
                while (var9_10.hasNext()) {
                    var3_3 = (X509Certificate)var9_10.next();
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    var3_3 = (X509Certificate)var6_7.generateCertificate(var7_8);
lbl24:
                    // 2 sources

                    ** while (var7_8.available() > 0)
                }
lbl25:
                // 1 sources

            }
            catch (Exception var4_5) {
                SAMLUtils.debug.error("getCertificate Exception: ", (Throwable)var4_5);
            }
        }
        return var3_3;
    }

    private PublicKey getPublicKey(X509Certificate x509Certificate) {
        PublicKey publicKey = null;
        if (x509Certificate != null) {
            publicKey = x509Certificate.getPublicKey();
        }
        return publicKey;
    }

    private boolean isValidAlgorithm(String string) {
        return string.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-md5") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-md5") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
    }

    private boolean isValidCanonicalizationMethod(String string) {
        return string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
    }

    private boolean isValidTransformAlgorithm(String string) {
        return string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/TR/1999/REC-xslt-19991116") || string.equals("http://www.w3.org/2000/09/xmldsig#base64") || string.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || string.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature") || string.equals("http://www.w3.org/TR/2001/WD-xptr-20010108") || string.equals("http://www.w3.org/2002/04/xmldsig-filter2") || string.equals("http://www.w3.org/2002/06/xmldsig-filter2") || string.equals("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter");
    }
}

