/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAMLSOAPReceiver
extends JAXMServlet {
    private static MessageFactory msgFactory = null;
    private static SAMLConstants sc = null;
    public static String localSAMLServiceID = null;
    private static boolean nullRecipient = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = SystemProperties.get((String)"com.iplanet.am.localserver.protocol");
        String string2 = SystemProperties.get((String)"com.iplanet.am.localserver.host");
        String string3 = SystemProperties.get((String)"com.iplanet.am.localserver.port");
        nullRecipient = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.saml.response.nullrecipient"));
        localSAMLServiceID = string + "://" + string2 + ":" + string3;
        super.init(servletConfig);
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            String string4 = SAMLUtils.bundle.getString("missingSoapMessageFactory");
            SAMLUtils.debug.error(string4, (Throwable)sOAPException);
            LogUtils.error(Level.INFO, string4 + ": " + sOAPException.getMessage());
            throw new ServletException(sOAPException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (SAMLUtils.getMaxContentLength() != 0) {
            int n = httpServletRequest.getContentLength();
            if (n == -1) {
                throw new ServletException(SAMLUtils.bundle.getString("unknownLength"));
            }
            if (n > SAMLUtils.getMaxContentLength()) {
                if (!SAMLUtils.debug.messageEnabled()) throw new ServletException(SAMLUtils.bundle.getString("largeContentLength"));
                SAMLUtils.debug.message("content length too large" + n);
                throw new ServletException(SAMLUtils.bundle.getString("largeContentLength"));
            }
        }
        String string = httpServletRequest.getRemoteAddr();
        Set set = null;
        set = SAMLSOAPReceiver.checkCaller(httpServletRequest, httpServletResponse);
        if (set != null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message(" got request from a trusted server, processing it now..");
            }
            try {
                MimeHeaders mimeHeaders = JAXMServlet.getHeaders((HttpServletRequest)httpServletRequest);
                ServletInputStream servletInputStream = httpServletRequest.getInputStream();
                SOAPMessage sOAPMessage = msgFactory.createMessage(mimeHeaders, (InputStream)servletInputStream);
                SOAPMessage sOAPMessage2 = null;
                sOAPMessage2 = this.onMessage(httpServletRequest, httpServletResponse, sOAPMessage, set);
                if (sOAPMessage2 == null) return;
                if (sOAPMessage2.saveRequired()) {
                    sOAPMessage2.saveChanges();
                }
                if (this.containsFault(sOAPMessage2)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Contains a SOAPFault!");
                    }
                    httpServletResponse.setStatus(500);
                } else {
                    httpServletResponse.setStatus(200);
                }
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage2.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage2.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        } else {
            SAMLUtils.debug.error("Error message from SOAP Receiver:" + string + " is untrusted site");
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("untrustedSite") + ": " + string);
            httpServletResponse.sendError(403);
        }
    }

    private boolean containsFault(SOAPMessage sOAPMessage) {
        try {
            SOAPPart sOAPPart = sOAPMessage.getSOAPPart();
            SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
            SOAPBody sOAPBody = sOAPEnvelope.getBody();
            return sOAPBody.hasFault();
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Error in containFault!");
            }
            return false;
        }
    }

    private SOAPMessage onMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SOAPMessage sOAPMessage, Set set) {
        try {
            Object object;
            Document document;
            block11: {
                block10: {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("OnMessage called in receiving servlet");
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    sOAPMessage.writeTo((OutputStream)byteArrayOutputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    document = XMLUtils.toDOMDocument((InputStream)byteArrayInputStream, (Debug)SAMLUtils.debug);
                    Element element = document.getDocumentElement();
                    String string = document.getDocumentElement().getLocalName();
                    if (string == null || string.equals("")) {
                        SAMLUtils.debug.error("Local name of the SOAPElement in  the SOAPMessage passed seems to be missing");
                        return this.FormSOAPError(httpServletResponse, "Client", "nullInput", "LocalNameMissing");
                    }
                    if (!string.equals("Envelope")) break block10;
                    if (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) break block11;
                }
                SAMLUtils.debug.error("SOAPReceiver: Could not parse SOAPMessage, either root element is not Envelope or invalid name space or prefix");
                return this.FormSOAPError(httpServletResponse, "Client", "invalidElement", "envelopeInvalid");
            }
            NodeList nodeList = document.getChildNodes();
            int n = nodeList.getLength();
            if (n <= 0) {
                SAMLUtils.debug.error("SOAPReceiver: Message does not have body");
                return this.FormSOAPError(httpServletResponse, "Client", "missingBody", null);
            }
            Node node = null;
            int n2 = 0;
            while (n2 < n) {
                node = nodeList.item(n2);
                if (node.getNodeType() == 1 && ((String)(object = node.getLocalName())).equals("Body")) break;
                ++n2;
            }
            object = (Element)node;
            Response response = this.extractProcessRequest(httpServletRequest, (Element)object, set);
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signresponse")).booleanValue()) {
                response.signXML();
            }
            return this.FormMessageResponse(httpServletResponse, response);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("Error in processing Request", (Throwable)exception);
            return this.FormSOAPError(httpServletResponse, "Server", "cannotProcessRequest", null);
        }
    }

    private Response extractProcessRequest(HttpServletRequest httpServletRequest, Element element, Set set) {
        Object object;
        Object object2;
        Response response = null;
        String string = SAMLUtils.generateID();
        String string2 = null;
        ArrayList arrayList = new ArrayList();
        String string3 = null;
        String string4 = httpServletRequest.getRemoteAddr();
        String string5 = null;
        if (!nullRecipient) {
            string5 = string4;
        }
        String string6 = SAMLUtils.bundle.getString("invalidRequestLogMessage") + " " + string4 + ": ";
        String string7 = SAMLUtils.bundle.getString("responseLogMessage") + " " + string4 + ": ";
        NodeList nodeList = element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        int n = nodeList.getLength();
        if (n == 0) {
            SAMLUtils.debug.error("SOAPReceiver: Body does not have a Request");
            string3 = SAMLUtils.bundle.getString("missingRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            LogUtils.error(Level.INFO, string6 + response.toString());
            return response;
        }
        boolean bl = false;
        AbstractRequest abstractRequest = null;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && node.getLocalName().equals("Request")) {
                try {
                    abstractRequest = new Request((Element)node);
                    SAMLUtils.debug.message("found request ");
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message(" Received Request:" + ((Request)abstractRequest).toString());
                    }
                    LogUtils.access(Level.FINE, SAMLUtils.bundle.getString("requestLogMessage") + " " + string4 + ": " + ((Request)abstractRequest).toString());
                    string2 = abstractRequest.getRequestID();
                    bl = true;
                    break;
                }
                catch (SAMLRequesterException sAMLRequesterException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:Requester " + sAMLRequesterException.getMessage());
                    }
                    string3 = new String(sAMLRequesterException.getMessage());
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    LogUtils.error(Level.INFO, string6 + response.toString());
                    return response;
                }
                catch (SAMLRequestVersionTooHighException sAMLRequestVersionTooHighException) {
                    String string8 = new String(sAMLRequestVersionTooHighException.getMessage());
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, "|");
                    string2 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:VersionMismatch " + string3);
                    }
                    try {
                        Status status = new Status(new StatusCode("samlp:RequestVersionTooHigh"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    LogUtils.error(Level.INFO, string6 + response.toString());
                    return response;
                }
                catch (SAMLRequestVersionTooLowException sAMLRequestVersionTooLowException) {
                    String string9 = new String(sAMLRequestVersionTooLowException.getMessage());
                    StringTokenizer stringTokenizer = new StringTokenizer(string9, "|");
                    string2 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:VersionMismatch " + string3);
                    }
                    try {
                        Status status = new Status(new StatusCode("samlp:RequestVersionTooLow"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    LogUtils.error(Level.INFO, string6 + response.toString());
                    return response;
                }
                catch (Exception exception) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver:setting status to samlp:Responder " + exception.getMessage());
                    }
                    string3 = new String(exception.getMessage());
                    try {
                        Status status = new Status(new StatusCode("samlp:Responder"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    }
                    LogUtils.error(Level.INFO, string6 + response.toString());
                    return response;
                }
            }
            ++n2;
        }
        if (!bl) {
            SAMLUtils.debug.error("SOAPReceiver: Body does not have a Request");
            string3 = SAMLUtils.bundle.getString("missingRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
            }
            LogUtils.error(Level.INFO, string6 + response.toString());
            return response;
        }
        if (!abstractRequest.isSignatureValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver: couldn't verify the signature on Request.");
            }
            string3 = SAMLUtils.bundle.getString("cannotVerifyRequest");
            try {
                Status status = new Status(new StatusCode("samlp:Requester"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
            LogUtils.access(Level.INFO, string7 + response.toString());
            return response;
        }
        int n3 = ((Request)abstractRequest).getContentType();
        if (n3 == -1) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver:Found element in the request which are not supported");
            }
            string3 = SAMLUtils.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
            LogUtils.access(Level.INFO, string7 + response.toString());
            return response;
        }
        List list = abstractRequest.getRespondWith();
        if (!this.parseRespondWith(list)) {
            SAMLUtils.debug.error("SOAPReceiver:Supported statements are not present in the RespondWith element.");
            string3 = SAMLUtils.bundle.getString("unsupportedStatement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
            LogUtils.access(Level.INFO, string7 + response.toString());
            return response;
        }
        AssertionManager assertionManager = null;
        try {
            assertionManager = AssertionManager.getInstance();
        }
        catch (SAMLException sAMLException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver: Cannot instantiate AssertionManager");
            }
            string3 = sAMLException.getMessage();
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException2) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response: " + sAMLException2.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException2.getMessage());
            }
            LogUtils.access(Level.INFO, string7 + response.toString());
            return response;
        }
        List list2 = null;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (n3 == 3) {
            list2 = ((Request)abstractRequest).getAssertionArtifact();
            n = list2.size();
            object2 = null;
            int n4 = 0;
            while (n4 < n) {
                AssertionArtifact assertionArtifact = (AssertionArtifact)list2.get(n4);
                if (!this.isThisSiteID(assertionArtifact.getSourceID())) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver:Artifact has invalid SourceID");
                    }
                    string3 = SAMLUtils.bundle.getString("mismatchSourceID");
                    try {
                        Status status = new Status(new StatusCode("samlp:Requester"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response: " + sAMLException.getMessage());
                        LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
                    }
                    LogUtils.access(Level.INFO, string7 + response.toString());
                    return response;
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < n) {
                object = (AssertionArtifact)list2.get(n5);
                Assertion assertion = null;
                try {
                    assertion = assertionManager.getAssertion((AssertionArtifact)object, set);
                }
                catch (SAMLException sAMLException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    string3 = sAMLException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException3) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response: " + sAMLException3.getMessage());
                        LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException3.getMessage());
                    }
                    LogUtils.access(Level.INFO, string7 + response.toString());
                    return response;
                }
                if (assertion != null) {
                    arrayList2.add(n5, assertion);
                }
                ++n5;
            }
        } else if (n3 == 2) {
            object2 = ((Request)abstractRequest).getAssertionIDReference();
            n = object2.size();
            int n6 = 0;
            while (n6 < n) {
                AssertionIDReference assertionIDReference = (AssertionIDReference)object2.get(n6);
                object = null;
                try {
                    object = assertionManager.getAssertion(assertionIDReference, set);
                }
                catch (SAMLException sAMLException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    string3 = sAMLException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException4) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response: " + sAMLException4.getMessage());
                        LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException4.getMessage());
                    }
                    LogUtils.access(Level.INFO, string7 + response.toString());
                    return response;
                }
                if (object != null) {
                    arrayList2.add(n6, object);
                }
                ++n6;
            }
        } else if (n3 == 0 || n3 == 1 || n3 == 4) {
            object2 = ((Request)abstractRequest).getQuery();
            if (object2 != null) {
                Assertion assertion = null;
                try {
                    assertion = assertionManager.getAssertion((Query)object2, (String)set.iterator().next());
                }
                catch (SAMLException sAMLException) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SOAPReceiver: could not find matching assertion");
                    }
                    string3 = sAMLException.getMessage();
                    try {
                        Status status = new Status(new StatusCode("samlp:Success"), string3, null);
                        response = new Response(string, string2, status, string5, arrayList);
                        response.setMajorVersion(abstractRequest.getMajorVersion());
                        response.setMinorVersion(abstractRequest.getMinorVersion());
                    }
                    catch (SAMLException sAMLException5) {
                        SAMLUtils.debug.error("SOAPReceiver:Fatal  error, cannot create status or  response: " + sAMLException5.getMessage());
                        LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException5.getMessage());
                    }
                    LogUtils.access(Level.INFO, string7 + response.toString());
                    return response;
                }
                if (assertion != null) {
                    arrayList2.add(assertion);
                }
            }
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SOAPReceiver:Request contents has element which is not supported at this time");
            }
            string3 = SAMLUtils.bundle.getString("unsupportedElement");
            try {
                Status status = new Status(new StatusCode("samlp:Responder"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
            LogUtils.access(Level.INFO, string7 + response.toString());
            return response;
        }
        int n7 = arrayList2.size();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("found " + n7 + " assertions.");
        }
        int n8 = 0;
        while (n8 < n7) {
            Response response2 = this.validateStatements((Assertion)arrayList2.get(n8), list, arrayList, n8, string, string2, string5);
            if (response2 != null) {
                LogUtils.access(Level.INFO, string7 + response2.toString());
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
                return response2;
            }
            ++n8;
        }
        if (n3 == 3) {
            if (arrayList.size() == list2.size()) {
                string3 = null;
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("SOAPReceiver: Matching Assertion found");
                }
                try {
                    Status status = new Status(new StatusCode("samlp:Success"), string3, null);
                    response = new Response(string, string2, status, string5, arrayList);
                    response.setMajorVersion(abstractRequest.getMajorVersion());
                    response.setMinorVersion(abstractRequest.getMinorVersion());
                }
                catch (SAMLException sAMLException) {
                    SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                    LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
                }
                LogUtils.access(Level.FINE, string7 + response.toString());
                return response;
            }
            string3 = SAMLUtils.bundle.getString("unequalMatch");
            try {
                Status status = new Status(new StatusCode("samlp:Success"), string3, null);
                response = new Response(string, string2, status, string5, arrayList);
                response.setMajorVersion(abstractRequest.getMajorVersion());
                response.setMinorVersion(abstractRequest.getMinorVersion());
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
            LogUtils.access(Level.INFO, string7 + response.toString());
            return response;
        }
        try {
            Status status = new Status(new StatusCode("samlp:Success"), string3, null);
            response = new Response(string, string2, status, string5, arrayList);
            response.setMajorVersion(abstractRequest.getMajorVersion());
            response.setMinorVersion(abstractRequest.getMinorVersion());
        }
        catch (SAMLException sAMLException) {
            SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            LogUtils.access(Level.FINER, string7 + response.toString());
        } else {
            LogUtils.access(Level.INFO, string7 + response.getResponseID());
        }
        return response;
    }

    private SOAPMessage FormSOAPError(HttpServletResponse httpServletResponse, String string, String string2, String string3) {
        SOAPMessage sOAPMessage = null;
        SOAPEnvelope sOAPEnvelope = null;
        SOAPFault sOAPFault = null;
        SOAPBody sOAPBody = null;
        DetailEntry detailEntry = null;
        try {
            sOAPMessage = msgFactory.createMessage();
            sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            sOAPBody = sOAPEnvelope.getBody();
            sOAPFault = sOAPBody.addFault();
            sOAPFault.setFaultCode(string);
            sOAPFault.setFaultString(SAMLUtils.bundle.getString(string2));
            if (string3 != null && !string3.equals("")) {
                Detail detail = sOAPFault.addDetail();
                detailEntry = detail.addDetailEntry(sOAPEnvelope.createName("Problem"));
                detailEntry.addAttribute(sOAPEnvelope.createName("details"), SAMLUtils.bundle.getString(string3));
            }
        }
        catch (SOAPException sOAPException) {
            SAMLUtils.debug.error("FormSOAPError:" + sOAPException.getMessage());
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("soapFaultError") + ": " + sOAPException.getMessage());
            httpServletResponse.setStatus(500);
        }
        return sOAPMessage;
    }

    private SOAPMessage FormMessageResponse(HttpServletResponse httpServletResponse, Response response) {
        SOAPMessage sOAPMessage = null;
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml");
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("\n");
        stringBuffer.append("<").append("soap-env").append(":Body>").append("\n");
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append("</").append("soap-env").append(":Body>").append("\n");
        stringBuffer2.append("</").append("soap-env").append(":Envelope>").append("\n");
        try {
            StringBuffer stringBuffer3 = new StringBuffer(300);
            stringBuffer3.append(stringBuffer).append(response.toString()).append(stringBuffer2);
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("response created is: " + stringBuffer3.toString());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(stringBuffer3.toString().getBytes("UTF-8"));
            sOAPMessage = msgFactory.createMessage(mimeHeaders, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("could not build response:" + exception.getMessage());
            httpServletResponse.setStatus(500);
            return this.FormSOAPError(httpServletResponse, "Server", "cannotBuildResponse", "cannotVerifyIdentity");
        }
        return sOAPMessage;
    }

    private Response validateStatements(Assertion assertion, List list, List list2, int n, String string, String string2, String string3) {
        Object var8_8 = null;
        String string4 = null;
        Set set = assertion.getStatement();
        int n2 = set.size();
        Response response = null;
        Status status = null;
        if (set.isEmpty() || n2 == 0) {
            SAMLUtils.debug.error("SOAPReceiver: Assertion found does not have any statements in it");
            string4 = SAMLUtils.bundle.getString("missingStatement");
            try {
                status = new Status(new StatusCode("samlp:Responder"), string4, null);
                response = new Response(string, string2, status, string3, list2);
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error, cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
            return response;
        }
        boolean bl = false;
        if (list.size() == 0) {
            list2.add(n, assertion);
        } else {
            boolean bl2 = bl = !this.checkAgainstRespondWith(list, set);
            if (!bl) {
                list2.add(n, assertion);
            }
        }
        if (bl) {
            SAMLUtils.debug.error("SOAPReceiver: Assertion does not  meet respondWith criteria in the received Request");
            string4 = SAMLUtils.bundle.getString("mismatchRespondWith");
            try {
                status = new Status(new StatusCode("samlp:Success"), string4, null);
                return new Response(string, string2, status, string3, list2);
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("SOAPReceiver:Fatal error,  cannot create status or response:" + sAMLException.getMessage());
                LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("cannotBuildResponse") + ": " + sAMLException.getMessage());
            }
        }
        return null;
    }

    private boolean parseRespondWith(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.indexOf(":");
            if (n == -1 || n == 0) {
                return false;
            }
            if (string.endsWith(":AuthenticationStatement") || string.endsWith(":AuthorizationDecisionStatement") || string.endsWith(":AttributeStatement")) continue;
            return false;
        }
        return true;
    }

    private boolean checkAgainstRespondWith(List list, Set set) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            bl = false;
            Statement statement = (Statement)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                SAMLUtils.debug.message("matching respondWith element:" + string);
                switch (statement.getStatementType()) {
                    case 1: {
                        if (!string.endsWith(":AuthenticationStatement")) break;
                        SAMLUtils.debug.message("matching auth st");
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (!string.endsWith(":AuthorizationDecisionStatement")) break;
                        SAMLUtils.debug.message("matching authz st");
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (!string.endsWith(":AttributeStatement")) break;
                        SAMLUtils.debug.message("matching attrib st");
                        bl = true;
                    }
                }
                if (!bl) continue;
                SAMLUtils.debug.message("match found");
                break;
            }
            if (bl) continue;
            SAMLUtils.debug.message("mismatch found");
            return false;
        }
        return true;
    }

    protected static Set checkCaller(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        String string = null;
        Set set = null;
        String string2 = httpServletRequest.getRemoteAddr();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("caller's IP:" + string2);
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLSOAPReceiver: Exception", (Throwable)exception);
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            string = string2;
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLSOAPReceiver: got all certs from HttpServletRequest =" + x509CertificateArray.length);
            }
            X509Certificate x509Certificate = x509CertificateArray[0];
            SAMLServiceManager.CertEntry certEntry = null;
            certEntry = SAMLServiceManager.getMatchingCertEntry(x509Certificate);
            if (certEntry != null) {
                string = certEntry.getNickName();
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Found matching nickname:" + string);
                }
            }
        }
        set = SAMLSOAPReceiver.getPartnerSourceID(string);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set;
    }

    private static Set getPartnerSourceID(String string) {
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            Set set2 = null;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)entry.getValue();
                set2 = sOAPEntry.getHostSet();
                if (set2 == null || !set2.contains(string)) continue;
                hashSet.add((String)entry.getKey());
                if (!SAMLUtils.debug.messageEnabled()) continue;
                SAMLUtils.debug.message("getPartnerSourceID: found a matching sid=" + Base64.encode((byte[])SAMLUtils.stringToByteArray((String)entry.getKey())));
            }
            return hashSet;
        }
        return null;
    }

    private boolean isThisSiteID(String string) {
        return ((String)SAMLServiceManager.getAttribute("mysiteid")).equals(string);
    }
}

