/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.servlet.POSTCleanUpThread;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAMLPOSTProfileServlet
extends HttpServlet {
    private static Map idTimeMap = new HashMap();
    private static Thread cThread = new POSTCleanUpThread(idTimeMap);

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (httpServletRequest == null || httpServletResponse == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        String string = httpServletRequest.getParameter("TARGET");
        if (string == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingTargetSite"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("missingTargetSite"));
            return;
        }
        SAMLServiceManager.SiteEntry siteEntry = this.getDestSite(string);
        String string2 = null;
        if (siteEntry == null || (string2 = siteEntry.getPOSTUrl()) == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("targetForbidden") + " " + string);
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("targetForbidden") + " " + string);
            return;
        }
        SSOToken sSOToken = this.getSSOToken(httpServletRequest);
        if (sSOToken == null) {
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullSSOToken"));
            return;
        }
        Response response = null;
        try {
            Object object2;
            object = siteEntry.getVersion();
            int n = 1;
            int n2 = SAMLConstants.PROTOCOL_MINOR_VERSION;
            if (object != null && ((StringTokenizer)(object2 = new StringTokenizer((String)object, "."))).countTokens() == 2) {
                n = Integer.parseInt(((StringTokenizer)object2).nextToken().trim());
                n2 = Integer.parseInt(((StringTokenizer)object2).nextToken().trim());
            }
            object2 = AssertionManager.getInstance();
            Assertion assertion = ((AssertionManager)object2).createSSOAssertion(sSOToken.getTokenID().toString(), null, siteEntry.getSourceID(), string, n + "." + n2);
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
            arrayList.add(assertion);
            response = new Response(null, status, string2, arrayList);
            response.setMajorVersion(n);
            response.setMinorVersion(n2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)numberFormatException);
            httpServletResponse.sendError(500, numberFormatException.getMessage());
            return;
        }
        catch (SAMLException sAMLException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)sAMLException);
            httpServletResponse.sendError(500, sAMLException.getMessage());
            return;
        }
        object = null;
        try {
            object = this.signResponse(response);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when signing the response:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("errorSigningResponse"));
            return;
        }
        String string3 = null;
        try {
            string3 = Base64.encode((byte[])object).trim();
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when encoding the response:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("errorEncodeResponse"));
            return;
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            LogUtils.access(Level.FINER, SAMLUtils.bundle.getString("targetURL") + string + ". " + SAMLUtils.bundle.getString("SAMLResponse") + new String((byte[])object, "UTF-8") + ". " + SAMLUtils.bundle.getString("redirectTo") + string2);
        } else {
            LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("targetURL") + string + ". " + SAMLUtils.bundle.getString("redirectTo") + string2);
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML>");
        printWriter.println("<BODY Onload=\"document.forms[0].submit()\">");
        printWriter.println("<FORM METHOD=\"POST\" ACTION=\"" + string2 + "\">");
        printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"SAMLResponse\" ");
        printWriter.println("VALUE=\"" + string3 + "\">");
        printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"TARGET\" VALUE=\"" + string + "\"> </FORM>");
        printWriter.println("</BODY></HTML>");
        printWriter.close();
    }

    private byte[] signResponse(Response response) throws SAMLException {
        response.signXML();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.signResponse: signed samlResponse is" + response.toString(true, true, true));
        }
        byte[] byArray = null;
        try {
            byArray = response.toString(true, true, true).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLPOSTProfileServlet.signResponse", (Throwable)unsupportedEncodingException);
            }
            throw new SAMLException(unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    private SAMLServiceManager.SiteEntry getDestSite(String string) {
        SAMLServiceManager.SiteEntry siteEntry = null;
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            if (string2 == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite: missing host in target.");
                return null;
            }
            SAMLServiceManager.SiteEntry siteEntry2 = null;
            Iterator iterator = ((Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list")).iterator();
            String string3 = null;
            int n2 = -1;
            while (iterator.hasNext()) {
                siteEntry2 = (SAMLServiceManager.SiteEntry)iterator.next();
                string3 = siteEntry2.getHostName();
                n2 = siteEntry2.getPort();
                if (string3 == null || string2.indexOf(string3) == -1) continue;
                if (n2 != -1) {
                    if (n2 != n) continue;
                    siteEntry = siteEntry2;
                    break;
                }
                siteEntry = siteEntry2;
            }
            if (siteEntry == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite:  No destSite found from the target.");
                return null;
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite: ", (Throwable)exception);
            return null;
        }
        return siteEntry;
    }

    private SSOToken getSSOToken(HttpServletRequest httpServletRequest) {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSSOToken: SSOToken is null.");
                return null;
            }
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSSOToken: SSOToken is invalid.");
                return null;
            }
        }
        catch (SSOException sSOException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSSOToken: Exception when getting SSOToken:", (Throwable)sSOException);
            return null;
        }
        return sSOToken;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        if (httpServletRequest == null || httpServletResponse == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        String string = httpServletRequest.getParameter("TARGET");
        if (string == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingTargetSite"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("missingTargetSite"));
            return;
        }
        String string2 = httpServletRequest.getParameter("SAMLResponse");
        if (string2 == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingSAMLResponse"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("missingSAMLResponse"));
            return;
        }
        byte[] byArray = null;
        try {
            byArray = Base64.decode((String)string2);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doPost: Exception when decoding SAMLResponse:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("errorDecodeResponse"));
            return;
        }
        Response response = this.verifySignatureAndGetResponse(byArray);
        if (response == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("errorObtainResponse"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("errorObtainResponse"));
            return;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: Received " + response.toString());
        }
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: requestUrl=" + stringBuffer);
        }
        if (!(bl = this.verifyResponse(response, stringBuffer.toString(), httpServletRequest))) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("invalidResponse"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("invalidResponse"));
            return;
        }
        Map map = this.verifyAssertionAndGetSSMap(response);
        if (map == null) {
            LogUtils.error(Level.INFO, SAMLUtils.bundle.getString("invalidAssertion"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("invalidAssertion"));
            return;
        }
        Subject subject = (Subject)map.get("subject");
        SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get("sourceSite");
        List list = (List)map.get("assertion");
        Map map2 = null;
        try {
            map2 = SAMLUtils.generateSSOToken(httpServletRequest, httpServletResponse, sOAPEntry, list, subject, string);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("generateToken: ", (Throwable)exception);
            LogUtils.error(Level.INFO, exception.getMessage());
            httpServletResponse.sendError(500, exception.getMessage());
            return;
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            LogUtils.access(Level.FINER, SAMLUtils.bundle.getString("accessGranted") + " " + SAMLUtils.bundle.getString("SAMLResponse") + new String(byArray, "UTF-8") + " " + SAMLUtils.bundle.getString("redirectTo") + string);
        } else {
            LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("accessGranted") + " " + SAMLUtils.bundle.getString("redirectTo") + string);
        }
        if (SAMLUtils.postYN(string)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("POST to target:" + string);
            }
            SAMLUtils.postToTarget(httpServletResponse, (List)map.get("assertion"), string, map2);
        } else {
            httpServletResponse.setHeader("Location", string);
            httpServletResponse.sendRedirect(string);
        }
    }

    private Response verifySignatureAndGetResponse(byte[] byArray) {
        Response response = null;
        if (byArray == null) {
            return null;
        }
        try {
            response = Response.parseXML(new ByteArrayInputStream(byArray));
        }
        catch (SAMLException sAMLException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifySignatureAndGetResponse:", (Throwable)sAMLException);
        }
        if (!(response == null || response.isSigned() && response.isSignatureValid())) {
            return null;
        }
        return response;
    }

    private boolean verifyResponse(Response response, String string, HttpServletRequest httpServletRequest) {
        String string2 = response.getRecipient();
        if (string2 == null || string2.length() == 0 || !string2.equals(string) && !string2.equals(this.getLBURL(string, httpServletRequest))) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyResponse: Incorrect Recipient.");
            return false;
        }
        if (!response.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyResponse: Incorrect StatusCode value.");
            return false;
        }
        return true;
    }

    private String getLBURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = httpServletRequest.getHeader("host");
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf("//");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string.substring(0, n + 2)).append(string2);
        String string3 = string.substring(n + 2, string.length());
        n = string3.indexOf("/");
        if (n != -1) {
            stringBuffer.append(string3.substring(n, string3.length()));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.getLBURL: LBURL=" + stringBuffer.toString());
        }
        return stringBuffer.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map verifyAssertionAndGetSSMap(Response response) {
        Object object;
        Subject subject = null;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        List list = response.getAssertion();
        Iterator iterator = list.iterator();
        Assertion assertion = null;
        String string = null;
        String string2 = null;
        Iterator iterator2 = null;
        Statement statement = null;
        int n = -1;
        Subject subject2 = null;
        SubjectConfirmation subjectConfirmation = null;
        Set set = null;
        String string3 = null;
        Date date = null;
        long l = System.currentTimeMillis() + 180000L;
        while (iterator.hasNext()) {
            assertion = (Assertion)iterator.next();
            string = assertion.getAssertionID();
            if (idTimeMap.containsKey(string)) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: Assertion: " + string + " is used.");
                return null;
            }
            string2 = assertion.getIssuer();
            sOAPEntry = SAMLUtils.getSourceSite(string2);
            if (sOAPEntry == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: issuer is not on the Partner list.");
                return null;
            }
            if (!assertion.isSignatureValid()) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: assertion's signature is not valid.");
                return null;
            }
            if (!assertion.isTimeValid()) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: assertion's time is not valid.");
                return null;
            }
            iterator2 = assertion.getStatement().iterator();
            while (iterator2.hasNext()) {
                statement = (Statement)iterator2.next();
                n = statement.getStatementType();
                if (n != 1 && n != 3 && n != 2) continue;
                subject2 = ((SubjectStatement)statement).getSubject();
                subjectConfirmation = subject2.getSubjectConfirmation();
                if (subjectConfirmation == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.size() != 1) {
                    SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: missing or extra ConfirmationMethod.");
                    return null;
                }
                string3 = (String)set.iterator().next();
                if (string3 == null || !string3.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) {
                    SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap:wrong ConfirmationMethod.");
                    return null;
                }
                if (n != 1 || subject != null) continue;
                subject = subject2;
            }
            object = assertion.getConditions();
            if (object != null && (date = ((Conditions)object).getNotOnorAfter()) != null) {
                l = date.getTime();
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: Adding " + string + " to idTimeMap.");
            }
            Map map = idTimeMap;
            synchronized (map) {
                idTimeMap.put(string, new Long(l));
            }
        }
        if (subject == null || sOAPEntry == null) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: couldn't find Subject.");
            return null;
        }
        object = new HashMap<String, Object>();
        object.put("subject", subject);
        object.put("sourceSite", sOAPEntry);
        object.put("assertion", list);
        return object;
    }

    static {
        cThread.start();
    }
}

