/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.assertion.Action;
import com.sun.identity.saml.assertion.Evidence;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.SubjectQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthorizationDecisionQuery
extends SubjectQuery {
    protected String resource = null;
    protected List actions = Collections.EMPTY_LIST;
    protected Evidence evidence = null;

    protected AuthorizationDecisionQuery() {
    }

    public AuthorizationDecisionQuery(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AuthorizationDecisionQuery: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkQuery(element, "AuthorizationDecisionQuery");
        if (!bl) {
            SAMLUtils.debug.message("AuthorizationDecisionQuery: wrong inout.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.resource = element.getAttribute("Resource");
        if (this.resource == null || this.resource.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: Missing attribute Resource.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getLocalName();
            if (string != null) {
                if (string.equals("Subject")) {
                    if (this.subject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionQuery: contained more than one <Subject>");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this.subject = new Subject((Element)node);
                } else if (string.equals("Action")) {
                    if (this.actions == Collections.EMPTY_LIST) {
                        this.actions = new ArrayList();
                    }
                    this.actions.add(new Action((Element)node));
                } else if (string.equals("Evidence")) {
                    if (this.evidence != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AuthorizationDecisionQuery: contained more than one <Evidence>");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this.evidence = new Evidence((Element)node);
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AuthorizationDecisionQuery: included wrong element:" + string);
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: missing <Subject>");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this.actions == Collections.EMPTY_LIST) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: missing <Action>");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    private void buildAuthZQuery(Subject subject, List list, Evidence evidence, String string) throws SAMLException {
        int n;
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: input <Subject> is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this.subject = subject;
        Object var6_5 = null;
        if (list != null && (n = list.size()) != 0) {
            int n2 = 0;
            while (n2 < n) {
                var6_5 = list.get(n2);
                if (!(var6_5 instanceof Action)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AuthorizationDecisionQuery: Wrong input for Action.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                ++n2;
            }
            this.actions = list;
        }
        if (this.actions == Collections.EMPTY_LIST) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: missing <Action> in input.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.evidence = evidence;
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthorizationDecisionQuery: Missing attribute Resource.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        this.resource = string;
    }

    public AuthorizationDecisionQuery(Subject subject, List list, Evidence evidence, String string) throws SAMLException {
        this.buildAuthZQuery(subject, list, evidence, string);
    }

    public AuthorizationDecisionQuery(Subject subject, List list, String string) throws SAMLException {
        this.buildAuthZQuery(subject, list, null, string);
    }

    public List getAction() {
        return this.actions;
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public String getResource() {
        return this.resource;
    }

    public int getQueryType() {
        return 1;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        stringBuffer.append("<").append(string).append("AuthorizationDecisionQuery").append(string2).append(" Resource=\"").append(this.resource).append("\">\n").append(this.subject.toString(true, true));
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Action)iterator.next()).toString(true, true));
        }
        if (this.evidence != null) {
            stringBuffer.append(this.evidence.toString(true, true));
        }
        stringBuffer.append("</").append(string).append("AuthorizationDecisionQuery>\n");
        return stringBuffer.toString();
    }
}

