/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.assertion.AttributeDesignator;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.SubjectQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeQuery
extends SubjectQuery {
    protected List attributeDesignators = Collections.EMPTY_LIST;
    protected String resource = null;

    protected AttributeQuery() {
    }

    public AttributeQuery(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeQuery(Element): null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkQuery(element, "AttributeQuery");
        if (!bl) {
            SAMLUtils.debug.message("AttributeQuery: wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (element.hasAttribute("Resource")) {
            this.resource = element.getAttribute("Resource");
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            String string = node.getLocalName();
            if (string != null) {
                if (string.equals("Subject")) {
                    if (this.subject != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AttributeQuery(Element): contained more than one Subject");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this.subject = new Subject((Element)node);
                } else if (string.equals("AttributeDesignator")) {
                    if (this.attributeDesignators == Collections.EMPTY_LIST) {
                        this.attributeDesignators = new ArrayList();
                    }
                    this.attributeDesignators.add(new AttributeDesignator((Element)node));
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AttributeQuery(Element): included wrong element:" + string);
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
            }
            ++n;
        }
        if (this.subject == null) {
            SAMLUtils.debug.message("AttributeQuery: missing Subject");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public AttributeQuery(Subject subject, List list, String string) throws SAMLException {
        this.buildAttributeQuery(subject, list, string);
    }

    public AttributeQuery(Subject subject, List list) throws SAMLException {
        this.buildAttributeQuery(subject, list, null);
    }

    public AttributeQuery(Subject subject) throws SAMLException {
        this.buildAttributeQuery(subject, null, null);
    }

    private void buildAttributeQuery(Subject subject, List list, String string) throws SAMLException {
        int n;
        if (subject == null) {
            SAMLUtils.debug.message("AttributeQuery: missing subject.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.subject = subject;
        Object var5_4 = null;
        if (list != null && (n = list.size()) != 0) {
            int n2 = 0;
            while (n2 < n) {
                var5_4 = list.get(n2);
                if (!(var5_4 instanceof AttributeDesignator)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AttributeQuery: Wrong input for AttributeDesignator.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                ++n2;
            }
            this.attributeDesignators = list;
        }
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    public List getAttributeDesignator() {
        return this.attributeDesignators;
    }

    public int getQueryType() {
        return 2;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(300);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        stringBuffer.append("<").append(string).append("AttributeQuery").append(string2);
        if (this.resource != null) {
            stringBuffer.append(" Resource=\"").append(this.resource).append("\"");
        }
        stringBuffer.append(">\n").append(this.subject.toString(true, true));
        Iterator iterator = this.attributeDesignators.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((AttributeDesignator)iterator.next()).toString(true, true));
        }
        stringBuffer.append("</").append(string).append("AttributeQuery>\n");
        return stringBuffer.toString();
    }
}

