/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.iplanet.services.util.Base64;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;

public class AssertionArtifact {
    protected String artifact;
    protected String assertionHandle = null;
    protected String sourceID = null;
    protected byte[] typeCode = null;
    static final int ARTIFACT_1_LENGTH = 42;
    static final byte ARTIFACT_1_TYPE_CODE_0 = 0;
    static final byte ARTIFACT_1_TYPE_CODE_1 = 1;
    static final byte[] ARTIFACT_1_TYPE_CODE = new byte[]{0, 1};

    protected AssertionArtifact() {
    }

    public AssertionArtifact(String string) throws SAMLException {
        if (string == null || string.equals("")) {
            SAMLUtils.debug.message("AssertionArtifact: empty input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        byte[] byArray = null;
        try {
            byArray = Base64.decode((String)string);
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact: exception decode input:", (Throwable)exception);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (byArray.length != 42) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact: the length is not 42:" + byArray.length);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (byArray[0] != 0 || byArray[1] != 1) {
            SAMLUtils.debug.message("AssertionArtifact: wrong typecode.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
        this.artifact = string;
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        System.arraycopy(byArray, 2, byArray2, 0, 20);
        System.arraycopy(byArray, 22, byArray3, 0, 20);
        try {
            this.sourceID = SAMLUtils.byteArrayToString(byArray2);
            this.assertionHandle = SAMLUtils.byteArrayToString(byArray3);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AssertionArtifact: encoding exception: ", (Throwable)exception);
            this.sourceID = new String(byArray2);
            this.assertionHandle = new String(byArray3);
        }
    }

    public AssertionArtifact(String string, String string2) throws SAMLException {
        if (string == null || string2 == null) {
            SAMLUtils.debug.message("AssertionArtifact: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byArray = SAMLUtils.stringToByteArray(string);
            byArray2 = SAMLUtils.stringToByteArray(string2);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AssertionArtifact: encoding exception: ", (Throwable)exception);
            byArray = string.getBytes();
            byArray2 = string2.getBytes();
        }
        if (byArray.length != 20 || byArray2.length != 20) {
            SAMLUtils.debug.message("AssertionArtifact: wrong input length.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.sourceID = string;
        this.assertionHandle = string2;
        byte[] byArray3 = new byte[42];
        byArray3[0] = 0;
        byArray3[1] = 1;
        int n = 0;
        while (n < 20) {
            byArray3[2 + n] = byArray[n];
            byArray3[22 + n] = byArray2[n];
            ++n;
        }
        try {
            this.artifact = Base64.encode((byte[])byArray3).trim();
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionArtifact: exception encode input:", (Throwable)exception);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        this.typeCode = ARTIFACT_1_TYPE_CODE;
    }

    public String getAssertionArtifact() {
        return this.artifact;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public String getAssertionHandle() {
        return this.assertionHandle;
    }

    public byte[] getTypeCode() {
        return this.typeCode;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string = "";
        if (bl) {
            string = "samlp:";
        }
        String string2 = "";
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        stringBuffer.append("<").append(string).append("AssertionArtifact").append(string2).append(">").append(this.artifact).append("</").append(string).append("AssertionArtifact>\n");
        return stringBuffer.toString();
    }
}

