/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import java.util.Date;
import org.w3c.dom.Element;

public abstract class AbstractResponse {
    protected String responseID = null;
    protected String inResponseTo = null;
    protected int majorVersion = 1;
    protected int minorVersion = SAMLConstants.PROTOCOL_MINOR_VERSION;
    protected Element signature = null;
    protected Date issueInstant = null;
    protected String recipient = null;
    protected boolean signed = false;
    protected boolean valid = true;

    protected AbstractResponse() {
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignatureValid() {
        return this.valid;
    }

    public abstract void signXML() throws SAMLException;

    public String getResponseID() {
        return this.responseID;
    }

    public boolean setResponseID(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        this.responseID = string;
        return true;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public boolean setInResponseTo(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        this.inResponseTo = string;
        return true;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMajorVersion(int n) {
        this.majorVersion = n;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public Element getSignature() {
        return this.signature;
    }

    public boolean setSignature(Element element) {
        if (this.signed) {
            return false;
        }
        if (element == null) {
            return false;
        }
        this.signature = element;
        this.signed = true;
        return true;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public boolean setIssueInstant(Date date) {
        if (this.signed) {
            return false;
        }
        if (date == null) {
            return false;
        }
        this.issueInstant = date;
        return true;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public boolean setRecipient(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        this.recipient = string;
        return true;
    }
}

