/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.util.DN;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SAMLUtils {
    public static final String HTTP_MAX_CONTENT_LENGTH = "com.sun.identity.saml.request.maxContentLength";
    public static final int defaultMaxLength = 16384;
    public static final String DEFAULT_CONTENT_LENGTH = String.valueOf(16384);
    public static SAMLConstants sc;
    public static ResourceBundle bundle;
    public static Debug debug;
    private static final String UTC_DATEFORMAT_STR = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String UTC_DATEFORMAT_WITH_MS_STR = "yyyy-MM-dd'T'HH:mm:ss.S'Z'";
    private static final String PST_DATEFORMAT_STR = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final String PST_DATEFORMAT_WITH_MS_STR = "yyyy-MM-dd'T'HH:mm:ss.sz";
    public static SecureRandom random;
    public static final String SAMLID_PREFIX = "s";
    private static TimeZone UTC_TIME_ZONE;
    private static int maxContentLength;

    private SAMLUtils() {
    }

    public static String makeStartElementTagXML(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string2 = "";
        String string3 = "";
        if (bl) {
            string2 = "saml:";
        }
        if (bl2) {
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string2).append(string).append(string3).append(">");
        return stringBuffer.toString();
    }

    public static String makeEndElementTagXML(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string2 = "";
        if (bl) {
            string2 = "saml:";
        }
        stringBuffer.append("</").append(string2).append(string).append(">").append("\n");
        return stringBuffer.toString();
    }

    public static Date stringToDate(String string) throws ParseException {
        Date date = null;
        Object var2_2 = null;
        SimpleDateFormat simpleDateFormat = null;
        if (string.indexOf(90) == -1) {
            simpleDateFormat = new SimpleDateFormat(PST_DATEFORMAT_STR);
            if (string.indexOf(".") == -1) {
                date = simpleDateFormat.parse(string);
            } else {
                int n = string.indexOf(".");
                int n2 = -1;
                n2 = string.lastIndexOf(43);
                if (n2 == -1) {
                    n2 = string.lastIndexOf(45);
                }
                if (n2 == -1) {
                    throw new ParseException("Date not in proper +/- hh:mm format", n2);
                }
                String string2 = string.substring(0, n) + string.substring(n2);
                if (debug.messageEnabled()) {
                    debug.message("parsing date:" + string2);
                }
                date = simpleDateFormat.parse(string2);
                if (debug.messageEnabled()) {
                    debug.message("+/- parsed date is:" + date);
                }
            }
        } else {
            if (string.indexOf(".") == -1) {
                simpleDateFormat = new SimpleDateFormat(UTC_DATEFORMAT_STR);
                simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
                date = simpleDateFormat.parse(string);
            } else {
                simpleDateFormat = new SimpleDateFormat(UTC_DATEFORMAT_WITH_MS_STR);
                simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
                date = simpleDateFormat.parse(string);
            }
            if (debug.messageEnabled()) {
                debug.message("after reading from vendor Z parsedDate is:" + date);
            }
        }
        return date;
    }

    public static String dateToString(Date date) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(100);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UTC_DATEFORMAT_STR);
        simpleDateFormat.setTimeZone(UTC_TIME_ZONE);
        String string = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0)).toString();
        if (debug.messageEnabled()) {
            debug.message("dateToString of vendor " + date + " is:" + string);
        }
        return string;
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        String string = SAMLID_PREFIX + SAMLUtils.byteArrayToHexString(byArray);
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.generated ID is: " + string);
        }
        return string;
    }

    public static String generateAssertionID() {
        String string;
        String string2;
        block4: {
            string2 = SAMLUtils.generateID();
            if (string2 == null) {
                return null;
            }
            string = null;
            try {
                string = WebtopNaming.getServerID((String)SAMLServiceManager.getServerProtocol(), (String)SAMLServiceManager.getServerHost(), (String)SAMLServiceManager.getServerPort());
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block4;
                debug.message("SAMLUtil:generateAssertionID: exception obtain serverID:", (Throwable)exception);
            }
        }
        if (string == null) {
            return string2;
        }
        return string2 + string;
    }

    public static boolean checkQuery(Element element, String string) {
        String string2 = element.getLocalName();
        if (string2 == null) {
            return false;
        }
        if (string2.equals("Query") || string2.equals("SubjectQuery")) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string3 = attr.getLocalName();
                if (string3 != null && string3.equals("type") && attr.getNodeValue().equals(string + "Type")) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
        } else if (!string2.equals(string)) {
            return false;
        }
        return true;
    }

    public static String getDecodedSourceIDString(String string) {
        String string2 = null;
        if (string == null) {
            debug.error("SAMLUtils.getDecodedSourceIDString: null input.");
            return null;
        }
        try {
            string2 = SAMLUtils.byteArrayToString(Base64.decode((String)string));
        }
        catch (Exception exception) {
            debug.error("SAMLUtils.getDecodedSourceIDString: ", (Throwable)exception);
            return null;
        }
        return string2;
    }

    public static String generateSourceID(String string) {
        if (string == null || string.length() == 0) {
            debug.error("SAMLUtils.genrateSourceID: empty siteURL.");
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            debug.error("SAMLUtils.generateSourceID: Exception when generating digest:", (Throwable)exception);
            return null;
        }
        messageDigest.update(SAMLUtils.stringToByteArray(string));
        byte[] byArray = messageDigest.digest();
        String string2 = null;
        try {
            string2 = Base64.encode((byte[])byArray).trim();
        }
        catch (Exception exception) {
            debug.error("SAMLUtils.generateSourceID: Exception:", (Throwable)exception);
        }
        return string2;
    }

    public static String generateAssertionHandle() {
        byte[] byArray;
        String string;
        byte[] byArray2;
        block5: {
            if (random == null) {
                return null;
            }
            byArray2 = new byte[20];
            random.nextBytes(byArray2);
            string = null;
            try {
                string = WebtopNaming.getServerID((String)SAMLServiceManager.getServerProtocol(), (String)SAMLServiceManager.getServerHost(), (String)SAMLServiceManager.getServerPort());
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block5;
                debug.message("SAMLUtil:generateAssertionHandle: exception obtain serverID:", (Throwable)exception);
            }
        }
        if (string != null && (byArray = SAMLUtils.stringToByteArray(string)).length < byArray2.length) {
            int n = 1;
            while (n <= byArray.length) {
                byArray2[byArray2.length - n] = byArray[byArray.length - n];
                ++n;
            }
        }
        return SAMLUtils.byteArrayToString(byArray2);
    }

    public static boolean checkStatement(Element element, String string) {
        String string2 = element.getLocalName();
        if (string2 == null) {
            return false;
        }
        if (string2.equals("Statement") || string2.equals("SubjectStatement")) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength();
            String string3 = null;
            Attr attr = null;
            int n2 = 0;
            while (n2 < n) {
                attr = (Attr)namedNodeMap.item(n2);
                string3 = attr.getLocalName();
                if (string3 != null && string3.equals("type") && attr.getNodeValue().equals(string + "Type")) {
                    return true;
                }
                ++n2;
            }
        } else if (string2.equals(string)) {
            return true;
        }
        return false;
    }

    public static String displayXML(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '\n') {
                stringBuffer.append("<BR>\n");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0xFF & byArray[n2] | 0xFFFFFF00;
            stringBuffer.append(Integer.toHexString(n3).substring(6));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            String string2 = string.substring(n2, n2 + 2);
            byArray[n3] = new Short(Integer.toString(Integer.parseInt(string2, 16))).byteValue();
            ++n2;
            ++n2;
            ++n3;
        }
        return byArray;
    }

    public static String hexStringToBase64(String string) {
        String string2;
        block4: {
            int n = string.length();
            byte[] byArray = new byte[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                string2 = string.substring(n2, n2 + 2);
                byArray[n3] = new Short(Integer.toString(Integer.parseInt(string2, 16))).byteValue();
                ++n2;
                ++n2;
                ++n3;
            }
            string2 = null;
            try {
                string2 = Base64.encode((byte[])byArray).trim();
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block4;
                debug.message("SAMLUtil:hexStringToBase64: exception encode input:", (Throwable)exception);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("base 64 source id is :" + string2);
        }
        return string2;
    }

    public static SAMLServiceManager.SOAPEntry getSourceSite(String string) {
        if (string == null) {
            return null;
        }
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map == null) {
            debug.error("SAMLUtils.isOnPartnerURLList: PartnerURL list is null.");
            return null;
        }
        Iterator iterator = map.values().iterator();
        boolean bl = false;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        String string2 = null;
        while (iterator.hasNext()) {
            sOAPEntry = (SAMLServiceManager.SOAPEntry)iterator.next();
            if (sOAPEntry == null || (string2 = sOAPEntry.getIssuer()) == null || !string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return sOAPEntry;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("usage : java SAMLUtils <host_name>");
            return;
        }
        System.out.println(SAMLUtils.generateSourceID(stringArray[0]));
    }

    private static TimeZone getTimeZone(String string) throws ParseException {
        TimeZone timeZone = null;
        int n = -1;
        if (string.indexOf(90) != -1) {
            timeZone = UTC_TIME_ZONE;
        } else {
            int n2;
            n = string.indexOf(43);
            if (n != -1) {
                Date date = new SimpleDateFormat("HH:mm").parse(string.substring(n + 1));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                int n3 = gregorianCalendar.get(11) * 60 * 60 * 1000 + gregorianCalendar.get(12) * 60 * 1000;
                return new SimpleTimeZone(n3, "UTC");
            }
            n = string.lastIndexOf(45);
            if (n != -1 && n > (n2 = string.indexOf(84))) {
                Date date = new SimpleDateFormat("HH:mm").parse(string.substring(n + 1));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                int n4 = -1 * (gregorianCalendar.get(11) * 60 * 1000 + gregorianCalendar.get(12) * 60 * 1000);
                return new SimpleTimeZone(n4, "UTC");
            }
        }
        return timeZone;
    }

    public static void postToTarget(HttpServletResponse httpServletResponse, List list, String string, Map map) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>\n");
        printWriter.println("<TITLE>Access rights validated</TITLE>\n");
        printWriter.println("</HEAD>\n");
        printWriter.println("<BODY Onload=\"document.forms[0].submit()\">");
        Iterator iterator = null;
        if (debug.messageEnabled()) {
            printWriter.println("<H1>Access rights validated</H1>\n");
            printWriter.println("<meta http-equiv=\"refresh\" content=\"20\">\n");
            printWriter.println("<P>We have verified your access rights <STRONG></STRONG> according to the assertion shown below. \n");
            printWriter.println("You are being redirected to the resource.\n");
            printWriter.println("Please wait ......\n");
            printWriter.println("</P>\n");
            printWriter.println("<HR><P>\n");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                printWriter.println(SAMLUtils.displayXML(iterator.next().toString()));
            }
            printWriter.println("</P>\n");
        }
        printWriter.println("<FORM METHOD=\"POST\" ACTION=\"" + string + "\">");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ASSERTION\"");
            printWriter.println("VALUE=\"" + URLEncoder.encode(((Assertion)iterator.next()).toString(true, true)) + "\">");
        }
        if (map != null && !map.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            Set set = map.entrySet();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string2 = SAMLUtils.HTMLEncode((String)entry.getKey(), '\"');
                String string3 = SAMLUtils.HTMLEncode((String)entry.getValue(), '\"');
                printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"" + string2 + "\" VALUE=\"" + string3 + "\">");
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(string2);
            }
            printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ATTRIBUTENAMES\" VALUE=\"" + stringBuffer + "\">");
        }
        printWriter.println("</FORM>");
        printWriter.println("</BODY></HTML>");
        printWriter.close();
    }

    public static boolean postYN(String string) {
        debug.message("Inside postYN()");
        if (string == null || string.equals("")) {
            return false;
        }
        Set set = (Set)SAMLServiceManager.getAttribute("iplanet-am-saml-post-to-target-urls");
        if (set == null || set.size() == 0) {
            return false;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            debug.error("SAMLUtils:postYN(): Malformed URL passed");
            return false;
        }
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = uRL.getPath();
        String string4 = string2.toLowerCase() + ":" + String.valueOf(n) + "/" + string3;
        return set.contains(string4);
    }

    public static boolean isCorrectConfirmationMethod(SubjectConfirmation subjectConfirmation) {
        if (subjectConfirmation == null) {
            return false;
        }
        Set set = subjectConfirmation.getConfirmationMethod();
        if (set == null || set.size() != 1) {
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.isCorrectConfirmationMethod: missing ConfirmationMethod in the Subject.");
            }
            return false;
        }
        String string = (String)set.iterator().next();
        if (string == null || !string.equals("urn:com:sun:identity")) {
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.isCorrectConfirmationMethod: wrong ConfirmationMethod value.");
            }
            return false;
        }
        return true;
    }

    public static boolean isAuthNAssertion(Assertion assertion) {
        if (assertion == null) {
            return false;
        }
        if (!assertion.isTimeValid() || !assertion.isSignatureValid()) {
            return false;
        }
        Set set = assertion.getStatement();
        Statement statement = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            statement = (Statement)iterator.next();
            if (statement.getStatementType() != 1) continue;
            return true;
        }
        return false;
    }

    public static byte[] stringToByteArray(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public static String byteArrayToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)byArray[n];
            ++n;
        }
        return new String(cArray);
    }

    public static String getServerID(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        String string2 = null;
        if (n >= 2) {
            string2 = string.substring(n - 2, n);
            return string2;
        }
        return null;
    }

    public static String getServerURL(String string) {
        String string2 = SAMLUtils.getServerID(string);
        if (string2 == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.getServerURL: id=" + string2);
        }
        String string3 = null;
        try {
            string3 = WebtopNaming.getServerFromID((String)string2);
        }
        catch (ServerEntryNotFoundException serverEntryNotFoundException) {
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.getServerURL: ServerEntryNotFoundException for " + string2);
            }
            return null;
        }
        String string4 = SAMLServiceManager.getServerURL();
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.getServerURL: remoteUrl=" + string3 + ", thisUrl=" + string4);
        }
        if (string3 == null || string4 == null || string3.equals(string4)) {
            return null;
        }
        return string3;
    }

    public static String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)"samlassertionmanager", (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (debug.messageEnabled()) {
                    debug.message("SAMLUtils.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("SAMLUtils.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }

    public static int getMaxContentLength() {
        return maxContentLength;
    }

    public static void checkHTTPContentLength(HttpServletRequest httpServletRequest) throws ServletException {
        if (maxContentLength != 0) {
            int n = httpServletRequest.getContentLength();
            if (debug.messageEnabled()) {
                debug.message("HttpRequest content length= " + n);
            }
            if (n > maxContentLength) {
                if (debug.messageEnabled()) {
                    debug.message("content length too large" + n);
                }
                throw new ServletException(bundle.getString("largeContentLength"));
            }
        }
    }

    public static Map generateSSOToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SAMLServiceManager.SOAPEntry sOAPEntry, List list, Subject subject, String string) throws Exception {
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Map map;
        Map map2;
        String string3;
        String string4;
        block20: {
            String string5 = sOAPEntry.getSourceID();
            string4 = null;
            string3 = null;
            map2 = null;
            PartnerAccountMapper partnerAccountMapper = sOAPEntry.getPartnerAccountMapper();
            if (partnerAccountMapper != null) {
                map = partnerAccountMapper.getUser(list, string5, string);
                string4 = (String)map.get("name");
                string3 = (String)map.get("org");
                map2 = (Map)map.get("attribute");
            } else {
                map = sOAPEntry.getAccountMapper().getUser(subject, string5);
                string4 = (String)map.get("name");
                string3 = (String)map.get("org");
            }
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.generateToken: name = " + string4 + ", org = " + string3 + ", attrMap = " + map2);
            }
            map = null;
            try {
                object4 = SSOTokenManager.getInstance();
                map = object4.createSSOToken(httpServletRequest);
                if (map != null && !object4.isValidToken((SSOToken)map)) {
                    map = null;
                }
            }
            catch (SSOException sSOException) {
                if (!debug.messageEnabled()) break block20;
                debug.message("SAMLUtils.generateSSOToken: There is no SSOToken in the cookie. Generating one.", (Throwable)sSOException);
            }
        }
        if (map != null) {
            try {
                object4 = map.getPrincipal().getName();
                object3 = map.getProperty("Organization");
                if (debug.messageEnabled()) {
                    debug.message("SAMLUtils.generateToken: oldName = " + (String)object4 + ", oldOrg = " + (String)object3);
                }
                object2 = new DN((String)object4);
                object = new DN((String)object3);
                if (!((DN)object2).equals(new DN(string4)) || !((DN)object).equals(new DN(string3))) {
                    map = null;
                }
            }
            catch (SSOException sSOException) {
                if (debug.messageEnabled()) {
                    debug.message("SAMLUtils.generateToken: Unable to get name or org from SSOToken.");
                }
                map = null;
            }
        }
        if (map == null) {
            Cookie cookie;
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.generateToken: constructing new token");
            }
            object4 = AuthUtils.getAuthContext(string3);
            AuthUtils.getLoginState((AuthContextLocal)object4).setHttpServletRequest(httpServletRequest);
            ((AuthContextLocal)object4).login(AuthContext.IndexType.USER, string4, true);
            map = ((AuthContextLocal)object4).getSSOToken();
            object3 = new ServiceSchemaManager("iPlanetAMPlatformService", (SSOToken)map);
            object2 = ((ServiceSchemaManager)object3).getGlobalSchema();
            object = (Set)((ServiceSchema)object2).getAttributeDefaults().get("iplanet-am-platform-cookie-domains");
            string2 = map.getTokenID().toString();
            String string6 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            if (object.size() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("SAMLUtils.generateSSOToken: cookie domain is null");
                }
                cookie = CookieUtils.newCookie((String)string6, (String)string2, (String)"/");
                httpServletResponse.addCookie(cookie);
            } else {
                cookie = object.iterator();
                Cookie cookie2 = null;
                while (cookie.hasNext()) {
                    cookie2 = CookieUtils.newCookie((String)string6, (String)string2, (String)"/", (String)((String)cookie.next()));
                    httpServletResponse.addCookie(cookie2);
                }
            }
        }
        if (map2 != null && !map2.isEmpty()) {
            object4 = map2.entrySet();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (String)object2.getKey();
                string2 = (String)object2.getValue();
                map.setProperty((String)object, string2);
                if (!debug.messageEnabled()) continue;
                debug.message("SAMLUtils.generateSSOToken: token.setProperty(" + (String)object + ", " + string2 + ")");
            }
        }
        return map2;
    }

    public static void addEnvParamsFromAssertion(Map map, Assertion assertion, Subject subject) {
        Set set = assertion.getStatement();
        Statement statement = null;
        Iterator iterator = null;
        List list = null;
        Iterator iterator2 = null;
        Attribute attribute = null;
        Element element = null;
        List list2 = null;
        String string = null;
        String string2 = null;
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                statement = (Statement)iterator.next();
                if (statement.getStatementType() != 3 || !subject.equals(((AttributeStatement)statement).getSubject())) continue;
                list = ((AttributeStatement)statement).getAttribute();
                iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    attribute = (Attribute)iterator2.next();
                    try {
                        list2 = attribute.getAttributeValue();
                    }
                    catch (Exception exception) {
                        debug.error("SAMLUtils.addEnvParamsFromAssertion: cannot obtain attribute value:", (Throwable)exception);
                        continue;
                    }
                    string = attribute.getAttributeName();
                    element = (Element)list2.get(0);
                    if (list2.size() == 1 && !XMLUtils.hasElementChild((Node)element)) {
                        string2 = XMLUtils.getElementValue((Element)element);
                        try {
                            if (debug.messageEnabled()) {
                                debug.message("SAMLUtils.addEnvParamsFromAssertion: attrName = " + string + " attrValue = " + string2);
                            }
                            map.put(string, string2);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        map.put(string, list2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static String HTMLEncode(String string, char c) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(c, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n)).append("&#" + c + ";");
            n2 = n + 1;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"amSAML");
        debug = Debug.getInstance((String)"amSAML");
        random = new SecureRandom();
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        maxContentLength = 0;
        try {
            maxContentLength = Integer.parseInt(SystemProperties.get((String)HTTP_MAX_CONTENT_LENGTH, (String)DEFAULT_CONTENT_LENGTH));
        }
        catch (NumberFormatException numberFormatException) {
            debug.error("Wrong format of SAML request max content length. Take default value.");
            maxContentLength = 16384;
        }
    }
}

