/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.AMPasswordUtil;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLSiteID;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.AccountMapper;
import com.sun.identity.saml.plugins.ActionMapper;
import com.sun.identity.saml.plugins.AttributeMapper;
import com.sun.identity.saml.plugins.DefaultAccountMapper;
import com.sun.identity.saml.plugins.DefaultActionMapper;
import com.sun.identity.saml.plugins.DefaultAttributeMapper;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.plugins.PartnerSiteAttributeMapper;
import com.sun.identity.saml.plugins.SiteAttributeMapper;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.X509Certificate;

public class SAMLServiceManager
implements ServiceListener {
    private static ServiceSchema serviceSchema = null;
    private static Map map = null;
    private static SAMLServiceManager instance = null;
    private static AMStoreConnection amConn = null;
    private static SSOToken ssoAuthSession = null;
    private static Map certdbCerts = null;
    public static boolean localFlag = false;
    private static String serverProtocol = null;
    private static String serverHost = null;
    private static String serverPort = null;
    private static String serverURL = null;
    private static boolean removeAssertion = false;

    private SAMLServiceManager() {
    }

    private static void init() {
        SAMLUtils.debug.message("SAMLServiceManager.init: Constructing a new instance of SAMLServiceManager");
        instance = new SAMLServiceManager();
        try {
            SSOToken sSOToken = SAMLServiceManager.getSSOToken();
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(sSOToken, "iPlanetAMSAMLService", "1.0");
            serviceSchema = serviceSchemaManager.getGlobalSchema();
            SAMLServiceManager.setValues();
            serviceSchemaManager.addListener(instance);
            amConn = new AMStoreConnection(sSOToken);
            serverProtocol = SystemProperties.get((String)"com.iplanet.am.localserver.protocol");
            serverHost = SystemProperties.get((String)"com.iplanet.am.localserver.host");
            serverPort = SystemProperties.get((String)"com.iplanet.am.localserver.port");
            serverURL = serverProtocol + "://" + serverHost + ":" + serverPort;
            String string = SystemProperties.get((String)"com.sun.identity.saml.removeassertion");
            if (string != null && !string.equals("")) {
                removeAssertion = Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLServiceListener.init: Exception:", (Throwable)exception);
        }
    }

    public static boolean getRemoveAssertion() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return removeAssertion;
    }

    public static String getServerProtocol() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverProtocol;
    }

    public static String getServerHost() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverHost;
    }

    public static String getServerPort() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverPort;
    }

    public static String getServerURL() {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return serverURL;
    }

    protected static synchronized SSOToken getSSOToken() throws SSOException, SessionException {
        if (ssoAuthSession == null) {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            try {
                ssoAuthSession = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            }
            catch (SSOException sSOException) {
                SAMLUtils.debug.error("SAMLServiceManager:getSSOToken(): SSOException : ", (Throwable)sSOException);
                throw new SessionException(sSOException.getMessage());
            }
        }
        return ssoAuthSession;
    }

    private static synchronized void setValues() {
        if (serviceSchema == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("iplanet-am-saml-artifact-timeout", new Integer(120));
            hashMap.put("iplanet-am-saml-assertion-timeout", new Integer(60));
            hashMap.put("iplanet-am-saml-artifact-name", "SAMLart");
            hashMap.put("iplanet-am-saml-target-specifier", "TARGET");
            hashMap.put("iplanet-am-saml-assertion-max-number", new Integer(0));
            hashMap.put("iplanet-am-saml-cleanup-interval", new Integer(180));
            hashMap.put("iplanet-am-saml-signrequest", Boolean.valueOf("false"));
            hashMap.put("iplanet-am-saml-signresponse", Boolean.valueOf("false"));
            hashMap.put("iplanet-am-saml-signassertion", Boolean.valueOf("false"));
            map = hashMap;
        } else {
            try {
                int n;
                Object[] objectArray;
                Object object;
                Object object2;
                Object object3;
                String string;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Serializable serializable;
                Object object8;
                Object object9;
                Object object10;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Map map = serviceSchema.getAttributeDefaults();
                Set set = (Set)map.get("iplanet-am-saml-notbefore-timeskew");
                int n2 = 300;
                if (set.size() == 1 && (n2 = Integer.parseInt((String)set.iterator().next())) <= 0) {
                    SAMLUtils.debug.error("SAMLServiceManager: invalid not before time skew period value=" + n2 + ", using default.");
                }
                Integer n3 = new Integer(n2);
                hashMap.put("iplanet-am-saml-notbefore-timeskew", n3);
                set = (Set)map.get("iplanet-am-saml-artifact-timeout");
                n2 = 120;
                if (set.size() == 1 && (n2 = Integer.parseInt((String)set.iterator().next())) <= 0) {
                    SAMLUtils.debug.error("SAMLServiceManager: invalid artifact timeout value=" + n2 + ", using default.");
                    n2 = 120;
                }
                n3 = new Integer(n2);
                hashMap.put("iplanet-am-saml-artifact-timeout", n3);
                set = (Set)map.get("iplanet-am-saml-assertion-timeout");
                n2 = 60;
                if (set.size() == 1 && (n2 = Integer.parseInt((String)set.iterator().next())) <= 0) {
                    SAMLUtils.debug.error("SAMLServiceManager: invalid assertion timeout value=" + n2 + ", using default.");
                    n2 = 60;
                }
                n3 = new Integer(n2);
                hashMap.put("iplanet-am-saml-assertion-timeout", n3);
                set = (Set)map.get("iplanet-am-saml-assertion-max-number");
                n2 = 0;
                if (set.size() == 1 && (n2 = Integer.parseInt((String)set.iterator().next())) < 0) {
                    SAMLUtils.debug.error("SAMLServiceManager: invalid assertion max number value=" + n2 + ", using default.");
                    n2 = 0;
                }
                n3 = new Integer(n2);
                hashMap.put("iplanet-am-saml-assertion-max-number", n3);
                set = (Set)map.get("iplanet-am-saml-cleanup-interval");
                n2 = 180;
                if (set.size() == 1 && (n2 = Integer.parseInt((String)set.iterator().next())) <= 0) {
                    SAMLUtils.debug.error("SAMLServiceManager: invalid cleanup interval value=" + n2 + ", using default.");
                    n2 = 180;
                }
                n3 = new Integer(n2);
                hashMap.put("iplanet-am-saml-cleanup-interval", n3);
                String string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-artifact-name", (String)"SAMLart");
                hashMap.put("iplanet-am-saml-artifact-name", string2);
                Set set2 = (Set)map.get("iplanet-am-saml-post-to-target-urls");
                if (set2 == null || set2.size() == 0) {
                    SAMLUtils.debug.message("SAMLServiceManager: No POST to targets found");
                } else {
                    object10 = Collections.synchronizedSet(new HashSet());
                    object9 = set2.iterator();
                    object8 = null;
                    while (object9.hasNext()) {
                        try {
                            object8 = (String)object9.next();
                            serializable = new URL((String)object8);
                            object7 = ((URL)serializable).getHost().toLowerCase() + ":" + String.valueOf(((URL)serializable).getPort()) + "/" + ((URL)serializable).getPath();
                            object10.add(object7);
                        }
                        catch (MalformedURLException malformedURLException) {
                            SAMLUtils.debug.error("SAMLServiceManager: Malformed Url in the POST to target list, skipping entry:" + (String)object8);
                        }
                    }
                    if (object10.size() > 0) {
                        hashMap.put("iplanet-am-saml-post-to-target-urls", object10);
                    } else {
                        SAMLUtils.debug.error("SAMLServiceManager: All POST to target URLs malformed");
                    }
                }
                object10 = SystemProperties.get((String)"com.iplanet.am.localserver.protocol") + "://" + SystemProperties.get((String)"com.iplanet.am.localserver.host") + ":" + SystemProperties.get((String)"com.iplanet.am.localserver.port");
                object9 = new HashMap();
                object8 = new HashMap();
                serializable = new HashMap();
                object7 = (Set)map.get("iplanet-am-saml-siteid-issuername-list");
                if (object7.size() == 0) {
                    SAMLUtils.debug.error("SAMLServiceManager: No Site ID or Issuer Name in the SAML service config.");
                } else {
                    object6 = null;
                    object5 = null;
                    object4 = null;
                    string = null;
                    object3 = null;
                    object2 = null;
                    object = null;
                    objectArray = object7.iterator();
                    while (objectArray.hasNext()) {
                        object6 = (String)objectArray.next();
                        object4 = null;
                        string = null;
                        object3 = null;
                        object5 = new StringTokenizer((String)object6, "|");
                        while (((StringTokenizer)object5).hasMoreElements()) {
                            object2 = ((StringTokenizer)object5).nextToken();
                            n = -1;
                            n = ((String)object2).indexOf("=");
                            if (n == -1) {
                                SAMLUtils.debug.error("SAMLServiceManager: wrong format: " + (String)object2);
                                break;
                            }
                            int n4 = n + 1;
                            if (n4 >= ((String)object2).length()) {
                                SAMLUtils.debug.error("SAMLServiceManager: wrong format: " + (String)object2);
                                break;
                            }
                            object = ((String)object2).substring(0, n);
                            if (((String)object).equalsIgnoreCase("INSTANCEID")) {
                                object4 = ((String)object2).substring(n4);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("SITEID")) {
                                string = ((String)object2).substring(n4);
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("ISSUERNAME")) {
                                object3 = ((String)object2).substring(n4);
                                continue;
                            }
                            SAMLUtils.debug.error("SAMLServiceManager: wrong format: " + (String)object2);
                        }
                        if (object4 == null) {
                            SAMLUtils.debug.error("SAMLServiceManager: missing instanceID:" + (String)object6);
                            break;
                        }
                        n = ((String)object4).equalsIgnoreCase((String)object10) ? 1 : 0;
                        if (string != null && (string = SAMLUtils.getDecodedSourceIDString(string)) != null) {
                            object9.put(object4, string);
                            serializable.put(string, object4);
                            if (n != 0) {
                                hashMap.put("mysiteid", string);
                            }
                        }
                        if (object3 == null) continue;
                        object8.put(object4, object3);
                        if (n == 0) continue;
                        hashMap.put("mysitename", object3);
                    }
                }
                if (!object9.containsKey(object10) && (object6 = SAMLSiteID.generateSourceID((String)object10)) != null) {
                    if ((object6 = SAMLUtils.getDecodedSourceIDString((String)object6)) != null) {
                        object9.put(object10, object6);
                        serializable.put(object6, object10);
                        hashMap.put("mysiteid", object6);
                    } else {
                        SAMLUtils.debug.error("Missing Site ID.");
                    }
                }
                if (!object8.containsKey(object10)) {
                    object8.put(object10, object10);
                    hashMap.put("mysitename", object10);
                }
                hashMap.put("iplanet-am-saml-siteid-list", object9);
                hashMap.put("iplanet-am-saml-instance-list", serializable);
                hashMap.put("iplanet-am-saml-issuername-list", object8);
                object6 = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-signrequest", (String)"false"));
                hashMap.put("iplanet-am-saml-signrequest", object6);
                object5 = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-signresponse", (String)"false"));
                hashMap.put("iplanet-am-saml-signresponse", object5);
                object4 = Boolean.valueOf(Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-signassertion", (String)"false"));
                hashMap.put("iplanet-am-saml-signassertion", object4);
                string = Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-target-specifier", (String)"TARGET");
                hashMap.put("iplanet-am-saml-target-specifier", string);
                object3 = Collections.synchronizedSet(new HashSet());
                object3 = (Set)map.get("iplanet-am-saml-partner-urls");
                if (object3.size() == 0) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("SAMLServiceManager: No entryin partner url config!");
                    }
                } else {
                    object2 = Collections.synchronizedSet(new HashSet());
                    object = Collections.synchronizedMap(new HashMap());
                    objectArray = object3.toArray();
                    n = objectArray.length;
                    String string3 = null;
                    String string4 = null;
                    int n5 = 0;
                    while (n5 < n) {
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        String string8 = null;
                        int n6 = -1;
                        String string9 = null;
                        String string10 = null;
                        String string11 = null;
                        String string12 = null;
                        String string13 = null;
                        String string14 = null;
                        AccountMapper accountMapper = null;
                        PartnerAccountMapper partnerAccountMapper = null;
                        SiteAttributeMapper siteAttributeMapper = null;
                        PartnerSiteAttributeMapper partnerSiteAttributeMapper = null;
                        AttributeMapper attributeMapper = null;
                        ActionMapper actionMapper = null;
                        String string15 = null;
                        HashSet<String> hashSet = null;
                        HashSet<String> hashSet2 = null;
                        string3 = (String)objectArray[n5];
                        if (string3.toUpperCase().indexOf("SOURCEID") == -1) {
                            SAMLUtils.debug.error("Ignore this trusted site since SourceID is absent:" + string3);
                        } else {
                            Object object11;
                            StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
                            while (stringTokenizer.hasMoreElements()) {
                                string4 = stringTokenizer.nextToken();
                                if (SAMLUtils.debug.messageEnabled()) {
                                    SAMLUtils.debug.message("SAML Service Manager: PartnerUrl List:" + string4);
                                }
                                int n7 = -1;
                                n7 = string4.indexOf("=");
                                if (n7 == -1) {
                                    SAMLUtils.debug.error("SAML Service Manager: illegal format of PartnerUrl:" + string4);
                                    break;
                                }
                                int n8 = n7 + 1;
                                if (n8 >= string4.length()) break;
                                object11 = string4.substring(0, n7);
                                if (((String)object11).equalsIgnoreCase("SOURCEID")) {
                                    string9 = SAMLUtils.getDecodedSourceIDString(string4.substring(n8));
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("TARGET")) {
                                    string5 = string4.substring(n8);
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("SAMLURL")) {
                                    string6 = string4.substring(n8).trim();
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("POSTURL")) {
                                    string7 = string4.substring(n8).trim();
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("SOAPURL")) {
                                    string10 = string4.substring(n8).trim();
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("AUTHTYPE")) {
                                    string11 = string4.substring(n8);
                                    if (!SAMLUtils.debug.messageEnabled()) continue;
                                    SAMLUtils.debug.message("authtype =" + string11);
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("USER")) {
                                    string12 = string4.substring(n8);
                                    if (!SAMLUtils.debug.messageEnabled()) continue;
                                    SAMLUtils.debug.message("user = " + string12);
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("ACCOUNTMAPPER")) {
                                    try {
                                        accountMapper = (AccountMapper)Class.forName(string4.substring(n8)).newInstance();
                                    }
                                    catch (InstantiationException instantiationException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + instantiationException);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + illegalAccessException);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + classNotFoundException);
                                    }
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("PARTNERACCOUNTMAPPER")) {
                                    try {
                                        partnerAccountMapper = (PartnerAccountMapper)Class.forName(string4.substring(n8)).newInstance();
                                    }
                                    catch (InstantiationException instantiationException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:", (Throwable)instantiationException);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:", (Throwable)illegalAccessException);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:", (Throwable)classNotFoundException);
                                    }
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("CERTALIAS")) {
                                    string13 = string4.substring(n8);
                                    if (!SAMLUtils.debug.messageEnabled()) continue;
                                    SAMLUtils.debug.message("certAlias =" + string13);
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("siteattributemapper")) {
                                    try {
                                        siteAttributeMapper = (SiteAttributeMapper)Class.forName(string4.substring(n8)).newInstance();
                                    }
                                    catch (InstantiationException instantiationException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + instantiationException);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + illegalAccessException);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + classNotFoundException);
                                    }
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("partnersiteattributemapper")) {
                                    try {
                                        partnerSiteAttributeMapper = (PartnerSiteAttributeMapper)Class.forName(string4.substring(n8)).newInstance();
                                    }
                                    catch (InstantiationException instantiationException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:", (Throwable)instantiationException);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:", (Throwable)illegalAccessException);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        SAMLUtils.debug.error("SAMLServiceManager:", (Throwable)classNotFoundException);
                                    }
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("ATTRIBUTEMAPPER")) {
                                    try {
                                        attributeMapper = (AttributeMapper)Class.forName(string4.substring(n8)).newInstance();
                                    }
                                    catch (Exception exception) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + exception);
                                    }
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("ACTIONMAPPER")) {
                                    try {
                                        actionMapper = (ActionMapper)Class.forName(string4.substring(n8)).newInstance();
                                    }
                                    catch (Exception exception) {
                                        SAMLUtils.debug.error("SAMLServiceManager:" + exception);
                                    }
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("ISSUER")) {
                                    string15 = string4.substring(n8).trim();
                                    if (!SAMLUtils.debug.messageEnabled()) continue;
                                    SAMLUtils.debug.message("issuer = " + string15);
                                    continue;
                                }
                                if (((String)object11).equalsIgnoreCase("hostlist")) {
                                    hashSet2 = new HashSet<String>();
                                    hashSet = new HashSet<String>();
                                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4.substring(n8), ",");
                                    InetAddress[] inetAddressArray = null;
                                    while (stringTokenizer2.hasMoreTokens()) {
                                        String string16;
                                        block95: {
                                            string16 = stringTokenizer2.nextToken().trim();
                                            try {
                                                inetAddressArray = InetAddress.getAllByName(string16);
                                                int n9 = 0;
                                                int n10 = inetAddressArray.length;
                                                while (n9 < n10) {
                                                    hashSet.add(inetAddressArray[n9].getHostAddress());
                                                    ++n9;
                                                }
                                            }
                                            catch (Exception exception) {
                                                if (!SAMLUtils.debug.warningEnabled()) break block95;
                                                SAMLUtils.debug.warning("SAML Service Manager: possible wrong hostname in the host list.");
                                            }
                                        }
                                        hashSet.add(string16);
                                        hashSet2.add(string16);
                                    }
                                    if (!SAMLUtils.debug.messageEnabled()) continue;
                                    SAMLUtils.debug.message("hostSet = " + hashSet);
                                    continue;
                                }
                                if (!((String)object11).equalsIgnoreCase("VERSION")) continue;
                                string14 = string4.substring(n8);
                            }
                            if (string11 == null) {
                                string11 = "NOAUTH";
                            }
                            if (accountMapper == null) {
                                accountMapper = new DefaultAccountMapper();
                            }
                            if (attributeMapper == null) {
                                attributeMapper = new DefaultAttributeMapper();
                            }
                            if (actionMapper == null) {
                                actionMapper = new DefaultActionMapper();
                            }
                            if (string14 == null || string14.equals("")) {
                                try {
                                    string14 = SystemProperties.get((String)"com.sun.identity.saml.protocol.version").trim();
                                }
                                catch (Exception exception) {
                                    string14 = "1.0";
                                }
                            }
                            if (string9 == null || string9.equals("")) {
                                SAMLUtils.debug.error("Ignore this trusted site since SourceID is misconfigured:" + string3);
                            } else {
                                if (string5 == null || string5.equals("") || (string6 == null || string6.equals("")) && (string7 == null || string7.equals(""))) {
                                    SAMLUtils.debug.warning("Either target or both SAMLUrl and POSTUrl are misconfigured:" + string3);
                                }
                                if (string5 != null && !string5.equals("")) {
                                    StringTokenizer stringTokenizer3 = new StringTokenizer(string5, ",");
                                    while (stringTokenizer3.hasMoreElements()) {
                                        String string17 = stringTokenizer3.nextToken();
                                        if (SAMLUtils.debug.messageEnabled()) {
                                            SAMLUtils.debug.message("SAML ServiceManager:target= " + string17);
                                        }
                                        if (((StringTokenizer)(object11 = new StringTokenizer(string17, ":"))).countTokens() == 2) {
                                            string8 = ((StringTokenizer)object11).nextToken().trim();
                                            n6 = Integer.parseInt(((StringTokenizer)object11).nextToken().trim());
                                            continue;
                                        }
                                        string8 = string17;
                                        n6 = -1;
                                    }
                                    SiteEntry siteEntry = new SiteEntry(string8, n6, string9, string6, string7, string14);
                                    object2.add(siteEntry);
                                }
                                SOAPEntry sOAPEntry = new SOAPEntry(string9, string10, string11, string12, string13, accountMapper, partnerAccountMapper, siteAttributeMapper, partnerSiteAttributeMapper, attributeMapper, actionMapper, string15, hashSet2, string14);
                                object.put(string9, sOAPEntry);
                            }
                        }
                        ++n5;
                    }
                    hashMap.put("iplanet-am-saml-trusted-server-list", object2);
                    hashMap.put("iplanet-am-saml-partner-urls", object);
                }
                SAMLServiceManager.map = hashMap;
            }
            catch (Exception exception) {
                SAMLUtils.debug.error("SAMLServiceManager.setValues: Exception:", (Throwable)exception);
            }
        }
    }

    public static synchronized Object getAttribute(String string) {
        if (instance == null) {
            SAMLServiceManager.init();
        }
        return map.get(string);
    }

    public static synchronized Map getSAMLUser(String string) {
        String string2 = null;
        String string3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            AMUser aMUser = amConn.getUser(string);
            HashSet hashSet = new HashSet();
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMSAMLService", SAMLServiceManager.getSSOToken());
            ServiceSchema serviceSchema = serviceSchemaManager.getSchema(SchemaType.USER);
            if (serviceSchema != null) {
                hashSet.addAll(serviceSchema.getAttributeSchemaNames());
            }
            Map map = aMUser.getAttributes(hashSet);
            string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-user");
            string3 = Misc.getMapAttr((Map)map, (String)"iplanet-am-saml-password");
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLServiceManager:getSAMLUserID: The user id on partner site is " + string2 + "\n" + "The password is " + string3);
            }
            string3 = AMPasswordUtil.decrypt((String)string3);
            hashMap.put("iplanet-am-saml-user", string2);
            hashMap.put("iplanet-am-saml-password", string3);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLServiceManager:getSAMLUser", (Throwable)exception);
        }
        return hashMap;
    }

    public void schemaChanged(String string, String string2) {
        SAMLUtils.debug.message("SAMLServiceManager: schemaChanged.");
        SAMLServiceManager.setValues();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        SAMLUtils.debug.message("SAMLServiceManager: globalConfigChanged.");
        SAMLServiceManager.setValues();
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        SAMLUtils.debug.message("SAMLServiceManager: orgConfigChanged.");
        SAMLServiceManager.setValues();
    }

    public static String getAuthMethodURI(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("Cert")) {
            return "urn:ietf:rfc:2246";
        }
        if (string.equalsIgnoreCase("Kerberos")) {
            return "urn:ietf:rfc:1510";
        }
        if (SAMLConstants.passwordAuthMethods.contains(string.toLowerCase())) {
            return "urn:oasis:names:tc:SAML:1.0:am:password";
        }
        if (SAMLConstants.tokenAuthMethods.contains(string.toLowerCase())) {
            return "urn:oasis:names:tc:SAML:1.0:am:HardwareToken";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("urn:com:sun:identity:").append(string);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertEntry getMatchingCertEntry(java.security.cert.X509Certificate x509Certificate) {
        Object object;
        CryptoManager cryptoManager;
        String string = x509Certificate.getIssuerDN().getName().trim();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        if (certdbCerts == null) {
            cryptoManager = new Object();
            object = cryptoManager;
            synchronized (object) {
                if (certdbCerts == null) {
                    certdbCerts = Collections.synchronizedMap(new HashMap());
                }
            }
        } else {
            cryptoManager = certdbCerts.entrySet().iterator();
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("found " + certdbCerts.entrySet().size() + " certdb certs");
            }
            while (cryptoManager.hasNext()) {
                object = (CertEntry)cryptoManager.next().getValue();
                if (!string.equals(object.getIssuerDN().getName()) || !bigInteger.equals(object.getSerialNumber())) continue;
                return object;
            }
        }
        SAMLUtils.debug.message("start loading certs from certdb");
        try {
            cryptoManager = CryptoManager.getInstance();
            object = cryptoManager.getPermCerts();
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("read " + ((X509Certificate[])object).length + " certdb certs");
                SAMLUtils.debug.message("inCert Issuer:" + string);
                SAMLUtils.debug.message("inCert SN:" + bigInteger);
            }
            int n = 0;
            while (n < ((X509Certificate[])object).length) {
                X509Certificate x509Certificate2 = object[n];
                CertEntry certEntry = new CertEntry(x509Certificate2.getNickname(), x509Certificate2.getIssuerDN(), x509Certificate2.getSerialNumber());
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate2.getEncoded());
                java.security.cert.X509Certificate x509Certificate3 = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                certdbCerts.put(x509Certificate2.getNickname(), certEntry);
                if (string.equals(x509Certificate3.getIssuerDN().getName().trim()) && bigInteger.compareTo(certEntry.getSerialNumber()) == 0) {
                    SAMLUtils.debug.message("found match..");
                    return certEntry;
                }
                ++n;
            }
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            SAMLUtils.debug.error("SAMLSOAPReceiver:Error retrieving certificate from certdb", (Throwable)notInitializedException);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLSOAPReceiver:Exception", (Throwable)exception);
        }
        return null;
    }

    public static class CertEntry {
        private String nickName = null;
        private Principal issuerDN = null;
        private BigInteger serialNumber;

        public CertEntry(String string, Principal principal, BigInteger bigInteger) {
            this.nickName = string;
            this.issuerDN = principal;
            this.serialNumber = bigInteger;
        }

        public String getNickName() {
            return this.nickName;
        }

        public Principal getIssuerDN() {
            return this.issuerDN;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }

    public static class SOAPEntry {
        private String destID = null;
        private String soapRevUrl = null;
        private String authenType = null;
        private String userid = null;
        private String certalias = null;
        private AccountMapper acctMapper = null;
        private PartnerAccountMapper partnerAcctMapper = null;
        private SiteAttributeMapper _siteAttributeMapper = null;
        private PartnerSiteAttributeMapper _partnerSiteAttributeMapper = null;
        private AttributeMapper attributeMapper = null;
        private ActionMapper actionMapper = null;
        private String _issuer = null;
        private Set origHostSet = null;
        private String prefVersion = null;

        public SOAPEntry(String string, String string2, String string3, String string4, String string5, AccountMapper accountMapper, PartnerAccountMapper partnerAccountMapper, SiteAttributeMapper siteAttributeMapper, PartnerSiteAttributeMapper partnerSiteAttributeMapper, AttributeMapper attributeMapper, ActionMapper actionMapper, String string6, Set set, String string7) {
            this.destID = string;
            this.soapRevUrl = string2;
            this.authenType = string3;
            this.userid = string4;
            this.certalias = string5;
            this.acctMapper = accountMapper;
            this.partnerAcctMapper = partnerAccountMapper;
            this._siteAttributeMapper = siteAttributeMapper;
            this._partnerSiteAttributeMapper = partnerSiteAttributeMapper;
            this.attributeMapper = attributeMapper;
            this.actionMapper = actionMapper;
            this._issuer = string6;
            this.origHostSet = set;
            this.prefVersion = string7;
        }

        public String getSourceID() {
            return this.destID;
        }

        public String getSOAPUrl() {
            return this.soapRevUrl;
        }

        public String getAuthType() {
            return this.authenType;
        }

        public String getUser() {
            return this.userid;
        }

        public String getCertAlias() {
            return this.certalias;
        }

        public String getVersion() {
            return this.prefVersion;
        }

        public AccountMapper getAccountMapper() {
            return this.acctMapper;
        }

        public PartnerAccountMapper getPartnerAccountMapper() {
            return this.partnerAcctMapper;
        }

        public SiteAttributeMapper getSiteAttributeMapper() {
            SAMLUtils.debug.message("getSiteAttributeMapper() called");
            if (this._siteAttributeMapper == null) {
                SAMLUtils.debug.message("siteMapper is null");
            }
            return this._siteAttributeMapper;
        }

        public PartnerSiteAttributeMapper getPartnerSiteAttributeMapper() {
            SAMLUtils.debug.message("getPartnerSiteAttributeMapper() called");
            if (this._partnerSiteAttributeMapper == null) {
                SAMLUtils.debug.message("partnerSiteMapper is null");
            }
            return this._partnerSiteAttributeMapper;
        }

        public AttributeMapper getAttributeMapper() {
            return this.attributeMapper;
        }

        public ActionMapper getActionMapper() {
            return this.actionMapper;
        }

        public String getIssuer() {
            return this._issuer;
        }

        public Set getHostSet() {
            if (this.origHostSet != null) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = this.origHostSet.iterator();
                while (iterator.hasNext()) {
                    String string;
                    block5: {
                        InetAddress[] inetAddressArray = null;
                        string = (String)iterator.next();
                        try {
                            inetAddressArray = InetAddress.getAllByName(string);
                            int n = 0;
                            int n2 = inetAddressArray.length;
                            while (n < n2) {
                                hashSet.add(inetAddressArray[n].getHostAddress());
                                ++n;
                            }
                        }
                        catch (Exception exception) {
                            if (!SAMLUtils.debug.warningEnabled()) break block5;
                            SAMLUtils.debug.warning("SAML Service Manager: getHostSet: possible wrong hostname in the host list.");
                        }
                    }
                    hashSet.add(string);
                }
                return hashSet;
            }
            return this.origHostSet;
        }
    }

    public static class SiteEntry {
        private String hostname = null;
        private int portnumber = -1;
        private String sid = null;
        private String saml = null;
        private String post = null;
        private String prefVersion = null;

        public SiteEntry(String string, int n, String string2, String string3, String string4, String string5) {
            this.hostname = string;
            this.portnumber = n;
            this.sid = string2;
            this.saml = string3;
            this.post = string4;
            this.prefVersion = string5;
        }

        public String getSAMLUrl() {
            return this.saml;
        }

        public String getPOSTUrl() {
            return this.post;
        }

        public String getHostName() {
            return this.hostname;
        }

        public int getPort() {
            return this.portnumber;
        }

        public String getSourceID() {
            return this.sid;
        }

        public String getVersion() {
            return this.prefVersion;
        }
    }
}

