/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Subject {
    static SAMLConstants sc;
    private SubjectConfirmation _subjectConfirmation;
    private NameIdentifier _nameIdentifier;

    protected Subject() {
    }

    public Subject(NameIdentifier nameIdentifier, SubjectConfirmation subjectConfirmation) throws SAMLException {
        if (nameIdentifier == null && subjectConfirmation == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:  null NameIdentifier and SubjectConfirmation  specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (nameIdentifier != null) {
            this._nameIdentifier = nameIdentifier;
        }
        if (subjectConfirmation != null) {
            this._subjectConfirmation = subjectConfirmation;
        }
    }

    public boolean equals(Subject subject) {
        boolean bl = false;
        boolean bl2 = false;
        if (subject != null) {
            NameIdentifier nameIdentifier = subject.getNameIdentifier();
            if (this._nameIdentifier != null) {
                bl = this._nameIdentifier.equals(nameIdentifier);
            } else if (nameIdentifier == null) {
                bl = true;
            }
            SubjectConfirmation subjectConfirmation = subject.getSubjectConfirmation();
            if (this._subjectConfirmation != null) {
                bl2 = this._subjectConfirmation.equals(subjectConfirmation);
            } else if (subjectConfirmation == null) {
                bl2 = true;
            }
            return bl && bl2;
        }
        return false;
    }

    public Subject(NameIdentifier nameIdentifier) throws SAMLException {
        if (nameIdentifier == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:  null NameIdentifier specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._nameIdentifier = nameIdentifier;
    }

    public Subject(Element element) throws SAMLException {
        int n = 0;
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("Subject")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        if (n2 == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: No sub elements found");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("emptyElement"));
        }
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeList.item(n3);
            if (node.getNodeType() == 1) {
                String string2 = node.getLocalName();
                if (string2.equals("NameIdentifier")) {
                    this._nameIdentifier = new NameIdentifier((Element)node);
                    ++n;
                } else if (string2.equals("SubjectConfirmation")) {
                    this._subjectConfirmation = new SubjectConfirmation((Element)node);
                    ++n;
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Subject: Invalid element encountered.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
                }
            }
            ++n3;
        }
        if (n > 2) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject: more than allowed elements passed");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
    }

    public Subject(SubjectConfirmation subjectConfirmation) throws SAMLException {
        if (subjectConfirmation == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:  null SubjectConfirmation specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this._subjectConfirmation = subjectConfirmation;
    }

    public boolean setSubjectConfirmation(SubjectConfirmation subjectConfirmation) {
        if (subjectConfirmation == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:  null SubjectConfirmation specified");
            }
            return false;
        }
        this._subjectConfirmation = subjectConfirmation;
        return true;
    }

    public boolean removeSubjectConfirmation() {
        if (this._nameIdentifier == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:At least one of NameIdentifier and SubjectConfirmation is mandatory");
            }
            return false;
        }
        this._subjectConfirmation = null;
        return true;
    }

    public boolean setNameIdentifier(NameIdentifier nameIdentifier) {
        if (nameIdentifier == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:  null nameIdentifier specified");
            }
            return false;
        }
        this._nameIdentifier = nameIdentifier;
        return true;
    }

    public boolean removeNameIdentifier() {
        if (this._subjectConfirmation == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Subject:At least one of NameIdentifier and SubjectConfirmation is mandatory");
            }
            return false;
        }
        this._nameIdentifier = null;
        return true;
    }

    public NameIdentifier getNameIdentifier() {
        return this._nameIdentifier;
    }

    public SubjectConfirmation getSubjectConfirmation() {
        return this._subjectConfirmation;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = SAMLUtils.makeStartElementTagXML("Subject", bl, bl2);
        stringBuffer.append(string).append("\n");
        if (this._nameIdentifier != null) {
            stringBuffer.append(this._nameIdentifier.toString(bl, false));
        }
        if (this._subjectConfirmation != null) {
            stringBuffer.append(this._subjectConfirmation.toString(bl, false));
        }
        string = SAMLUtils.makeEndElementTagXML("Subject", bl);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

