/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Evidence {
    static SAMLConstants sc;
    private Set _assertionIDRef = new HashSet();
    private Set _assertion = new HashSet();
    private int dataContentType;

    public Evidence(Element element) throws SAMLException {
        String string = element.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Evidence:local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("Evidence")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Evidence: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement") + ":" + string);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n <= 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message(string + ":" + "no sub elements found in this Element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("noElement"));
        }
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string2 = node.getLocalName();
                if (string2.equals("Assertion")) {
                    this._assertion.add(new Assertion((Element)node));
                } else if (string2.equals("AssertionIDReference")) {
                    this._assertionIDRef.add(new AssertionIDReference(XMLUtils.getElementValue((Element)((Element)node))));
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Evidence:  invalid sub element");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
                }
            }
            ++n2;
        }
    }

    public Evidence(Set set) throws SAMLException {
        if (set.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Evidence:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Assertion) {
                this._assertion.add((Assertion)e);
                continue;
            }
            if (e instanceof AssertionIDReference) {
                this._assertionIDRef.add((AssertionIDReference)e);
                continue;
            }
            SAMLUtils.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
    }

    public Evidence(Set set, Set set2) throws SAMLException {
        Object e;
        if (set.isEmpty() && set2.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Evidence:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof AssertionIDReference) {
                this._assertionIDRef.add((AssertionIDReference)e);
                continue;
            }
            SAMLUtils.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e instanceof Assertion) {
                this._assertion.add((Assertion)e);
                continue;
            }
            SAMLUtils.debug.message("Evidence: Invalid input Element");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement"));
        }
    }

    public boolean addAssertion(Assertion assertion) {
        if (assertion == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Evidence:  null input specified");
            }
            return false;
        }
        this._assertion.add(assertion);
        return true;
    }

    public boolean addAssertionIDReference(AssertionIDReference assertionIDReference) {
        if (assertionIDReference == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Evidence:  null input specified");
            }
            return false;
        }
        this._assertionIDRef.add(assertionIDReference);
        return true;
    }

    public boolean removeAssertion(Assertion assertion) {
        if (assertion != null) {
            if (this._assertionIDRef.size() + this._assertion.size() > 1) {
                this._assertion.remove(assertion);
                return true;
            }
        } else if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Evidence:  null input specified");
        }
        return false;
    }

    public boolean removeAssertionIDReference(AssertionIDReference assertionIDReference) {
        if (assertionIDReference != null) {
            if (this._assertionIDRef.size() + this._assertion.size() > 1) {
                this._assertionIDRef.remove(assertionIDReference);
                return true;
            }
        } else if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("Evidence:  null input specified");
        }
        return false;
    }

    public Set getAssertionIDReference() {
        return this._assertionIDRef;
    }

    public Set getAssertion() {
        return this._assertion;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = null;
        string = SAMLUtils.makeStartElementTagXML("Evidence", bl, bl2);
        stringBuffer.append(string).append("\n");
        Iterator iterator = this._assertion.iterator();
        while (iterator.hasNext()) {
            object = (Assertion)iterator.next();
            stringBuffer.append(((Assertion)object).toString(bl, false));
        }
        iterator = this._assertionIDRef.iterator();
        while (iterator.hasNext()) {
            object = (AssertionIDReference)iterator.next();
            stringBuffer.append(((AssertionIDReference)object).toString(bl, false));
        }
        string = SAMLUtils.makeEndElementTagXML("Evidence", bl);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

