/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Condition;
import com.sun.identity.saml.assertion.DoNotCacheCondition;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Conditions {
    static SAMLConstants sc;
    private Date _notBefore = null;
    private Date _notOnOrAfter = null;
    private Set _arcs = Collections.synchronizedSet(new HashSet());
    private DoNotCacheCondition doNotCache = null;

    public Conditions() {
    }

    public Conditions(Date date, Date date2) throws SAMLException {
        if (date != null) {
            if (date2 != null) {
                if (date.after(date2) || date.equals(date2)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Conditions:  invalid    notBefore or notOnOrAfter");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this._notBefore = date;
                this._notOnOrAfter = date2;
            } else {
                this._notBefore = date;
            }
        } else {
            this._notOnOrAfter = date2;
        }
    }

    public Conditions(Date date, Date date2, Condition condition, AudienceRestrictionCondition audienceRestrictionCondition) throws SAMLException {
        this._notBefore = date;
        this._notOnOrAfter = date2;
        if (date != null && date2 != null && (date.after(date2) || date.equals(date2))) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Conditions:  invalid  data");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (audienceRestrictionCondition != null) {
            this._arcs.add(audienceRestrictionCondition);
        }
    }

    public Conditions(Date date, Date date2, Condition condition, AudienceRestrictionCondition audienceRestrictionCondition, DoNotCacheCondition doNotCacheCondition) throws SAMLException {
        this(date, date2, condition, audienceRestrictionCondition);
        if (doNotCacheCondition != null) {
            this.doNotCache = doNotCacheCondition;
        }
    }

    public Conditions(Element element) throws SAMLException {
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Conditions: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("Conditions")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Conditions: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement") + ":" + string);
        }
        String string2 = element2.getAttribute("NotBefore");
        if (string2 != null && !string2.equals("")) {
            try {
                this._notBefore = SAMLUtils.stringToDate(string2);
            }
            catch (ParseException parseException) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Conditions: could not parse  NotBefore or NotOnOrAfter ");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput") + parseException.getMessage());
            }
        }
        if ((string2 = element2.getAttribute("NotOnOrAfter")) != null && !string2.equals("")) {
            try {
                this._notOnOrAfter = SAMLUtils.stringToDate(element2.getAttribute("NotOnOrAfter"));
            }
            catch (ParseException parseException) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Conditions: could not parse  NotBefore or NotOnOrAfter ");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput") + parseException.getMessage());
            }
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1) {
                String string3 = node.getLocalName();
                if (string3.equals("AudienceRestrictionCondition")) {
                    this._arcs.add(new AudienceRestrictionCondition((Element)node));
                } else if (string3.equals("DoNotCacheCondition")) {
                    this.doNotCache = new DoNotCacheCondition((Element)node);
                } else {
                    String string4 = ((Element)node).getAttribute("xsi:type");
                    if (string4.equals("AudienceRestrictionCondition")) {
                        this._arcs.add(new AudienceRestrictionCondition((Element)node));
                    } else if (string4.equals("DoNotCacheCondition")) {
                        this.doNotCache = new DoNotCacheCondition((Element)node);
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("Conditions: unsupported condition, cannot determine extension ");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("unsupportedCondition"));
                    }
                }
            }
            ++n2;
        }
    }

    public Date getNotBefore() {
        return this._notBefore;
    }

    public Date getNotOnorAfter() {
        return this._notOnOrAfter;
    }

    public boolean addAudienceRestrictionCondition(AudienceRestrictionCondition audienceRestrictionCondition) {
        if (audienceRestrictionCondition != null) {
            this._arcs.add(audienceRestrictionCondition);
            return true;
        }
        return false;
    }

    public boolean checkDateValidity(long l) {
        if (this._notBefore == null) {
            if (this._notOnOrAfter == null) {
                return true;
            }
            if (l < this._notOnOrAfter.getTime()) {
                return true;
            }
        } else if (this._notOnOrAfter == null ? l >= this._notBefore.getTime() : l >= this._notBefore.getTime() && l < this._notOnOrAfter.getTime()) {
            return true;
        }
        return false;
    }

    public Set getAudienceRestrictionCondition() {
        return this._arcs;
    }

    public boolean removeAudienceRestrictionCondition(String string) {
        Iterator iterator = this._arcs.iterator();
        while (iterator.hasNext()) {
            AudienceRestrictionCondition audienceRestrictionCondition = (AudienceRestrictionCondition)iterator.next();
            if (!audienceRestrictionCondition.containsAudience(string)) continue;
            return audienceRestrictionCondition.removeAudience(string);
        }
        return false;
    }

    public void setDoNotCacheCondition(DoNotCacheCondition doNotCacheCondition) {
        if (this.doNotCache != null) {
            this.doNotCache = doNotCacheCondition;
        }
    }

    public DoNotCacheCondition getDoNotCacheCondition() {
        return this.doNotCache;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (bl) {
            string2 = "saml:";
        }
        stringBuffer.append("<").append(string2).append("Conditions").append(" ").append(string).append(" ");
        String string3 = null;
        if (this._notBefore != null) {
            try {
                string3 = SAMLUtils.dateToString(this._notBefore);
            }
            catch (ParseException parseException) {
                SAMLUtils.debug.error("Conditions: could not toString  NotBefore");
            }
            stringBuffer.append("NotBefore").append("=\"").append(string3).append("\"").append(" ");
        }
        if (this._notOnOrAfter != null) {
            try {
                string3 = SAMLUtils.dateToString(this._notOnOrAfter);
            }
            catch (ParseException parseException) {
                SAMLUtils.debug.error("Conditions: could not toString  NotOnOrAfter");
            }
            stringBuffer.append("NotOnOrAfter").append("=\"").append(string3).append("\"").append(" ").append(">").append("\n");
        }
        if (this._arcs.size() > 0) {
            Iterator iterator = this._arcs.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((AudienceRestrictionCondition)iterator.next()).toString(bl, false));
            }
        }
        if (this.doNotCache != null) {
            stringBuffer.append(this.doNotCache.toString(bl, false));
        }
        String string4 = SAMLUtils.makeEndElementTagXML("Conditions", bl);
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }
}

