/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeStatement
extends SubjectStatement {
    private List _attributes = null;

    protected AttributeStatement() {
    }

    public AttributeStatement(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AttributeStatement: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean bl = SAMLUtils.checkStatement(element, "AttributeStatement");
        if (!bl) {
            SAMLUtils.debug.message("AttributeStatement: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    String string = node.getLocalName();
                    String string2 = node.getNamespaceURI();
                    if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AttributeStatement:  The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string.equals("Subject") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._subject != null) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("AttributeStatement: should not contain more than one subject.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
                        }
                        this._subject = new Subject((Element)node);
                    } else if (string.equals("Attribute") && string2.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._attributes == null) {
                            this._attributes = new ArrayList();
                        }
                        if (!this._attributes.add(new Attribute((Element)node))) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("AttributeStatement: failed to add to the Attribute list.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
                        }
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AttributeStatement:wrong element:" + string);
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
                ++n2;
            }
        }
        if (this._subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeStatement: missing Subject");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this._attributes == null || this._attributes.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeStatement: should at least contain one Attribute element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public AttributeStatement(Subject subject, List list) throws SAMLException {
        if (subject == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeStatement: missing subject.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this._subject = subject;
        if (list == null || list.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeStatement: Attribute isrequired.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes = list;
    }

    public List getAttribute() {
        return this._attributes;
    }

    public int getStatementType() {
        return 3;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AttributeStatement ").append(string2).append(">\n");
        stringBuffer.append(this._subject.toString(bl, false));
        Iterator iterator = this._attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            stringBuffer.append(attribute.toString(bl, false));
        }
        stringBuffer.append("</").append(string).append("AttributeStatement>\n");
        return stringBuffer.toString();
    }
}

