/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import org.w3c.dom.Element;

public class AssertionIDReference {
    private String assertionID = null;

    public AssertionIDReference(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AssertionIDReference: Input is null.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("AssertionIDReference")) {
            SAMLUtils.debug.message("AssertionIDReference: wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.assertionID = XMLUtils.getElementValue((Element)element);
        if (this.assertionID == null || this.assertionID.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionIDReference is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElementValue"));
        }
    }

    public AssertionIDReference() {
        this.assertionID = SAMLUtils.generateAssertionID();
    }

    public AssertionIDReference(String string) {
        this.assertionID = string == null || string.equals("") ? SAMLUtils.generateAssertionID() : string;
    }

    public String getAssertionIDReference() {
        return this.assertionID;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("AssertionIDReference").append(string2).append(">").append(this.assertionID).append("</").append(string).append("AssertionIDReference>\n");
        return stringBuffer.toString();
    }
}

