/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Advice {
    private List _assertionIDRef = null;
    private List _assertion = null;
    private List _otherElements = null;

    public Advice(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("Advice: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("Advice")) {
            SAMLUtils.debug.message("Advice: wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                if (node.getNodeType() == 1) {
                    Object object;
                    String string2 = node.getLocalName();
                    String string3 = node.getNamespaceURI();
                    if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("Advice: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string2.equals("AssertionIDReference") && string3.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        object = new AssertionIDReference((Element)node);
                        if (this._assertionIDRef == null) {
                            this._assertionIDRef = new ArrayList();
                        }
                        if (!this._assertionIDRef.add(object)) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("Advice:failed to add to AssertionIDReference List.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
                        }
                    } else if (string2.equals("Assertion") && string3.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        object = new Assertion((Element)node);
                        if (this._assertion == null) {
                            this._assertion = new ArrayList();
                        }
                        if (!this._assertion.add(object)) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("Advice:failed to add to Assertion List.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
                        }
                    } else {
                        if (this._otherElements == null) {
                            this._otherElements = new ArrayList();
                        }
                        if (!this._otherElements.add((Element)node)) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("Advice: failed to add to other elements list.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public Advice(List list, List list2, List list3) {
        if (list != null && !list.isEmpty()) {
            if (this._assertionIDRef == null) {
                this._assertionIDRef = new ArrayList();
            }
            this._assertionIDRef = list;
        }
        if (list2 != null && !list2.isEmpty()) {
            if (this._assertion == null) {
                this._assertion = new ArrayList();
            }
            this._assertion = list2;
        }
        if (list3 != null) {
            if (this._otherElements == null) {
                this._otherElements = new ArrayList();
            }
            this._otherElements = list3;
        }
    }

    public List getAssertionIDReference() {
        return this._assertionIDRef;
    }

    public List getAssertion() {
        return this._assertion;
    }

    public List getOtherElement() {
        return this._otherElements;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        Iterator iterator = null;
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("Advice").append(string2).append(">\n");
        if (this._assertionIDRef != null && !this._assertionIDRef.isEmpty()) {
            iterator = this._assertionIDRef.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((AssertionIDReference)iterator.next()).toString(bl, false));
            }
        }
        if (this._assertion != null && !this._assertion.isEmpty()) {
            iterator = this._assertion.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Assertion)iterator.next()).toString(bl, false));
            }
        }
        if (this._otherElements != null && !this._otherElements.isEmpty()) {
            iterator = this._otherElements.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(XMLUtils.print((Node)((Element)iterator.next())));
            }
        }
        stringBuffer.append("</").append(string).append("Advice>\n");
        return stringBuffer.toString();
    }
}

