/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOToken;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.AssertionManagerIF;
import com.sun.identity.saml.AssertionManagerImpl;
import com.sun.identity.saml.AssertionManagerService_Impl;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.Stub;

public final class AssertionManagerClient {
    private static String SERVICE_NAME = "samlassertionmanager";
    private static boolean checkedForLocal;
    private static boolean isLocal;
    private boolean useLocal;
    private static AssertionManagerIF remoteStub;
    private static AssertionManager assertionManager;
    private AssertionManagerIF stub;

    public AssertionManagerClient() throws SAMLException {
        if (!checkedForLocal) {
            try {
                remoteStub = AssertionManagerClient.getServiceEndPoint(SystemProperties.get((String)"com.iplanet.am.localserver.protocol"), SystemProperties.get((String)"com.iplanet.am.localserver.host"), SystemProperties.get((String)"com.iplanet.am.localserver.port"));
                remoteStub.checkForLocal();
                if (AssertionManagerImpl.isLocal) {
                    isLocal = true;
                    SAMLUtils.debug.warning("AMC(): Using local service");
                    assertionManager = AssertionManager.getInstance();
                }
                checkedForLocal = true;
            }
            catch (Exception exception) {
                checkedForLocal = true;
                if (SAMLUtils.debug.warningEnabled()) {
                    SAMLUtils.debug.warning("AssertionManagerClient()Exception", (Throwable)exception);
                }
                throw new SAMLException(exception.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
        }
    }

    public AssertionManagerClient(String string) throws SAMLException {
        try {
            Stub stub = (Stub)new AssertionManagerService_Impl().getAssertionManagerIFPort();
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string);
            this.stub = (AssertionManagerIF)stub;
            this.useLocal = false;
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AssertionManagerClient() Exception", (Throwable)exception);
            }
            throw new SAMLException(exception.getMessage());
        }
    }

    private static AssertionManagerIF getServiceEndPoint(String string, String string2, String string3) throws Exception {
        URL uRL = WebtopNaming.getServiceURL((String)SERVICE_NAME, (String)string, (String)string2, (String)string3);
        String string4 = uRL.toString();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionManagerClient with URL: " + string4);
        }
        Stub stub = (Stub)new AssertionManagerService_Impl().getAssertionManagerIFPort();
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string4);
        return (AssertionManagerIF)stub;
    }

    private static AssertionManagerIF getRemoteStub() throws SAMLException {
        AssertionManagerIF assertionManagerIF;
        Exception exception;
        boolean bl;
        block8: {
            bl = false;
            exception = null;
            assertionManagerIF = null;
            try {
                Enumeration enumeration = WebtopNaming.getPlatformServerList().elements();
                while (enumeration.hasMoreElements() && !bl) {
                    URL uRL = new URL((String)enumeration.nextElement());
                    assertionManagerIF = AssertionManagerClient.getServiceEndPoint(uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()));
                    try {
                        assertionManagerIF.checkForLocal();
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("AMC(): Using the remote URL: " + uRL.toString());
                        }
                        bl = true;
                        if (!SAMLUtils.debug.warningEnabled()) continue;
                        SAMLUtils.debug.warning("AMC:getRemoteStub: remote server being used: " + uRL.toString());
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!SAMLUtils.debug.warningEnabled()) continue;
                        SAMLUtils.debug.warning("AMC:getRemoteStub: server (" + uRL.toString() + ") error: ", (Throwable)exception2);
                    }
                }
            }
            catch (Exception exception3) {
                exception = exception3;
                if (!SAMLUtils.debug.warningEnabled()) break block8;
                SAMLUtils.debug.warning("AMC:getRemoteStub: generic error: ", (Throwable)exception3);
            }
        }
        if (!bl) {
            if (exception != null) {
                throw new SAMLException(exception.getMessage());
            }
            throw new SAMLException(SAMLUtils.bundle.getString("serverNotFound"));
        }
        return assertionManagerIF;
    }

    public Assertion createAssertion(SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertion(sSOToken);
        }
        String string = null;
        try {
            string = this.stub.createAssertion(sSOToken.getTokenID().toString());
            return new Assertion(XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:createAssertion(SSO)", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Assertion createAssertion(SSOToken sSOToken, List list) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertion(sSOToken, list);
        }
        if (list == null || list.isEmpty()) {
            return this.createAssertion(sSOToken);
        }
        String string = null;
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                linkedList.add(attribute.toString(true, true));
            }
            string = this.stub.createAssertion(sSOToken.getTokenID().toString(), linkedList);
            return new Assertion(XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:createAssertion(SSO, attrs)", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public AssertionArtifact createAssertionArtifact(Assertion assertion, String string) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertionArtifact(assertion, string);
        }
        String string2 = null;
        try {
            String string3 = assertion.toString(true, true);
            string2 = this.stub.createAssertionArtifact(string3, Base64.encode((byte[])SAMLUtils.stringToByteArray(string)));
            return new AssertionArtifact(string2);
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:createAssertionArtifact:", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, Set set) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionIDReference, set);
        }
        String string = null;
        try {
            HashSet<String> hashSet = new HashSet<String>();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(Base64.encode((byte[])SAMLUtils.stringToByteArray((String)iterator.next())));
                }
            }
            string = this.stub.getAssertionByIdRef(assertionIDReference.getAssertionIDReference(), hashSet);
            return new Assertion(XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + assertionIDReference, (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, String string) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionIDReference, string);
        }
        String string2 = null;
        try {
            if (string == null || string.equals("")) {
                string = " ";
            }
            string2 = this.stub.getAssertionByIdRef(assertionIDReference.getAssertionIDReference(), Base64.encode((byte[])SAMLUtils.stringToByteArray(string)));
            return new Assertion(XMLUtils.toDOMDocument((String)string2, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + assertionIDReference, (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Assertion getAssertion(AssertionArtifact assertionArtifact, Set set) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionArtifact, set);
        }
        String string = null;
        try {
            if (set == null || set.isEmpty()) {
                SAMLUtils.debug.error("AssertionManagerClient:getAssertion(AssertionArtifact, Set): destID set is null");
                throw new SAMLException("nullInput");
            }
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                hashSet.add(Base64.encode((byte[])SAMLUtils.stringToByteArray((String)iterator.next())));
            }
            string = this.stub.getAssertion(assertionArtifact.getAssertionArtifact(), hashSet);
            return new Assertion(XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + assertionArtifact, (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    protected Assertion getAssertion(AssertionArtifact assertionArtifact, String string) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionArtifact, string);
        }
        String string2 = null;
        try {
            string2 = this.stub.getAssertion(assertionArtifact.getAssertionArtifact(), Base64.encode((byte[])SAMLUtils.stringToByteArray(string)));
            return new Assertion(XMLUtils.toDOMDocument((String)string2, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + assertionArtifact, (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(assertionIDReference, sSOToken);
        }
        String string = null;
        try {
            string = this.stub.getAssertionByIdRefToken(assertionIDReference.getAssertionIDReference(), sSOToken.getTokenID().toString());
            return new Assertion(XMLUtils.toDOMDocument((String)string, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + assertionIDReference, (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Set getAssertionArtifacts(SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertionArtifacts(sSOToken);
        }
        try {
            return this.stub.getAssertionArtifacts(sSOToken.getTokenID().toString());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertionArtifacts: ", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }

    public Set getAssertions(SSOToken sSOToken) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertions(sSOToken);
        }
        try {
            return this.stub.getAssertions(sSOToken.getTokenID().toString());
        }
        catch (RemoteException remoteException) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertions: ", (Throwable)remoteException);
            }
            throw new SAMLException(remoteException.getMessage());
        }
    }
}

