/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Stats;
import com.iplanet.am.util.StatsListener;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.util.Base64;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.saml.ArtifactStats;
import com.sun.identity.saml.AssertionManagerClient;
import com.sun.identity.saml.AssertionSSOTokenListener;
import com.sun.identity.saml.AssertionStats;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.plugins.ActionMapper;
import com.sun.identity.saml.plugins.AttributeMapper;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.plugins.PartnerSiteAttributeMapper;
import com.sun.identity.saml.plugins.SiteAttributeMapper;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.protocol.AuthenticationQuery;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.saml.protocol.Query;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Element;

public final class AssertionManager {
    public static Stats assStats;
    public static Stats artStats;
    private static AssertionStats assertionStats;
    private static ArtifactStats artifactStats;
    private static String defaultNameIdentifierFormat;
    private static AssertionManager instance;
    private static Map artEntryMap;
    private static Map idEntryMap;
    private static String assertionVersion;
    private static String protocolVersion;
    private static Thread cThread;
    static /* synthetic */ Class class$com$sun$identity$saml$AssertionManager;

    private AssertionManager() {
        idEntryMap = new HashMap();
        artEntryMap = new HashMap();
        try {
            assertionVersion = SystemProperties.get((String)"com.sun.identity.saml.assertion.version");
            protocolVersion = SystemProperties.get((String)"com.sun.identity.saml.protocol.version");
            defaultNameIdentifierFormat = SystemProperties.get((String)"com.sun.identity.saml.nameidentifier.format");
        }
        catch (Exception exception) {
            assertionVersion = "1.0";
            protocolVersion = "1.0";
        }
        if (assStats.isEnabled()) {
            artifactStats = new ArtifactStats(artEntryMap);
            artStats.addStatsListener((StatsListener)artifactStats);
            assertionStats = new AssertionStats(idEntryMap);
            assStats.addStatsListener((StatsListener)assertionStats);
        }
        cThread = new CleanUpThread();
        cThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssertionManager getInstance() throws SAMLException {
        if (instance == null) {
            Class clazz = class$com$sun$identity$saml$AssertionManager == null ? (class$com$sun$identity$saml$AssertionManager = AssertionManager.class$("com.sun.identity.saml.AssertionManager")) : class$com$sun$identity$saml$AssertionManager;
            synchronized (clazz) {
                if (instance == null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Constructing a new instance of AssertionManager");
                    }
                    instance = new AssertionManager();
                }
            }
        }
        return instance;
    }

    public Assertion createAssertion(SSOToken sSOToken) throws SAMLException {
        if (assertionVersion.equals("1.0")) {
            return this.createAssertion(sSOToken, null, "urn:oasis:names:tc:SAML:1.0:cm:artifact-01", 0);
        }
        if (assertionVersion.equals("1.1")) {
            return this.createAssertion(sSOToken, null, SAMLConstants.CONFIRMATION_METHOD_ARTIFACT, 1);
        }
        throw new SAMLException(SAMLUtils.bundle.getString("assertionVersionNotSupport"));
    }

    public Assertion createAssertion(SSOToken sSOToken, List list) throws SAMLException {
        if (assertionVersion.equals("1.0")) {
            return this.createAssertion(sSOToken, list, "urn:oasis:names:tc:SAML:1.0:cm:artifact-01", 0);
        }
        if (assertionVersion.equals("1.1")) {
            return this.createAssertion(sSOToken, list, SAMLConstants.CONFIRMATION_METHOD_ARTIFACT, 1);
        }
        throw new SAMLException(SAMLUtils.bundle.getString("assertionVersionNotSupport"));
    }

    private Assertion createAssertion(SSOToken sSOToken, List list, String string, int n) throws SAMLException {
        if (sSOToken == null) {
            SAMLUtils.debug.error("AssertionManager.createAssertion(id):input SSOToken is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string2 = sSOToken.getTokenID().toString();
        return this.createAssertion(string2, null, null, list, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssertionArtifact createAssertionArtifact(Assertion assertion, String string) throws SAMLException {
        Object object;
        if (assertion == null || string == null || string.length() == 0) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Assertion, String): null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map == null || !map.containsKey(string)) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact:(Assertion, String): destID not in partner list.");
            throw new SAMLException(SAMLUtils.bundle.getString("destIDNotFound"));
        }
        String string2 = SAMLUtils.generateAssertionHandle();
        if (string2 == null) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Assertion,String): couldn't generate assertion handle.");
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        String string3 = (String)SAMLServiceManager.getAttribute("mysiteid");
        AssertionArtifact assertionArtifact = new AssertionArtifact(string3, string2);
        String string4 = assertionArtifact.getAssertionArtifact();
        String string5 = assertion.getAssertionID();
        Entry entry = (Entry)idEntryMap.get(string5);
        if (entry == null && !this.validateNumberOfAssertions(idEntryMap)) {
            entry = new Entry(assertion, string, string4, null);
            try {
                object = idEntryMap;
                synchronized (object) {
                    idEntryMap.put(string5, entry);
                }
            }
            catch (Exception exception) {
                SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Assertion,String): couldn't add to idEntryMap." + exception);
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
            }
            LogUtils.access(Level.FINE, SAMLUtils.bundle.getString("assertionCreated") + ":" + assertion.toString(true, true));
        } else {
            object = entry.getArtifactString();
            if (object != null && artEntryMap.containsKey(object)) {
                SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(Asssertion, String): Artifact exists for the assertion.");
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
            }
            entry.setDestID(string);
            entry.setArtifactString(string4);
        }
        object = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-timeout");
        long l = System.currentTimeMillis() + (long)((Integer)object * 1000);
        try {
            Map map2 = artEntryMap;
            synchronized (map2) {
                artEntryMap.put(string4, new ArtEntry(string5, l));
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtfact(Assertion,String): couldn't add artifact to the artEntryMap", (Throwable)exception);
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionArtifactCreated") + ":" + string4 + " " + SAMLUtils.bundle.getString("forAssertion") + ":" + string5);
        return assertionArtifact;
    }

    public Set getAssertions(SSOToken sSOToken) throws SAMLException {
        if (sSOToken == null) {
            SAMLUtils.debug.error("AssertionManager.getAssertions(SSOToken): input token is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!this.hasTopLevelAdminRole(sSOToken)) {
            SAMLUtils.debug.error("AssertionManager.getAssertions(SSOToken): SSOToken doesn't have the privilege.");
            throw new SAMLException(SAMLUtils.bundle.getString("noPrivilege"));
        }
        return idEntryMap.keySet();
    }

    private boolean hasTopLevelAdminRole(SSOToken sSOToken) {
        block3: {
            try {
                AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
                AMUser aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
                AMRole aMRole = null;
                Set set = aMUser.getRoleDNs();
                if (set == null || set.isEmpty()) break block3;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    aMRole = aMStoreConnection.getRole((String)iterator.next());
                    if (aMRole.getRoleType() != 1) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                if (!SAMLUtils.debug.messageEnabled()) break block3;
                SAMLUtils.debug.message("AssertionManager.hasTopLevelAdminRole:Exception: ", (Throwable)exception);
            }
        }
        return false;
    }

    public Assertion getAssertion(String string) throws SAMLException {
        if (string == null || string.length() == 0) {
            SAMLUtils.debug.error("AssertionManager.getAssetion(String): id is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        AssertionIDReference assertionIDReference = new AssertionIDReference(string);
        return this.getAssertion(assertionIDReference, null, false);
    }

    public Set getAssertionArtifacts(SSOToken sSOToken) throws SAMLException {
        if (sSOToken == null) {
            SAMLUtils.debug.error("AssertionManager.getArtifacts(SSOToken): input token is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!this.hasTopLevelAdminRole(sSOToken)) {
            SAMLUtils.debug.error("AssertionManager.getArtifacts(SSOToken): SSOToken doesn't have the privilege.");
            throw new SAMLException(SAMLUtils.bundle.getString("noPrivilege"));
        }
        return artEntryMap.keySet();
    }

    public Assertion createSSOAssertion(String string, AssertionArtifact assertionArtifact, String string2, String string3, String string4) throws SAMLException {
        List list = null;
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string2);
        if (sOAPEntry != null) {
            try {
                SiteAttributeMapper siteAttributeMapper;
                PartnerSiteAttributeMapper partnerSiteAttributeMapper = sOAPEntry.getPartnerSiteAttributeMapper();
                if (partnerSiteAttributeMapper != null) {
                    list = partnerSiteAttributeMapper.getAttributes(SSOTokenManager.getInstance().createSSOToken(string), string3);
                }
                if ((siteAttributeMapper = sOAPEntry.getSiteAttributeMapper()) != null) {
                    list = siteAttributeMapper.getAttributes(SSOTokenManager.getInstance().createSSOToken(string));
                }
            }
            catch (SSOException sSOException) {
                SAMLUtils.debug.error("AssertionManager.createAssertion(id): exception retrieving info from the SSOToken", (Throwable)sSOException);
                return null;
            }
        }
        if (assertionArtifact == null) {
            if (string4.equals("1.1")) {
                return this.createAssertion(string, assertionArtifact, string2, list, "urn:oasis:names:tc:SAML:1.0:cm:bearer", 1);
            }
            return this.createAssertion(string, assertionArtifact, string2, list, "urn:oasis:names:tc:SAML:1.0:cm:bearer", 0);
        }
        if (string4 == null || string4.equals("1.0")) {
            return this.createAssertion(string, assertionArtifact, string2, list, "urn:oasis:names:tc:SAML:1.0:cm:artifact-01", 0);
        }
        if (string4.equals("1.1")) {
            return this.createAssertion(string, assertionArtifact, string2, list, SAMLConstants.CONFIRMATION_METHOD_ARTIFACT, 1);
        }
        SAMLUtils.debug.error("Input version " + string4 + " is not supported.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion createAssertion(String string, AssertionArtifact assertionArtifact, String string2, List list, String string3, int n) throws SAMLException {
        Assertion assertion;
        block34: {
            Object object;
            Object object2;
            Object object3;
            if (string == null || string.equals("")) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.createAssertion(id):null input.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
            }
            this.validateNumberOfAssertions(idEntryMap);
            String string4 = null;
            Date date = null;
            String string5 = null;
            String string6 = null;
            SSOToken sSOToken = null;
            String string7 = null;
            try {
                object3 = SSOTokenManager.getInstance();
                sSOToken = object3.createSSOToken(string);
                string4 = SAMLServiceManager.getAuthMethodURI(sSOToken.getAuthType());
                date = SAMLUtils.stringToDate(sSOToken.getProperty("authInstant"));
                string5 = sSOToken.getProperty("Organization");
                string6 = sSOToken.getPrincipal().getName();
                try {
                    object2 = sSOToken.getIPAddress();
                    string7 = ((InetAddress)object2).getHostAddress();
                }
                catch (Exception exception) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.createAssertion(id): exception when obtaining client ip: ", (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                SAMLUtils.debug.error("AssertionManager.createAssertion(id): exception retrieving info from the SSOToken: ", (Throwable)exception);
                return null;
            }
            object3 = new NameIdentifier(string6, string5, defaultNameIdentifierFormat);
            object2 = null;
            String string8 = null;
            if (string3 != null && string3.length() > 0) {
                object2 = new SubjectConfirmation(string3);
            } else if (assertionArtifact != null) {
                string3 = n == 0 ? "urn:oasis:names:tc:SAML:1.0:cm:artifact-01" : SAMLConstants.CONFIRMATION_METHOD_ARTIFACT;
                object2 = new SubjectConfirmation(string3);
            } else {
                object2 = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
            }
            if (assertionArtifact != null) {
                string8 = assertionArtifact.getAssertionArtifact();
            }
            Subject subject = new Subject((NameIdentifier)object3, (SubjectConfirmation)object2);
            SubjectLocality subjectLocality = null;
            if (string7 != null && string7.length() != 0) {
                subjectLocality = new SubjectLocality(string7, null);
            }
            HashSet<SubjectStatement> hashSet = new HashSet<SubjectStatement>();
            hashSet.add(new AuthenticationStatement(string4, date, subject, subjectLocality, null));
            if (list != null && !list.isEmpty()) {
                hashSet.add(new AttributeStatement(subject, list));
            }
            Date date2 = new Date();
            Integer n2 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-notbefore-timeskew");
            long l = n2 * 1000;
            Date date3 = new Date(date2.getTime() - l);
            Integer n3 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-timeout");
            long l2 = n3 * 1000;
            Date date4 = new Date(date2.getTime() + l2);
            Conditions conditions = new Conditions(date3, date4);
            String string9 = (String)SAMLServiceManager.getAttribute("mysitename");
            assertion = new Assertion(null, string9, date2, conditions, hashSet);
            assertion.setMinorVersion(n);
            String string10 = assertion.getAssertionID();
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
                assertion.signXML();
            }
            Entry entry = new Entry(assertion, string2, string8, sSOToken);
            try {
                object = idEntryMap;
                synchronized (object) {
                    idEntryMap.put(string10, entry);
                }
            }
            catch (Exception exception) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager: couldn't add to idEntryMap.", (Throwable)exception);
                }
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
            }
            if (LogUtils.isLoggable(Level.FINER)) {
                LogUtils.access(Level.FINER, SAMLUtils.bundle.getString("assertionCreated") + ":" + assertion.toString(true, true));
            } else {
                LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionCreated") + ":" + string10);
            }
            if (string8 != null) {
                object = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-timeout");
                l2 = (Integer)object * 1000;
                try {
                    Map map = artEntryMap;
                    synchronized (map) {
                        artEntryMap.put(string8, new ArtEntry(string10, System.currentTimeMillis() + l2));
                    }
                }
                catch (Exception exception) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager: couldn't add artifact to the artEntryMap.", (Throwable)exception);
                    }
                    throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
                }
                LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionArtifactCreated") + ":" + string8 + " " + SAMLUtils.bundle.getString("forAssertion") + ":" + string10);
            }
            if (sSOToken == null) break block34;
            object = new AssertionSSOTokenListener(string10, string8);
            try {
                sSOToken.addSSOTokenListener((SSOTokenListener)object);
            }
            catch (SSOException sSOException) {
                SAMLUtils.debug.error("AssertionManager.createAssertion(id): Couldn't add listener to token:", (Throwable)sSOException);
            }
        }
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteAssertion(String string, String string2) {
        ArtEntry artEntry = null;
        if (string2 != null) {
            artEntry = (ArtEntry)artEntryMap.remove(string2);
            LogUtils.access(Level.FINE, SAMLUtils.bundle.getString("assertionArtifactRemoved") + ":" + string2);
        }
        if (string != null) {
            Entry entry = null;
            entry = (Entry)idEntryMap.remove(string);
            if (entry != null) {
                String string3;
                LogUtils.access(Level.FINE, SAMLUtils.bundle.getString("assertionRemoved") + ":" + string);
                if (string2 == null && (string3 = entry.getArtifactString()) != null) {
                    Map map = artEntryMap;
                    synchronized (map) {
                        artEntryMap.remove(string3);
                    }
                    LogUtils.access(Level.FINE, SAMLUtils.bundle.getString("assertionArtifactRemoved") + ":" + string3);
                }
            }
        } else if (artEntry != null && SAMLServiceManager.getRemoveAssertion()) {
            Map map = idEntryMap;
            synchronized (map) {
                idEntryMap.remove(artEntry.getAssertionID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAssertion(AssertionArtifact assertionArtifact, Set set, boolean bl) throws SAMLException {
        Object object;
        Object object2;
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("getAssertion(arti): destID set= " + Base64.encode((byte[])SAMLUtils.stringToByteArray((String)set.iterator().next())));
        }
        String string = assertionArtifact.getAssertionArtifact();
        String string2 = SAMLUtils.getServerURL(assertionArtifact.getAssertionHandle());
        if (string2 != null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid: calling another server in lb site:" + string2);
            }
            AssertionManagerClient assertionManagerClient = new AssertionManagerClient(SAMLUtils.getFullServiceURL(string2));
            return assertionManagerClient.getAssertion(assertionArtifact, set);
        }
        String string3 = null;
        long l = 0L;
        try {
            object2 = (ArtEntry)artEntryMap.get(string);
            if (object2 == null) {
                throw new SAMLException();
            }
            string3 = ((ArtEntry)object2).getAssertionID();
            if (string3 == null) {
                throw new SAMLException();
            }
            l = ((ArtEntry)object2).getExpireTime();
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no AssertionID found corresponding to artifact.", (Throwable)exception);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        if (System.currentTimeMillis() > l) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): artifact timed out.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("artifactTimedOut"));
        }
        object2 = null;
        try {
            object2 = (Entry)idEntryMap.get(string3);
            if (object2 == null) {
                throw new SAMLException();
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no Entry found corresponding to artifact.", (Throwable)exception);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        if (bl) {
            object = ((Entry)object2).getDestID();
            if (object == null) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no destID found corresponding to artifact.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("noDestIDMatchingArtifact"));
            }
            if (set == null || !set.contains(object)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): destinationID doesn't match.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("destIDNotMatch"));
            }
        }
        if ((object = ((Entry)object2).getAssertion()) == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(art, destid): no Assertion found corresponding to aID.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        Map map = artEntryMap;
        synchronized (map) {
            artEntryMap.remove(string);
        }
        LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionArtifactVerified") + ":" + string);
        if (SAMLServiceManager.getRemoveAssertion()) {
            Map map2 = idEntryMap;
            synchronized (map2) {
                idEntryMap.remove(string3);
            }
        }
        if (!((Assertion)object).isTimeValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: assertion " + string3 + " is expired.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("assertionTimeNotValid"));
        }
        return object;
    }

    public Assertion getAssertion(AssertionArtifact assertionArtifact, String string) throws SAMLException {
        if (assertionArtifact == null || string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: input is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        return this.getAssertion(assertionArtifact, hashSet, true);
    }

    public Assertion getAssertion(AssertionArtifact assertionArtifact, Set set) throws SAMLException {
        if (assertionArtifact == null || set == null || set.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: input is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.getAssertion(assertionArtifact, set, true);
    }

    protected Assertion getAssertion(AssertionArtifact assertionArtifact) throws SAMLException {
        if (assertionArtifact == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: input is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.getAssertion(assertionArtifact, null, false);
    }

    public Assertion getAssertion(Query query, String string) throws SAMLException {
        if (query == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion: input query is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        Assertion assertion = null;
        int n = query.getQueryType();
        if (n == 0) {
            assertion = this.getAuthenticationAssertion((AuthenticationQuery)query, string);
        } else if (n == 1) {
            assertion = this.getAuthorizationDecisionAssertion((AuthorizationDecisionQuery)query, string);
        } else if (n == 2) {
            assertion = this.getAttributeAssertion((AttributeQuery)query, string);
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion: this type of query is not supported:" + n);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("queryNotSupported"));
        }
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAttributeAssertion(AttributeQuery attributeQuery, String string) throws SAMLException {
        String string2;
        Assertion assertion;
        block35: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (attributeQuery == null) {
                return null;
            }
            if (string == null || string.length() == 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: missing destID.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("missingDestID"));
            }
            this.validateNumberOfAssertions(idEntryMap);
            Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (map == null) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: empty partner URL list.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("emptyPartnerURLList"));
            }
            SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string);
            AttributeMapper attributeMapper = null;
            if (sOAPEntry == null || (attributeMapper = sOAPEntry.getAttributeMapper()) == null) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: couldn't obtain AttributeMapper.");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("errorObtainAttributeMapper"));
            }
            Subject subject = attributeQuery.getSubject();
            String string3 = attributeMapper.getSSOTokenID(attributeQuery);
            SSOToken sSOToken = null;
            String string4 = (String)SAMLServiceManager.getAttribute("mysitename");
            if (string3 != null) {
                try {
                    object5 = SSOTokenManager.getInstance();
                    sSOToken = object5.createSSOToken(string3);
                }
                catch (Exception exception) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: invalid SSO token:", (Throwable)exception);
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("invalidSSOToken"));
                }
            } else {
                object5 = attributeMapper.getSSOAssertion(attributeQuery);
                if (object5 == null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: couldn't find SSOAssertion in query.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("noSSOAssertion"));
                }
                if (!((Assertion)object5).isSignatureValid()) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: SSOAssertion is signature invalid.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("assertionSignatureNotValid"));
                }
                if (!((Assertion)object5).isTimeValid()) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: SSOAssertion is time invalid.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("assertionTimeNotValid"));
                }
                object4 = ((Assertion)object5).getStatement().iterator();
                object3 = null;
                object2 = null;
                while (object4.hasNext()) {
                    object3 = (Statement)object4.next();
                    if (((Statement)object3).getStatementType() != 1) continue;
                    object2 = ((AuthenticationStatement)object3).getSubject();
                    break;
                }
                if (object2 == null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttributeAssertion: missing AuthenticationStatement in SSOAssertion.");
                    }
                    throw new SAMLException(SAMLUtils.bundle.getString("noAuthNStatement"));
                }
                object = ((Assertion)object5).getIssuer();
                String string5 = ((Assertion)object5).getAssertionID();
                if (string4 != null && string4.equals(object) && SAMLUtils.getServerURL(string5) == null) {
                    Entry entry;
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttrAssertion:this server is the issuer.");
                    }
                    if ((entry = (Entry)idEntryMap.get(string5)) != null && (sSOToken = entry.getSSOToken()) != null) {
                        this.verifySSOTokenAndNI(sSOToken, ((Subject)object2).getNameIdentifier());
                    }
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager.getAttrAssertion:this server is not the issuer.");
                    }
                    sSOToken = this.checkAssertionAndCreateSSOToken((Assertion)object5, null, (Subject)object2);
                }
            }
            object5 = attributeMapper.getAttributes(attributeQuery, string, sSOToken);
            if (object5 == null || object5.size() == 0) {
                return null;
            }
            object4 = new HashSet();
            object4.add(new AttributeStatement(subject, (List)object5));
            object3 = new Date();
            object2 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-timeout");
            object = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-notbefore-timeskew");
            long l = (Integer)object * 1000;
            Date date = new Date(((Date)object3).getTime() - l);
            long l2 = (Integer)object2 * 1000;
            Date date2 = new Date(((Date)object3).getTime() + l2);
            Conditions conditions = new Conditions(date, date2);
            assertion = new Assertion(null, string4, (Date)object3, conditions, (Set)object4);
            if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
                assertion.signXML();
            }
            string2 = assertion.getAssertionID();
            Entry entry = new Entry(assertion, string, null, null);
            try {
                Map map2 = idEntryMap;
                synchronized (map2) {
                    idEntryMap.put(string2, entry);
                }
            }
            catch (Exception exception) {
                if (!SAMLUtils.debug.messageEnabled()) break block35;
                SAMLUtils.debug.message("AssertionManager.getAttributeAssertion couldn't add assertion to the idEntryMap.", (Throwable)exception);
            }
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            LogUtils.access(Level.FINER, SAMLUtils.bundle.getString("assertionCreated") + ":" + assertion.toString(true, true));
        } else {
            LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionCreated") + ":" + string2);
        }
        return assertion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAuthenticationAssertion(AuthenticationQuery authenticationQuery, String string) throws SAMLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (authenticationQuery == null) {
            return null;
        }
        this.validateNumberOfAssertions(idEntryMap);
        Subject subject = authenticationQuery.getSubject();
        SubjectConfirmation subjectConfirmation = subject.getSubjectConfirmation();
        if (subjectConfirmation == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: missing SubjectConfirmation.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("missingSubjectConfirmation"));
        }
        if (!SAMLUtils.isCorrectConfirmationMethod(subjectConfirmation)) {
            throw new SAMLException(SAMLUtils.bundle.getString("wrongConfirmationMethodValue"));
        }
        Element element = subjectConfirmation.getSubjectConfirmationData();
        if (element == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: missing SubjectConfirmationData in the Subject.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("missingSubjectConfirmationData"));
        }
        String string2 = null;
        Date date = null;
        String string3 = null;
        String string4 = null;
        SSOToken sSOToken = null;
        String string5 = null;
        try {
            object4 = SSOTokenManager.getInstance();
            sSOToken = object4.createSSOToken(XMLUtils.getElementString((Element)element));
            string2 = SAMLServiceManager.getAuthMethodURI(sSOToken.getAuthType());
            date = SAMLUtils.stringToDate(sSOToken.getProperty("authInstant"));
            string3 = sSOToken.getProperty("Organization");
            string4 = sSOToken.getPrincipal().getName();
            try {
                object3 = sSOToken.getIPAddress();
                string5 = ((InetAddress)object3).getHostAddress();
            }
            catch (Exception exception) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: exception when getting client ip:", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: exception retrieving info from the SSOToken:", (Throwable)exception);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongSubjectConfirmationData"));
        }
        if ((object4 = subject.getNameIdentifier()) != null) {
            object3 = ((NameIdentifier)object4).getName();
            object2 = ((NameIdentifier)object4).getNameQualifier();
            if (object3 != null && !((String)object3).equalsIgnoreCase(string4) || object2 != null && !((String)object2).equalsIgnoreCase(string3)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: NameIdentifier is different from info in SubjectConfirmation");
                }
                throw new SAMLException(SAMLUtils.bundle.getString("wrongNameIdentifier"));
            }
        }
        if ((object3 = authenticationQuery.getAuthenticationMethod()) != null && ((String)object3).length() != 0 && !((String)object3).equalsIgnoreCase(string2)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: couldn't form an assertion matching the AuthenticationMethod in the query.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("authenticationMethodInQueryNotMatch"));
        }
        object2 = null;
        if (string5 != null && string5.length() != 0) {
            object2 = new SubjectLocality(string5, null);
        }
        AuthenticationStatement authenticationStatement = new AuthenticationStatement(string2, date, subject, (SubjectLocality)object2, null);
        Date date2 = new Date();
        Integer n = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-timeout");
        long l = n * 1000;
        Date date3 = new Date(date2.getTime() + l);
        Integer n2 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-notbefore-timeskew");
        long l2 = n2 * 1000;
        Date date4 = new Date(date2.getTime() - l2);
        Conditions conditions = new Conditions(date4, date3);
        String string6 = (String)SAMLServiceManager.getAttribute("mysitename");
        HashSet<AuthenticationStatement> hashSet = new HashSet<AuthenticationStatement>();
        hashSet.add(authenticationStatement);
        Assertion assertion = new Assertion(null, string6, date2, conditions, hashSet);
        if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
            assertion.signXML();
        }
        String string7 = assertion.getAssertionID();
        Entry entry = new Entry(assertion, string, null, sSOToken);
        try {
            object = idEntryMap;
            synchronized (object) {
                idEntryMap.put(string7, entry);
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthNAssertion: couldn't add assertion to the idEntryMap.", (Throwable)exception);
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        if (LogUtils.isLoggable(Level.FINER)) {
            LogUtils.access(Level.FINER, SAMLUtils.bundle.getString("assertionCreated") + ":" + assertion.toString(true, true));
        } else {
            LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionCreated") + ":" + string7);
        }
        object = new AssertionSSOTokenListener(string7);
        try {
            sSOToken.addSSOTokenListener((SSOTokenListener)object);
        }
        catch (SSOException sSOException) {
            SAMLUtils.debug.error("AssertionManager.getAuthNAssertion: Couldn't add listener to token:", (Throwable)sSOException);
        }
        return assertion;
    }

    private Assertion getAuthorizationDecisionAssertion(AuthorizationDecisionQuery authorizationDecisionQuery, String string) throws SAMLException {
        return this.getAuthorizationDecisionAssertion(authorizationDecisionQuery, string, true);
    }

    private Assertion getAuthorizationDecisionAssertion(AuthorizationDecisionQuery authorizationDecisionQuery, String string, boolean bl) throws SAMLException {
        Object object;
        if (authorizationDecisionQuery == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: missing destID.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("missingDestID"));
        }
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: empty partnerURL list.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("emptyPartnerURLList"));
        }
        SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(string);
        ActionMapper actionMapper = null;
        if (sOAPEntry == null || (actionMapper = sOAPEntry.getActionMapper()) == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: couldn't obtain ActionMapper.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("errorObtainActionMapper"));
        }
        Subject subject = authorizationDecisionQuery.getSubject();
        NameIdentifier nameIdentifier = subject.getNameIdentifier();
        SSOToken sSOToken = null;
        boolean bl2 = true;
        String string2 = actionMapper.getSSOTokenID(authorizationDecisionQuery);
        if (string2 != null) {
            try {
                object = SSOTokenManager.getInstance();
                sSOToken = object.createSSOToken(string2);
            }
            catch (Exception exception) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: invalid SSO token:", (Throwable)exception);
                }
                throw new SAMLException(SAMLUtils.bundle.getString("invalidSSOToken"));
            }
            this.verifySSOTokenAndNI(sSOToken, nameIdentifier);
        } else {
            Map map2;
            object = actionMapper.getSSOAssertion(authorizationDecisionQuery, string);
            if (object != null && (sSOToken = (SSOToken)(map2 = this.verifyAssertionAndGetSSOToken(subject, (Assertion)object)).get("true")) == null) {
                bl2 = false;
                sSOToken = (SSOToken)map2.get("false");
            }
        }
        if (sSOToken == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: Couldn't obtain ssotoken.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        object = actionMapper.getAuthorizationDecisions(authorizationDecisionQuery, sSOToken, string);
        return this.getAuthorizationDecisionAssertion(authorizationDecisionQuery, string, true, sSOToken, bl2, (Map)object);
    }

    private Map verifyAssertionAndGetSSOToken(Subject subject, Assertion assertion) throws SAMLException {
        if (subject == null || assertion == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: null input.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (!assertion.isSignatureValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: SSOAssertion is signature invalid.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("assertionSignatureNotValid"));
        }
        if (!assertion.isTimeValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: SSOAssertion is time invalid.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("assertionTimeNotValid"));
        }
        HashMap<String, SSOToken> hashMap = new HashMap<String, SSOToken>();
        SSOToken sSOToken = null;
        String string = (String)SAMLServiceManager.getAttribute("mysitename");
        String string2 = assertion.getIssuer();
        String string3 = assertion.getAssertionID();
        if (string != null && string.equals(string2) && SAMLUtils.getServerURL(string3) == null) {
            Entry entry;
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion:this server is the issuer.");
            }
            if ((entry = (Entry)idEntryMap.get(string3)) != null && (sSOToken = entry.getSSOToken()) != null) {
                this.verifySSOTokenAndNI(sSOToken, subject.getNameIdentifier());
                hashMap.put("true", sSOToken);
                return hashMap;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken: either not an AuthN assertion or token is not for this subject.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionManager.getAuthZAssertion:this server is not the issuer.");
        }
        Iterator iterator = assertion.getStatement().iterator();
        Statement statement = null;
        AuthenticationStatement authenticationStatement = null;
        while (iterator.hasNext()) {
            statement = (Statement)iterator.next();
            if (statement.getStatementType() != 1) continue;
            authenticationStatement = (AuthenticationStatement)statement;
            break;
        }
        if (authenticationStatement == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAssertionAndGetSSOToken:  missing AuthenticationStatement in SSOAssertion.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noAuthNStatement"));
        }
        sSOToken = this.checkAssertionAndCreateSSOToken(assertion, (AuthenticationStatement)statement, subject);
        hashMap.put("false", sSOToken);
        return hashMap;
    }

    private void verifySSOTokenAndNI(SSOToken sSOToken, NameIdentifier nameIdentifier) throws SAMLException {
        String string = null;
        String string2 = null;
        try {
            string = sSOToken.getPrincipal().getName();
            string2 = sSOToken.getProperty("Organization");
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifySSOTokenAndNI: SSOToken is not valid.", (Throwable)exception);
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (nameIdentifier == null) {
            return;
        }
        String string3 = nameIdentifier.getName();
        String string4 = nameIdentifier.getNameQualifier();
        if (string3 != null && !string3.equalsIgnoreCase(string) || string4 != null && !string4.equalsIgnoreCase(string2)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifySSOTokenAndNI: NameIdentifier is different from info in token.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("wrongNameIdentifier"));
        }
    }

    private SSOToken checkAssertionAndCreateSSOToken(Assertion assertion, AuthenticationStatement authenticationStatement, Subject subject) throws SAMLException {
        String string = assertion.getIssuer();
        SAMLServiceManager.SOAPEntry sOAPEntry = SAMLUtils.getSourceSite(string);
        if (sOAPEntry == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.checkAssertionAndCreateSSOToken: issuer is not on the partnerURL list.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        if (!(authenticationStatement == null || subject != null && subject.equals(authenticationStatement.getSubject()))) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.verifyAndGetSSOToken: wrong subject in evidence.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("cannotVerifySubject"));
        }
        return this.createTempSSOToken(assertion, subject, sOAPEntry);
    }

    private SSOToken createTempSSOToken(Assertion assertion, Subject subject, SAMLServiceManager.SOAPEntry sOAPEntry) throws SAMLException {
        Map map;
        ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
        arrayList.add(assertion);
        String string = sOAPEntry.getSourceID();
        String string2 = null;
        String string3 = null;
        PartnerAccountMapper partnerAccountMapper = sOAPEntry.getPartnerAccountMapper();
        if (partnerAccountMapper != null) {
            map = partnerAccountMapper.getUser(arrayList, string, null);
            string2 = (String)map.get("name");
            string3 = (String)map.get("org");
        } else {
            map = sOAPEntry.getAccountMapper().getUser(subject, string);
            string3 = (String)map.get("org");
            string2 = (String)map.get("name");
        }
        if (string3 == null || string2 == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createTempSSOToken: couldn't map the subject to a local user.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("cannotMapSubject"));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionManager.createTempSSOToken: org = " + string3 + ", name = " + string2);
        }
        map = null;
        SessionService sessionService = SessionService.getSessionService();
        if (sessionService == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createTempSSOToken: fail to get SessionService");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        map = sessionService.newInternalSession(string3, null);
        if (map == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createTempSSOToken: fail to create internal session");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        map.setType(0);
        map.setClientID(string2);
        map.setClientDomain(string3);
        map.putProperty("Principal", string2);
        map.setMaxSessionTime(1L);
        map.setMaxIdleTime(1L);
        if (!map.activate(string2)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createTempSSOToken: fail to create internal session");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(map.getID().toString());
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManger.createTempSSOToken: Couldn't retrieve the ssotoken.", (Throwable)exception);
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
        }
        return sSOToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Assertion getAuthorizationDecisionAssertion(AuthorizationDecisionQuery authorizationDecisionQuery, String string, boolean bl, SSOToken sSOToken, boolean bl2, Map map) throws SAMLException {
        int n;
        if (map == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: actionMap from ActionMapper is null.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("nullAuthZDecision"));
        }
        this.validateNumberOfAssertions(idEntryMap);
        List list = null;
        list = (List)map.get("Permit");
        if (list != null) {
            n = 1;
        } else {
            list = (List)map.get("Deny");
            if (list != null) {
                n = 2;
            } else {
                list = (List)map.get("Indeterminate");
                if (list == null) {
                    list = authorizationDecisionQuery.getAction();
                }
                n = 3;
            }
        }
        AuthorizationDecisionStatement authorizationDecisionStatement = new AuthorizationDecisionStatement(authorizationDecisionQuery.getSubject(), authorizationDecisionQuery.getResource(), n, list, authorizationDecisionQuery.getEvidence());
        Date date = new Date();
        Integer n2 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-timeout");
        long l = n2 * 1000;
        Date date2 = new Date(date.getTime() + l);
        Integer n3 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-notbefore-timeskew");
        long l2 = n3 * 1000;
        Date date3 = new Date(date.getTime() - l2);
        Conditions conditions = new Conditions(date3, date2);
        String string2 = (String)SAMLServiceManager.getAttribute("mysitename");
        HashSet<AuthorizationDecisionStatement> hashSet = new HashSet<AuthorizationDecisionStatement>();
        hashSet.add(authorizationDecisionStatement);
        Assertion assertion = new Assertion(null, string2, date, conditions, hashSet);
        if (((Boolean)SAMLServiceManager.getAttribute("iplanet-am-saml-signassertion")).booleanValue()) {
            assertion.signXML();
        }
        String string3 = assertion.getAssertionID();
        if (bl) {
            Object object;
            Entry entry = null;
            if (bl2) {
                object = new AssertionSSOTokenListener(string3);
                try {
                    sSOToken.addSSOTokenListener((SSOTokenListener)object);
                }
                catch (SSOException sSOException) {
                    SAMLUtils.debug.error("AssertionManager.getAuthNAssertion: Couldn't get listener to token:", (Throwable)sSOException);
                }
            }
            entry = new Entry(assertion, string, null, null);
            try {
                object = idEntryMap;
                synchronized (object) {
                    idEntryMap.put(string3, entry);
                }
            }
            catch (Exception exception) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("AssertionManager.getAuthZAssertion: couldn't add assertion to the idAssertionMap.", (Throwable)exception);
                }
                throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateAssertion"));
            }
            if (LogUtils.isLoggable(Level.FINER)) {
                LogUtils.access(Level.FINER, SAMLUtils.bundle.getString("assertionCreated") + ":" + assertion.toString(true, true));
            } else {
                LogUtils.access(Level.INFO, SAMLUtils.bundle.getString("assertionCreated") + ":" + string3);
            }
        }
        return assertion;
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference) throws SAMLException {
        return this.getAssertion(assertionIDReference, null, false);
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, SSOToken sSOToken) throws SAMLException {
        if (sSOToken == null) {
            SAMLUtils.debug.error("AssertionManager.getAssertion(idRef, token): input token is null.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!this.hasTopLevelAdminRole(sSOToken)) {
            SAMLUtils.debug.error("AssertionManager.getAssertion(idRef, token): SSOToken doesn't have the privilege.");
            throw new SAMLException(SAMLUtils.bundle.getString("noPrivilege"));
        }
        return this.getAssertion(assertionIDReference, null, true);
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, String string) throws SAMLException {
        if (string == null) {
            return this.getAssertion(assertionIDReference, null, false);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        return this.getAssertion(assertionIDReference, hashSet, false);
    }

    public Assertion getAssertion(AssertionIDReference assertionIDReference, Set set) throws SAMLException {
        return this.getAssertion(assertionIDReference, set, false);
    }

    private Assertion getAssertion(AssertionIDReference assertionIDReference, Set set, boolean bl) throws SAMLException {
        String string;
        Object object;
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("getAssertion(idRef): destID set=" + set);
        }
        if (assertionIDReference == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionIDRef): null AssertionID.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string2 = assertionIDReference.getAssertionIDReference();
        if (!bl && (object = SAMLUtils.getServerURL(string2)) != null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(idRef): calling another server in lb site:" + (String)object);
            }
            AssertionManagerClient assertionManagerClient = new AssertionManagerClient(SAMLUtils.getFullServiceURL((String)object));
            return assertionManagerClient.getAssertion(assertionIDReference, set);
        }
        object = (Entry)idEntryMap.get(string2);
        if (object == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionIDRef): no matching assertion found in idEntryMap.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        Assertion assertion = ((Entry)object).getAssertion();
        if (assertion == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionIDRef): no matching assertion found.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("noMatchingAssertion"));
        }
        if (!(bl || (string = ((Entry)object).getDestID()) == null || set != null && set.contains(string))) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.getAssertion(AssertionID): destID doesn't match.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("destIDNotMatch"));
        }
        if (!assertion.isTimeValid()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: assertion " + string2 + " is expired.");
            }
            throw new SAMLException("assertionTimeNotValid");
        }
        return assertion;
    }

    public AssertionArtifact createAssertionArtifact(String string, String string2) throws SAMLException {
        return this.createAssertionArtifact(string, string2, null, null);
    }

    public AssertionArtifact createAssertionArtifact(String string, String string2, String string3, String string4) throws SAMLException {
        if (string == null || string2 == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager: null input for method createAssertionArtifact.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (map == null || !map.containsKey(string2)) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact:(String, String): destID not in partner list.");
            throw new SAMLException(SAMLUtils.bundle.getString("destIDNotFound"));
        }
        String string5 = SAMLUtils.generateAssertionHandle();
        if (string5 == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManager.createAssertionArtifact: couldn't generate assertion handle.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        String string6 = (String)SAMLServiceManager.getAttribute("mysiteid");
        AssertionArtifact assertionArtifact = new AssertionArtifact(string6, string5);
        Assertion assertion = this.createSSOAssertion(string, assertionArtifact, string2, string3, string4);
        try {
            StringTokenizer stringTokenizer;
            if (string4 != null && (stringTokenizer = new StringTokenizer(string4, ".")).countTokens() == 2) {
                assertion.setMajorVersion(Integer.parseInt(stringTokenizer.nextToken().trim()));
                assertion.setMinorVersion(Integer.parseInt(stringTokenizer.nextToken().trim()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAMLException(numberFormatException.getMessage());
        }
        return assertionArtifact;
    }

    public int isAllowed(AuthorizationDecisionQuery authorizationDecisionQuery, String string) {
        if (authorizationDecisionQuery == null) {
            SAMLUtils.debug.error("AssertionManager.isAllowed: null input.");
            return 3;
        }
        Assertion assertion = null;
        try {
            assertion = this.getAuthorizationDecisionAssertion(authorizationDecisionQuery, string, false);
        }
        catch (SAMLException sAMLException) {
            SAMLUtils.debug.error("AssertionManager.isAllowed: exception thrown when trying to get an assertion from authZQuery. ", (Throwable)sAMLException);
            return 3;
        }
        if (assertion == null) {
            return 3;
        }
        Set set = assertion.getStatement();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (statement.getStatementType() != 2) continue;
                return ((AuthorizationDecisionStatement)statement).getDecision();
            }
            SAMLUtils.debug.error("AssertionManager.isAllowed: no authZstatement in assertion.");
            return 3;
        }
        SAMLUtils.debug.error("AssertionManager.isAllowed: no statements in assertion.");
        return 3;
    }

    boolean validateNumberOfAssertions(Map map) throws SAMLResponderException {
        Integer n = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-max-number");
        int n2 = n;
        if (n2 != 0 && map.size() > n2) {
            SAMLUtils.debug.error("AssertionManager.createAssertionArtifact(assertion,String): reached maxNumber of assertions.");
            throw new SAMLResponderException(SAMLUtils.bundle.getString("errorCreateArtifact"));
        }
        return false;
    }

    boolean removeAssertion(Assertion assertion) {
        if (assertion.getConditions() != null) {
            return !assertion.isTimeValid();
        }
        long l = System.currentTimeMillis();
        Integer n = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-notbefore-timeskew");
        long l2 = n * 1000;
        Date date = assertion.getIssueInstant();
        Date date2 = new Date(date.getTime() - l2);
        Integer n2 = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-assertion-timeout");
        long l3 = n2 * 1000;
        Date date3 = new Date(date.getTime() + l3);
        return l < date2.getTime() || l >= date3.getTime();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        defaultNameIdentifierFormat = null;
        assStats = Stats.getInstance((String)"amAssertionMap");
        artStats = Stats.getInstance((String)"amArtifactMap");
        instance = null;
        artEntryMap = null;
        idEntryMap = null;
        assertionVersion = null;
        protocolVersion = null;
        cThread = null;
    }

    private class CleanUpThread
    extends Thread {
        private CleanUpThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator<Object> iterator = null;
            Integer n = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-cleanup-interval");
            long l = n * 1000;
            String string = null;
            Entry entry = null;
            ArtEntry artEntry = null;
            Assertion assertion = null;
            HashSet<String> hashSet = null;
            while (true) {
                long l2 = System.currentTimeMillis();
                SAMLUtils.debug.message("Clean up thread wakes up..");
                hashSet = new HashSet<String>();
                Map map = artEntryMap;
                synchronized (map) {
                    iterator = artEntryMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        artEntry = (ArtEntry)artEntryMap.get(string);
                        if (artEntry == null || artEntry.getExpireTime() > l2) continue;
                        hashSet.add(string);
                    }
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager::CleanUpThread::artifacts to be removed:" + hashSet.size());
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        AssertionManager.this.deleteAssertion(null, (String)iterator.next());
                    }
                }
                Map map2 = idEntryMap;
                synchronized (map2) {
                    iterator = idEntryMap.keySet().iterator();
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager::CleanUpThread::number of assertions in IdEntryMap:" + idEntryMap.size());
                    }
                    hashSet = new HashSet();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        entry = (Entry)idEntryMap.get(string);
                        if (entry == null || (assertion = entry.getAssertion()) == null || !AssertionManager.this.removeAssertion(assertion)) continue;
                        hashSet.add(string);
                    }
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AssertionManager::CleanUpThread::assertions to be removed from IdEntryMap:" + hashSet.size());
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        AssertionManager.this.deleteAssertion((String)iterator.next(), null);
                    }
                }
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (Exception exception) {
                    if (!SAMLUtils.debug.messageEnabled()) continue;
                    SAMLUtils.debug.message("CleanUpThread::run", (Throwable)exception);
                    continue;
                }
                break;
            }
        }
    }

    private class ArtEntry {
        private String aID = null;
        private long expiretime = 0L;

        public ArtEntry(String string, long l) {
            this.aID = string;
            this.expiretime = l;
        }

        public String getAssertionID() {
            return this.aID;
        }

        public long getExpireTime() {
            return this.expiretime;
        }
    }

    private class Entry {
        private String destID = null;
        private String artString = null;
        private SSOToken token = null;
        private Assertion assertion = null;

        public Entry(Assertion assertion, String string, String string2, SSOToken sSOToken) {
            this.assertion = assertion;
            this.destID = string;
            this.artString = string2;
            this.token = sSOToken;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public String getDestID() {
            return this.destID;
        }

        public void setDestID(String string) {
            this.destID = string;
        }

        public String getArtifactString() {
            return this.artString;
        }

        public void setArtifactString(String string) {
            this.artString = string;
        }

        public SSOToken getSSOToken() {
            return this.token;
        }
    }
}

