/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.util;

import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.L10NMessageImpl;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.ProxyPolicyEvaluator;
import com.sun.identity.policy.ProxyPolicyEvaluatorFactory;
import com.sun.identity.policy.util.AuthServiceConfigInfo;
import com.sun.identity.policy.util.GatewayServletUtils;
import com.sun.identity.sm.ServiceConfigManager;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Gateway
extends HttpServlet {
    ServletConfig config = null;
    private static final String GOTO_URL = "goto";
    private static final String LOGIN_URL = "/UI/Login";
    private static final String DEFAULT_MODULE = "module=LDAP";
    private static final String AUTH_LEVEL_ADVICE = "AuthLevelConditionAdvice";
    private static final String AUTH_SCHEME_ADVICE = "AuthSchemeConditionAdvice";
    private static final String ORG_NAME = "org";
    private static final String AUTH_SCHEME = "module";
    private static final String AUTH_LEVEL = "authlevel";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String ALLOW = "allow";
    private static final String CERT_PROTOCOL = "https://";
    private static final String CERT_SCHEME = "Cert";
    private static final String WEB_AGENT_SERVICE_NAME = "iPlanetAMWebAgentService";
    private static final String CERT_SERVICE_NAME = "iPlanetAMAuthCertService";
    private static Debug debug = Debug.getInstance((String)"amGateway");
    private static AuthD authD;
    private static SSOTokenManager defTokenMgr;
    private static SSOToken defToken;
    private static ProxyPolicyEvaluator pe;
    private static HashMap gwServletUtilsMap;
    private static HashSet authenticators;
    private static Set actionNames;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.config = servletConfig;
        try {
            String string;
            gwServletUtilsMap = new HashMap();
            authD = AuthD.getAuth();
            defToken = authD.getSSOAuthSession();
            defTokenMgr = SSOTokenManager.getInstance();
            Iterator iterator = authD.getAuthenticators();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                authenticators.add(string);
            }
            string = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
            this.initGWServletUtilsMap(string);
            actionNames.add(GET);
            actionNames.add(POST);
            pe = ProxyPolicyEvaluatorFactory.getInstance().getProxyPolicyEvaluator(defToken, WEB_AGENT_SERVICE_NAME);
        }
        catch (Exception exception) {
            debug.error("GatewayServlet: Unable to create PolicyEvaluator", (Throwable)exception);
            throw new ServletException(exception.getMessage());
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Object object;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ActionDecision actionDecision = null;
        Map map = null;
        String string5 = null;
        try {
            RequestUtils.checkContentLength((HttpServletRequest)httpServletRequest);
        }
        catch (L10NMessageImpl l10NMessageImpl) {
            ISLocaleContext iSLocaleContext = new ISLocaleContext();
            iSLocaleContext.setLocale(httpServletRequest);
            Locale locale = iSLocaleContext.getLocale();
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: " + l10NMessageImpl.getL10NMessage(locale));
            }
            throw new ServletException(l10NMessageImpl.getL10NMessage(locale));
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(LOGIN_URL);
        String string6 = httpServletRequest.getQueryString();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (string6 != null && enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).equalsIgnoreCase(GOTO_URL)) {
                string4 = httpServletRequest.getParameter((String)object);
                continue;
            }
            if (((String)object).equalsIgnoreCase(AUTH_SCHEME)) {
                string2 = httpServletRequest.getParameter((String)object);
                continue;
            }
            if (!((String)object).equalsIgnoreCase(AUTH_LEVEL)) continue;
            string3 = httpServletRequest.getParameter((String)object);
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet: queryString : " + string6);
            debug.message("GatewayServlet: gotoUrl : " + string4);
        }
        if (string4 != null && (actionDecision = this.getActionDecision(string4)) != null) {
            map = actionDecision.getAdvices();
            string5 = this.getOrgNameFromAdvice(map);
        }
        object = null;
        if (string4 != null && string2 == null && string3 == null) {
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: gotoUrl : " + string4);
            }
            stringBuffer.append('?').append(string6);
            string = this.getPolicyAdvice(actionDecision);
            object = this.getGWServletUtilsFromMap(map);
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: advice from getPolicyAdvice() : " + string);
            }
            if (string != null && string.length() > 0) {
                stringBuffer.append('&').append(string);
            }
        } else if (string2 != null || string3 != null) {
            stringBuffer.append('?').append(string6);
            if (string2 != null) {
                object = this.getGWServletUtilsByScheme(string5, string2);
            } else if (string3 != null) {
                object = this.getGWServletUtilsByLevel(string5, string3);
            }
        }
        string = stringBuffer.toString();
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet >>> Need to change URL !");
            debug.message("OLD URL : " + string);
        }
        if (object != null && ((AuthServiceConfigInfo)object).getPortNumber() != null) {
            string = CERT_PROTOCOL + httpServletRequest.getServerName() + ":" + ((AuthServiceConfigInfo)object).getPortNumber() + SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor") + string;
            if (string5 != null && string.indexOf("org=") == -1) {
                string = string + "&" + ORG_NAME + "=" + this.DNtoName(string5);
            }
            httpServletResponse.sendRedirect(string);
        } else {
            if (string5 != null && string.indexOf("org=") == -1) {
                string = string + "&" + ORG_NAME + "=" + this.DNtoName(string5);
            }
            RequestDispatcher requestDispatcher = this.config.getServletContext().getRequestDispatcher(string);
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        if (debug.messageEnabled()) {
            debug.message("New URL : " + string);
        }
    }

    String getPolicyAdvice(ActionDecision actionDecision) {
        StringBuffer stringBuffer = new StringBuffer(30);
        this.processActionDecision(actionDecision, stringBuffer);
        return stringBuffer.toString().trim();
    }

    boolean processActionDecision(ActionDecision actionDecision, StringBuffer stringBuffer) {
        if (actionDecision == null) {
            return false;
        }
        Set set = actionDecision.getValues();
        if (set.contains(ALLOW)) {
            stringBuffer.append(DEFAULT_MODULE);
            return true;
        }
        Map map = actionDecision.getAdvices();
        if (map != null) {
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet: processActionDecision : " + map.values().toString());
            }
            if (this.appendAdvice(AUTH_SCHEME, (Set)map.get(AUTH_SCHEME_ADVICE), stringBuffer) || this.appendAdvice(AUTH_LEVEL, (Set)map.get(AUTH_LEVEL_ADVICE), stringBuffer)) {
                return true;
            }
        }
        return false;
    }

    boolean appendAdvice(String string, Set set, StringBuffer stringBuffer) {
        Iterator iterator;
        if (set != null && (iterator = set.iterator()).hasNext()) {
            String string2 = (String)iterator.next();
            if (stringBuffer.length() != 0) {
                stringBuffer.append('&');
            }
            stringBuffer.append(string).append('=').append(string2);
            return true;
        }
        return false;
    }

    private GatewayServletUtils initGWServletUtilsMap(String string) {
        GatewayServletUtils gatewayServletUtils = null;
        AMOrganization aMOrganization = authD.getOrgProfile(string);
        try {
            Set set = aMOrganization.getRegisteredServiceNames();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.trim().indexOf("iPlanetAMAuth") != 0) continue;
                int n = string2.lastIndexOf("Service");
                String string3 = null;
                if (n <= "iPlanetAMAuth".length() || !authenticators.contains(string3 = string2.substring("iPlanetAMAuth".length(), n))) continue;
                gatewayServletUtils = this.addGWServletUtilsToMap(string, string3);
            }
        }
        catch (Exception exception) {
            debug.error("Error in GatewayServlet:initGWServletUtilsMap()");
            debug.error("", (Throwable)exception);
        }
        return gatewayServletUtils;
    }

    private GatewayServletUtils addGWServletUtilsToMap(String string, String string2) {
        GatewayServletUtils gatewayServletUtils;
        block3: {
            gatewayServletUtils = null;
            String string3 = AMAuthConfigUtils.getModuleServiceName(string2);
            try {
                ServiceConfigManager serviceConfigManager = new ServiceConfigManager(string3, defToken);
                gatewayServletUtils = new GatewayServletUtils(serviceConfigManager, string2);
                gatewayServletUtils.organizationConfigChanged(string);
                AuthServiceConfigInfo authServiceConfigInfo = gatewayServletUtils.getAuthConfigInfo(string);
                if (authServiceConfigInfo.getPortNumber() != null) {
                    serviceConfigManager.addListener(gatewayServletUtils);
                    gwServletUtilsMap.put(string3, gatewayServletUtils);
                    break block3;
                }
                gatewayServletUtils = null;
                gwServletUtilsMap.put(string3, null);
            }
            catch (Exception exception) {
                debug.error("GatewayServlet: Unable to add Auth Service Info : " + string3, (Throwable)exception);
            }
        }
        return gatewayServletUtils;
    }

    private AuthServiceConfigInfo getGWServletUtilsFromMap(Map map) {
        String string = null;
        String string2 = null;
        String string3 = null;
        AuthServiceConfigInfo authServiceConfigInfo = null;
        string = this.getOrgNameFromAdvice(map);
        string2 = this.getAuthSchemeFromAdvice(map);
        if (string2 != null) {
            authServiceConfigInfo = this.getGWServletUtilsByScheme(string, string2);
        } else {
            string3 = this.getAuthLevelFromAdvice(map);
            if (string3 != null) {
                authServiceConfigInfo = this.getGWServletUtilsByLevel(string, string3);
            }
        }
        return authServiceConfigInfo;
    }

    private ActionDecision getActionDecision(String string) {
        ActionDecision actionDecision = null;
        if (pe != null) {
            Map map;
            PolicyDecision policyDecision = null;
            try {
                map = new HashMap();
                policyDecision = pe.getPolicyDecisionIgnoreSubjects(string, actionNames, map);
            }
            catch (Exception exception) {
                debug.error("GatewayServlet: Error in getting policy decision.", (Throwable)exception);
                return null;
            }
            map = policyDecision.getActionDecisions();
            if (map != null && (actionDecision = (ActionDecision)map.get(GET)) == null) {
                actionDecision = (ActionDecision)map.get(POST);
            }
        }
        return actionDecision;
    }

    private String getOrgNameFromAdvice(Map map) {
        Iterator iterator;
        String string = null;
        Set set = (Set)map.get("AdvicingOrganization");
        if (set != null && (iterator = set.iterator()).hasNext()) {
            string = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getOrgName() : " + string);
        }
        return string;
    }

    private String getAuthSchemeFromAdvice(Map map) {
        Iterator iterator;
        String string = null;
        Set set = (Set)map.get(AUTH_SCHEME_ADVICE);
        if (set != null && (iterator = set.iterator()).hasNext()) {
            string = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getAuthScheme() : " + string);
        }
        return string;
    }

    private String getAuthLevelFromAdvice(Map map) {
        Iterator iterator;
        String string = null;
        Set set = (Set)map.get(AUTH_LEVEL_ADVICE);
        if (set != null && (iterator = set.iterator()).hasNext()) {
            string = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getAuthLevel() : " + string);
        }
        return string;
    }

    private AuthServiceConfigInfo getGWServletUtilsByScheme(String string, String string2) {
        AuthServiceConfigInfo authServiceConfigInfo = null;
        GatewayServletUtils gatewayServletUtils = null;
        String string3 = AMAuthConfigUtils.getModuleServiceName(string2);
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getGWServletUtilsByScheme()");
            debug.message("OrgName : " + string);
            debug.message("Auth Scheme : " + string2);
        }
        if ((gatewayServletUtils = (GatewayServletUtils)gwServletUtilsMap.get(string3)) != null) {
            authServiceConfigInfo = gatewayServletUtils.getAuthConfigInfo(string);
        }
        return authServiceConfigInfo;
    }

    private AuthServiceConfigInfo getGWServletUtilsByLevel(String string, String string2) {
        AuthServiceConfigInfo authServiceConfigInfo = null;
        GatewayServletUtils gatewayServletUtils = null;
        Set set = gwServletUtilsMap.keySet();
        Iterator iterator = set.iterator();
        if (debug.messageEnabled()) {
            debug.message("GatewayServlet:getGWServletUtilsByLevel()");
            debug.message("OrgName : " + string);
            debug.message("Auth Level : " + string2);
            debug.message("No of entries in  GWServletUtilsMap : " + gwServletUtilsMap.size());
        }
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            gatewayServletUtils = (GatewayServletUtils)gwServletUtilsMap.get(string3);
            if (gatewayServletUtils == null || gatewayServletUtils.getAuthLevel(string) == null || !gatewayServletUtils.getAuthLevel(string).equals(string2)) continue;
            authServiceConfigInfo = gatewayServletUtils.getAuthConfigInfo(string);
            break;
        }
        return authServiceConfigInfo;
    }

    String DNtoName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        string2 = n2 == -1 ? string.substring(n + 1).trim() : string.substring(n + 1, n2).trim();
        return string2;
    }

    static {
        authenticators = new HashSet();
        actionNames = new HashSet();
    }
}

