/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class WebServicesClients
implements Subject {
    private Set selectedWebServicesClients = Collections.EMPTY_SET;
    static Debug debug = Debug.getInstance((String)"amPolicy");
    static I18n i18n = I18n.getInstance((String)"iPlanetAMPolicyService");

    public void WebServicesClients() {
    }

    public void initialize(Map map) {
    }

    public Syntax getValueSyntax(SSOToken sSOToken) {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            JKSKeyProvider jKSKeyProvider = new JKSKeyProvider();
            KeyStore keyStore = jKSKeyProvider.getKeyStore();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (debug.messageEnabled()) {
                    debug.message("WSClient.getValidValues: alias=" + string2);
                }
                if (keyStore.isCertificateEntry(string2)) {
                    debug.message("WSClient.getValidValues: alias is trusted.");
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
                    if (x509Certificate != null) {
                        debug.message("WSClient.getValidValues:cert not null");
                        Principal principal = x509Certificate.getSubjectDN();
                        String string3 = principal.getName();
                        if (string3 == null || string3.equals("")) continue;
                        hashSet.add(string3);
                        continue;
                    }
                    debug.message("WSClient.getValidValues: cert is null");
                    continue;
                }
                debug.message("WSClient.getValidValues:alias not trusted.");
            }
        }
        catch (KeyStoreException keyStoreException) {
            debug.error("WebServicesClients: couldn't get subjects", (Throwable)keyStoreException);
        }
        return new ValidValues(0, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) {
        return string;
    }

    public Set getValues() {
        return this.selectedWebServicesClients;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("WebServicesClients.setValues(): Invalid names");
            throw new InvalidNameException(i18n.getString("webservicesclients_subject_invalid_user_names", "null"), "null", 5);
        }
        this.selectedWebServicesClients = new HashSet();
        this.selectedWebServicesClients.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("WebServicesClients.setValues(): selected web service clients names=" + this.selectedWebServicesClients);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException {
        Principal principal = sSOToken.getPrincipal();
        String string = principal.getName();
        if (this.selectedWebServicesClients.contains(string)) {
            debug.message("WebServicesClients.isMemeber():principal is member");
            return true;
        }
        String string2 = sSOToken.getProperty("Principals");
        HashSet hashSet = new HashSet();
        if (string2 != null && !string2.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (!this.selectedWebServicesClients.contains(stringTokenizer.nextToken())) continue;
                if (debug.messageEnabled()) {
                    debug.message("WebServicesClients.isMemeber(): principals is member.");
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof WebServicesClients) {
            WebServicesClients webServicesClients = (WebServicesClients)object;
            if (this.selectedWebServicesClients != null && webServicesClients.selectedWebServicesClients != null && this.selectedWebServicesClients.equals(webServicesClients.selectedWebServicesClients)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        WebServicesClients webServicesClients = null;
        try {
            webServicesClients = (WebServicesClients)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedWebServicesClients != null) {
            webServicesClients.selectedWebServicesClients = new HashSet();
            webServicesClients.selectedWebServicesClients.addAll(this.selectedWebServicesClients);
        }
        return webServicesClients;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

