/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Referral;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OrgReferral
implements Referral {
    protected static final String SEARCH_TEMPLATE_NAME = "BasicOrganizationSearch";
    protected static final String CREATION_TEMPLATE_NAME = "BasicOrganization";
    protected static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    protected static final String CAN_NOT_GET_VALUES_FOR_REFERRAL = "can_not_get_values_for_referral";
    private String _name;
    private Set _values;
    protected Map _configurationMap;
    protected String _orgName;
    protected Cache cachedPolicyEvaluators = new Cache(50);

    public void initialize(Map map) {
        this._configurationMap = map;
    }

    private void setName(String string) {
        this._name = string;
    }

    private String getName() {
        return this._name;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set.isEmpty() || set.size() > 1) {
            throw new InvalidNameException("amPolicy", "invalid_organization", null, "", 4);
        }
        this._values = set;
        Iterator iterator = set.iterator();
        this._orgName = (String)iterator.next();
    }

    public Set getValues() {
        return this._values;
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        String string2 = null;
        try {
            string2 = PolicyUtils.getDisplayName(string);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{string};
            throw new NameNotFoundException("amPolicy", "role_name_not_present", objectArray, string, 5);
        }
        return string2;
    }

    public abstract ValidValues getValidValues(SSOToken var1) throws SSOException, PolicyException;

    public abstract ValidValues getValidValues(SSOToken var1, String var2) throws SSOException, PolicyException;

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException, PolicyException {
        Syntax syntax = Syntax.NONE;
        ValidValues validValues = this.getValidValues(sSOToken);
        Set set = validValues.getSearchResults();
        syntax = set == null || set.isEmpty() ? Syntax.NONE : Syntax.SINGLE_CHOICE;
        return syntax;
    }

    public abstract String getReferralTypeName();

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, String string2, Set set, Map map) throws SSOException, PolicyException {
        PolicyEvaluator policyEvaluator = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = stringBuffer.append(this._orgName).append(string).toString();
        policyEvaluator = (PolicyEvaluator)this.cachedPolicyEvaluators.get((Object)string3);
        if (policyEvaluator == null) {
            policyEvaluator = new PolicyEvaluator(this._orgName, string);
            this.cachedPolicyEvaluators.put((Object)string3, (Object)policyEvaluator);
        }
        return policyEvaluator.getPolicyDecision(sSOToken, string2, set, map);
    }

    protected String getSearchFilter(String string) throws UMSException {
        String string2 = null;
        Guid guid = new Guid(string);
        SearchTemplate searchTemplate = TemplateManager.getTemplateManager().getSearchTemplate(SEARCH_TEMPLATE_NAME, guid);
        string2 = searchTemplate == null ? "(objectclass=organization)" : searchTemplate.getSearchFilter();
        if (string2 == null) {
            string2 = "(objectclass=organization)";
        }
        return string2;
    }

    protected String getNamingAttribute(String string) throws UMSException {
        String string2 = null;
        Guid guid = new Guid(string);
        CreationTemplate creationTemplate = TemplateManager.getTemplateManager().getCreationTemplate(CREATION_TEMPLATE_NAME, guid);
        if (creationTemplate == null) {
            string2 = "o";
        } else {
            string2 = creationTemplate.getNamingAttribute();
            if (string2 == null) {
                string2 = "o";
            }
        }
        return string2;
    }

    protected String getSearchFilter(String string, String string2) throws UMSException {
        String string3 = this.getSearchFilter(string);
        String string4 = this.getNamingAttribute(string);
        if (string2 == null) {
            string2 = "*";
        }
        string3 = "(&(" + string3 + ")(" + string4 + "=" + string2 + "))";
        return string3;
    }

    protected String getNamingAttribute(PersistentObject persistentObject) {
        return persistentObject.getNamingAttribute();
    }

    public Set getResourceNames(SSOToken sSOToken, String string, String string2) throws PolicyException, SSOException {
        Set set = null;
        PolicyEvaluator policyEvaluator = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = stringBuffer.append(this._orgName).append(string).toString();
        policyEvaluator = (PolicyEvaluator)this.cachedPolicyEvaluators.get((Object)string3);
        if (policyEvaluator == null) {
            policyEvaluator = new PolicyEvaluator(this._orgName, string);
            this.cachedPolicyEvaluators.put((Object)string3, (Object)policyEvaluator);
        }
        set = policyEvaluator.getResourceNames(sSOToken, string2, true);
        return set;
    }
}

