/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LEAuthLevelCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private final I18n I18N = I18n.getInstance((String)"iPlanetAMPolicyService");
    public static final String AUTH_LEVEL = "AuthLevel";
    public static final String REQUEST_AUTH_LEVEL = "requestAuthLevel";
    private Map properties;
    private int authLevel;
    private static List propertyNames = new ArrayList(1);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String string) {
        return Syntax.NONE;
    }

    public String getDisplayName(String string, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String string) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        this.properties = (HashMap)map;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        boolean bl = false;
        Integer n = null;
        if (map != null && map.get(REQUEST_AUTH_LEVEL) != null) {
            try {
                n = (Integer)map.get(REQUEST_AUTH_LEVEL);
            }
            catch (ClassCastException classCastException) {
                Object[] objectArray = new String[]{REQUEST_AUTH_LEVEL};
                throw new PolicyException(this.I18N.getString("property_is_not_an_Integer", objectArray), classCastException);
            }
        } else if (sSOToken != null) {
            n = new Integer(sSOToken.getAuthLevel());
        }
        if (n != null && n <= this.authLevel) {
            bl = true;
        }
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At LEAuthLevelCondition.getConditionDecision(): authLevel,  requestAuthLevel, allowed = " + this.authLevel + ", " + n + "," + bl);
        }
        return new ConditionDecision(bl);
    }

    public Object clone() {
        LEAuthLevelCondition lEAuthLevelCondition = null;
        try {
            lEAuthLevelCondition = (LEAuthLevelCondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.properties != null) {
            lEAuthLevelCondition.properties = new HashMap();
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                HashSet hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                lEAuthLevelCondition.properties.put(k, hashSet);
            }
        }
        return lEAuthLevelCondition;
    }

    private boolean validateProperties() throws PolicyException {
        Object object;
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException(this.I18N.getString("properties_can_not_be_null_or_empty"));
        }
        Set set = this.properties.keySet();
        if (!set.contains(AUTH_LEVEL)) {
            Object[] objectArray = new String[]{AUTH_LEVEL};
            throw new PolicyException(this.I18N.getString("property_value_not_defined", objectArray));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (AUTH_LEVEL.equals(object)) continue;
            Object[] objectArray = new String[]{object};
            throw new PolicyException(this.I18N.getString("attempt_to_set_invalid_property", objectArray));
        }
        object = (Set)this.properties.get(AUTH_LEVEL);
        if (object != null) {
            this.validateAuthLevels((Set)object);
        }
        return true;
    }

    private boolean validateAuthLevels(Set set) throws PolicyException {
        if (set.isEmpty() || set.size() > 1) {
            Object[] objectArray = new String[]{AUTH_LEVEL};
            throw new PolicyException(this.I18N.getString("property_does_not_allow_empty_or_multiple_values", objectArray));
        }
        Iterator iterator = set.iterator();
        String string = null;
        try {
            string = (String)iterator.next();
            this.authLevel = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{AUTH_LEVEL};
            throw new PolicyException(this.I18N.getString("property_is_not_an_Integer", objectArray));
        }
        return true;
    }

    private boolean isAllowed(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        return this.getConditionDecision(sSOToken, map).isAllowed();
    }

    static {
        propertyNames.add(AUTH_LEVEL);
    }
}

