/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class LDAPGroups
implements Subject {
    static final String STATIC_GROUP_MEMBER_ATTR = "uniqueMember";
    static final String DYNAMIC_GROUP_MEMBER_URL = "memberUrl";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedGroupDNs = Collections.EMPTY_SET;
    private Set selectedRFCGroupDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String groupSearchFilter;
    private int groupSearchScope = 2;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String groupRDNAttrName;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private ConnectionPool connPool;
    private boolean localDS;
    private boolean aliasEnabled;
    private String ldapServer;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map map) throws PolicyException {
        if (map == null) {
            throw new PolicyException("amPolicy", "ldapgroups_initialization_failed", null, null);
        }
        this.ldapServer = ((String)map.get("iplanet-am-policy-config-ldap-server")).toLowerCase();
        this.localDS = PolicyUtils.isLocalDS(this.ldapServer);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-base-dn");
        this.groupSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-groups-search-filter");
        String string = (String)map.get("iplanet-am-policy-config-ldap-groups-search-scope");
        this.groupSearchScope = string.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.groupRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-groups-search-attribute");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        string = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string2.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.initialize(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\ngroupSearchFilter: " + this.groupSearchFilter + "\ngroupRDNAttrName: " + this.groupRDNAttrName + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldapgroups_subject_not_yet_initialized", null, null);
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        string2 = string != null && !string.equals("") ? "(&" + this.groupSearchFilter + "(" + this.groupRDNAttrName + "=" + string + "))" : this.groupSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.getValidValues(): group search filter is: " + string2);
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        int n = 0;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.groupSearchScope, string2, null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                        if (!debug.messageEnabled()) continue;
                        debug.message("LDAPGroups.getValidValues(): found group name=" + lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("LDAPGroups.getValidValues(): exceeded the size limit");
                            n = 1;
                            continue;
                        }
                        if (n2 == 3) {
                            debug.warning("LDAPGroups.getValidValues(): exceeded the time limit");
                            n = 2;
                            continue;
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                String string3 = lDAPException.getMessage();
                String string4 = lDAPException.getLDAPErrorMessage();
                if (string4 != null) {
                    throw new PolicyException(string3 + ": " + string4);
                }
                throw new PolicyException(string3);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var14_18 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        return new ValidValues(n, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.getValues() gets called");
        }
        return this.selectedGroupDNs;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("LDAPGroups.setValues(): Invalid names");
            throw new InvalidNameException("amPolicy", "ldapgroups_subject_invalid_group_names", null, null, 5);
        }
        this.selectedGroupDNs = new HashSet();
        this.selectedGroupDNs.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.setValues(): selected group names=" + this.selectedGroupDNs);
        }
        this.selectedRFCGroupDNs = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.selectedRFCGroupDNs.add(new DN((String)iterator.next()).toRFCString().toLowerCase());
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        if (sSOToken == null) {
            return false;
        }
        boolean bl = false;
        String string = sSOToken.getTokenID().toString();
        String string2 = sSOToken.getPrincipal().getName();
        DN dN = null;
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMember(): user local DN is " + string2);
        }
        if (this.selectedRFCGroupDNs.size() > 0) {
            Iterator iterator = this.selectedRFCGroupDNs.iterator();
            while (iterator.hasNext()) {
                Boolean bl2 = null;
                String string3 = (String)iterator.next();
                bl2 = SubjectEvaluationCache.isMember(string, this.ldapServer, string3);
                if (bl2 != null) {
                    boolean bl3;
                    if (debug.messageEnabled()) {
                        debug.message("LDAPGroups.isMember():Got membership from cache of " + string2 + " in group " + string3 + " :" + bl2);
                    }
                    if (!(bl3 = bl2.booleanValue())) continue;
                    return bl3;
                }
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups:isMember():entry for " + string3 + " not in subject evaluation cache,fetching from " + "directory server.");
                }
                String string4 = null;
                if (dN == null) {
                    if (this.localDS) {
                        dN = new DN(string2);
                    } else {
                        int n = string2.indexOf("=");
                        int n2 = string2.indexOf(",");
                        if (n <= 0 || n2 <= 0 || n >= n2) {
                            throw new PolicyException("amPolicy", "ldapgroups_subject_invalid_local_user_dn", null, null);
                        }
                        String string5 = string2.substring(n + 1, n2);
                        string4 = PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string5, this.aliasEnabled);
                        dN = this.getUserDN(sSOToken, string4);
                    }
                    if (dN == null) {
                        if (debug.messageEnabled()) {
                            debug.message("LDAPGroups.isMember(): User " + string2 + " is not found in the directory");
                        }
                        return false;
                    }
                }
                if (!bl && !PolicyEvaluator.ssoListenerRegistry.containsKey(string)) {
                    sSOToken.addSSOTokenListener(PolicyEvaluator.ssoListener);
                    PolicyEvaluator.ssoListenerRegistry.put(string, PolicyEvaluator.ssoListener);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPGroups.isMember(): sso listener added .\n");
                    }
                    bl = true;
                }
                if (!this.isMemberOfGroup(string3, dN, string4, sSOToken)) continue;
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups.isMember(): User " + dN.toRFCString() + " is a member of this LDAPGroups.");
                }
                return true;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMember(): User " + string2 + " is not a member of this LDAPGroups.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMemberOfGroup(String string, DN dN, String string2, SSOToken sSOToken) throws SSOException, PolicyException {
        String string3;
        Enumeration enumeration;
        Serializable serializable;
        if (string == null || string.equals("") || dN == null) {
            return false;
        }
        String string4 = sSOToken.getTokenID().toString();
        boolean bl = false;
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPEntry lDAPEntry = null;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                lDAPEntry = lDAPConnection.read(string);
            }
            catch (Exception exception) {
                debug.warning("LDAPGroups: invalid group name " + string + " specified in the policy definition.");
                boolean bl2 = false;
                Object var12_10 = null;
                this.connPool.close(lDAPConnection);
                return bl2;
            }
            serializable = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(STATIC_GROUP_MEMBER_ATTR);
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration != null && enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                serializable = new DN(string3);
                if (!dN.equals((DN)serializable)) continue;
                bl = true;
                break;
            }
        }
        if (!bl && (lDAPAttribute = lDAPEntry.getAttribute(DYNAMIC_GROUP_MEMBER_URL)) != null) {
            enumeration = lDAPAttribute.getStringValues();
            block7: while (enumeration != null && enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                try {
                    serializable = new LDAPUrl(string3);
                    Set set = this.findDynamicGroupMembersByUrl((LDAPUrl)serializable, string2);
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        String string5 = (String)iterator.next();
                        DN dN2 = new DN(string5);
                        if (!dN.equals(dN2)) continue;
                        bl = true;
                        continue block7;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    throw new PolicyException(malformedURLException);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPGroups.isMemberOfGroup():adding entry " + string4 + " " + this.ldapServer + " " + string + " " + bl + " in subject evaluation cache.");
        }
        SubjectEvaluationCache.addEntry(string4, this.ldapServer, string, bl);
        return bl;
    }

    private Set findDynamicGroupMembersByUrl(LDAPUrl lDAPUrl, String string) throws PolicyException {
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                StringBuffer stringBuffer = new StringBuffer(25);
                stringBuffer.append("(&").append(string);
                String string2 = lDAPUrl.getFilter();
                int n = string2.indexOf("(");
                if (n != 0) {
                    stringBuffer.append("(").append(string2).append("))");
                } else {
                    stringBuffer.append(string2).append(")");
                }
                if (debug.messageEnabled()) {
                    debug.message("search filter in LDAPGroups : " + stringBuffer);
                }
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN(), lDAPUrl.getScope(), stringBuffer.toString(), null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        Object[] objectArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("LDAPGroups.findDynamicGroupMembersByUrl(): exceeded the size limit");
                            throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                        }
                        if (n2 == 3) {
                            debug.warning("LDAPGroups.findDynamicGroupMembersByUrl(): exceeded the time limit");
                            throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var15_16 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        return hashSet;
    }

    public int hashCode() {
        return this.selectedGroupDNs.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LDAPGroups) {
            LDAPGroups lDAPGroups = (LDAPGroups)object;
            if (this.selectedGroupDNs != null && lDAPGroups.selectedGroupDNs != null && this.selectedGroupDNs.equals(lDAPGroups.selectedGroupDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPGroups lDAPGroups = null;
        try {
            lDAPGroups = (LDAPGroups)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedGroupDNs != null) {
            lDAPGroups.selectedGroupDNs = new HashSet();
            lDAPGroups.selectedGroupDNs.addAll(this.selectedGroupDNs);
        }
        if (this.selectedRFCGroupDNs != null) {
            lDAPGroups.selectedRFCGroupDNs = new HashSet();
            lDAPGroups.selectedRFCGroupDNs.addAll(this.selectedRFCGroupDNs);
        }
        return lDAPGroups;
    }

    private DN getUserDN(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        DN dN = null;
        if (string != null) {
            Object object;
            String string2 = sSOToken.getPrincipal().getName();
            HashSet<String> hashSet = new HashSet<String>();
            String string3 = null;
            string3 = this.userSearchFilter != null && !this.userSearchFilter.equals("") ? "(&" + this.userSearchFilter + string + ")" : string;
            if (debug.messageEnabled()) {
                debug.message("LDAPGroups.getUserDN(): search filter is: " + string3);
            }
            LDAPConnection lDAPConnection = this.connPool.getConnection();
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(this.maxResults);
            lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
            try {
                try {
                    lDAPConnection.authenticate(this.authid, this.authpw);
                    object = lDAPConnection.search(this.baseDN, this.userSearchScope, string3, null, false, lDAPSearchConstraints);
                    while (((LDAPSearchResults)object).hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry = ((LDAPSearchResults)object).next();
                            if (lDAPEntry == null) continue;
                            hashSet.add(lDAPEntry.getDN());
                        }
                        catch (LDAPReferralException lDAPReferralException) {
                        }
                        catch (LDAPException lDAPException) {
                            Object[] objectArray = new String[]{this.orgName};
                            int n = lDAPException.getLDAPResultCode();
                            if (n == 4) {
                                debug.warning("LDAPGroups.isMember(): exceeded the size limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                            }
                            if (n == 3) {
                                debug.warning("LDAPGroups.isMember(): exceeded the time limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                            }
                            throw new PolicyException(lDAPException);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 49) {
                        throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                    }
                    String string4 = lDAPException.getMessage();
                    String string5 = lDAPException.getLDAPErrorMessage();
                    if (string5 != null) {
                        throw new PolicyException(string4 + ": " + string5);
                    }
                    throw new PolicyException(string4);
                }
                catch (Exception exception) {
                    throw new PolicyException(exception);
                }
                Object var15_19 = null;
                this.connPool.close(lDAPConnection);
            }
            catch (Throwable throwable) {
                Object var15_20 = null;
                this.connPool.close(lDAPConnection);
                throw throwable;
            }
            if (hashSet.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("LDAPGroups.getUserDN(): qualified users=" + hashSet);
                }
                object = hashSet.iterator();
                dN = new DN((String)object.next());
            }
        }
        return dN;
    }
}

