/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.HybridHashtable;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.PolicyNotificationHandler;
import com.sun.identity.policy.client.PolicyProperties;
import com.sun.identity.policy.client.SSOEntry;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.policy.remote.PolicyChangeNotification;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyNotification;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ResourceResultCache {
    private static ResourceResultCache instance = null;
    private Map mapSvcNameToMap = new HashMap(10);
    private int hashSize = 1000;
    private CacheThread thread = null;
    private SSOToken appSSOToken = null;
    private static PolicyProperties policyProp = null;
    private static String serviceName = null;
    private static ResourceName resourceComparator = null;
    private static Debug debug = PolicyEvaluator.debug;
    private static final String BEGIN_XML_DATA_BLOCK = "<![CDATA[";
    private static final String END_XML_DATA_BLOCK = "]]>";
    private static final String NODE_POLICY_SERVICE = "PolicyService";
    private static final String NODE_POLICY_NOTIFICATION = "PolicyNotification";
    private static final String NAMING_POLICY = "policy";
    private static final Object PURGE_LOCK = new Object();
    private PolicyNotificationHandler notificationHandler;
    static /* synthetic */ Class class$com$sun$identity$policy$client$ResourceResultCache;

    private ResourceResultCache(PolicyProperties policyProperties, SSOToken sSOToken, String string, ResourceName resourceName) {
        policyProp = policyProperties;
        this.hashSize = policyProperties.cacheSize;
        this.appSSOToken = sSOToken;
        serviceName = string;
        resourceComparator = resourceName;
        this.notificationHandler = new PolicyNotificationHandler();
        if (policyProperties.isNotifEnabled) {
            if (debug.messageEnabled()) {
                debug.message("Notification is enabled, Trying to add Policy Listener");
            }
            if (policyProperties.notificationURL == null) {
                debug.error("Notification URL is null, cannot add or remove listeners");
            } else {
                boolean bl = this.removePolicyListener(policyProperties.notificationURL);
                if (bl) {
                    if (debug.messageEnabled()) {
                        debug.message("Successfully removed Policy Listener at URL " + policyProperties.notificationURL);
                    }
                } else {
                    debug.error("Failed to remove Policy Listener at URL " + policyProperties.notificationURL);
                }
                if (bl = this.addPolicyListener(policyProperties.notificationURL)) {
                    this.registerHandlerWithPLLClient(this.notificationHandler);
                    if (debug.messageEnabled()) {
                        debug.message("Successfully added Policy Listener at URL " + policyProperties.notificationURL);
                    }
                } else {
                    debug.error("Failed to add Policy Listener at URL " + policyProperties.notificationURL);
                }
            }
        }
        this.thread = new CacheThread(policyProperties.pollInterval);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceResultCache getInstance(PolicyProperties policyProperties, SSOToken sSOToken, String string, ResourceName resourceName) {
        if (instance == null) {
            Class clazz = class$com$sun$identity$policy$client$ResourceResultCache == null ? (class$com$sun$identity$policy$client$ResourceResultCache = ResourceResultCache.class$("com.sun.identity.policy.client.ResourceResultCache")) : class$com$sun$identity$policy$client$ResourceResultCache;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new ResourceResultCache(policyProperties, sSOToken, string, resourceName);
                }
            }
        }
        return instance;
    }

    static ResourceResultCache getInstance() {
        if (instance != null) {
            return instance;
        }
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache has not been created, cannot return object");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSOEntry addEntry(String string, SSOEntry sSOEntry) {
        SSOToken sSOToken = sSOEntry.getSSOToken();
        SSOTokenID sSOTokenID = sSOToken.getTokenID();
        SSOEntry sSOEntry2 = this.getEntry(string, sSOToken);
        Object object = PURGE_LOCK;
        synchronized (object) {
            HybridHashtable hybridHashtable = this.getHastable(string, true);
            hybridHashtable.addEntry(sSOTokenID.hashCode(), sSOTokenID.toString(), sSOEntry);
        }
        return sSOEntry2;
    }

    SSOEntry getEntry(String string, SSOToken sSOToken) {
        HybridHashtable hybridHashtable = this.getHastable(string, false);
        if (hybridHashtable != null) {
            SSOTokenID sSOTokenID = sSOToken.getTokenID();
            return (SSOEntry)hybridHashtable.getEntry(sSOTokenID.hashCode(), sSOTokenID.toString());
        }
        return null;
    }

    void removeEntry(String string, SSOToken sSOToken) {
        HybridHashtable hybridHashtable = this.getHastable(string, false);
        if (hybridHashtable != null) {
            SSOTokenID sSOTokenID = sSOToken.getTokenID();
            hybridHashtable.removeEntry(sSOTokenID.hashCode(), sSOTokenID.toString());
        }
    }

    void markStale(String string, ResourceName resourceName, String string2, boolean bl) {
        HybridHashtable hybridHashtable = this.getHastable(string, false);
        if (hybridHashtable != null) {
            hybridHashtable.markStale(resourceName, string2, bl);
        }
    }

    void markResultAsStale(Object object, ResourceName resourceName, String string, boolean bl) {
        SSOEntry sSOEntry = (SSOEntry)object;
        if (debug.messageEnabled()) {
            debug.message("Marking resource : " + string + " as stale in cache");
        }
        sSOEntry.markResultAsStale(resourceName, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HybridHashtable getHastable(String string, boolean bl) {
        HybridHashtable hybridHashtable = (HybridHashtable)this.mapSvcNameToMap.get(string);
        if (hybridHashtable == null && bl) {
            Map map = this.mapSvcNameToMap;
            synchronized (map) {
                hybridHashtable = (HybridHashtable)this.mapSvcNameToMap.get(string);
                if (hybridHashtable == null) {
                    hybridHashtable = new HybridHashtable(this, this.hashSize);
                    this.mapSvcNameToMap.put(string, hybridHashtable);
                }
            }
        }
        return hybridHashtable;
    }

    static void purgeEntries() {
        if (debug.messageEnabled()) {
            debug.message("ResourceResultCache.purgeEntries() purging entries ...");
        }
        long l = System.currentTimeMillis();
        Iterator iterator = ResourceResultCache.instance.mapSvcNameToMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            HybridHashtable hybridHashtable = (HybridHashtable)ResourceResultCache.instance.mapSvcNameToMap.get(string);
            Iterator iterator2 = hybridHashtable.iterator();
            while (iterator2.hasNext()) {
                Hashtable hashtable = (Hashtable)iterator2.next();
                ResourceResultCache.purgeEntries(hashtable, l);
            }
        }
    }

    static void purgeEntries(Hashtable hashtable, long l) {
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SSOEntry sSOEntry = (SSOEntry)hashtable.get(string);
            if (sSOEntry == null) continue;
            if (!sSOEntry.validate(l)) {
                iterator.remove();
                debug.message("sso entry is purged");
                continue;
            }
            debug.message("sso entry stays");
        }
    }

    static void printCache() {
        Iterator iterator = ResourceResultCache.instance.mapSvcNameToMap.keySet().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                HybridHashtable hybridHashtable = (HybridHashtable)ResourceResultCache.instance.mapSvcNameToMap.get(string);
                if (debug.messageEnabled()) {
                    debug.message("Printing HybridHashtable for service name : " + string);
                }
                hybridHashtable.printHybridTable();
            }
        }
    }

    private boolean addPolicyListener(String string) {
        boolean bl;
        block8: {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache.addPolicyListener():notificationURL=" + string);
            }
            bl = false;
            URL uRL = null;
            if (this.appSSOToken != null) {
                try {
                    uRL = PolicyEvaluator.getPolicyServiceURL(this.appSSOToken);
                }
                catch (PolicyException policyException) {
                    debug.error("Can not add policy listner", (Throwable)policyException);
                }
            }
            if (this.appSSOToken == null || uRL == null) break block8;
            PolicyListenerRequest policyListenerRequest = new PolicyListenerRequest();
            policyListenerRequest.setServiceName(serviceName);
            policyListenerRequest.setNotificationURL(string);
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(this.appSSOToken.getTokenID().toString());
            policyRequest.setMethodID(2);
            policyRequest.setPolicyListenerRequest(policyListenerRequest);
            PolicyService policyService = new PolicyService();
            policyService.setMethodID(1);
            policyService.setPolicyRequest(policyRequest);
            String string2 = policyService.toXMLString();
            try {
                Request request = new Request(string2);
                RequestSet requestSet = new RequestSet(NAMING_POLICY);
                requestSet.addRequest(request);
                Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
                Response response = (Response)vector.elementAt(0);
                PolicyService policyService2 = PolicyService.parseXML(response.getContent());
                if (policyService2 != null) {
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.addPolicyListener, result=" + policyService2.toXMLString());
                    }
                    bl = this.processNotificationRegisResult(policyService2);
                    break block8;
                }
                debug.error("ResourceResultCache.addPolicyListener, no result");
            }
            catch (Exception exception) {
                debug.error("ResourceResultCache.addPolicyListener", (Throwable)exception);
            }
        }
        return bl;
    }

    private boolean processNotificationRegisResult(PolicyService policyService) {
        PolicyResponse policyResponse;
        boolean bl = false;
        if (policyService != null && (policyResponse = policyService.getPolicyResponse()).getMethodID() == 2) {
            bl = true;
        }
        return bl;
    }

    private boolean removePolicyListener(String string) {
        boolean bl;
        block7: {
            bl = false;
            URL uRL = null;
            if (this.appSSOToken != null) {
                try {
                    uRL = PolicyEvaluator.getPolicyServiceURL(this.appSSOToken);
                }
                catch (PolicyException policyException) {
                    debug.error("Can not remove policy listner", (Throwable)policyException);
                }
            }
            if (this.appSSOToken == null || uRL == null) break block7;
            RemoveListenerRequest removeListenerRequest = new RemoveListenerRequest();
            removeListenerRequest.setServiceName(serviceName);
            removeListenerRequest.setNotificationURL(string);
            PolicyRequest policyRequest = new PolicyRequest();
            policyRequest.setAppSSOToken(this.appSSOToken.getTokenID().toString());
            policyRequest.setMethodID(3);
            policyRequest.setRemoveListenerRequest(removeListenerRequest);
            PolicyService policyService = new PolicyService();
            policyService.setMethodID(1);
            policyService.setPolicyRequest(policyRequest);
            String string2 = policyService.toXMLString();
            try {
                Request request = new Request(string2);
                RequestSet requestSet = new RequestSet(NAMING_POLICY);
                requestSet.addRequest(request);
                Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
                Response response = (Response)vector.elementAt(0);
                PolicyService policyService2 = PolicyService.parseXML(response.getContent());
                if (policyService2 != null) {
                    if (debug.messageEnabled()) {
                        debug.message("ResourceResultCache.removePolicyListener, result=" + policyService2.toXMLString());
                    }
                    bl = this.processNotificationUnRegisResult(policyService2);
                    break block7;
                }
                debug.message("ResourceResultCache.removePolicyListener, no result");
            }
            catch (Exception exception) {
                debug.error("ResourceResultCache.removePolicyListener", (Throwable)exception);
            }
        }
        return bl;
    }

    private boolean processNotificationUnRegisResult(PolicyService policyService) {
        PolicyResponse policyResponse;
        boolean bl = false;
        if (policyService != null && (policyResponse = policyService.getPolicyResponse()).getMethodID() == 3) {
            bl = true;
        }
        return bl;
    }

    public static void processNotification(String string) throws PolicyEvaluationException {
        ResourceResultCache resourceResultCache = ResourceResultCache.getInstance();
        Node node = resourceResultCache.getNotificationDOMNode(string);
        if (node != null) {
            PolicyNotification policyNotification = PolicyNotification.parseXML(node);
            PolicyChangeNotification policyChangeNotification = policyNotification.getPolicyChangeNotification();
            String string2 = policyChangeNotification.getServiceName();
            if (string2 != null && string2.equals(serviceName)) {
                Set set = policyChangeNotification.getResourceNames();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    resourceResultCache.markStale(serviceName, resourceComparator, (String)iterator.next(), ResourceResultCache.policyProp.useWildcard);
                }
            }
        } else {
            debug.error("ResourceResultCache:processNotification, cannot find notification node");
        }
    }

    private Node getNotificationDOMNode(String string) throws PolicyEvaluationException {
        try {
            Document document;
            Node node;
            string = this.getNotificationDataBlock(string);
            if (string != null && (node = XMLUtils.getRootNode((Document)(document = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string.getBytes()))), (String)NODE_POLICY_SERVICE)) != null) {
                return XMLUtils.getChildNode((Node)node, (String)NODE_POLICY_NOTIFICATION);
            }
            debug.error("ResourceResultCache.getNotificationDOMNode, invalid root element specified in the request");
            throw new PolicyEvaluationException("amPolicy", "invalid_root_element", null, null);
        }
        catch (Exception exception) {
            debug.error("getNotificationDOMNode.getNotificationDOMNode", (Throwable)exception);
            throw new PolicyEvaluationException("amPolicy", "xml_parsing_error", null, exception);
        }
    }

    private String getNotificationDataBlock(String string) {
        int n = string.indexOf(BEGIN_XML_DATA_BLOCK);
        if (n != -1 && (n = (string = string.substring(n + BEGIN_XML_DATA_BLOCK.length())).indexOf(END_XML_DATA_BLOCK)) != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    static void processNotification(PolicyNotification policyNotification) throws PolicyEvaluationException {
        if (policyNotification != null) {
            if (debug.messageEnabled()) {
                debug.message("ResourceResultCache:processNotification():xml received=" + policyNotification);
            }
            ResourceResultCache resourceResultCache = ResourceResultCache.getInstance();
            PolicyChangeNotification policyChangeNotification = policyNotification.getPolicyChangeNotification();
            String string = policyChangeNotification.getServiceName();
            if (string != null && string.equals(serviceName)) {
                Set set = policyChangeNotification.getResourceNames();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    resourceResultCache.markStale(serviceName, resourceComparator, (String)iterator.next(), ResourceResultCache.policyProp.useWildcard);
                }
            }
        } else {
            debug.error("ResourceResultCache.processNotification()PolicyNotification is null");
        }
    }

    private void registerHandlerWithPLLClient(PolicyNotificationHandler policyNotificationHandler) {
        block3: {
            try {
                PLLClient.addNotificationHandler((String)NAMING_POLICY, (NotificationHandler)policyNotificationHandler);
                if (debug.messageEnabled()) {
                    debug.message("at ResourceResultCache.registerHandlerWithPLLClient():registered notification handler");
                }
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                if (!debug.warningEnabled()) break block3;
                debug.message("at ResourceResultCache.registerHandlerWithPLLClient():AlreadyRegisteredException", (Throwable)alreadyRegisteredException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class CacheThread
    extends Thread {
        private int pollInterval = 0;

        protected CacheThread(int n) {
            this.pollInterval = n * 60 * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.pollInterval);
                        Object object = PURGE_LOCK;
                        synchronized (object) {
                            ResourceResultCache.purgeEntries();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    debug.warning("ResourceResultCache.run(): Thread interrupted!!", (Throwable)interruptedException);
                    continue;
                }
                catch (Throwable throwable) {
                    debug.error("ResourceResultCache.run(): Throwable caught thread", throwable);
                    continue;
                }
                break;
            }
        }
    }
}

